/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.dto.DoctorListForScheduleReqDTO;
import com.ebaiyihui.family.doctor.common.dto.DoctorSchedDTO;
import com.ebaiyihui.family.doctor.common.dto.QueryDoctorsDTO;
import com.ebaiyihui.family.doctor.common.dto.SearchDoctorDayScheduleReqDTO;
import com.ebaiyihui.family.doctor.common.vo.DoctorListForScheduleResVo;
import com.ebaiyihui.family.doctor.common.vo.DoctorListVo;
import com.ebaiyihui.family.doctor.common.vo.DoctorSchedVo;
import com.ebaiyihui.family.doctor.common.vo.DoctorScheduleInfoResVo;
import com.ebaiyihui.family.doctor.server.service.DoctorService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/doctor"})
@Api(tags={"\u533b\u751fAPI"})
public class DoctorController {
    private static final Logger log = LoggerFactory.getLogger(DoctorController.class);
    @Autowired
    private DoctorService doctorService;

    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u5217\u8868\u548c\u670d\u52a1\u6b21\u6570\u4fe1\u606f", notes="\u533b\u751f\u670d\u52a1feign\u8c03\u7528")
    @RequestMapping(value={"/getSignedDoctorList"}, method={RequestMethod.POST})
    public BaseResponse<PageResult<DoctorListVo>> getSignedDoctorList(@RequestBody QueryDoctorsDTO reqVo, BindingResult bindingResult) {
        BaseResponse doctorListVo = null;
        try {
            doctorListVo = this.doctorService.getSignedDoctorList(reqVo);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u533b\u751f\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return BaseResponse.error((String)e.getMessage());
        }
        return doctorListVo;
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u5206\u7c7b\u83b7\u53d6\u5f00\u901a\u5728\u7ebf\u95ee\u8bca\u7684\u533b\u751f\u5217\u8868")
    @RequestMapping(value={"/getDoctorListForSchedule"}, method={RequestMethod.POST})
    public BaseResponse<List<DoctorListForScheduleResVo>> getDoctorListForSchedule(@RequestBody DoctorListForScheduleReqDTO req) {
        return this.doctorService.getDoctorListForSchedule(req);
    }

    @ApiOperation(value="\u7ba1\u7406\u7aef\u641c\u7d22\u533b\u751f\u67d0\u5929\u7684\u6392\u73ed")
    @RequestMapping(value={"/searchDoctorDaySchedule"}, method={RequestMethod.POST})
    public BaseResponse<DoctorScheduleInfoResVo> searchDoctorDaySchedule(@RequestBody SearchDoctorDayScheduleReqDTO reqDTO) {
        return this.doctorService.searchDoctorDaySchedule(reqDTO);
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u6392\u73ed\u4fe1\u606f", notes="\u533b\u751f\u670d\u52a1feign\u8c03\u7528")
    @RequestMapping(value={"/getDoctorSched"}, method={RequestMethod.POST})
    public BaseResponse<DoctorSchedVo> getDoctorSched(@RequestBody DoctorSchedDTO reqVo, BindingResult bindingResult) {
        BaseResponse response = null;
        try {
            response = this.doctorService.getDoctorSched(reqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }
}

