/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.dto.SignedDoctorDTO;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.service.PatientService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patient"})
@Api(tags={"\u60a3\u8005API"})
public class PatientController {
    private static final Logger log = LoggerFactory.getLogger(PatientController.class);
    @Autowired
    private PatientService patientService;

    @ApiOperation(value="\u7b7e\u7ea6\u533b\u751f", notes="\u533b\u751f\u670d\u52a1feign\u8c03\u7528")
    @RequestMapping(value={"/signedDoctor"}, method={RequestMethod.POST})
    public BaseResponse<String> signedDoctor(@RequestBody SignedDoctorDTO reqVo, BindingResult bindingResult) {
        BaseResponse response = null;
        try {
            response = this.patientService.signedDoctor(reqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="\u83b7\u53d6\u7b7e\u7ea6\u533b\u751f\u4fe1\u606f", notes="\u533b\u751f\u670d\u52a1feign\u8c03\u7528")
    @RequestMapping(value={"/getSignedDoctor"}, method={RequestMethod.POST})
    public BaseResponse<PatientSignEntity> getSignedDoctor(@RequestBody SignedDoctorDTO reqVo, BindingResult bindingResult) {
        BaseResponse response = null;
        try {
            response = this.patientService.getSignedDoctor(reqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }
}

