/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.dto.InvalidMedicalRecordDTO;
import com.ebaiyihui.family.doctor.common.vo.PatientCaseDetail;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.HisTemplateService;
import com.ebaiyihui.family.doctor.server.service.PatientMedicalRecordService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/medicalRecord"})
@Api(tags={"\u60a3\u8005\u75c5\u5386API"})
public class PatientMedicalRecordController {
    @Autowired
    private PatientMedicalRecordService patientMedicalRecordService;
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private HisTemplateService hisTemplateService;

    @PostMapping(value={"/getMedicalInfoByAdmId"})
    @ApiOperation(value="\u6839\u636eadmID\u67e5\u8be2\u75c5\u4f8b")
    public BaseResponse<PatientCaseDetail> getMedicalInfoByAdmId(@RequestBody InvalidMedicalRecordDTO admId) {
        PatientCaseDetail medicalInfoByAdmId = this.patientMedicalRecordService.getMedicalInfoByAdmId(admId.getAdmId());
        return BaseResponse.success((Object)medicalInfoByAdmId);
    }

    @ApiOperation(value="\u63a8\u9001\u75c5\u4f8b\u5361\u7247", notes="\u533b\u751f\u5f00\u5177\u590d\u8bca\u75c5\u4f8b\u63a8\u9001\u5c0f\u5361\u7247")
    @RequestMapping(value={"/treatmentCard"}, method={RequestMethod.POST})
    public BaseResponse<Object> treatmentCard(@RequestBody @Validated InvalidMedicalRecordDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        return this.patientMedicalRecordService.treatmentCard(param.getAdmId());
    }

    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u533b\u751f\u4fe1\u606f", notes="\u83b7\u53d6\u60a3\u8005\u533b\u751f\u4fe1\u606f-\u533b\u836f\u4e91\u8c03\u7528")
    @RequestMapping(value={"/getBaseInfoByAdmId"}, method={RequestMethod.POST})
    public BaseResponse<Object> getBaseInfoByAdmId(@RequestBody @Validated InvalidMedicalRecordDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
        }
        return this.patientMedicalRecordService.getBaseInfoByAdmId(param.getAdmId());
    }

    @ApiOperation(value="\u624b\u52a8\u6302\u53f7", notes="\u624b\u52a8\u7ed9\u5df2\u7b7e\u7ea6\u7684\u8ba2\u5355\u6302\u53f7\u4e91his")
    @RequestMapping(value={"/manualReg"}, method={RequestMethod.GET})
    public BaseResponse<Object> test(@RequestParam String admId) {
        PatientSignEntity patientSignEntity = this.patientSignMapper.queryByAdmId(admId);
        BaseResponse response = this.hisTemplateService.registrationAndTreatment(patientSignEntity);
        if (!response.isSuccess()) {
            throw new BusinessException("his\u6302\u53f7\u5931\u8d25");
        }
        patientSignEntity.setClinicCode(response.getData().toString());
        this.patientSignMapper.updateById((Object)patientSignEntity);
        return BaseResponse.success();
    }
}

