/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.vo.FindUserIdListReq;
import com.doctoruser.api.pojo.vo.FindUserIdReqVO;
import com.doctoruser.api.pojo.vo.FindUserIdRespVO;
import com.doctoruser.api.pojo.vo.GetUserInfoByUserIdReqVO;
import com.doctoruser.api.pojo.vo.UserInfoByUserIdRespVO;
import com.ebaiyihui.family.doctor.common.dto.GoeasyPushMsgReqDTO;
import com.ebaiyihui.family.doctor.server.common.constants.ProjProperties;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.GoEasyPushService;
import com.ebaiyihui.family.doctor.server.util.UserRestTemplateUtil;
import com.ebaiyihui.framework.utils.HttpKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class GoEasyPushServiceImpl
implements GoEasyPushService {
    private static final Logger log = LoggerFactory.getLogger(GoEasyPushServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private PatientSignMapper patientSignMapper;

    @Async
    public void newOrderToReceive(String admId) {
        log.info("\u533b\u751fweb\u7aef\u63a8\u9001\u5f00\u59cb:{}", (Object)admId);
        QueryWrapper wrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(admId);
        wrapper.setEntity((Object)patientSign);
        PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)wrapper);
        boolean isOrder = Objects.equals(StatusEnum.IN_CONSULTATION.getValue(), patientSignEntity.getStatus());
        if (isOrder) {
            UserInfoByUserIdRespVO userInfoByUserIdRespVO = this.queryDocAccountInfo(String.valueOf(patientSignEntity.getDoctorId()));
            String userId = userInfoByUserIdRespVO.getUserId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", patientSignEntity.getAdmId());
            map.put("body", "\u60a8\u6709\u4e00\u7b14\u65b0\u7684\u5bb6\u5ead\u533b\u751f\u8ba2\u5355\u5f85\u5904\u7406\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b");
            map.put("type", "jtys_new_order");
            map.put("title", "\u5bb6\u5ead\u533b\u751f\u8ba2\u5355\u63d0\u9192");
            map.put("subTitle", "\u5bb6\u5ead\u533b\u751f\u8ba2\u5355\u63d0\u9192");
            map.put("pushCode", "1");
            this.goEasyPush(userId, JSON.toJSONString(map), "jtys");
        }
    }

    private UserInfoByUserIdRespVO queryDocAccountInfo(String docId) {
        FindUserIdListReq findUserIdListReq = new FindUserIdListReq();
        FindUserIdReqVO findUserIdReqVO = new FindUserIdReqVO();
        findUserIdReqVO.setReqId(docId);
        findUserIdReqVO.setUserType(Short.valueOf((short)1));
        ArrayList<FindUserIdReqVO> findUserIdReqVOList = new ArrayList<FindUserIdReqVO>(1);
        findUserIdReqVOList.add(findUserIdReqVO);
        findUserIdListReq.setFindUserIdReqVOS(findUserIdReqVOList);
        log.info("findUserIdListReq:{}", (Object)JSON.toJSONString((Object)findUserIdListReq));
        List findUserIdRespVOS = UserRestTemplateUtil.queryUserIdList((FindUserIdListReq)findUserIdListReq, (String)this.projProperties.getUserFindUserId());
        log.info("00001\u67e5\u8be2\u7528\u6237Id\u8bf7\u6c42\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)findUserIdRespVOS));
        if (null == findUserIdRespVOS) {
            return null;
        }
        FindUserIdRespVO findUserIdRespVO = (FindUserIdRespVO)findUserIdRespVOS.get(0);
        log.info("000========:{}", (Object)JSON.toJSONString((Object)findUserIdRespVO));
        GetUserInfoByUserIdReqVO getUserInfoByUserIdReqVO = new GetUserInfoByUserIdReqVO();
        getUserInfoByUserIdReqVO.setUserId(findUserIdRespVO.getUserId());
        log.info("0002\u83b7\u53d6\u7528\u6237\u57fa\u7840\u8d44\u6599\u8bf7\u6c42\u5bf9\u8c61\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)getUserInfoByUserIdReqVO));
        UserInfoByUserIdRespVO userInfo = UserRestTemplateUtil.getUserInfo((GetUserInfoByUserIdReqVO)getUserInfoByUserIdReqVO, (String)this.projProperties.getUserInfo());
        log.info("0002\u83b7\u53d6\u7528\u6237\u57fa\u7840\u8d44\u6599\u8bf7\u6c42\u5bf9\u8c61\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)userInfo));
        if (null != userInfo) {
            return userInfo;
        }
        return null;
    }

    public void goEasyPush(String userId, String text, String busiCode) {
        String url = this.projProperties.getBaseAddress() + "/cloud/push/goeasy/pushgoeasyuserid";
        try {
            log.info("goeasy\u63a8\u9001url----------->{}", (Object)url);
            GoeasyPushMsgReqDTO vo = new GoeasyPushMsgReqDTO();
            vo.setBusiCode(busiCode);
            vo.setBody(text);
            vo.setUserId(userId);
            log.info("=======>goeasy\u63a8\u9001\u53c2\u6570----->{}", (Object)JSON.toJSONString((Object)vo));
            String httpResult = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)vo));
            log.info("=======>goeasy\u63a8\u9001\u8fd4\u56de\u7ed3\u679c----->{}", (Object)httpResult);
        }
        catch (Exception e) {
            log.info("=======>goeasy\u63a8\u9001 - \u83b7\u53d6\u5f02\u5e38", (Throwable)e);
        }
    }
}

