/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.AppPointRequestDTO;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.ArchivingRequestDTO;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.DiagnosticReqDTO;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.FeeBillCreationDto;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.FeeBillCreationVo;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.HisDeptAndDocCodeVo;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.MakeAnAppointmentRequestVO;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.OutpatientTypeVo;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.PayDto;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.PayRefundDto;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.PayRefundVo;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.PayVo;
import com.ebaiyihui.family.doctor.server.common.constants.ProjProperties;
import com.ebaiyihui.family.doctor.server.common.enums.CloudHisAdmissionStatusEnum;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.feign.DepartmentFeignClient;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.service.HisTemplateService;
import com.ebaiyihui.family.doctor.server.util.HttpKit;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HisTemplateServiceImpl
implements HisTemplateService {
    private static final Logger log = LoggerFactory.getLogger(HisTemplateServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private DepartmentFeignClient departmentInfoApi;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private PatientMapper patientMapper;

    public BaseResponse<Object> registrationAndTreatment(PatientSignEntity patientSign) {
        HisDeptAndDocCodeVo hisDeptAndDocCode = this.getHisDeptAndDocCode(patientSign.getDeptId().toString(), String.valueOf(patientSign.getDoctorId()));
        AppPointRequestDTO appPointRequestDTO = this.buildAppointmentParam(patientSign, hisDeptAndDocCode);
        log.info("0\u5143\u590d\u8bca\u6302\u53f7\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)appPointRequestDTO));
        MakeAnAppointmentRequestVO makeAnAppointmentRequestVO = this.admissionRegistration(appPointRequestDTO);
        if (Objects.isNull(makeAnAppointmentRequestVO) || StringUtils.isEmpty((String)makeAnAppointmentRequestVO.getOutpatientNo())) {
            return BaseResponse.error((String)"\u4e91his\u6302\u53f7\u5931\u8d25");
        }
        log.info("\u5357\u660c\u4f17\u5eb7\u533b\u751f\u63a5\u8bca======");
        if (StringUtils.isEmpty((String)makeAnAppointmentRequestVO.getOutpatientNo())) {
            return BaseResponse.error((String)"\u6302\u53f7\u5931\u8d25,\u4e0d\u80fd\u63a5\u8bca");
        }
        AppPointRequestDTO receive = new AppPointRequestDTO();
        receive.setOutpatientNo(makeAnAppointmentRequestVO.getOutpatientNo());
        receive.setStatus(CloudHisAdmissionStatusEnum.TREATNENTED.getValue());
        log.info("\u590d\u8bca\u63a5\u8bca\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)receive));
        FrontResponse hisResponse = this.updateAppointment(receive);
        if ("0".equals(hisResponse.getCode())) {
            return BaseResponse.error((String)"\u6302\u53f7\u5931\u8d25\uff0c\u65e0\u6cd5\u63a5\u8bca");
        }
        return BaseResponse.success((Object)makeAnAppointmentRequestVO.getOutpatientNo());
    }

    public MakeAnAppointmentRequestVO admissionRegistration(AppPointRequestDTO appPointRequestDTO) {
        String url = this.projProperties.getAdmissionRegistration();
        FrontRequest request = new FrontRequest();
        request.setBody((Object)appPointRequestDTO);
        try {
            log.info("\u4e91his=>>\u65b0\u589e\u5c31\u8bca\u4fe1\u606f\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u65b0\u589e\u5c31\u8bca\u4fe1\u606f\u8fd4\u56de\u503c:{}", (Object)JSONObject.toJSONString((Object)frontResponse));
            MakeAnAppointmentRequestVO makeAnAppointmentRequestVO = (MakeAnAppointmentRequestVO)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), MakeAnAppointmentRequestVO.class);
            log.info("\u4e91his=>\u65b0\u589e\u5c31\u8bca\u8bb0\u5f55\u8fd4\u56de\u503c:{}", (Object)JSONObject.toJSONString((Object)makeAnAppointmentRequestVO));
            return makeAnAppointmentRequestVO;
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u9884\u7ea6\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public FrontResponse<String> updateAppointment(AppPointRequestDTO appPointRequestDTO) {
        String url = this.projProperties.getAdmissionUpdate();
        FrontRequest request = new FrontRequest();
        request.setBody((Object)appPointRequestDTO);
        try {
            log.info("\u4e91his=>>\u66f4\u65b0\u6302\u53f7\u4fe1\u606f\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u66f4\u65b0\u6302\u53f7\u4fe1\u606f\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            if (!"1".equals(frontResponse.getCode())) {
                return null;
            }
            String data = (String)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), String.class);
            return FrontResponse.success(null, (Object)data);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6302\u53f7\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public FrontResponse<String> saveDiagnostic(DiagnosticReqDTO diagnosticReqDTO) {
        String url = this.projProperties.getUpdateOutpatientMedicalRecords();
        FrontRequest request = new FrontRequest();
        request.setBody((Object)diagnosticReqDTO);
        try {
            log.info("\u4e91his=>>\u4fdd\u5b58\u8bca\u65ad\u4fe1\u606f\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u4fdd\u5b58\u8bca\u65ad\u4fe1\u606f\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            if (!"1".equals(frontResponse.getCode())) {
                return null;
            }
            String data = (String)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), String.class);
            return FrontResponse.success(null, (Object)data);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u8bca\u65ad\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public FrontResponse<FeeBillCreationVo> createCharge(FeeBillCreationDto feeBillCreationDto) {
        String url = this.projProperties.getCreateOrderCharge();
        FrontRequest request = new FrontRequest();
        request.setBody((Object)feeBillCreationDto);
        try {
            log.info("\u4e91his=>>\u590d\u8bca\u8ba2\u5355\u9884\u652f\u4ed8\u4fe1\u606f\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u590d\u8bca\u8ba2\u5355\u9884\u652f\u4ed8\u4fe1\u606f\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            if (!"1".equals(frontResponse.getCode())) {
                return null;
            }
            FeeBillCreationVo data = (FeeBillCreationVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), FeeBillCreationVo.class);
            return FrontResponse.success(null, (Object)data);
        }
        catch (Exception e) {
            log.error("\u590d\u8bca\u8ba2\u5355\u9884\u652f\u4ed8\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public FrontResponse<PayVo> payment(PayDto payDto) {
        String url = this.projProperties.getPayment();
        FrontRequest request = new FrontRequest();
        request.setBody((Object)payDto);
        try {
            log.info("\u4e91his=>\u590d\u8bca\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u590d\u8bca\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            if (!"1".equals(frontResponse.getCode())) {
                return null;
            }
            PayVo data = (PayVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), PayVo.class);
            return FrontResponse.success(null, (Object)data);
        }
        catch (Exception e) {
            log.error("\u590d\u8bca\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public FrontResponse<String> archiving(ArchivingRequestDTO archivingRequestDTO) {
        String url = this.projProperties.getArchiving();
        FrontRequest request = new FrontRequest();
        request.setBody((Object)archivingRequestDTO);
        try {
            log.info("\u4e91his=>\u590d\u8bca\u75c5\u5386\u5f52\u6863\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u590d\u8bca\u75c5\u5386\u5f52\u6863\u4fe1\u606f\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            if (!"1".equals(frontResponse.getCode())) {
                return null;
            }
            String data = JSON.toJSONString((Object)frontResponse.getBody());
            return FrontResponse.success(null, (Object)data);
        }
        catch (Exception e) {
            log.error("\u590d\u8bca\u75c5\u5386\u5f52\u6863\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public FrontResponse<PayRefundVo> refund(PayRefundDto payRefundDto) {
        String url = this.projProperties.getRefund();
        FrontRequest request = new FrontRequest();
        request.setBody((Object)payRefundDto);
        try {
            log.info("\u4e91his=>\u590d\u8bca\u9000\u6b3e\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u590d\u8bca\u9000\u6b3e\u4fe1\u606f\u8fd4\u56de\u503c:{}" + JSONObject.toJSONString((Object)frontResponse));
            if (!"1".equals(frontResponse.getCode())) {
                return null;
            }
            PayRefundVo data = (PayRefundVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), PayRefundVo.class);
            return FrontResponse.success(null, (Object)data);
        }
        catch (Exception e) {
            log.error("\u590d\u8bca\u9000\u6b3e\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public FrontResponse<OutpatientTypeVo> checkDocAndDeptAndRegFeeInfo(HisDeptAndDocCodeVo hisDeptAndDocCode) {
        String url = this.projProperties.getCheckDocAndDeptAndRegFeeInfo();
        FrontRequest request = new FrontRequest();
        request.setBody((Object)hisDeptAndDocCode);
        try {
            log.info("\u4e91his=>\u590d\u8bca\u6302\u53f7\u7c7b\u578b\u533b\u751f\u90e8\u95e8\u6821\u9a8c\u8bf7\u6c42url:{},param:{}", (Object)url, (Object)JSON.toJSONString((Object)request));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
            FrontResponse frontResponse = (FrontResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), FrontResponse.class);
            log.info("\u4e91his=>\u590d\u8bca\u6302\u53f7\u7c7b\u578b\u533b\u751f\u90e8\u95e8\u6821\u9a8c\u8fd4\u56de\u503c:{}", (Object)JSONObject.toJSONString((Object)frontResponse));
            if (!"1".equals(frontResponse.getCode())) {
                return FrontResponse.error(null, (String)"0", (String)frontResponse.getMessage());
            }
            OutpatientTypeVo data = (OutpatientTypeVo)JSON.parseObject((String)JSON.toJSONString((Object)frontResponse.getBody()), OutpatientTypeVo.class);
            return FrontResponse.success(null, (Object)data);
        }
        catch (Exception e) {
            log.error("\u590d\u8bca\u6302\u53f7\u7c7b\u578b\u533b\u751f\u90e8\u95e8\u6821\u9a8c\u5f02\u5e38:{}", (Object)e.getMessage());
            return FrontResponse.error(null, (String)"0", (String)"\u590d\u8bca\u6302\u53f7\u7c7b\u578b\u533b\u751f\u90e8\u95e8\u6821\u9a8c\u5f02\u5e38");
        }
    }

    public HisDeptAndDocCodeVo getHisDeptAndDocCode(String deptId, String doctorId) {
        log.info("deptId\uff1a{},doctorId\uff1a{}", (Object)deptId, (Object)doctorId);
        HisDeptAndDocCodeVo hisDeptAndDocCodeVo = new HisDeptAndDocCodeVo();
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(doctorId);
        BaseResponse personnelInfoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        log.info("his\u533b\u751fcode:" + JSON.toJSONString((Object)personnelInfoBaseResponse));
        if (personnelInfoBaseResponse.isSuccess() && null != personnelInfoBaseResponse.getData()) {
            log.info("his\u533b\u751fcode:" + JSON.toJSONString((Object)personnelInfoBaseResponse));
            String emplCode = ((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode();
            hisDeptAndDocCodeVo.setDoctorCode(emplCode);
            hisDeptAndDocCodeVo.setDoctorName(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDoctorName());
        }
        Long deptIdL = Long.valueOf(deptId);
        BaseResponse departmentDetail = this.departmentInfoApi.getDepartmentDetail(deptIdL);
        log.info("his\u533b\u751fcode:" + JSON.toJSONString((Object)departmentDetail));
        if (departmentDetail.isSuccess() && null != departmentDetail.getData()) {
            log.info("his\u79d1\u5ba4code:" + JSON.toJSONString((Object)departmentDetail));
            String deptCode = ((DepartmentDetailVo)departmentDetail.getData()).getDeptCode();
            hisDeptAndDocCodeVo.setDeptCode(deptCode);
            hisDeptAndDocCodeVo.setDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
        }
        return hisDeptAndDocCodeVo;
    }

    private AppPointRequestDTO buildAppointmentParam(PatientSignEntity patientEntity, HisDeptAndDocCodeVo hisDeptAndDocCode) {
        String patientId = patientEntity.getPatientId();
        PatientEntity patientInfo = (PatientEntity)this.patientMapper.selectById((Serializable)((Object)patientId));
        AppPointRequestDTO appPointRequestDTO = new AppPointRequestDTO();
        appPointRequestDTO.setCardType("01");
        appPointRequestDTO.setName(patientEntity.getPatientName());
        appPointRequestDTO.setOutpatientType("1");
        appPointRequestDTO.setDeptId(Integer.valueOf(hisDeptAndDocCode.getDeptCode()));
        appPointRequestDTO.setSex(patientInfo.getGender() + "");
        appPointRequestDTO.setCardNo(patientInfo.getCredNo());
        appPointRequestDTO.setPhone(patientInfo.getPhone());
        appPointRequestDTO.setDoctorName(hisDeptAndDocCode.getDoctorName());
        appPointRequestDTO.setMedicalType("1");
        appPointRequestDTO.setDoctorId(Integer.valueOf(hisDeptAndDocCode.getDoctorCode()));
        appPointRequestDTO.setDeptName(hisDeptAndDocCode.getDeptName());
        appPointRequestDTO.setHospitalName("\u4f17\u5eb7\u5bb6\u5ead\u533b\u751f");
        return appPointRequestDTO;
    }
}

