/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.family.doctor.common.dto.NotifyConsultDataDTO;
import com.ebaiyihui.family.doctor.common.dto.SendImMsgDTO;
import com.ebaiyihui.family.doctor.common.dto.SignedDoctorDTO;
import com.ebaiyihui.family.doctor.server.common.constants.CommonConstants;
import com.ebaiyihui.family.doctor.server.common.enums.ImSignStatus;
import com.ebaiyihui.family.doctor.server.common.enums.SignStatus;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.MobileBenefitPackageEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.entity.ScheduleRecordEntity;
import com.ebaiyihui.family.doctor.server.entity.ServiceConfigEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.mapper.MobileBenefitPackageMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.mapper.ScheduleRecordMapper;
import com.ebaiyihui.family.doctor.server.mapper.ServiceConfigMapper;
import com.ebaiyihui.family.doctor.server.rabbitmq.RabbitProduct;
import com.ebaiyihui.family.doctor.server.service.GoEasyPushService;
import com.ebaiyihui.family.doctor.server.service.HisTemplateService;
import com.ebaiyihui.family.doctor.server.service.ImChatTemplate;
import com.ebaiyihui.family.doctor.server.service.ImMsgTemplateService;
import com.ebaiyihui.family.doctor.server.service.PatientService;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import com.ebaiyihui.family.doctor.server.util.ThirdOrderPushUtil;
import com.ebaiyihui.family.doctor.server.util.UUIDUtil;
import com.ebaiyihui.family.doctor.server.vo.OrderTaskVo;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PatientServiceImpl
implements PatientService {
    private static final Logger log = LoggerFactory.getLogger(PatientServiceImpl.class);
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private ServiceConfigMapper serviceConfigMapper;
    @Autowired
    private MobileBenefitPackageMapper mobileBenefitPackageMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ImMsgTemplateService imMsgTemplateService;
    @Autowired
    private GoEasyPushService goEasyPushService;
    @Autowired
    private ImChatTemplate imChatTemplate;
    @Autowired
    private ThirdOrderPushUtil thirdOrderPushUtil;
    @Autowired
    private RabbitProduct rabbitProduct;
    @Autowired
    private HisTemplateService hisTemplateService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseResponse<String> signedDoctor(SignedDoctorDTO reqVo) {
        BaseResponse response;
        MobileBenefitPackageEntity entity = this.mobileBenefitPackageMapper.queryByPhone(reqVo.getPhone(), reqVo.getPackageOrderId(), null);
        log.info("entity={}", (Object)entity);
        if (ObjectUtils.isEmpty((Object)entity)) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6709\u5173\u6743\u76ca");
        }
        String admId = UUIDUtil.getUUID();
        Date curDate = new Date();
        Date signEndTime = DateUtils.getAfterDay((Date)curDate, (int)CommonConstants.DAY);
        Date signStartTime = new Date();
        try {
            if (!StringUtils.isEmpty((Object)entity.getBenefitsEndTime())) {
                signEndTime = DateUtils.parseDate((String)entity.getBenefitsEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
                signStartTime = DateUtils.parseDate((String)entity.getBenefitsStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            }
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6709\u5173\u6743\u76ca");
        }
        Long doctorId = reqVo.getDoctorId();
        String doctorName = reqVo.getDoctorName();
        Long deptId = reqVo.getDeptId();
        String deptName = reqVo.getDeptName();
        PatientSignEntity oldPatientSignEntity = new PatientSignEntity();
        PatientSignEntity tempOldPatientSignEntity = new PatientSignEntity();
        if (!SignStatus.SIGNED.getValue().equals(reqVo.getSignStatus())) {
            QueryWrapper psWrapper = new QueryWrapper();
            PatientSignEntity patientSign = new PatientSignEntity();
            patientSign.setAdmId(reqVo.getAdmId());
            psWrapper.setEntity((Object)patientSign);
            oldPatientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)psWrapper);
            Date signCreateTime = oldPatientSignEntity.getCreateTime();
            BeanUtils.copyProperties((Object)oldPatientSignEntity, (Object)tempOldPatientSignEntity);
            log.info("tempOldPatientSignEntity={}", (Object)tempOldPatientSignEntity);
            log.info("\u5165\u53c2\u67e5\u8be2oldPatientSignEntity={}", (Object)oldPatientSignEntity);
            if (!oldPatientSignEntity.getSignId().equals(0L)) {
                QueryWrapper cpsWrapper = new QueryWrapper();
                PatientSignEntity cPatientSign = new PatientSignEntity();
                cPatientSign.setId(oldPatientSignEntity.getSignId());
                cpsWrapper.setEntity((Object)cPatientSign);
                oldPatientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)cpsWrapper);
                log.info("\u6539\u7b7e\u67e5\u8be2\u539f\u59cboldPatientSignEntity={}", (Object)oldPatientSignEntity);
            }
            if (SignStatus.CANCEL.getValue().equals(reqVo.getSignStatus())) {
                if (!tempOldPatientSignEntity.getSignId().equals(0L)) {
                    log.info("signCreateTime={}, signStartTime={}, signEndTime={}", new Object[]{signCreateTime, signStartTime, signEndTime});
                    if (signCreateTime.after(signStartTime) && signCreateTime.before(signEndTime)) {
                        return BaseResponse.error((String)"\u5df2\u7ecf\u6709\u8fdb\u884c\u4e2d\u7684\u7b7e\u7ea6\u6216\u8005\u6539\u7b7e\u533b\u751f\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u7b7e\u7ea6\u6216\u8005\u6539\u7b7e\uff01\uff01\uff01");
                    }
                }
                if (!StringUtils.isEmpty((Object)reqVo.getAdmId()) || !StringUtils.isEmpty((Object)reqVo.getSignSeqId())) {
                    if (!Objects.nonNull(tempOldPatientSignEntity)) return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u7684\u7b7e\u7ea6\u533b\u751f\uff0c\u4e0d\u80fd\u8fdb\u884c\u6539\u7b7e\uff01\uff01\uff01");
                    signEndTime = tempOldPatientSignEntity.getSignEndTime();
                    tempOldPatientSignEntity.setStatus(StatusEnum.FINISH_APPLY.getValue());
                    tempOldPatientSignEntity.setSignStatus(SignStatus.CANCEL.getValue());
                    tempOldPatientSignEntity.setSubStatus(Integer.valueOf(2));
                    tempOldPatientSignEntity.setSignEndTime(curDate);
                    this.patientSignMapper.updateById((Object)tempOldPatientSignEntity);
                }
            } else if (SignStatus.NORMAL.getValue().equals(reqVo.getSignStatus())) {
                QueryWrapper nPsWrapper = new QueryWrapper();
                PatientSignEntity nPatientSign = new PatientSignEntity();
                nPatientSign.setSignId(oldPatientSignEntity.getId());
                nPatientSign.setStatus(StatusEnum.IN_CONSULTATION.getValue());
                nPatientSign.setSignStatus(SignStatus.NORMAL.getValue());
                nPsWrapper.setEntity((Object)nPatientSign);
                PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)nPsWrapper);
                if (Objects.nonNull(patientSignEntity)) {
                    return BaseResponse.success((Object)patientSignEntity.getAdmId());
                }
                ScheduleRecordEntity scheduleRecordEntity = this.getScheduleDoctor(reqVo.getPatientId(), reqVo.getPackageOrderId(), tempOldPatientSignEntity.getDoctorId());
                doctorId = Long.valueOf(scheduleRecordEntity.getDoctorId());
                doctorName = scheduleRecordEntity.getDoctorName();
                deptId = Long.valueOf(scheduleRecordEntity.getDeptId());
                deptName = scheduleRecordEntity.getDeptName();
            }
        } else {
            Integer signStatus = SignStatus.SIGNED.getValue();
            Integer status = StatusEnum.IN_CONSULTATION.getValue();
            List patientSignEntities = this.getPatientSignList(reqVo.getPhone(), reqVo.getPackageOrderId(), signStatus, status);
            if (!patientSignEntities.isEmpty() && SignStatus.SIGNED.getValue().equals(reqVo.getSignStatus())) {
                return BaseResponse.error((String)"\u5df2\u7ecf\u6709\u8fdb\u884c\u4e2d\u7684\u7b7e\u7ea6\u6216\u8005\u6539\u7b7e\u533b\u751f\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u7b7e\u7ea6\u6216\u8005\u6539\u7b7e\uff01\uff01\uff01");
            }
        }
        PatientSignEntity patientSignEntity = new PatientSignEntity();
        patientSignEntity.setAdmId(admId);
        patientSignEntity.setAppCode("NCZK");
        patientSignEntity.setOrganId(CommonConstants.ORGAN_CODE);
        patientSignEntity.setOrganName("\u5357\u660c\u4f17\u5eb7\u533b\u9662");
        patientSignEntity.setDoctorId(doctorId);
        patientSignEntity.setDoctorName(doctorName);
        patientSignEntity.setDeptId(deptId);
        patientSignEntity.setDeptName(deptName);
        patientSignEntity.setSignStatus(SignStatus.CANCEL.getValue().equals(reqVo.getSignStatus()) ? SignStatus.SIGNED.getValue() : reqVo.getSignStatus());
        patientSignEntity.setPatientPhone(reqVo.getPhone());
        patientSignEntity.setCredNo(reqVo.getCredNo());
        patientSignEntity.setPatientId(reqVo.getPatientId());
        patientSignEntity.setPatientName(reqVo.getName());
        patientSignEntity.setPatientUserId(entity.getUserId());
        patientSignEntity.setStatus(StatusEnum.IN_CONSULTATION.getValue());
        patientSignEntity.setPackageOrderId(reqVo.getPackageOrderId());
        patientSignEntity.setSignEndTime(signEndTime);
        log.info("oldPatientSignEntity={}", (Object)oldPatientSignEntity);
        if (Objects.nonNull(oldPatientSignEntity)) {
            patientSignEntity.setSignId(oldPatientSignEntity.getId());
        }
        if (!(response = this.hisTemplateService.registrationAndTreatment(patientSignEntity)).isSuccess()) {
            throw new BusinessException("his\u6302\u53f7\u5931\u8d25");
        }
        patientSignEntity.setClinicCode(response.getData().toString());
        this.patientSignMapper.insert((Object)patientSignEntity);
        BaseResponse createImResponse = this.imChatTemplate.createImSession(patientSignEntity);
        if (!createImResponse.isSuccess()) {
            log.info("\u521b\u5efaIM\u5931\u8d25:{}", (Object)createImResponse.getMsg());
            throw new BusinessException("\u521b\u5efaIM\u5931\u8d25");
        }
        SendImMsgDTO sendImMsgDTO = new SendImMsgDTO();
        sendImMsgDTO.setAdmId(admId);
        sendImMsgDTO.setAppCode("NCZK");
        sendImMsgDTO.setOrganId(CommonConstants.ORGAN_CODE);
        sendImMsgDTO.setType(SignStatus.SIGNED.getValue().equals(reqVo.getSignStatus()) ? ImSignStatus.SIGN_SUC.getValue() : (SignStatus.CANCEL.getValue().equals(reqVo.getSignStatus()) ? ImSignStatus.REISSUE_SUC.getValue() : ImSignStatus.INQUIRY_SCH_DOC.getValue()));
        if ("0".equals(entity.getIsRenew()) || SignStatus.NORMAL.getValue().equals(reqVo.getSignStatus())) {
            OrderTaskVo orderTaskVo = new OrderTaskVo();
            orderTaskVo.setType(Integer.valueOf(1));
            orderTaskVo.setId(String.valueOf(patientSignEntity.getId()));
            if ("0".equals(entity.getIsRenew())) {
                orderTaskVo.setExpireTime(Integer.valueOf(DateUtils.secondBetween((Date)signStartTime, (Date)signEndTime)));
            }
            this.rabbitProduct.sendDelay(orderTaskVo);
        }
        this.thirdOrderPushUtil.pushSignedOrder(String.valueOf(reqVo.getDoctorId()), reqVo.getPhone(), SignStatus.SIGNED.getValue().equals(reqVo.getSignStatus()) ? String.valueOf(patientSignEntity.getId()) : String.valueOf(patientSignEntity.getSignId()), reqVo.getPackageOrderId(), reqVo.getSignStatus());
        this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
        if (!SignStatus.NORMAL.getValue().equals(reqVo.getSignStatus())) {
            NotifyConsultDataDTO notifyConsultDataDTO = new NotifyConsultDataDTO();
            notifyConsultDataDTO.setActivateOrderId(reqVo.getPackageOrderId());
            notifyConsultDataDTO.setConsultOrderNo(admId);
            notifyConsultDataDTO.setStatus(String.valueOf(StatusEnum.IN_CONSULTATION.getValue()));
            notifyConsultDataDTO.setProductId(entity.getProductId());
            notifyConsultDataDTO.setPatientId(entity.getUserId());
            notifyConsultDataDTO.setExpertName(reqVo.getDoctorName());
            notifyConsultDataDTO.setOrderDate(DateUtils.dateToFullString((Date)patientSignEntity.getCreateTime()));
            notifyConsultDataDTO.setSupplierCode("zhongkang_mfd");
            this.thirdOrderPushUtil.syncBenefitUsedOrder(notifyConsultDataDTO, Long.valueOf(10000L));
            if (SignStatus.CANCEL.getValue().equals(reqVo.getSignStatus())) {
                NotifyConsultDataDTO notifyConsultDataDTO2 = new NotifyConsultDataDTO();
                notifyConsultDataDTO2.setActivateOrderId(reqVo.getPackageOrderId());
                notifyConsultDataDTO2.setConsultOrderNo(tempOldPatientSignEntity.getAdmId());
                notifyConsultDataDTO2.setStatus(String.valueOf(StatusEnum.FINISH_APPLY.getValue()));
                notifyConsultDataDTO2.setProductId(entity.getProductId());
                notifyConsultDataDTO2.setPatientId(entity.getUserId());
                notifyConsultDataDTO2.setExpertName(reqVo.getDoctorName());
                notifyConsultDataDTO2.setOrderDate(DateUtils.dateToFullString((Date)patientSignEntity.getCreateTime()));
                notifyConsultDataDTO2.setSupplierCode("zhongkang_mfd");
                this.thirdOrderPushUtil.syncBenefitUsedOrder(notifyConsultDataDTO2, Long.valueOf(10000L));
            }
        } else if (Objects.nonNull(oldPatientSignEntity)) {
            sendImMsgDTO.setOldAdmId(oldPatientSignEntity.getAdmId());
        }
        this.goEasyPushService.newOrderToReceive(admId);
        return BaseResponse.success((Object)admId);
    }

    public BaseResponse<PatientSignEntity> getSignedDoctor(SignedDoctorDTO reqVo) {
        PatientSignEntity patientSignEntity;
        QueryWrapper psWrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        if (Objects.nonNull(reqVo.getAdmId())) {
            patientSign.setAdmId(reqVo.getAdmId());
        }
        if (Objects.nonNull(reqVo.getPhone())) {
            patientSign.setPatientPhone(reqVo.getPhone());
        }
        psWrapper.setEntity((Object)patientSign);
        if (Objects.nonNull(reqVo.getPhone())) {
            psWrapper.orderByDesc((Object)"create_time");
            psWrapper.last("limit 1");
        }
        if (null == (patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)psWrapper))) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7b7e\u7ea6\u533b\u751f\u4fe1\u606f\uff01");
        }
        return BaseResponse.success((Object)patientSignEntity);
    }

    public ScheduleRecordEntity getScheduleDoctor(String patientId, String packageOrderId, Long doctorId) {
        String date = DateUtils.dateToSimpleString((Date)new Date());
        String hourAndSecond = DateUtils.getHourAndSecond();
        QueryWrapper psWrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setPatientId(patientId);
        patientSign.setPackageOrderId(packageOrderId);
        patientSign.setSignStatus(SignStatus.NORMAL.getValue());
        patientSign.setStatus(StatusEnum.IN_CONSULTATION.getValue());
        psWrapper.setEntity((Object)patientSign);
        List patientSignEntities = this.patientSignMapper.selectList((Wrapper)psWrapper);
        if (!CollectionUtils.isEmpty((Collection)patientSignEntities)) {
            throw new BusinessException("\u5df2\u6709\u8fdb\u884c\u4e2d\u6392\u73ed\u533b\u751f\u6c9f\u901a,\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        List scheduleRecordEntities = this.scheduleRecordMapper.selectByDate(String.valueOf(CommonConstants.ORGAN_CODE), Integer.valueOf(5), date, Integer.valueOf(1), hourAndSecond, null);
        log.info("\u5f53\u524d\u6392\u73ed\u533b\u751f:{},\u4f20\u8fdb\u6765\u8fc7\u6ee4\u7684\u533b\u751fid={}", (Object)JSON.toJSONString((Object)scheduleRecordEntities), (Object)doctorId);
        if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntities)) {
            scheduleRecordEntities = scheduleRecordEntities.stream().filter(scheduleRecordEntity -> !scheduleRecordEntity.getDoctorId().equals(String.valueOf(doctorId))).collect(Collectors.toList());
        }
        log.info("\u8fc7\u6ee4\u4e4b\u540e\u7684\u533b\u751f:{}", (Object)JSON.toJSONString((Object)scheduleRecordEntities));
        if (CollectionUtils.isEmpty((Collection)scheduleRecordEntities)) {
            throw new BusinessException("\u670d\u52a1\u65f6\u95f4\u4e3a08:00-20:00\uff0c\u60a8\u53d1\u8d77\u7684\u54a8\u8be2\u6682\u65f6\u6ca1\u6709\u533b\u751f\u56de\u7b54\uff0c\u533b\u751f\u4e0a\u73ed\u540e\u4f1a\u7b2c\u4e00\u65f6\u95f4\u56de\u590d\u60a8\u3002");
        }
        ScheduleRecordEntity scheduleRecordEntity2 = new ScheduleRecordEntity();
        Random random = new Random();
        int i = random.nextInt(scheduleRecordEntities.size() + 1);
        if (i == 0) {
            ++i;
        }
        scheduleRecordEntity2 = (ScheduleRecordEntity)scheduleRecordEntities.get(i - 1);
        log.info("\u67e5\u8be2\u5f53\u524d\u6392\u73ed\u533b\u751fdoctorId={}", (Object)scheduleRecordEntity2.getDoctorId());
        QueryWrapper queryWrapper = new QueryWrapper();
        ServiceConfigEntity wrapperEntity = new ServiceConfigEntity();
        wrapperEntity.setOrganId(String.valueOf(CommonConstants.ORGAN_CODE));
        wrapperEntity.setAppCode("NCZK");
        wrapperEntity.setDoctorId(scheduleRecordEntity2.getDoctorId());
        wrapperEntity.setServiceCode("jtys");
        wrapperEntity.setStatus(Integer.valueOf(1));
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        ServiceConfigEntity serviceConfigEntity = (ServiceConfigEntity)this.serviceConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u5f53\u524d\u6392\u73ed\u533b\u751f\u4fe1\u606fserviceConfigEntity={}", (Object)serviceConfigEntity);
        if (Objects.nonNull(serviceConfigEntity) && serviceConfigEntity.getOfficeStatus().equals(-1)) {
            serviceConfigEntity.setOfficeStatus(Integer.valueOf(1));
            this.serviceConfigMapper.updateById((Object)serviceConfigEntity);
        }
        log.info("\u5f53\u524d\u4e0b\u5355\u7684\u533b\u751f:{}", (Object)JSON.toJSONString((Object)scheduleRecordEntity2));
        return scheduleRecordEntity2;
    }

    List<PatientSignEntity> getPatientSignList(String phone, String packageOrderId, Integer signStatus, Integer status) {
        QueryWrapper psWrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setPatientPhone(phone);
        patientSign.setPackageOrderId(packageOrderId);
        patientSign.setSignStatus(signStatus);
        patientSign.setStatus(status);
        psWrapper.setEntity((Object)patientSign);
        psWrapper.orderByDesc((Object)"create_time");
        List patientSignEntities = this.patientSignMapper.selectList((Wrapper)psWrapper);
        return patientSignEntities;
    }
}

