/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.task;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.family.doctor.common.bo.Result;
import com.ebaiyihui.family.doctor.common.dto.HealthInfoDTO;
import com.ebaiyihui.family.doctor.common.dto.NotifyConsultDataDTO;
import com.ebaiyihui.family.doctor.common.dto.SendImMsgDTO;
import com.ebaiyihui.family.doctor.server.common.constants.CommonConstants;
import com.ebaiyihui.family.doctor.server.common.enums.MsgTempTypeEnum;
import com.ebaiyihui.family.doctor.server.common.enums.SignStatus;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.MobileBenefitPackageEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.mapper.MobileBenefitPackageMapper;
import com.ebaiyihui.family.doctor.server.service.ImMsgTemplateService;
import com.ebaiyihui.family.doctor.server.service.PatientSignService;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import com.ebaiyihui.family.doctor.server.util.ThirdOrderPushUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginRspVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class SignedTask {
    private static final Logger log = LoggerFactory.getLogger(SignedTask.class);
    @Autowired
    private ImMsgTemplateService imMsgTemplateService;
    @Autowired
    private PatientSignService patientSignSevice;
    @Autowired
    private MobileBenefitPackageMapper mobileBenefitPackageMapper;
    @Autowired
    private ThirdOrderPushUtil thirdOrderPushUtil;

    @Scheduled(cron="0 0 10 * * ?")
    public void healthRecordWhetherUpdate() {
        log.info("\u5f00\u59cb\u8fdb\u884c\u5065\u5eb7\u67e5\u8be2\u5904\u7406...");
        PatientSignEntity patientSignEntity = new PatientSignEntity();
        patientSignEntity.setStatus(StatusEnum.IN_CONSULTATION.getValue());
        patientSignEntity.setSignStatus(SignStatus.SIGNED.getValue());
        List patientSignEntities = this.patientSignSevice.selectList(patientSignEntity);
        log.info("\u67e5\u8be2\u5065\u5eb7patientSignEntities={}", (Object)patientSignEntities);
        if (!patientSignEntities.isEmpty()) {
            for (PatientSignEntity ps : patientSignEntities) {
                HealthInfoDTO healthInfoDTO = new HealthInfoDTO();
                healthInfoDTO.setPhone(ps.getPatientPhone());
                String result = this.thirdOrderPushUtil.getHealthRecordWhetherUpdate(healthInfoDTO);
                Result res = (Result)JSONObject.parseObject((String)result, Result.class);
                Boolean flag = (Boolean)res.getData();
                SendImMsgDTO sendImMsgDTO = new SendImMsgDTO();
                sendImMsgDTO.setAppCode("NCZK");
                sendImMsgDTO.setOrganId(CommonConstants.ORGAN_CODE);
                sendImMsgDTO.setAdmId(ps.getAdmId());
                if (!flag.booleanValue()) {
                    sendImMsgDTO.setType(MsgTempTypeEnum.ACT_PUSH_HEAL_REC.getValue());
                    this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
                }
                Date curDate = new Date();
                int difDay = DateUtils.daysBetween((Date)ps.getCreateTime(), (Date)curDate);
                int afterFifteenDay = DateUtils.daysBetween((Date)ps.getCreateTime(), (Date)curDate);
                if (10 == difDay || afterFifteenDay % 15 == 0) {
                    sendImMsgDTO.setType(MsgTempTypeEnum.ACT__SIG_SUC.getValue());
                    this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
                }
                if (20 == difDay) {
                    sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_REP_ANO.getValue());
                    this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
                }
                IMQueryMsgReqVO imQueryMsgReqVO = new IMQueryMsgReqVO();
                imQueryMsgReqVO.setAppCode("EHOS_PATIENT");
                imQueryMsgReqVO.setBusinessCode("jtys");
                imQueryMsgReqVO.setMsgType("1");
                imQueryMsgReqVO.setPageSize(Integer.valueOf(10));
                imQueryMsgReqVO.setSortOrder("DESC");
                ArrayList<String> appointmentIds = new ArrayList<String>();
                appointmentIds.add(ps.getAdmId());
                imQueryMsgReqVO.setAppointmentId(appointmentIds);
                imQueryMsgReqVO.setUserId(ps.getPatientUserId());
                String sendTimeStr = "2023-12-01 00:00:00";
                try {
                    Date sendTime;
                    int difSendDay;
                    BaseResponse msgContent = this.patientSignSevice.getAllMsgContent(imQueryMsgReqVO);
                    if (!"1".equals(msgContent.getCode())) continue;
                    List imSingleMsgResultVOS = (List)msgContent.getData();
                    IMQueryUserLoginReqVO imQueryUserLoginReqVO = new IMQueryUserLoginReqVO();
                    imQueryUserLoginReqVO.setAppCode("EHOS_PATIENT");
                    imQueryUserLoginReqVO.setUserId(ps.getPatientUserId());
                    BaseResponse sdkLogin = this.patientSignSevice.querySdkLogin(imQueryUserLoginReqVO);
                    if ("1".equals(sdkLogin.getCode())) {
                        IMQueryUserLoginRspVO imQueryUserLoginRspVO = (IMQueryUserLoginRspVO)sdkLogin.getData();
                        String sdkAccount = imQueryUserLoginRspVO.getSdkAccount();
                        for (IMSingleMsgResultVO imSingleMsgResultVO : imSingleMsgResultVOS) {
                            if (!imSingleMsgResultVO.getSender().equals(sdkAccount)) continue;
                            sendTimeStr = imSingleMsgResultVO.getSendTime();
                            break;
                        }
                    }
                    if (7 != (difSendDay = DateUtils.daysBetween((Date)(sendTime = DateUtils.parseDate((String)sendTimeStr, (String)"yyyy-MM-dd HH:mm:ss")), (Date)curDate))) continue;
                    sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_UN_CON.getValue());
                    this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u53d1\u9001\u6d88\u606f\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    @Scheduled(cron="0 0 20 * * ?")
    public void holidayPush() {
        log.info("\u5f00\u59cb\u8fdb\u884c\u8282\u5047\u65e5\u6d88\u606f\u5904\u7406...");
        PatientSignEntity patientSignEntity = new PatientSignEntity();
        patientSignEntity.setStatus(StatusEnum.IN_CONSULTATION.getValue());
        patientSignEntity.setSignStatus(SignStatus.SIGNED.getValue());
        List patientSignEntities = this.patientSignSevice.selectList(patientSignEntity);
        log.info("\u67e5\u8be2\u8282\u5047\u65e5\u6d88\u606fpatientSignEntities={}", (Object)patientSignEntities);
        try {
            if (!patientSignEntities.isEmpty()) {
                for (PatientSignEntity ps : patientSignEntities) {
                    Date guoQingBeforeDay;
                    Date zhongQiuBeforeDay;
                    Date duanWuBeforeDay;
                    Date laborBeforeDay;
                    SendImMsgDTO sendImMsgDTO = new SendImMsgDTO();
                    sendImMsgDTO.setAppCode("NCZK");
                    sendImMsgDTO.setOrganId(CommonConstants.ORGAN_CODE);
                    sendImMsgDTO.setAdmId(ps.getAdmId());
                    Date curDate = new Date();
                    Date qmBeforeDay = DateUtils.getQingMingBeforeDay((Date)curDate);
                    Date curDay = DateUtils.parseDate((String)DateUtils.getFormatDateString((Date)curDate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                    if (qmBeforeDay.equals(curDay)) {
                        sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_TSD.getValue());
                        this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
                    }
                    if ((laborBeforeDay = DateUtils.getLaborBeforeDay((Date)curDate)).equals(curDay)) {
                        sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_LD.getValue());
                        this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
                    }
                    if ((duanWuBeforeDay = DateUtils.getLaborBeforeDay((Date)curDate)).equals(curDay)) {
                        sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_TDBF.getValue());
                        this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
                    }
                    if ((zhongQiuBeforeDay = DateUtils.getZhongQiuBeforeDay((Date)curDate)).equals(curDay)) {
                        sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_MAF.getValue());
                        this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
                    }
                    if (!(guoQingBeforeDay = DateUtils.getGuoQingBeforeDay((Date)curDate)).equals(curDay)) continue;
                    sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_MAF.getValue());
                    this.imMsgTemplateService.sendImMsg(sendImMsgDTO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8282\u65e5\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
    }

    @Scheduled(cron="0 0 1 * * ?")
    public void orderInvalidation() {
        log.info("\u5f00\u59cb\u8fdb\u884c\u6743\u76ca\u4fe1\u606f\u5904\u7406...");
        List mobileBenefitPackageEntities = this.mobileBenefitPackageMapper.queryMaxOneList();
        log.info("\u67e5\u8be2\u9700\u8981\u5904\u7406\u7684\u6743\u9650mobileBenefitPackageEntities={}", (Object)mobileBenefitPackageEntities);
        try {
            if (!mobileBenefitPackageEntities.isEmpty()) {
                for (MobileBenefitPackageEntity mbp : mobileBenefitPackageEntities) {
                    Date curTime = new Date();
                    Date endTime = DateUtils.parseDate((String)mbp.getBenefitsEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
                    List patientSignEntities = this.patientSignSevice.getListByPhone(mbp.getPhone(), mbp.getActivateOrderId());
                    mbp.setVersion(Integer.valueOf(1));
                    for (PatientSignEntity patientSignEntity : patientSignEntities) {
                        if (endTime.after(curTime)) {
                            patientSignEntity.setSignEndTime(endTime);
                        } else if (SignStatus.SIGNED.getValue().equals(patientSignEntity.getSignStatus()) && StatusEnum.IN_CONSULTATION.getValue().equals(patientSignEntity.getStatus())) {
                            patientSignEntity.setStatus(StatusEnum.FINISH_APPLY.getValue());
                            MobileBenefitPackageEntity entity = this.mobileBenefitPackageMapper.queryByPhone(patientSignEntity.getPatientPhone(), patientSignEntity.getPackageOrderId(), "1");
                            if (!ObjectUtils.isEmpty((Object)entity)) {
                                NotifyConsultDataDTO notifyConsultDataDTO = new NotifyConsultDataDTO();
                                notifyConsultDataDTO.setActivateOrderId(patientSignEntity.getPackageOrderId());
                                notifyConsultDataDTO.setConsultOrderNo(patientSignEntity.getAdmId());
                                notifyConsultDataDTO.setStatus(String.valueOf(StatusEnum.FINISH_APPLY.getValue()));
                                notifyConsultDataDTO.setProductId(entity.getProductId());
                                notifyConsultDataDTO.setPatientId(entity.getUserId());
                                notifyConsultDataDTO.setExpertName(patientSignEntity.getDoctorName());
                                notifyConsultDataDTO.setOrderDate(DateUtils.dateToFullString((Date)patientSignEntity.getCreateTime()));
                                notifyConsultDataDTO.setSupplierCode("zhongkang_mfd");
                                this.thirdOrderPushUtil.syncBenefitUsedOrder(notifyConsultDataDTO, null);
                            }
                        }
                        this.patientSignSevice.updateById(patientSignEntity);
                    }
                    this.mobileBenefitPackageMapper.updateVersion(mbp);
                }
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
    }
}

