/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.util;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component(value="redisUtil")
public final class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    public JedisCluster jedisCluster;
    private static final Long RELEASE_SUCCESS = 1L;
    private static final String LOCK_SUCCESS = "OK";
    private static final long WAIT_TIMEOUT = 10L;

    public void setJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    public String get(String key) {
        String result = (String)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            byte[] value = connection.get(serializer.serialize((Object)key));
            return (String)serializer.deserialize(value);
        });
        return result;
    }

    public boolean set(String key, String value) {
        boolean result = (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.set(serializer.serialize((Object)key), serializer.serialize((Object)value));
            return true;
        });
        return result;
    }

    public boolean set(String key, String value, long expirationTime) {
        boolean result = (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.set(serializer.serialize((Object)key), serializer.serialize((Object)value), Expiration.seconds((long)expirationTime), RedisStringCommands.SetOption.UPSERT);
            return true;
        });
        return result;
    }

    public boolean delete(String key) {
        boolean result = (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.del((byte[][])new byte[][]{serializer.serialize((Object)key)});
            return true;
        });
        return result;
    }

    public boolean setHash(String key, String hashKey, String value) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.hSet(serializer.serialize((Object)key), serializer.serialize((Object)hashKey), serializer.serialize((Object)value));
            return true;
        });
    }

    public Object getHash(String key, String hashKey) {
        return this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.hGet(serializer.serialize((Object)key), serializer.serialize((Object)hashKey));
            return true;
        });
    }

    public boolean rPush(String key, String value) {
        return (Boolean)this.redisTemplate.execute(connection -> {
            RedisSerializer serializer = this.redisTemplate.getStringSerializer();
            connection.rPush(serializer.serialize((Object)key), (byte[][])new byte[][]{serializer.serialize((Object)value)});
            return true;
        });
    }

    public List<?> lRange(String key, long l, long l1) {
        ListOperations list = this.redisTemplate.opsForList();
        return list.range((Object)key, l, l1);
    }

    public void add(String key, String value) {
        this.redisTemplate.opsForSet().add((Object)key, (Object[])new String[]{value});
    }

    public Set<String> setMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public void zAdd(String key, String value, double scoure) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        zset.add((Object)key, (Object)value, scoure);
    }

    public Set<String> rangeByScore(String key, double scoure, double scoure1) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.rangeByScore((Object)key, scoure, scoure1);
    }

    public Boolean getLock(String key, Long lockTime) {
        String lock = this.get(key);
        if (lock == null) {
            this.set(key, "lock", lockTime.longValue());
            return true;
        }
        return false;
    }

    public boolean del(String key) {
        return this.stringRedisTemplate.delete((Object)key);
    }

    public boolean lock(String lockKey, String requestId, int expireTime) {
        try {
            expireTime = 1000 * expireTime;
            String result = this.jedisCluster.set(lockKey, requestId, "NX", "PX", (long)expireTime);
            return LOCK_SUCCESS.equals(result);
        }
        catch (Exception e) {
            log.error("tryLock is error", (Throwable)e);
            return false;
        }
    }

    public boolean tryLock(String lockKey, String requestId, int expireTime) {
        long start = System.currentTimeMillis();
        try {
            while (true) {
                String result;
                if (LOCK_SUCCESS.equals(result = this.jedisCluster.set(lockKey, requestId, "NX", "PX", (long)(expireTime = 1000 * expireTime)))) {
                    return true;
                }
                if (System.currentTimeMillis() - start > 10000L) {
                    return false;
                }
                TimeUnit.MILLISECONDS.sleep(100L);
            }
        }
        catch (Exception e) {
            log.error("tryLock is error", (Throwable)e);
            return false;
        }
    }

    public boolean unLock(String lockKey, String requestId) {
        try {
            String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            Object result = this.jedisCluster.eval(script, Collections.singletonList(lockKey), Collections.singletonList(requestId));
            return RELEASE_SUCCESS.equals(result);
        }
        catch (Exception e) {
            log.error("unLock is error", (Throwable)e);
            return false;
        }
    }
}

