/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.util;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.family.doctor.common.bo.Result;
import com.ebaiyihui.family.doctor.common.dto.AbnormalDataDTO;
import com.ebaiyihui.family.doctor.common.dto.FollowUpOrderDTO;
import com.ebaiyihui.family.doctor.common.dto.HealthInfoDTO;
import com.ebaiyihui.family.doctor.common.dto.MasterUrlDTO;
import com.ebaiyihui.family.doctor.common.dto.NotifyConsultDataDTO;
import com.ebaiyihui.family.doctor.common.dto.ReportDetailDTO;
import com.ebaiyihui.family.doctor.common.dto.SyncSignedOrderDTO;
import com.ebaiyihui.family.doctor.common.dto.UnReadMsgDTO;
import com.ebaiyihui.family.doctor.common.dto.UserInfoDTO;
import com.ebaiyihui.family.doctor.common.vo.AccessTokenVo;
import com.ebaiyihui.family.doctor.server.common.constants.ProjProperties;
import com.ebaiyihui.family.doctor.server.common.enums.SignTypeEnum;
import com.ebaiyihui.family.doctor.server.util.HttpKit;
import com.ebaiyihui.family.doctor.server.util.SignUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ThirdOrderPushUtil {
    private static final Logger log = LoggerFactory.getLogger(ThirdOrderPushUtil.class);
    @Autowired
    private ProjProperties projProperties;

    public <T> Map<String, String> getThirdHead(T t) {
        log.info("\u4e1a\u52a1\u5165\u53c2\uff1a{}", t);
        String param = JSONObject.toJSONString(t);
        log.info("\u4e1a\u52a1\u6570\u636e\uff1a{}", (Object)param);
        String assessToken = this.getAssessToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", assessToken);
        Map map = null;
        try {
            map = SignUtils.paramToMap(t);
        }
        catch (Exception e) {
            log.error("\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        String sign = SignUtils.getSignatureToStr((Map)map, (String)"123456");
        header.put("sign", sign);
        header.put("timestamp", String.valueOf(new Date().getTime()));
        return header;
    }

    public String getAssessToken() {
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("grantType", "client_credentials");
        param.put("clientId", this.projProperties.getFamilyDoctorThirdClientId());
        param.put("clientSecret", this.projProperties.getFamilyDoctorThirdClientSecret());
        try {
            String result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/oauth/token"), (String)JSONObject.toJSONString(param));
            Result resultResp = (Result)JSONObject.parseObject((String)result, Result.class);
            if (resultResp.isSuccess()) {
                AccessTokenVo accessTokenVo = (AccessTokenVo)JSONObject.parseObject((String)String.valueOf(resultResp.getData()), AccessTokenVo.class);
                return accessTokenVo.getTokenType() + " " + accessTokenVo.getAccessToken();
            }
        }
        catch (Exception e) {
            log.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
        return null;
    }

    @Async
    public void pushSignedOrder(String doctorId, String phone, String signId, String packageOrderId, Integer signStatus) {
        SyncSignedOrderDTO syncSignedOrderDTO = new SyncSignedOrderDTO();
        syncSignedOrderDTO.setDoctorId(String.valueOf(doctorId));
        syncSignedOrderDTO.setPhone(phone);
        syncSignedOrderDTO.setBenefitOrderId(packageOrderId);
        syncSignedOrderDTO.setSignSeqId(signId);
        syncSignedOrderDTO.setSignType(SignTypeEnum.SIGNED_DOCTOR.getValue());
        switch (signStatus) {
            case 2: {
                this.syncSignedOrder(syncSignedOrderDTO);
                break;
            }
            case 3: {
                this.updateSignedOrder(syncSignedOrderDTO);
            }
        }
    }

    @Async
    public void syncBenefitUsedOrder(NotifyConsultDataDTO notifyConsultDataDTO, Long sleepTime) {
        try {
            if (Objects.nonNull(sleepTime)) {
                Thread.sleep(10000L);
            }
            String param = JSONObject.toJSONString((Object)notifyConsultDataDTO);
            log.info("syncBenefitUsedOrder\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            String result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/notify_consult/v1.0.1/data"), (String)param, (Map)this.getThirdHead((Object)notifyConsultDataDTO));
            log.info("syncBenefitUsedOrder\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("syncSignedOrder\u63a8\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    public void syncSignedOrder(SyncSignedOrderDTO syncSignedOrderDTO) {
        try {
            String param = JSONObject.toJSONString((Object)syncSignedOrderDTO);
            log.info("syncSignedOrder\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            String result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.1/signature/info"), (String)param, (Map)this.getThirdHead((Object)syncSignedOrderDTO));
            log.info("syncSignedOrder\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("syncSignedOrder\u63a8\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    public void updateSignedOrder(SyncSignedOrderDTO syncSignedOrderDTO) {
        try {
            String param = JSONObject.toJSONString((Object)syncSignedOrderDTO);
            log.info("updateSignedOrder\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            String result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.1/signature/changeSign"), (String)param, (Map)this.getThirdHead((Object)syncSignedOrderDTO));
            log.info("updateSignedOrder\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("updateSignedOrder\u63a8\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    public String getAbnormalData(AbnormalDataDTO abnormalDataDTO) {
        String result = "";
        try {
            String param = JSONObject.toJSONString((Object)abnormalDataDTO);
            log.info("getAbnormalData\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/abnormal/detail"), (String)param, (Map)this.getThirdHead((Object)abnormalDataDTO));
            log.info("getAbnormalData\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("getAbnormalData\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return result;
    }

    public String getHealthSchStatus(HealthInfoDTO healthInfoDTO) {
        String result = "";
        try {
            String param = JSONObject.toJSONString((Object)healthInfoDTO);
            log.info("getHealthSchStatus\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/healthSchedule/status"), (String)param, (Map)this.getThirdHead((Object)healthInfoDTO));
            log.info("getHealthSchStatus\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("getHealthSchStatus\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return result;
    }

    public String getHealthRecordWhetherUpdate(HealthInfoDTO healthInfoDTO) {
        String result = "";
        try {
            String param = JSONObject.toJSONString((Object)healthInfoDTO);
            log.info("getHealthRecordWhetherUpdate\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/healthRecordWhetherUpdate"), (String)param, (Map)this.getThirdHead((Object)healthInfoDTO));
            log.info("getHealthRecordWhetherUpdate\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("getHealthRecordWhetherUpdate\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return result;
    }

    public void pushFollowUpOrder(FollowUpOrderDTO followUpOrderDTO) {
        try {
            String param = JSONObject.toJSONString((Object)followUpOrderDTO);
            log.info("pushFollowUpOrder\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            String result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/push/follow_up_order"), (String)param, (Map)this.getThirdHead((Object)followUpOrderDTO));
            log.info("pushFollowUpOrder\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("pushFollowUpOrder\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    public String getUserPic(UserInfoDTO userInfoDTO) {
        String result = "";
        try {
            String param = JSONObject.toJSONString((Object)userInfoDTO);
            log.info("getUserPic\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/userPicUrl"), (String)param, (Map)this.getThirdHead((Object)userInfoDTO));
            log.info("getUserPic\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("getUserPic\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return result;
    }

    public void getUserBasicInfo(UserInfoDTO userInfoDTO) {
        try {
            String param = JSONObject.toJSONString((Object)userInfoDTO);
            log.info("getUserBasicInfo\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            String result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/userBasicInformation"), (String)param, (Map)this.getThirdHead((Object)userInfoDTO));
            log.info("getUserBasicInfo\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("getUserBasicInfo\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    public void getUserBasicInd(UserInfoDTO userInfoDTO) {
        try {
            String param = JSONObject.toJSONString((Object)userInfoDTO);
            log.info("getUserBasicInd\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            String result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/userBasicIndicators"), (String)param, (Map)this.getThirdHead((Object)userInfoDTO));
            log.info("getUserBasicInd\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("getUserBasicInd\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    public String getMasterUrl(MasterUrlDTO masterUrlDTO) {
        String result = "";
        try {
            String param = JSONObject.toJSONString((Object)masterUrlDTO);
            log.info("getMasterUrl\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/family_doctor_master_url"), (String)param, (Map)this.getThirdHead((Object)masterUrlDTO));
            log.info("getMasterUrl\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("getMasterUrl\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return result;
    }

    public String getReportDetail(ReportDetailDTO reportDetailDTO) {
        String result = "";
        try {
            String param = JSONObject.toJSONString((Object)reportDetailDTO);
            log.info("getReportDetail\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/report_detail"), (String)param, (Map)this.getThirdHead((Object)reportDetailDTO));
            log.info("getReportDetail\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("getReportDetail\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return result;
    }

    @Async
    public void syncUnReadMsgCount(UnReadMsgDTO unReadMsgDTO) {
        try {
            String param = JSONObject.toJSONString((Object)unReadMsgDTO);
            log.info("syncUnReadMsgCount\u8bf7\u6c42\u5165\u53c2{}", (Object)param);
            String result = HttpKit.jsonPost((String)(this.projProperties.getFamilyDoctorThirdUrl() + "/auth/v1.0.0/push/unread_msg"), (String)param, (Map)this.getThirdHead((Object)unReadMsgDTO));
            log.info("syncUnReadMsgCount\u8bf7\u6c42\u8fd4\u53c2{}", (Object)result);
        }
        catch (Exception e) {
            log.error("syncUnReadMsgCount\u63a8\u9001\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }
}

