/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.common.enums.MethodCodeEnum;
import com.ebaiyihui.hkdhisfront.service.HisRemoteService;
import com.ebaiyihui.hkdhisfront.utils.CxfClientUtil;
import com.ebaiyihui.hkdhisfront.utils.XmlTemplateKit;
import com.ebaiyihui.hkdhisfront.utils.XmlUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HisRemoteServiceImpl
implements HisRemoteService {
    private static final Logger log = LoggerFactory.getLogger(HisRemoteServiceImpl.class);
    @Value(value="${his.wsdlUrl}")
    public String hisWsdlUrl;
    @Value(value="${his.method}")
    public String method;
    @Value(value="${his.debug}")
    public Boolean debug;
    @Resource
    private CxfClientUtil cxfClientUtil;
    private String code = "?transCode=";
    private String xml = "&xml=";

    public <T> FrontResponse<T> requestHis(String transactionId, String transCode, Map map, Class<T> clazz) {
        String requestHisXml = XmlTemplateKit.process((String)transCode, (Map)map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml) && !transCode.equals(MethodCodeEnum.CHECK.getValue()) && !transCode.equals(MethodCodeEnum.CREATE_CARD_NUMBER.getValue()) && !transCode.equals(MethodCodeEnum.REGISTER_LEVEL.getValue())) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("requestHisXml\u6a21\u677f\uff1a" + JSON.toJSONString((Object)requestHisXml));
        String responseHisXml = "";
        try {
            responseHisXml = this.cxfClientUtil.send(this.hisWsdlUrl, this.method, transCode, requestHisXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (responseHisXml.contains("\u83b7\u53d6\u6570\u636e\u9519\u8bef")) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u8bf7\u6c42\u5931\u8d25");
        }
        log.info("requestHisXml\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("\r\n", "");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-16\"?>", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        log.info("xml\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    static {
        XmlTemplateKit.init();
    }
}

