/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.CreateCardReqDTO;
import com.ebaiyihui.his.pojo.dto.CreateCardResDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoReqDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoResDTO;
import com.ebaiyihui.his.pojo.dto.registerHealthCard;
import com.ebaiyihui.his.pojo.dto.registerHealthCardResDTO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.utils.SnowflakeIdWorker;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.card.QueryCardInfoReqVO;
import his.pojo.vo.card.QueryCardInfoResVO;
import his.pojo.vo.card.RegisteredCardReqVO;
import his.pojo.vo.card.RegisteredCardResVO;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        try {
            QueryCardInfoReqVO paramBody = (QueryCardInfoReqVO)param.getBody();
            QueryCardInfoReqDTO hisQueryCardInfoReqVO = new QueryCardInfoReqDTO();
            if (!StrUtil.isNotBlank((CharSequence)paramBody.getCardNo())) {
                hisQueryCardInfoReqVO.setHosCardNo(paramBody.getCredNo());
            }
            if (!StrUtil.isNotBlank((CharSequence)paramBody.getCredNo())) {
                hisQueryCardInfoReqVO.setHosCardNo(paramBody.getCardNo());
            }
            hisQueryCardInfoReqVO.setHosCardType("66");
            HashMap<String, QueryCardInfoReqDTO> cardInfoMap = new HashMap<String, QueryCardInfoReqDTO>();
            cardInfoMap.put(EntityKeyEnum.QUERY_CARD_INFO.getValue(), hisQueryCardInfoReqVO);
            log.info("\u8bf7\u6c42his\u83b7\u53d6\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f\u5165\u53c2 - > {}", (Object)JSON.toJSONString(cardInfoMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse queryCardInfoResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.FIND_PATIENT_INFO.getValue(), cardInfoMap, QueryCardInfoResDTO.class);
            log.info("\u8bf7\u6c42his\u83b7\u53d6\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f\u51fa\u53c2 - > {}", (Object)JSON.toJSONString((Object)queryCardInfoResDTOFrontResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(queryCardInfoResDTOFrontResponse)) {
                return FrontResponse.error((String)queryCardInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(queryCardInfoResDTOFrontResponse.getBody())) {
                return FrontResponse.error((String)queryCardInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)queryCardInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)queryCardInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            if ("1".equals(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getData().getHosCardType())) {
                return FrontResponse.error((String)queryCardInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)"\u5f53\u524d\u60a3\u8005\u6682\u65e0\u5c31\u8bca\u5361");
            }
            QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
            queryCardInfoResVO.setTelephone(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getData().getPhone());
            queryCardInfoResVO.setCardNo(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getData().getPatientId());
            queryCardInfoResVO.setCredNo(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getData().getCertNo());
            queryCardInfoResVO.setPatientId(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getData().getHosCardNo());
            queryCardInfoResVO.setDob(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getData().getBirth());
            queryCardInfoResVO.setCredType("01");
            queryCardInfoResVO.setCardType("1702");
            queryCardInfoResVO.setAddress(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getData().getAddress());
            queryCardInfoResVO.setName(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getData().getName());
            queryCardInfoResVO.setSex(((QueryCardInfoResDTO)queryCardInfoResDTOFrontResponse.getBody()).getData().getSex().equals("01") ? "\u7537" : "\u5973");
            return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    private FrontResponse registerHealthCard(FrontRequest<RegisteredCardReqVO> param) {
        RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
        HashMap<String, registerHealthCard> createCardMap = new HashMap<String, registerHealthCard>();
        registerHealthCard registerHealthCard2 = new registerHealthCard();
        registerHealthCard2.setCityCode("620000");
        registerHealthCard2.setSqfs("8");
        registerHealthCard2.setYljgdm("620000000726");
        registerHealthCard2.setZjlxdm("01");
        registerHealthCard2.setZjhm(body.getCredNo());
        registerHealthCard2.setXm(body.getName());
        registerHealthCard2.setXbdm(body.getSex().equals("M") ? "1" : "2");
        registerHealthCard2.setBrdhhm(body.getTelephone());
        registerHealthCard2.setTradeTime(DateUtil.now());
        registerHealthCard2.setMzdm(body.getNation());
        createCardMap.put(EntityKeyEnum.CREATE_CARD.getValue(), registerHealthCard2);
        log.info("\u8bf7\u6c42his\u529e\u7406\u8bca\u5361\u5165\u53c2 - > {}", (Object)JSON.toJSONString(createCardMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        FrontResponse createCardResDTOFrontResponse = this.hisRemoteService.requestHisUrl("http://61.178.141.148:57772/csp/jcjt/HEREN.BS.DZJKK.DZJKKBusinessWS.CLS?WSDL", "MainProcess", param.getTransactionId(), MethodCodeEnum.CREATE_ELECTRONIC_CARD.getValue(), createCardMap, registerHealthCardResDTO.class);
        log.info("\u8bf7\u6c42his\u529e\u7406\u8bca\u5361\u51fa\u53c2 - > {}", (Object)JSON.toJSONString((Object)createCardResDTOFrontResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        if (null == createCardResDTOFrontResponse) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (((registerHealthCardResDTO)createCardResDTOFrontResponse.getBody()).getHead().getTradeStatus().equals("AE")) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((registerHealthCardResDTO)createCardResDTOFrontResponse.getBody()).getHead().getTradeMessage());
        }
        if (null == ((registerHealthCardResDTO)createCardResDTOFrontResponse.getBody()).getBody().getQrcode()) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)((registerHealthCardResDTO)createCardResDTOFrontResponse.getBody()).getHead().getTradeMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)((registerHealthCardResDTO)createCardResDTOFrontResponse.getBody()).getBody().getQrcode());
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            FrontResponse frontResponse = this.registerHealthCard(param);
            if (null == frontResponse) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5931\u8d25");
            }
            if ("0".equals(frontResponse.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5931\u8d25");
            }
            if (null == frontResponse.getBody().toString()) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5931\u8d25");
            }
            RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
            HashMap<String, CreateCardReqDTO> createCardMap = new HashMap<String, CreateCardReqDTO>();
            CreateCardReqDTO createCardReqVo = new CreateCardReqDTO();
            int ageByIdCard = IdcardUtil.getAgeByIdCard((String)body.getCredNo());
            if (ageByIdCard >= 18) {
                createCardReqVo.setHosCardFlag("2");
            } else {
                createCardReqVo.setHosCardFlag("1");
            }
            createCardReqVo.setName(body.getName());
            createCardReqVo.setCertNo(body.getCredNo());
            createCardReqVo.setHosCardNo(frontResponse.getBody().toString());
            createCardReqVo.setAddress(body.getAddress());
            createCardReqVo.setPhone(body.getTelephone());
            createCardReqVo.setBirth(IdcardUtil.getBirthByIdCard((String)body.getCredNo()));
            createCardReqVo.setSex(IdcardUtil.getGenderByIdCard((String)body.getCredNo()) == 1 ? "M" : "F");
            createCardReqVo.setHosCardType("66");
            createCardMap.put(EntityKeyEnum.CREATE_CARD.getValue(), createCardReqVo);
            log.info("\u8bf7\u6c42his\u529e\u7406\u8bca\u5361\u5165\u53c2 - > {}", (Object)JSON.toJSONString(createCardMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse createCardResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CREATE_VISIT_CARD.getValue(), createCardMap, CreateCardResDTO.class);
            log.info("\u8bf7\u6c42his\u529e\u7406\u8bca\u5361\u51fa\u53c2 - > {}", (Object)JSON.toJSONString((Object)createCardResDTOFrontResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(createCardResDTOFrontResponse)) {
                return FrontResponse.error((String)createCardResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(createCardResDTOFrontResponse.getBody())) {
                return FrontResponse.error((String)createCardResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((CreateCardResDTO)createCardResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)createCardResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((CreateCardResDTO)createCardResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)createCardResDTOFrontResponse.getTransactionId(), (String)"0", (String)((CreateCardResDTO)createCardResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
            registeredCardResVO.setCardNo(((CreateCardResDTO)createCardResDTOFrontResponse.getBody()).getData().getPatientId());
            registeredCardResVO.setPatientId(frontResponse.getBody().toString());
            registeredCardResVO.setCredType("01");
            registeredCardResVO.setCardType("1702");
            return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
        }
        catch (Exception e) {
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }
}

