/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);
    public static final int ONE_THOUSAND = 1000;
    public static final String DELAY_STRING = "x-delay";

    public static void orderHeartbeat(RabbitTemplate rabbitTemplate, String orderId, Long orderExpireTime) {
        rabbitTemplate.convertAndSend("logistics.delayed_exchange_pre_new", "order.sync.day.heartbeat.routing.key", (Object)orderId, message -> {
            message.getMessageProperties().setHeader(DELAY_STRING, (Object)(orderExpireTime * 1000L));
            log.info("send orderHeartbeat message to rabbitmq: " + orderId);
            return message;
        });
    }

    public static void orderEveryDay(RabbitTemplate rabbitTemplate, String orderId, Long orderExpireTime) {
        rabbitTemplate.convertAndSend("logistics.delayed_exchange_pre_new", "order.sync.every.day.routing.key", (Object)orderId, message -> {
            message.getMessageProperties().setHeader(DELAY_STRING, (Object)(orderExpireTime * 1000L));
            log.info("send orderEveryDay message to rabbitmq: " + orderId);
            return message;
        });
    }
}

