/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.rabbitmq;

import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.his.service.YkTransferService;
import com.ebaiyihui.his.utils.DateUtil;
import com.ebaiyihui.his.utils.RabbitMqUtils;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DelayedOrderSyncHeartbeatReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedOrderSyncHeartbeatReceiver.class);
    @Autowired
    private YkTransferService ykTransferService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    public static String IDENT = UUIDUtils.getUUID();
    public static final long TIME = 60L;

    @PostConstruct
    public void setMq() {
        RabbitMqUtils.orderHeartbeat((RabbitTemplate)this.rabbitTemplate, (String)IDENT, (Long)60L);
    }

    @Async(value="myThreadPoolTaskExecutor")
    @RabbitListener(queues={"order.sync.day.heartbeat.queue"})
    @RabbitHandler
    public void nextBuyOrder(String message) {
        Boolean state;
        Map syncPatientSwitch;
        String state2;
        if (!message.equalsIgnoreCase(IDENT)) {
            log.info("\u4e0d\u4e3a\u672c\u6b21\u5b9a\u65f6\uff0c\u9000\u51fa");
            return;
        }
        String time = DateUtil.getCurrentTimeStr();
        log.info(time + "\u7684\u5fc3\u8df3\u5f00\u59cb\uff0c\u6267\u884c\u7684\u65f6\u95f4\u4e3a: " + LocalDateTime.now().toLocalTime());
        RabbitMqUtils.orderHeartbeat((RabbitTemplate)this.rabbitTemplate, (String)IDENT, (Long)60L);
        Map heartbeat = this.ykTransferService.heartbeat();
        if (heartbeat != null && StringUtils.isNotBlank((CharSequence)(state2 = (String)heartbeat.get("actionState"))) && "1".equals(state2)) {
            log.info("\u5f00\u59cb\u6267\u884c\u8ba2\u5355\u540c\u6b65\u548c\u5e93\u5b58\u67e5\u8be2");
            this.ykTransferService.historicalOrderService();
            this.ykTransferService.currentDrugPriceAndInventoryService();
        }
        if ((syncPatientSwitch = this.ykTransferService.getSyncPatientSwitch()) != null && (state = (Boolean)syncPatientSwitch.get("syncPatientSwitch")).booleanValue()) {
            log.info("\u5f00\u59cb\u6267\u884c\u7528\u6237\u540c\u6b65");
            this.ykTransferService.historicalMemberService();
        }
        log.info(time + "\u7684\u5fc3\u8df3\u7ed3\u675f\uff0c\u6267\u884c\u7684\u65f6\u95f4\u4e3a: " + LocalDateTime.now().toLocalTime());
    }
}

