/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtil {
    public static String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static String TIME_FORMAT = "HH:mm:ss";
    public static String DATE_FORMAT = "yyyy-MM-dd";

    public static String getCurrentTimeStr() {
        Date currentDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
        return format.format(currentDate);
    }

    public static String getCurrentDateStr() {
        Date currentDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(currentDate);
    }

    public static String dateStrToStamp(String s) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FULL_FORMAT);
        Date date = simpleDateFormat.parse(s);
        long ts = date.getTime();
        String res = String.valueOf(ts);
        return res;
    }

    public static Date dateStrToDate(String s) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FULL_FORMAT);
            Date date = simpleDateFormat.parse(s);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getAfterCurrentDay(int days) {
        Date result = null;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.add(7, days);
            result = calendar.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Date addHours(Date date, int num) {
        Calendar startDT = Calendar.getInstance();
        startDT.setTime(date);
        startDT.add(11, num);
        return startDT.getTime();
    }

    public static String getPastDate(int past) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, calendar.get(6) - past);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        String result = format.format(today);
        return result;
    }

    public static Date parseY_M_DDate(String s) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            Date date = simpleDateFormat.parse(s);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTimeAfter(String date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseY_M_DDate((String)date));
        calendar.set(6, calendar.get(6) + num);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(today);
    }

    public static String getTimeAfter(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, calendar.get(6) + num);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(today);
    }

    public static String getTimeAfterSecond(String date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.convertString2Date((String)FULL_FORMAT, (String)date));
        calendar.set(13, calendar.get(13) + num);
        Date today = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(FULL_FORMAT);
        return format.format(today);
    }

    public static Date getSubtractMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, -month);
        return now.getTime();
    }

    public static String dateToSimpleString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.format(date);
    }

    public static boolean checkTimeRange(String startTime, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(DateTimeFormatter.ofPattern(format).format(LocalDateTime.now()));
            return startDate.after(endDate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean timeRange(String startTime, String endTime) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            Date endDate = sdf.parse(endTime);
            Date startDate = sdf.parse(startTime);
            return startDate.after(endDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List<String> getIntervalTimeList(String start, String end, int interval) {
        Date startDate = DateUtil.convertString2Date((String)"HH:mm:ss", (String)start);
        Date endDate = DateUtil.convertString2Date((String)"HH:mm:ss", (String)end);
        ArrayList<String> list = new ArrayList<String>();
        while (startDate.getTime() <= endDate.getTime()) {
            list.add(DateUtil.convertDate2String((String)"HH:mm:ss", (Date)startDate));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.add(12, interval);
            if (calendar.getTime().getTime() > endDate.getTime()) {
                if (!startDate.equals(endDate)) {
                    list.add(DateUtil.convertDate2String((String)"HH:mm:ss", (Date)endDate));
                }
                startDate = calendar.getTime();
                continue;
            }
            startDate = calendar.getTime();
        }
        return list;
    }

    public static List<String> getIntervalDateTimeList(String start, String end, int interval) {
        Date startDate = DateUtil.convertString2Date((String)"yyyy-MM-dd HH:mm:ss", (String)start);
        Date endDate = DateUtil.convertString2Date((String)"yyyy-MM-dd HH:mm:ss", (String)end);
        ArrayList<String> list = new ArrayList<String>();
        while (startDate.getTime() <= endDate.getTime()) {
            list.add(DateUtil.convertDate2String((String)"yyyy-MM-dd HH:mm:ss", (Date)startDate));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.add(12, interval);
            if (calendar.getTime().getTime() > endDate.getTime()) {
                if (!startDate.equals(endDate)) {
                    list.add(DateUtil.convertDate2String((String)"yyyy-MM-dd HH:mm:ss", (Date)endDate));
                }
                startDate = calendar.getTime();
                continue;
            }
            startDate = calendar.getTime();
        }
        return list;
    }

    public static Date convertString2Date(String format, String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        try {
            Date date = simpleDateFormat.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertDate2String(String format, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static String formatDate(Date date, Object ... pattern) {
        if (date == null) {
            return null;
        }
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        return formatDate;
    }

    public static String getHours() {
        return DateUtil.formatDate((Date)new Date(), (Object[])new Object[]{"HH"});
    }
}

