/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.AppointRegistrationNoPayReqDTO;
import com.ebaiyihui.his.pojo.dto.AppointRegistrationNoPayResDTO;
import com.ebaiyihui.his.pojo.dto.AppointRegistrationNoPayResDataDTO;
import com.ebaiyihui.his.pojo.dto.AppointmentNoPayCancelResDTO;
import com.ebaiyihui.his.pojo.dto.CancelReservationDTO;
import com.ebaiyihui.his.pojo.dto.DayRegistrationPayRegistrationDTO;
import com.ebaiyihui.his.pojo.dto.DayRegistrationPayRegistrationResDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointRecordReqDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointRecordResDTO;
import com.ebaiyihui.his.pojo.dto.NewPayAppointmentResDTO;
import com.ebaiyihui.his.pojo.dto.NewPayAppointmentResDataDTO;
import com.ebaiyihui.his.pojo.dto.PayAppointmentReqDTO;
import com.ebaiyihui.his.pojo.dto.PayAppointmentResDTO;
import com.ebaiyihui.his.pojo.dto.RegisteredNowDayReqDTO;
import com.ebaiyihui.his.pojo.dto.RegisteredNowDayResDTO;
import com.ebaiyihui.his.pojo.dto.ResponseModel;
import com.ebaiyihui.his.pojo.dto.ReturnRegisterReqDTO;
import com.ebaiyihui.his.pojo.dto.ReturnRegisterResDTO;
import com.ebaiyihui.his.pojo.dto.WithdrawalNumberDTO;
import com.ebaiyihui.his.pojo.dto.WithdrawalNumberResDTO;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordReq;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordRes;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationMsg;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.AppointService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AppointServiceImpl
implements AppointService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public String hisOperNum;
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<ConfirmRegisterRes> confirmRegister(FrontRequest<ConfirmRegisterReq> param) {
        ConfirmRegisterReq confirmRegisterReq = (ConfirmRegisterReq)param.getBody();
        if (null == confirmRegisterReq) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, AppointRegistrationNoPayReqDTO> map = new HashMap<String, AppointRegistrationNoPayReqDTO>();
        AppointRegistrationNoPayReqDTO appointRegistrationNoPayReqDTO = new AppointRegistrationNoPayReqDTO();
        appointRegistrationNoPayReqDTO.setLockType(Integer.valueOf(1));
        appointRegistrationNoPayReqDTO.setLockTime("");
        appointRegistrationNoPayReqDTO.setScheduleId(confirmRegisterReq.getRbasId());
        appointRegistrationNoPayReqDTO.setParTimeId("");
        appointRegistrationNoPayReqDTO.setPatientId(confirmRegisterReq.getPatientId());
        appointRegistrationNoPayReqDTO.setMobile(confirmRegisterReq.getPhone());
        appointRegistrationNoPayReqDTO.setIDCard(confirmRegisterReq.getIdNo());
        map.put(EntityKeyEnum.OUT_PAT_BOOKINGCANCEL.getValue(), appointRegistrationNoPayReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUT_PAT_BOOKINGCANCEL.getValue(), map, AppointRegistrationNoPayResDTO.class);
        AppointRegistrationNoPayResDTO appointRegistrationNoPayReq = (AppointRegistrationNoPayResDTO)response.getBody();
        if (Objects.isNull(appointRegistrationNoPayReq)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"1", (String)response.getMessage());
        }
        ResponseModel responseModel = appointRegistrationNoPayReq.getResponseModel();
        if (1 != responseModel.getReturnCode()) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        AppointRegistrationNoPayResDataDTO data = appointRegistrationNoPayReq.getData();
        ConfirmRegisterRes confirmRegisterRes = new ConfirmRegisterRes();
        confirmRegisterRes.setAdmitAddress(data.getLocation());
        confirmRegisterRes.setAppointId(data.getHisOrderNO());
        return FrontResponse.success((String)param.getTransactionId(), (Object)confirmRegisterRes);
    }

    public FrontResponse<PayRegistrationRes> payRegistration(FrontRequest<PayRegistrationReq> param) {
        PayRegistrationRes payRegistrationRes = new PayRegistrationRes();
        PayRegistrationReq payRegistrationReq = (PayRegistrationReq)param.getBody();
        PayRegistrationMsg respMsg = payRegistrationReq.getRespMsg();
        PayAppointmentReqDTO payAppointmentReqDTO = new PayAppointmentReqDTO();
        payAppointmentReqDTO.setScheduleId(payRegistrationReq.getScheduleId());
        payAppointmentReqDTO.setPatientID(payRegistrationReq.getPatientId());
        HashMap<String, PayAppointmentReqDTO> map = new HashMap<String, PayAppointmentReqDTO>();
        map.put(EntityKeyEnum.PAY_REGISTRATION.getValue(), payAppointmentReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.APPOINTMENT_REGISTRATION_PAY.getValue(), map, PayAppointmentResDTO.class);
        PayAppointmentResDTO responseBody = (PayAppointmentResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"1", (String)response.getMessage());
        }
        ResponseModel responseModel = responseBody.getResponseModel();
        if (1 != responseModel.getReturnCode()) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)payRegistrationRes);
    }

    public FrontResponse<CancelRegisterRes> cancelRegister(FrontRequest<CancelRegisterReq> param) {
        CancelRegisterReq cancelRegisterReq = (CancelRegisterReq)param.getBody();
        if (null == cancelRegisterReq) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CancelReservationDTO cancelReservationDTO = new CancelReservationDTO();
        HashMap<String, CancelReservationDTO> map = new HashMap<String, CancelReservationDTO>();
        map.put(EntityKeyEnum.APPOINTMENT_REGISTRATION_NOPAY.getValue(), cancelReservationDTO);
        FrontResponse appointRegistrationNoPayRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CANCEL_APPOINTMENT.getValue(), map, AppointmentNoPayCancelResDTO.class);
        AppointmentNoPayCancelResDTO appointmentNoPayCancelResDTO = (AppointmentNoPayCancelResDTO)appointRegistrationNoPayRes.getBody();
        if (null == appointmentNoPayCancelResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)appointRegistrationNoPayRes.getMessage());
        }
        if (!"1".equals(appointmentNoPayCancelResDTO.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)appointmentNoPayCancelResDTO.getResultMsg());
        }
        CancelRegisterRes cancelRegisterRes = new CancelRegisterRes();
        cancelRegisterRes.setMsg(appointmentNoPayCancelResDTO.getResultMsg());
        return FrontResponse.success((String)appointRegistrationNoPayRes.getTransactionId(), (Object)cancelRegisterRes);
    }

    public FrontResponse<ReturnRegisterRes> returnRegister(FrontRequest<ReturnRegisterReq> param) {
        ReturnRegisterRes returnRegisterRes = new ReturnRegisterRes();
        ReturnRegisterReqDTO returnRegisterReqDTO = new ReturnRegisterReqDTO();
        ReturnRegisterReq returnRegisterReq = (ReturnRegisterReq)param.getBody();
        HashMap<String, ReturnRegisterReqDTO> map = new HashMap<String, ReturnRegisterReqDTO>();
        map.put(EntityKeyEnum.RETURN_REGISTER.getValue(), returnRegisterReqDTO);
        FrontResponse returnRegisterResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.ONLINE_REGISTRATION_REFUND.getValue(), map, ReturnRegisterResDTO.class);
        if (null == returnRegisterResDTO) {
            return FrontResponse.error((String)returnRegisterResDTO.getTransactionId(), (String)"0", (String)returnRegisterResDTO.getMessage());
        }
        if (!"1".equals(returnRegisterResDTO.getCode())) {
            return FrontResponse.error((String)returnRegisterResDTO.getTransactionId(), (String)"0", (String)returnRegisterResDTO.getCode());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)returnRegisterRes);
    }

    public FrontResponse<GetAppointRecordRes> getAppointRecord(FrontRequest<GetAppointRecordReq> param) {
        GetAppointRecordRes getAppointRecordRes = new GetAppointRecordRes();
        ArrayList items = new ArrayList();
        GetAppointRecordReqDTO getAppointRecordReqDTO = new GetAppointRecordReqDTO();
        HashMap<String, GetAppointRecordReqDTO> map = new HashMap<String, GetAppointRecordReqDTO>();
        map.put(EntityKeyEnum.GET_APPOINT_RECORD.getValue(), getAppointRecordReqDTO);
        FrontResponse appointRecordRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PATIENT_APPOINTMENT_LIST_QUERY.getValue(), map, GetAppointRecordResDTO.class);
        if (null == appointRecordRes) {
            return FrontResponse.error((String)appointRecordRes.getTransactionId(), (String)"0", (String)appointRecordRes.getMessage());
        }
        if (!"1".equals(((GetAppointRecordResDTO)appointRecordRes.getBody()).getResultCode())) {
            return FrontResponse.error((String)appointRecordRes.getTransactionId(), (String)"0", (String)((GetAppointRecordResDTO)appointRecordRes.getBody()).getResultMsg());
        }
        List getAppointRecordResItemDTOList = ((GetAppointRecordResDTO)appointRecordRes.getBody()).getDataRow();
        if (CollectionUtils.isEmpty((Collection)getAppointRecordResItemDTOList)) {
            return FrontResponse.error((String)appointRecordRes.getTransactionId(), (String)"0", (String)((GetAppointRecordResDTO)appointRecordRes.getBody()).getResultMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAppointRecordRes);
    }

    public FrontResponse<DayRegisterRes> dayRegister(FrontRequest<DayRegisterReq> param) {
        DayRegisterReq dayRegisterReq = (DayRegisterReq)param.getBody();
        if (null == dayRegisterReq) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RegisteredNowDayReqDTO registeredNowDayReqDTO = new RegisteredNowDayReqDTO();
        registeredNowDayReqDTO.setLockType(Integer.valueOf(1));
        registeredNowDayReqDTO.setPatientID(dayRegisterReq.getPatientId());
        registeredNowDayReqDTO.setLockTime("");
        HashMap<String, RegisteredNowDayReqDTO> map = new HashMap<String, RegisteredNowDayReqDTO>();
        map.put(EntityKeyEnum.REGISTERED_NOWDAY.getValue(), registeredNowDayReqDTO);
        FrontResponse registeredNowDayRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REGISTERED_NOWDAY.getValue(), map, RegisteredNowDayResDTO.class);
        this.logger.info("\u8fd4\u56debody\u6570\u636e\uff1a" + registeredNowDayRes.getBody());
        RegisteredNowDayResDTO registeredNowDayResDTO = (RegisteredNowDayResDTO)registeredNowDayRes.getBody();
        if (null == registeredNowDayResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"1", (String)registeredNowDayRes.getMessage());
        }
        ResponseModel responseModel = registeredNowDayResDTO.getResponseModel();
        if (1 != responseModel.getReturnCode()) {
            return FrontResponse.error((String)registeredNowDayRes.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        DayRegisterRes dayRegisterRes = new DayRegisterRes();
        this.logger.info("\u8fd4\u56de\u6570\u636e\uff1a" + FrontResponse.success((String)registeredNowDayRes.getTransactionId(), (Object)dayRegisterRes));
        return FrontResponse.success((String)registeredNowDayRes.getTransactionId(), (Object)dayRegisterRes);
    }

    public FrontResponse<PayRegistrationRes> dayPayRegistration(FrontRequest<PayRegistrationReq> param) {
        this.logger.info("\u5f53\u65e5\u6302\u53f7\u786e\u8ba4\u5165\u53c2" + JSON.toJSONString(param));
        PayRegistrationRes payRegistrationRes = new PayRegistrationRes();
        PayRegistrationReq payRegistrationReq = (PayRegistrationReq)param.getBody();
        PayRegistrationMsg respMsg = payRegistrationReq.getRespMsg();
        PayAppointmentReqDTO payAppointmentReqDTO = new PayAppointmentReqDTO();
        payAppointmentReqDTO.setScheduleId(payAppointmentReqDTO.getScheduleId());
        payAppointmentReqDTO.setOrderNo(payRegistrationReq.getAppointId());
        payAppointmentReqDTO.setPatientID(payRegistrationReq.getPatientId());
        payAppointmentReqDTO.setScheduleId(payRegistrationReq.getScheduleId());
        payAppointmentReqDTO.setPayNature(Integer.valueOf(1));
        payAppointmentReqDTO.setPayType(Integer.valueOf(2));
        payAppointmentReqDTO.setPowerTranID(respMsg.getOrderid());
        payAppointmentReqDTO.setZFAmount(respMsg.getPayment());
        payAppointmentReqDTO.setHisOperNum(this.hisOperNum);
        HashMap<String, PayAppointmentReqDTO> map = new HashMap<String, PayAppointmentReqDTO>();
        this.logger.info("payAppointmentReqDTO:" + payAppointmentReqDTO);
        map.put(EntityKeyEnum.REGISTERED_NOWDAY_PAY.getValue(), payAppointmentReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DAY_APPOINTMENT_REGISTRATION_PAY.getValue(), map, NewPayAppointmentResDTO.class);
        NewPayAppointmentResDTO responseBody = (NewPayAppointmentResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"1", (String)response.getMessage());
        }
        ResponseModel responseModel = responseBody.getResponseModel();
        if (1 != responseModel.getReturnCode()) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        NewPayAppointmentResDataDTO responseBodyData = (NewPayAppointmentResDataDTO)responseBody.getData().get(0);
        payRegistrationRes.setRegistFee(payRegistrationReq.getRegFee());
        payRegistrationRes.setAdmId(responseBodyData.getSerialNo());
        payRegistrationRes.setAdmitAddress(responseBodyData.getLocation());
        payRegistrationRes.setReceiptId(responseBodyData.getReptNum());
        payRegistrationRes.setTotalRegFee(payRegistrationReq.getRegFee());
        return FrontResponse.success((String)param.getTransactionId(), (Object)payRegistrationRes);
    }

    public FrontResponse<Object> withdrawalNumber(FrontRequest<PayRegistrationReq> param) {
        WithdrawalNumberDTO withdrawalNumberDTO = WithdrawalNumberDTO.builder().build();
        HashMap<String, WithdrawalNumberDTO> map = new HashMap<String, WithdrawalNumberDTO>();
        map.put(EntityKeyEnum.WITHDRAWAL_NUMBER.getValue(), withdrawalNumberDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.WITHDRAWAL_NUMBER.getValue(), map, WithdrawalNumberResDTO.class);
        return null;
    }

    public FrontResponse<Object> dayRegistrationPayRegistration(FrontRequest<PayRegistrationReq> param) {
        DayRegistrationPayRegistrationDTO registrationDTO = DayRegistrationPayRegistrationDTO.builder().build();
        HashMap<String, DayRegistrationPayRegistrationDTO> map = new HashMap<String, DayRegistrationPayRegistrationDTO>();
        map.put(EntityKeyEnum.DAY_REGISTRATION_PAY_REGISTRATION.getValue(), registrationDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DAY_REGISTRATION_PAY_REGISTRATION.getValue(), map, DayRegistrationPayRegistrationResDTO.class);
        return null;
    }

    public static void main(String[] args) {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n<response> \n  <returnresult> \n    <returncode>1</returncode>  \n    <errormsg>\u6210\u529f\u8fd4\u56de1\u6761</errormsg> \n  </returnresult>  \n  <data> \n    <data_row> \n      <ReptNum>112391</ReptNum>  \n      <Location/>  \n      <TiketNo>MZ001321009</TiketNo>  \n      <SerialNo>5</SerialNo>  \n      <QueueCount>4</QueueCount>  \n      <Ext1>2021/12/8 0:00:00~2021/12/8 12:00:00</Ext1>  \n      <Ext2/>  \n      <Ext3/>  \n      <Ext4/>  \n      <Ext5/> \n    </data_row> \n  </data>\n</response>\n";
        NewPayAppointmentResDTO resHisDTO = (NewPayAppointmentResDTO)XmlUtil.convertToJavaBean((String)xml, NewPayAppointmentResDTO.class);
        System.out.println(resHisDTO);
    }
}

