/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.common.enums.GanderTypeEnums;
import com.ebaiyihui.his.model.QueryCardInfo;
import com.ebaiyihui.his.model.QueryCardInfoRes;
import com.ebaiyihui.his.model.RegisterCardInfo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardReqVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.utils.HeadUtil;
import com.ebaiyihui.his.utils.HttpUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;
    @Value(value="${his.wsdlUrl}")
    public String hisWsdlUrl;

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        QueryCardInfoReqVO paramBody = (QueryCardInfoReqVO)param.getBody();
        QueryCardInfo queryCardInfo = new QueryCardInfo();
        queryCardInfo.setIdNo(paramBody.getCredNo());
        queryCardInfo.setIDTypeCode("01");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Head", HeadUtil.getHead());
        map.put("Data", queryCardInfo);
        String url = this.hisWsdlUrl.concat("/HISCenter/PatientInfoQuery");
        try {
            log.info("\u67e5\u8be2\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f:{}", (Object)JSON.toJSONString(map));
            String responseBody = HttpUtils.doPost((String)url, (String)JSON.toJSONString(map));
            log.info("\u8fd4\u56de\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f:{}", (Object)responseBody);
            QueryCardInfoRes response = (QueryCardInfoRes)JSON.parseObject((String)responseBody, QueryCardInfoRes.class);
            log.info("\u8fd4\u56de\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606fresponse:{}", (Object)JSON.toJSONString((Object)response));
            if (Objects.nonNull(response)) {
                List data = response.getData();
                if (Objects.nonNull(data) && !data.isEmpty()) {
                    QueryCardInfoRes.DataDTO dataDTO = (QueryCardInfoRes.DataDTO)data.get(0);
                    queryCardInfoResVO.setName(dataDTO.getPatientName());
                    queryCardInfoResVO.setTelephone(dataDTO.getPhone());
                    String idNo = dataDTO.getIdNo();
                    String genderStr = IdCardUtil.getGenderByIdCard((String)idNo);
                    if (StringUtils.isNotBlank((CharSequence)genderStr)) {
                        queryCardInfoResVO.setSex(genderStr);
                    }
                    queryCardInfoResVO.setDob(dataDTO.getBirth());
                    queryCardInfoResVO.setPatientId(dataDTO.getPatientId());
                    queryCardInfoResVO.setPatientNo(dataDTO.getPatientId());
                    queryCardInfoResVO.setCredNo(idNo);
                    queryCardInfoResVO.setCredType(dataDTO.getIDTypeName());
                    queryCardInfoResVO.setCardNo(dataDTO.getPatientId());
                    queryCardInfoResVO.setCardType(paramBody.getCardType());
                    return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO);
                }
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ca1\u6709\u67e5\u5230\u60a3\u8005\u6570\u636e");
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ca1\u6709\u67e5\u5230\u60a3\u8005\u6570\u636e");
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42his\u5931\u8d25");
        }
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        RegisteredCardReqVO registeredCardReqVO = (RegisteredCardReqVO)param.getBody();
        RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
        RegisterCardInfo registerCardInfo = new RegisterCardInfo();
        RegisterCardInfo.PatientDTO patientDTO = new RegisterCardInfo.PatientDTO();
        patientDTO.setIdNo(registeredCardReqVO.getCredNo());
        patientDTO.setIDTypeCode("01");
        patientDTO.setPhone(registeredCardReqVO.getTelephone());
        patientDTO.setPatientName(registeredCardReqVO.getName());
        patientDTO.setSexCode(GanderTypeEnums.getValue((String)registeredCardReqVO.getSex()));
        patientDTO.setBirth(registeredCardReqVO.getDob());
        registerCardInfo.setPatient(patientDTO);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Head", HeadUtil.getHead());
        map.put("Data", registerCardInfo);
        String url = this.hisWsdlUrl.concat("/HISCenter/PatientInfoRegisterForOther");
        try {
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u4fe1\u606f:{}", (Object)JSON.toJSONString(map));
            String responseBody = HttpUtils.doPost((String)url, (String)JSON.toJSONString(map));
            log.info("\u8fd4\u56de\u6ce8\u518c\u5c31\u8bca\u5361\u4fe1\u606f:{}", (Object)responseBody);
            QueryCardInfoRes response = (QueryCardInfoRes)JSON.parseObject((String)responseBody, QueryCardInfoRes.class);
            log.info("\u8fd4\u56de\u6ce8\u518c\u5c31\u8bca\u5361\u4fe1\u606fresponse:{}", (Object)response);
            return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public FrontResponse<Object> patMedCardCheck(FrontRequest<QueryCardInfoReqVO> param) {
        return FrontResponse.success((String)param.getTransactionId(), null);
    }

    public static void main(String[] args) {
        QueryCardInfo queryCardInfo = new QueryCardInfo();
        queryCardInfo.setIdNo("12313123123");
        queryCardInfo.setIDTypeCode("01");
        HashMap<String, QueryCardInfo> map = new HashMap<String, QueryCardInfo>();
        map.put("Data", queryCardInfo);
        System.out.println(JSON.toJSONString(map));
    }
}

