/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.model.InspectionModel;
import com.ebaiyihui.his.model.VDzbgJcModel;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.QueryDischargeRecordRes;
import com.ebaiyihui.his.pojo.vo.report.VhisCyjlModel;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String CHECK_TYPE = "1";
    public static final String INSPECTION_TYPE = "2";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq paramBody = (GetReportListsReq)param.getBody();
        String reportType = paramBody.getReportType();
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        getReportListsRes.setSuccess(CHECK_TYPE);
        getReportListsRes.setPatientID(paramBody.getPatientId());
        ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
        if (Objects.equals(CHECK_TYPE, reportType)) {
            ArrayList inspectionModels = new ArrayList();
            if (!inspectionModels.isEmpty()) {
                Map<String, List<InspectionModel>> inspectionModelsMap = inspectionModels.stream().collect(Collectors.groupingBy(InspectionModel::getReportNo));
                inspectionModelsMap.forEach((s, inspectionModels1) -> {
                    InspectionModel inspectionModel = (InspectionModel)inspectionModels1.get(0);
                    GetReportListsData getReportListsData = new GetReportListsData();
                    getReportListsData.setReportNo(inspectionModel.getReportNo());
                    getReportListsData.setReportName(inspectionModel.getItemName1());
                    getReportListsData.setReportType(CHECK_TYPE);
                    getReportListsData.setReportDate(inspectionModel.getReportDate());
                    datas.add(getReportListsData);
                });
                List collect = datas.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
                getReportListsRes.setDatas(collect);
                return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        ArrayList vDzbgJcModel = new ArrayList();
        for (VDzbgJcModel dzbgJcModel : vDzbgJcModel) {
            getReportListsRes.setPatientName(dzbgJcModel.getPatientname());
            GetReportListsData getReportListsData = new GetReportListsData();
            getReportListsData.setReportNo(dzbgJcModel.getReportno());
            getReportListsData.setReportName(dzbgJcModel.getItemname());
            getReportListsData.setReportType(INSPECTION_TYPE);
            getReportListsData.setReportDate(dzbgJcModel.getReportdate());
            datas.add(getReportListsData);
        }
        List collect = datas.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
        getReportListsRes.setDatas(collect);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
    }

    public FrontResponse<LisReportListRes> queryInspectionInfo(FrontRequest<LisReportListReq> param) {
        LisReportListReq paramBody = (LisReportListReq)param.getBody();
        LisReportListRes lisReportListRes = new LisReportListRes();
        ArrayList list = new ArrayList();
        if (!list.isEmpty()) {
            InspectionModel inspectionModel = (InspectionModel)list.get(0);
            lisReportListRes.setPatientName(inspectionModel.getPatientName());
            lisReportListRes.setReportNo(inspectionModel.getReportNo());
            lisReportListRes.setReportName(inspectionModel.getItemName1());
            lisReportListRes.setPatientNo(inspectionModel.getPatientId());
            lisReportListRes.setSex(inspectionModel.getSex());
            lisReportListRes.setAge(inspectionModel.getAge().replaceAll("\u5c81", ""));
            lisReportListRes.setDeptName(inspectionModel.getApplyDeptName());
            lisReportListRes.setDoctorName(inspectionModel.getApplyDoctor());
            lisReportListRes.setWardName(inspectionModel.getNursingUnit());
            lisReportListRes.setBed(inspectionModel.getBed());
            lisReportListRes.setRoom(inspectionModel.getRoom());
            lisReportListRes.setSpecName(inspectionModel.getSample());
            lisReportListRes.setRecTime(inspectionModel.getReceiveDate());
            lisReportListRes.setRecUser(inspectionModel.getReceiveAutitor());
            lisReportListRes.setAuthUser(inspectionModel.getReportAutitor());
            lisReportListRes.setColTime(inspectionModel.getSampleDate());
            lisReportListRes.setPrint(String.valueOf(inspectionModel.getPrint()));
            lisReportListRes.setAdmType(inspectionModel.getAdmType());
            if (StringUtils.isNotBlank((CharSequence)inspectionModel.getDiagnosis())) {
                lisReportListRes.setDiagnosis(inspectionModel.getDiagnosis().replaceAll("\n", "").replaceAll("\r", ""));
            }
            ArrayList<LisReportListResData> datas = new ArrayList<LisReportListResData>();
            for (InspectionModel inspectionModels : list) {
                LisReportListResData lisReportListResData = new LisReportListResData();
                lisReportListResData.setItmName(inspectionModels.getItemName());
                lisReportListResData.setItmCode(inspectionModels.getItemCode());
                lisReportListResData.setItmUnit(inspectionModels.getItemUnit());
                if (StringUtils.isNotBlank((CharSequence)inspectionModels.getItemRes())) {
                    lisReportListResData.setItmRes(inspectionModels.getItemRes().replaceAll("\n", "").replaceAll("\r", ""));
                }
                lisReportListResData.setItmRanges(inspectionModels.getItemRanges());
                lisReportListResData.setItmCrises(inspectionModels.getItemCrises());
                datas.add(lisReportListResData);
            }
            lisReportListRes.setDatas(datas);
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        PacsReportListReq paramBody = (PacsReportListReq)param.getBody();
        VDzbgJcModel vDzbgJcModel = new VDzbgJcModel();
        PacsReportListRes pacsReportListRes = new PacsReportListRes();
        if (Objects.nonNull(vDzbgJcModel)) {
            pacsReportListRes.setPatientName(vDzbgJcModel.getPatientname());
            pacsReportListRes.setReportName(vDzbgJcModel.getItemname());
            pacsReportListRes.setReportNo(vDzbgJcModel.getReportno());
            pacsReportListRes.setPatientNo(vDzbgJcModel.getPatientid());
            pacsReportListRes.setSex(vDzbgJcModel.getSex());
            pacsReportListRes.setAge(vDzbgJcModel.getAge().replaceAll("\u5c81", ""));
            pacsReportListRes.setDeptName(vDzbgJcModel.getApplydeptname());
            pacsReportListRes.setDoctorName(vDzbgJcModel.getApplydoctor());
            pacsReportListRes.setWardName(vDzbgJcModel.getNursingunit());
            pacsReportListRes.setBed(vDzbgJcModel.getBed());
            pacsReportListRes.setRoom(vDzbgJcModel.getRoom());
            pacsReportListRes.setAuthUser(vDzbgJcModel.getReportautitor());
            pacsReportListRes.setAuthTime(vDzbgJcModel.getReportdate());
            pacsReportListRes.setPrint(vDzbgJcModel.getPrint());
            pacsReportListRes.setAdmType(vDzbgJcModel.getAdmtype());
            if (StringUtils.isNotBlank((CharSequence)vDzbgJcModel.getMedicaladvice())) {
                pacsReportListRes.setCheckDesc(vDzbgJcModel.getMedicaladvice().replaceAll("\n", "").replaceAll("\r", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)vDzbgJcModel.getCheckresult())) {
                pacsReportListRes.setCheckResult(vDzbgJcModel.getCheckresult().replaceAll("\n", "").replaceAll("\r", ""));
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(vDzbgJcModel.getCheckimages());
            pacsReportListRes.setCheckImages(list);
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportListRes);
    }

    public FrontResponse<QueryDischargeRecordRes> queryDischargeRecord(FrontRequest<PacsReportListReq> param) {
        QueryDischargeRecordRes queryDischargeRecordRes = new QueryDischargeRecordRes();
        PacsReportListReq paramBody = (PacsReportListReq)param.getBody();
        ArrayList list = new ArrayList();
        String pastDate = DateUtil.getPastDate((int)7);
        ArrayList removeList = new ArrayList();
        list.stream().forEach(x -> {
            boolean bool;
            String ysname = x.getYsname();
            if (Objects.equals("\u51fa\u9662\u65e5\u671f", ysname) && !(bool = DateUtil.timeRange((String)pastDate, (String)x.getValue()))) {
                removeList.add(x.getInpatientNo());
            }
        });
        Map<String, List<VhisCyjlModel>> inspectionModelsMap = list.stream().collect(Collectors.groupingBy(VhisCyjlModel::getInpatientNo));
        for (String key : removeList) {
            inspectionModelsMap.remove(key);
        }
        queryDischargeRecordRes.setRes(inspectionModelsMap);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryDischargeRecordRes);
    }
}

