/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.GetIPDepositRecordsReqDTO;
import com.ebaiyihui.his.pojo.dto.HospDepositRecordsItemResDTO;
import com.ebaiyihui.his.pojo.dto.HospDepositRecordsResDTO;
import com.ebaiyihui.his.pojo.dto.InHospDepositReqDTO;
import com.ebaiyihui.his.pojo.dto.InHospDepositResDTO;
import com.ebaiyihui.his.pojo.dto.QueryCompletionStatusResDTO;
import com.ebaiyihui.his.pojo.dto.QueryDetailedInfoItemDTO;
import com.ebaiyihui.his.pojo.dto.QueryDetailedInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryDischargeDetailedInfoDTO;
import com.ebaiyihui.his.pojo.dto.QueryDischargeMainInfoDTO;
import com.ebaiyihui.his.pojo.dto.QueryDischargeMainInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryInpatientInfoDTO;
import com.ebaiyihui.his.pojo.dto.QueryInpatientInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryMainInfoDTO;
import com.ebaiyihui.his.pojo.dto.QueryMainInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryMainInfoResItemDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpDetailReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpDetailRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.respmsg.DepositRespmsg;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.HospitalizationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class HospitalizationServiceImpl
implements HospitalizationService {
    public static final String HIS_OUT_HOSP_STATUS = "1";
    public static final String BYH_OUT_HOSP_STATUS = "D";
    public static final String BYH_IN_HOSP_STATUS = "A";
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetInpAdmissionRes> getInpAdmission(FrontRequest<GetInpAdmissionReq> param) {
        GetInpAdmissionRes getInpAdmissionRes = new GetInpAdmissionRes();
        GetInpAdmissionReq reqBody = (GetInpAdmissionReq)param.getBody();
        QueryMainInfoDTO queryMainInfoDTO = QueryMainInfoDTO.builder().queryNum(reqBody.getInHospNo()).queryType(HIS_OUT_HOSP_STATUS).build();
        HashMap<String, QueryMainInfoDTO> map = new HashMap<String, QueryMainInfoDTO>();
        map.put(EntityKeyEnum.QUERY_MAIN_INFO.getValue(), queryMainInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_MAIN_INFO.getValue(), map, QueryMainInfoResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        if (!HIS_OUT_HOSP_STATUS.equals(((QueryMainInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryMainInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        List queryMainInfoResItemDTOList = ((QueryMainInfoResDTO)response.getBody()).getQueryMainInfoResItemDataDTO().getItems();
        if (CollectionUtils.isEmpty((Collection)queryMainInfoResItemDTOList)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryMainInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        ArrayList<GetInpAdmissionResItems> items = new ArrayList<GetInpAdmissionResItems>();
        for (QueryMainInfoResItemDTO queryMainInfoResItemDTO : queryMainInfoResItemDTOList) {
            GetInpAdmissionResItems getInpAdmissionResItems = new GetInpAdmissionResItems();
            if (StringUtils.isEmpty((Object)queryMainInfoResItemDTO.getOutHosDate())) {
                getInpAdmissionResItems.setHospStatus(BYH_IN_HOSP_STATUS);
            } else {
                getInpAdmissionResItems.setHospStatus(BYH_OUT_HOSP_STATUS);
            }
            getInpAdmissionResItems.setInHospNo(queryMainInfoResItemDTO.getInHosNum());
            getInpAdmissionResItems.setStartDate(queryMainInfoResItemDTO.getInHosDate());
            getInpAdmissionResItems.setEndDate(queryMainInfoResItemDTO.getOutHosDate());
            getInpAdmissionResItems.setDeptName(queryMainInfoResItemDTO.getDeptName());
            getInpAdmissionResItems.setDeptCode(queryMainInfoResItemDTO.getDepartCode());
            getInpAdmissionResItems.setPatientId(queryMainInfoResItemDTO.getPatientID());
            getInpAdmissionResItems.setPatientName(queryMainInfoResItemDTO.getPatientName());
            getInpAdmissionResItems.setPatientAge(queryMainInfoResItemDTO.getPatientAge());
            getInpAdmissionResItems.setPatientSex(queryMainInfoResItemDTO.getPatientSex());
            getInpAdmissionResItems.setBed(queryMainInfoResItemDTO.getBedNo());
            getInpAdmissionResItems.setDepost(queryMainInfoResItemDTO.getPayTotalAmount());
            getInpAdmissionResItems.setTotalMoney(queryMainInfoResItemDTO.getTotalAmount());
            getInpAdmissionResItems.setCurrentMoney(queryMainInfoResItemDTO.getHosBalance());
            HashMap<String, QueryMainInfoDTO> mapDb = new HashMap<String, QueryMainInfoDTO>();
            mapDb.put(EntityKeyEnum.QUERY_DETAILED_INFO.getValue(), queryMainInfoDTO);
            FrontResponse queryDetailedInfoResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_DETAILED_INFO.getValue(), mapDb, QueryDetailedInfoResDTO.class);
            if (null == queryDetailedInfoResDTOFrontResponse) {
                return FrontResponse.error((String)queryDetailedInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)queryDetailedInfoResDTOFrontResponse.getMessage());
            }
            if (!HIS_OUT_HOSP_STATUS.equals(((QueryDetailedInfoResDTO)queryDetailedInfoResDTOFrontResponse.getBody()).getBaseReturnResultRepDTO().getResultCode())) {
                return FrontResponse.error((String)queryDetailedInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryDetailedInfoResDTO)queryDetailedInfoResDTOFrontResponse.getBody()).getBaseReturnResultRepDTO().getResultMsg());
            }
            List queryDetailedInfoItemDTOList = ((QueryDetailedInfoResDTO)queryDetailedInfoResDTOFrontResponse.getBody()).getQueryDetailedInfoItemDataDTO().getItems();
            if (CollectionUtils.isEmpty((Collection)queryDetailedInfoItemDTOList)) {
                return FrontResponse.error((String)queryDetailedInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryDetailedInfoResDTO)queryDetailedInfoResDTOFrontResponse.getBody()).getBaseReturnResultRepDTO().getResultMsg());
            }
            QueryDetailedInfoItemDTO queryDetailedInfoItemDTO = (QueryDetailedInfoItemDTO)queryDetailedInfoItemDTOList.get(0);
            getInpAdmissionResItems.setNursingUnit(queryDetailedInfoItemDTO.getItemName());
            getInpAdmissionResItems.setOwnMoney(queryDetailedInfoItemDTO.getAutoAmount());
            getInpAdmissionResItems.setApplyMoney(queryDetailedInfoItemDTO.getAccAmount());
            getInpAdmissionResItems.setCaseDesc("");
            getInpAdmissionResItems.setDiagnoseResult("");
            getInpAdmissionResItems.setRoom("");
            getInpAdmissionResItems.setDocCode("");
            getInpAdmissionResItems.setDocName("");
            items.add(getInpAdmissionResItems);
        }
        getInpAdmissionRes.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getInpAdmissionRes);
    }

    public FrontResponse<GetInpDetailRes> getInpDetail(FrontRequest<GetInpDetailReq> param) {
        return null;
    }

    public FrontResponse<DepositRes> deposit(FrontRequest<DepositReq> param) {
        DepositRes depositRes = new DepositRes();
        DepositReq depositReq = (DepositReq)param.getBody();
        DepositRespmsg respmsg = depositReq.getRespmsg();
        InHospDepositReqDTO inHospDepositReqDTO = new InHospDepositReqDTO();
        inHospDepositReqDTO.setInHosNum(depositReq.getInHospNo());
        inHospDepositReqDTO.setHisOperNum("001");
        inHospDepositReqDTO.setPayAmount(depositReq.getAmount());
        inHospDepositReqDTO.setPowerTranID(depositReq.getFlowNo());
        inHospDepositReqDTO.setPowerPayChannel("4");
        HashMap<String, InHospDepositReqDTO> map = new HashMap<String, InHospDepositReqDTO>();
        map.put(EntityKeyEnum.IN_HOSP_DEPOSIT.getValue(), inHospDepositReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.HOSPITAL_RENEWAL_DEPOSIT.getValue(), map, InHospDepositResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        if (!HIS_OUT_HOSP_STATUS.equals(((InHospDepositResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)((InHospDepositResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        depositRes.setReceiptId(((InHospDepositResDTO)response.getBody()).getInHospDepositRcptResDTO().getRcptNo());
        return FrontResponse.success((String)param.getTransactionId(), (Object)depositRes);
    }

    public FrontResponse<GetIPDepositRecordsRes> getIPDepositRecords(FrontRequest<GetIPDepositRecordsReq> param) {
        ArrayList<GetIPDepositRecordsItems> getIPDepositRecordsItems = new ArrayList<GetIPDepositRecordsItems>();
        GetIPDepositRecordsReq body = (GetIPDepositRecordsReq)param.getBody();
        GetIPDepositRecordsReqDTO getIPDepositRecordsReqDTO = new GetIPDepositRecordsReqDTO();
        getIPDepositRecordsReqDTO.setQueryType(HIS_OUT_HOSP_STATUS);
        getIPDepositRecordsReqDTO.setQueryNum(body.getInHospNo());
        getIPDepositRecordsReqDTO.setStartTime(body.getStartDate());
        getIPDepositRecordsReqDTO.setEndTime(body.getEndDate());
        HashMap<String, GetIPDepositRecordsReqDTO> map = new HashMap<String, GetIPDepositRecordsReqDTO>();
        map.put(EntityKeyEnum.GET_IP_DEPOSIT_RECORDS.getValue(), getIPDepositRecordsReqDTO);
        FrontResponse hospDepositRecordsRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_IP_DEPOSIT_RECORDS.getValue(), map, HospDepositRecordsResDTO.class);
        HospDepositRecordsResDTO hospDepositRecordsResDTO = (HospDepositRecordsResDTO)hospDepositRecordsRes.getBody();
        if (null == hospDepositRecordsResDTO) {
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)hospDepositRecordsRes.getMessage());
        }
        if (!HIS_OUT_HOSP_STATUS.equals(hospDepositRecordsResDTO.getBaseReturnResultRepDTO().getResultCode())) {
            return FrontResponse.error((String)hospDepositRecordsRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hospDepositRecordsRes.getMessage());
        }
        if (!CollectionUtils.isEmpty((Collection)hospDepositRecordsResDTO.getHospDepositRecordsItemResDataDTO().getItem())) {
            for (HospDepositRecordsItemResDTO hospDepositRecordsItemResDTO : hospDepositRecordsResDTO.getHospDepositRecordsItemResDataDTO().getItem()) {
                GetIPDepositRecordsItems getIPDepositRecords = new GetIPDepositRecordsItems();
                getIPDepositRecords.setDepositNo(hospDepositRecordsItemResDTO.getPowerTranID());
                getIPDepositRecords.setOper(hospDepositRecordsItemResDTO.getHisOperNum());
                getIPDepositRecords.setPrePayDateTime(hospDepositRecordsItemResDTO.getTranDate());
                getIPDepositRecords.setPayChannel(hospDepositRecordsItemResDTO.getPayTypeList());
                getIPDepositRecords.setAmout(hospDepositRecordsItemResDTO.getTranAmount());
                getIPDepositRecords.setPayStatus(SUCCESS_FLAG);
                getIPDepositRecordsItems.add(getIPDepositRecords);
            }
        }
        GetIPDepositRecordsRes getIPDepositRecordsRes = new GetIPDepositRecordsRes();
        getIPDepositRecordsRes.setItems(getIPDepositRecordsItems);
        return FrontResponse.success((String)hospDepositRecordsRes.getTransactionId(), (Object)getIPDepositRecordsRes);
    }

    public FrontResponse<GetOrdItemsRes> getOrdItems(FrontRequest<GetOrdItemsReq> param) {
        GetOrdItemsRes getOrdItemsRes = new GetOrdItemsRes();
        ArrayList<GetOrdItemsResItems> ordItem = new ArrayList<GetOrdItemsResItems>();
        GetOrdItemsReq body = (GetOrdItemsReq)param.getBody();
        QueryMainInfoDTO queryMainInfoDTO = QueryMainInfoDTO.builder().queryNum(body.getInHospNo()).queryType(HIS_OUT_HOSP_STATUS).startTime(body.getStartDate()).endTime(body.getEndDate()).build();
        HashMap<String, QueryMainInfoDTO> map = new HashMap<String, QueryMainInfoDTO>();
        map.put(EntityKeyEnum.QUERY_MAIN_INFO.getValue(), queryMainInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_MAIN_INFO.getValue(), map, QueryMainInfoResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        if (!HIS_OUT_HOSP_STATUS.equals(((QueryMainInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryMainInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        List queryMainInfoResItemDTOList = ((QueryMainInfoResDTO)response.getBody()).getQueryMainInfoResItemDataDTO().getItems();
        if (CollectionUtils.isEmpty((Collection)queryMainInfoResItemDTOList)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryMainInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        QueryMainInfoResItemDTO queryMainInfoResItemDTO = (QueryMainInfoResItemDTO)queryMainInfoResItemDTOList.get(0);
        getOrdItemsRes.setInHospNo(queryMainInfoResItemDTO.getInHosNum());
        getOrdItemsRes.setAdmDate(queryMainInfoResItemDTO.getInHosDate());
        getOrdItemsRes.setName(queryMainInfoResItemDTO.getPatientName());
        getOrdItemsRes.setSex(queryMainInfoResItemDTO.getPatientSex());
        getOrdItemsRes.setAdmDep(queryMainInfoResItemDTO.getDeptName());
        HashMap<String, QueryMainInfoDTO> mapDb = new HashMap<String, QueryMainInfoDTO>();
        mapDb.put(EntityKeyEnum.QUERY_DETAILED_INFO.getValue(), queryMainInfoDTO);
        FrontResponse queryDetailedInfoResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_DETAILED_INFO.getValue(), mapDb, QueryDetailedInfoResDTO.class);
        if (null == queryDetailedInfoResDTOFrontResponse) {
            return FrontResponse.error((String)queryDetailedInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)queryDetailedInfoResDTOFrontResponse.getMessage());
        }
        if (!HIS_OUT_HOSP_STATUS.equals(((QueryDetailedInfoResDTO)queryDetailedInfoResDTOFrontResponse.getBody()).getBaseReturnResultRepDTO().getResultCode())) {
            return FrontResponse.error((String)queryDetailedInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryDetailedInfoResDTO)queryDetailedInfoResDTOFrontResponse.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        QueryDetailedInfoResDTO queryDetailedInfoResDTO = (QueryDetailedInfoResDTO)queryDetailedInfoResDTOFrontResponse.getBody();
        List queryDetailedInfoItemDTOList = queryDetailedInfoResDTO.getQueryDetailedInfoItemDataDTO().getItems();
        if (CollectionUtils.isEmpty((Collection)queryDetailedInfoItemDTOList)) {
            return FrontResponse.error((String)queryDetailedInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryDetailedInfoResDTO)queryDetailedInfoResDTOFrontResponse.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        for (QueryDetailedInfoItemDTO queryDetailedInfoItemDTO : queryDetailedInfoItemDTOList) {
            GetOrdItemsResItems getOrdItemsResItems = new GetOrdItemsResItems();
            getOrdItemsResItems.setAmount(queryDetailedInfoItemDTO.getItemAmount());
            getOrdItemsResItems.setFeeDate(queryDetailedInfoItemDTO.getTrDateTime());
            getOrdItemsResItems.setFeeType(queryDetailedInfoItemDTO.getItemType());
            getOrdItemsResItems.setItmMastName(queryDetailedInfoItemDTO.getItemName());
            getOrdItemsResItems.setPrice(queryDetailedInfoItemDTO.getItemPrice());
            getOrdItemsResItems.setQty(queryDetailedInfoItemDTO.getItemCount());
            getOrdItemsResItems.setUomDesc(queryDetailedInfoItemDTO.getItemUnit());
            ordItem.add(getOrdItemsResItems);
        }
        getOrdItemsRes.setOrdItem(ordItem);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getOrdItemsRes);
    }

    public FrontResponse<GetOrdItemsRes> queryInpatientInfo(FrontRequest<GetOrdItemsReq> param) {
        GetOrdItemsReq body = (GetOrdItemsReq)param.getBody();
        QueryInpatientInfoDTO queryInpatientInfoDTO = QueryInpatientInfoDTO.builder().queryCode(body.getInHospNo()).queryType(HIS_OUT_HOSP_STATUS).build();
        HashMap<String, QueryInpatientInfoDTO> map = new HashMap<String, QueryInpatientInfoDTO>();
        map.put(EntityKeyEnum.QUERY_INPATIENT_NFO.getValue(), queryInpatientInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_INPATIENT_NFO.getValue(), map, QueryInpatientInfoResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
        }
        if (!HIS_OUT_HOSP_STATUS.equals(((QueryInpatientInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryInpatientInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        List queryInpatientInfoResDataListDTOList = ((QueryInpatientInfoResDTO)response.getBody()).getQueryInpatientInfoResDataListDataDTO().getList();
        GetOrdItemsRes getOrdItemsRes = new GetOrdItemsRes();
        ArrayList getOrdItemsResItemsList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)queryInpatientInfoResDataListDTOList)) {
            GetOrdItemsResItems getOrdItemsResItems = new GetOrdItemsResItems();
        }
        return null;
    }

    public FrontResponse<GetOrdItemsRes> queryCompletionStatus(FrontRequest<GetOrdItemsReq> param) {
        String powerTranID = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(EntityKeyEnum.QUERY_COMPLETION_STATUS.getValue(), powerTranID);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_COMPLETION_STATUS.getValue(), map, QueryCompletionStatusResDTO.class);
        return null;
    }

    public FrontResponse<GetOrdItemsRes> queryMainInfo(FrontRequest<GetOrdItemsReq> param) {
        QueryMainInfoDTO queryMainInfoDTO = QueryMainInfoDTO.builder().build();
        HashMap<String, QueryMainInfoDTO> map = new HashMap<String, QueryMainInfoDTO>();
        map.put(EntityKeyEnum.QUERY_MAIN_INFO.getValue(), queryMainInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_MAIN_INFO.getValue(), map, QueryMainInfoResDTO.class);
        return null;
    }

    public FrontResponse<GetOrdItemsRes> queryDetailedInfo(FrontRequest<GetOrdItemsReq> param) {
        QueryMainInfoDTO queryMainInfoDTO = QueryMainInfoDTO.builder().build();
        HashMap<String, QueryMainInfoDTO> map = new HashMap<String, QueryMainInfoDTO>();
        map.put(EntityKeyEnum.QUERY_DETAILED_INFO.getValue(), queryMainInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_DETAILED_INFO.getValue(), map, QueryDetailedInfoResDTO.class);
        return null;
    }

    public FrontResponse<GetOrdItemsRes> queryDischargeMainInfo(FrontRequest<GetOrdItemsReq> param) {
        QueryDischargeMainInfoDTO queryDischargeMainInfoDTO = QueryDischargeMainInfoDTO.builder().build();
        HashMap<String, QueryDischargeMainInfoDTO> map = new HashMap<String, QueryDischargeMainInfoDTO>();
        map.put(EntityKeyEnum.QUERY_DISCHARGE_MAIN_INFO.getValue(), queryDischargeMainInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_DISCHARGE_MAIN_INFO.getValue(), map, QueryDischargeMainInfoResDTO.class);
        return null;
    }

    public FrontResponse<GetOrdItemsRes> queryDischargeDetailedInfo(FrontRequest<GetOrdItemsReq> param) {
        QueryDischargeMainInfoDTO queryDischargeMainInfoDTO = QueryDischargeMainInfoDTO.builder().build();
        HashMap<String, QueryDischargeMainInfoDTO> map = new HashMap<String, QueryDischargeMainInfoDTO>();
        map.put(EntityKeyEnum.QUERY_DISCHARGE_MAIN_INFO.getValue(), queryDischargeMainInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_DISCHARGE_DETAILED_INFO.getValue(), map, QueryDischargeDetailedInfoDTO.class);
        return null;
    }
}

