/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.TimeSlotEnum;
import com.ebaiyihui.his.pojo.dto.DocDayScheduleDTO;
import com.ebaiyihui.his.pojo.dto.DocScheduleSourceDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorReqDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorResDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorResDataDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptDoctorResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptScheduleResDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptScheduleResDataDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptScheduleResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetDocSourceScheduleResDTO;
import com.ebaiyihui.his.pojo.dto.GetDocSourceScheduleResDataDTO;
import com.ebaiyihui.his.pojo.dto.GetDocSourceScheduleResDataRowDTO;
import com.ebaiyihui.his.pojo.dto.ResponseModel;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptDoctorInfoResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ScheduleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Value(value="${his.hospName}")
    private String hospName;
    @Value(value="${his.hospCode}")
    private String hospCode;
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        GetScheduleReqVO paramBody = (GetScheduleReqVO)param.getBody();
        GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
        ArrayList items = new ArrayList();
        HashMap<String, DocScheduleSourceDTO> map = new HashMap<String, DocScheduleSourceDTO>();
        DocScheduleSourceDTO docScheduleSourceDTO = new DocScheduleSourceDTO();
        docScheduleSourceDTO.setStartTime(paramBody.getBgDate());
        docScheduleSourceDTO.setEndTime(paramBody.getEdDate());
        docScheduleSourceDTO.setDepartCode(paramBody.getLocCode());
        map.put(EntityKeyEnum.DOC_SCHEDULE_SOURCE.getValue(), docScheduleSourceDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DOCTOR_SOURCE_LIST.getValue(), map, GetDocSourceScheduleResDTO.class);
        GetDocSourceScheduleResDTO responseBody = (GetDocSourceScheduleResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        ResponseModel responseModel = responseBody.getResponseModel();
        if (1 != responseModel.getReturnCode()) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"1", (String)responseModel.getErrorMsg());
        }
        GetDocSourceScheduleResDataDTO responseBodyData = responseBody.getData();
        if (Objects.isNull(responseBodyData)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"2", (String)responseModel.getErrorMsg());
        }
        List item = responseBodyData.getDataRow();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"3", (String)responseModel.getErrorMsg());
        }
        List collect = item.stream().filter(GetDocSourceScheduleResDataRowDTO2 -> Objects.equals(GetDocSourceScheduleResDataRowDTO2.getValidFlag(), "1") || Objects.equals(GetDocSourceScheduleResDataRowDTO2.getValidFlag(), "-1")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"4", (String)responseModel.getErrorMsg());
        }
        Map<String, List<GetDocSourceScheduleResDataRowDTO>> scheduleMap = collect.stream().collect(Collectors.groupingBy(GetDocSourceScheduleResDataRowDTO::getDoctorCode));
        scheduleMap.forEach((k, v) -> v.stream().forEach(s -> {
            GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
            getScheduleResItems.setScheduleId(s.getScheduleId());
            getScheduleResItems.setScheduleType(Integer.valueOf(1));
            getScheduleResItems.setIsTimeArrange(Integer.valueOf(0));
            getScheduleResItems.setIsAppend("0");
            if (Objects.equals("1", s.getValidFlag())) {
                getScheduleResItems.setDocCode(s.getDoctorCode());
                getScheduleResItems.setDocName(s.getDoctorName());
                getScheduleResItems.setScheduleStatus("1");
            } else if (Objects.equals("1", s.getStopflag())) {
                getScheduleResItems.setDocCode(s.getDoctorCode2());
                getScheduleResItems.setDocName(s.getDoctorCodeName2());
                getScheduleResItems.setScheduleStatus("3");
            } else {
                getScheduleResItems.setDocCode(s.getDoctorCode());
                getScheduleResItems.setDocName(s.getDoctorName());
                getScheduleResItems.setScheduleStatus("2");
            }
            getScheduleResItems.setAdmDate(s.getOutpDate());
            getScheduleResItems.setAdmTimeRange(TimeSlotEnum.getDisplay((String)s.getTimeInterval()));
            getScheduleResItems.setHospitalAreaCode(s.getSubHospitalID());
            getScheduleResItems.setLocCode(s.getDepartCode());
            getScheduleResItems.setLocName(s.getDeptName());
            getScheduleResItems.setRegFee(s.getRegistrationFee());
            getScheduleResItems.setDiagFee(s.getDiagFee());
            getScheduleResItems.setRegTitleName(s.getDoctorTitle());
            getScheduleResItems.setScheduleLevelName(s.getClinicTypeName());
            getScheduleResItems.setAdmLocation(s.getLocation());
            Integer registrationLimit = s.getRegistrationLimit();
            Integer reserveLimit = s.getReserveLimit();
            Integer registrationNum = s.getRegistrationNum();
            Integer reserveNum = s.getReserveNum();
            if (registrationLimit == 0) {
                getScheduleResItems.setRegTotal(Integer.valueOf(0));
                getScheduleResItems.setRegAvailable(Integer.valueOf(999));
            } else {
                getScheduleResItems.setRegTotal(registrationLimit);
                getScheduleResItems.setRegAvailable(Integer.valueOf(registrationLimit - registrationNum - reserveNum));
            }
            items.add(getScheduleResItems);
        }));
        getScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
    }

    public FrontResponse<GetDeptScheduleResVO> getDeptSchedule(FrontRequest<GetDeptScheduleReqVO> param) {
        GetDeptScheduleResVO getDeptScheduleResVO = new GetDeptScheduleResVO();
        ArrayList<GetDeptScheduleResItems> items = new ArrayList<GetDeptScheduleResItems>();
        HashMap<String, DocDayScheduleDTO> map = new HashMap<String, DocDayScheduleDTO>();
        DocDayScheduleDTO docDayScheduleDTO = new DocDayScheduleDTO();
        GetDeptScheduleReqVO body = (GetDeptScheduleReqVO)param.getBody();
        docDayScheduleDTO.setDepartType("0");
        docDayScheduleDTO.setSearchType(Integer.valueOf(2));
        map.put(EntityKeyEnum.DOC_DAY_SCHEDULE_SOURCE.getValue(), docDayScheduleDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REGISTERED_DOCTOR_LIST.getValue(), map, GetDeptScheduleResDTO.class);
        GetDeptScheduleResDTO responseBody = (GetDeptScheduleResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        ResponseModel responseModel = responseBody.getResponseModel();
        if (1 != responseModel.getReturnCode()) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        GetDeptScheduleResDataDTO data = responseBody.getData();
        if (Objects.isNull(data)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        List getDeptItemList = data.getItems();
        if (CollectionUtils.isEmpty((Collection)getDeptItemList)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        for (GetDeptScheduleResItemDTO getDeptScheduleResItemDTO : getDeptItemList) {
            GetDeptScheduleResItems getDeptScheduleResItems = new GetDeptScheduleResItems();
            getDeptScheduleResItems.setDeptCode(getDeptScheduleResItemDTO.getDepartCode());
            getDeptScheduleResItems.setDeptName(getDeptScheduleResItemDTO.getDepartName());
            getDeptScheduleResItems.setDeptAddress(getDeptScheduleResItemDTO.getLocation());
            items.add(getDeptScheduleResItems);
        }
        getDeptScheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
    }

    public FrontResponse<GetDeptDoctorInfoResVO> getDeptDoctorInfo(FrontRequest<GetDeptDoctorInfoReqVO> param) {
        GetDeptDoctorInfoReqVO paramBody = (GetDeptDoctorInfoReqVO)param.getBody();
        GetDeptDoctorInfoResVO getDeptDoctorInfoResVO = new GetDeptDoctorInfoResVO();
        ArrayList<GetDeptDoctorInfoResItems> items = new ArrayList<GetDeptDoctorInfoResItems>();
        GetDeptDoctorReqDTO getDeptDoctorReqDTO = new GetDeptDoctorReqDTO();
        getDeptDoctorReqDTO.setSearchType(Integer.valueOf(1));
        getDeptDoctorReqDTO.setDepartCode(paramBody.getDeptCode());
        HashMap<String, GetDeptDoctorReqDTO> map = new HashMap<String, GetDeptDoctorReqDTO>();
        map.put(EntityKeyEnum.DEPT_DOCTOR_INFO.getValue(), getDeptDoctorReqDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUT_SCHE_RESOURCES.getValue(), map, GetDeptDoctorResDTO.class);
        GetDeptDoctorResDTO responseBody = (GetDeptDoctorResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        ResponseModel responseModel = responseBody.getResponseModel();
        if (1 != responseModel.getReturnCode()) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        GetDeptDoctorResDataDTO responseBodyData = responseBody.getData();
        if (Objects.isNull(responseBodyData)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        List getDeptDoctorResItemDTOList = responseBodyData.getItem();
        if (CollectionUtils.isEmpty((Collection)getDeptDoctorResItemDTOList)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        for (GetDeptDoctorResItemDTO getDeptDoctorResItemDTO : getDeptDoctorResItemDTOList) {
            GetDeptDoctorInfoResItems getDeptDoctorInfoResItems = new GetDeptDoctorInfoResItems();
            getDeptDoctorInfoResItems.setDoctorCode(getDeptDoctorResItemDTO.getDoctorCode());
            getDeptDoctorInfoResItems.setDoctorName(getDeptDoctorResItemDTO.getDoctorName());
            getDeptDoctorInfoResItems.setDoctorTitle(getDeptDoctorResItemDTO.getDoctorTitle());
            items.add(getDeptDoctorInfoResItems);
        }
        getDeptDoctorInfoResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptDoctorInfoResVO);
    }
}

