/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.pojo.dto.audit.AuditMainCheckOutputResDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.audit.AuditMainCheckInputReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.MedicalMoveMainVO;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MainManage {
    private static final Logger log = LoggerFactory.getLogger(MainManage.class);
    @Autowired
    private NodeConfig nodeConfig;

    public void pushMainManage(MedicalMoveMainVO medicalMoveMainVO) {
        log.info("\u5f00\u59cb\u63a8\u9001\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u5904\u65b9\uff0c\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)medicalMoveMainVO));
        String url = this.nodeConfig.getMainPush() + "/api/ncefyPrescription/v1/medicalPushMain";
        try {
            String body = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)medicalMoveMainVO));
            log.info("\u8c03\u7528\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u63a8\u9001\u8fd4\u56de\u7ed3\u679c,{}", (Object)body);
            if (StringUtils.isBlank((String)body)) {
                throw new BusinessException("\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u8fd4\u56de\u4e3a\u7a7a");
            }
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            if (!"1".equalsIgnoreCase(baseResponse.getCode())) {
                throw new BusinessException("\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u8c03\u7528\u51fa\u9519\uff1a" + baseResponse.getMsg());
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u63a8\u9001\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u63a8\u9001\u7f51\u7edc\u5f02\u5e38");
        }
    }

    public AuditMainCheckOutputResDTO checkMain(AuditMainCheckInputReqVO inputReqVO) {
        log.info("\u51c6\u5907\u8bf7\u6c42\u5357\u5927\u4e8c\u524d\u7f6e\u673a\uff0c\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)inputReqVO));
        HashMap<String, AuditMainCheckInputReqVO> map = new HashMap<String, AuditMainCheckInputReqVO>();
        map.put("body", inputReqVO);
        try {
            String url = this.nodeConfig.getTransfer() + "/prescription/checkMain";
            String body = HttpKit.jsonPost((String)url, (String)JSON.toJSONString(map));
            FrontResponse baseResponse = (FrontResponse)JSON.parseObject((String)body, FrontResponse.class);
            if ("1".equalsIgnoreCase(baseResponse.getCode())) {
                AuditMainCheckOutputResDTO auditMainCheckOutputResDTO = (AuditMainCheckOutputResDTO)JSON.parseObject((String)JSON.parseObject((String)body).getString("body"), AuditMainCheckOutputResDTO.class);
                log.info("\u5ba1\u65b9\u524d\u7f6e\u673a\u8fd4\u56de\u7ed3\u679c,{}", (Object)JSON.toJSONString((Object)auditMainCheckOutputResDTO));
                return auditMainCheckOutputResDTO;
            }
            log.error("\u8c03\u7528\u524d\u7f6e\u673a\u53d1\u751f\u9519\u8bef,{}", (Object)baseResponse.getMessage());
            throw new BusinessException("\u8c03\u7528\u524d\u7f6e\u673a\u53d1\u751f\u9519\u8bef,{}", baseResponse.getMessage());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u524d\u7f6e\u673a\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u524d\u7f6e\u673a\u53d1\u751f\u9519\u8bef,{}", (Throwable)e);
        }
    }

    public void insertOrDeleteMain(AuditMainCheckInputReqVO inputReqVO) {
        inputReqVO.setTag("2");
        log.info("\u51c6\u5907\u8bf7\u6c42\u5357\u5927\u4e8c\u524d\u7f6e\u673a\u65b0\u589e\u6216\u8005\u5220\u9664\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)inputReqVO));
        HashMap<String, AuditMainCheckInputReqVO> map = new HashMap<String, AuditMainCheckInputReqVO>();
        map.put("body", inputReqVO);
        try {
            String url = this.nodeConfig.getTransfer() + "/prescription/saveOrDelete";
            HttpKit.jsonPost((String)url, (String)JSON.toJSONString(map));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u524d\u7f6e\u673a\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u524d\u7f6e\u673a\u53d1\u751f\u9519\u8bef,{}", (Throwable)e);
        }
    }
}

