/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.rabbitmq;

import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedPrescriptionOrderReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedPrescriptionOrderReceiver.class);
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private MosDrugPrescriptionMapper drugPrescriptionMapper;

    @RabbitListener(queues={"prescription.delayed.order.test"})
    @RabbitHandler
    public void process(String mainId) {
        log.info("=====================orderSeq: " + mainId);
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mainId);
        log.info("mosDrugLogisticsOrderRegEntityList->{}", (Object)Objects.toString(drugMainEntity, null));
        if (drugMainEntity == null) {
            return;
        }
        this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.USELESS.getValue(), mainId);
    }
}

