/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.ReconciliationVO;
import com.ebaiyihui.medicalcloud.service.MosDrugOrderService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MosDrugOrderServiceImpl
implements MosDrugOrderService {
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;

    public DrugOrderEntity queryById(String xId) {
        return this.mosDrugOrderMapper.queryById(xId);
    }

    public DrugOrderEntity insert(DrugOrderEntity mosDrugOrder) {
        this.mosDrugOrderMapper.insert(mosDrugOrder);
        return mosDrugOrder;
    }

    public DrugOrderEntity update(DrugOrderEntity mosDrugOrder) {
        this.mosDrugOrderMapper.update(mosDrugOrder);
        return this.queryById(mosDrugOrder.getxId());
    }

    public DrugOrderEntity queryByMainIdAndOrderStatus(String mainId, Integer status) {
        return this.mosDrugOrderMapper.queryByMainIdAndOrderStatus(mainId, status);
    }

    public DrugOrderEntity queryByOrderSeq(String orderSeq) {
        return this.mosDrugOrderMapper.queryByOrderSeq(orderSeq);
    }

    public List<ReconciliationVO> queryReconciliationData(String date, String organCode) {
        String dateStr = DateUtils.formatDate((Date)DateUtils.parseYMDDate((String)date), (Object[])new Object[]{"yyyy-MM-dd"});
        String startTime = new StringBuffer(dateStr).append(" 00:00:00").toString();
        String endTime = new StringBuffer(dateStr).append(" 23:59:59").toString();
        return this.mosDrugOrderMapper.queryReconciliationData(startTime, endTime, organCode.toUpperCase());
    }

    public DrugOrderEntity queryByBankTradeNo(String bankTradeNo) {
        return this.mosDrugOrderMapper.queryByBankTradeNo(bankTradeNo);
    }

    public DrugOrderEntity queryByDealSeq(String dealSeq) {
        return this.mosDrugOrderMapper.queryByDealSeq(dealSeq);
    }

    public DrugOrderEntity queryByMainId(String mainId) {
        return this.mosDrugOrderMapper.queryByMainId(mainId);
    }
}

