/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl.hyt;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.enums.AppCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DistributionTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DoctorTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.HytHisRecipeStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.manage.AsynManage;
import com.ebaiyihui.medicalcloud.manage.Camanage;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.DrugMainManage;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.manage.LogisticsManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsRouteMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugVerifierMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugstoreMapper;
import com.ebaiyihui.medicalcloud.mapper.MosOutpatientMainRelMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugstoreEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsRouteEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.FeedDetailVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalOrderFeedResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.MainDetailReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.MainDetailResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDetailData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDetailDataDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.PresDrugDetailData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.QueryMainIdsReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendDrugItemData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendMainDetailData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailDataDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailResVO;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.PrescriptionPdfService;
import com.ebaiyihui.medicalcloud.service.hyt.HytPrescriptionService;
import com.ebaiyihui.medicalcloud.utils.BeanHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HytPrescriptionServiceImpl
implements HytPrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(HytPrescriptionServiceImpl.class);
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper logisticsOrderRegMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private DrugMainManage drugMainManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private SpecialNodeConfig nodeConfig;
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private LogisticsManage logisticsManage;
    @Autowired
    private MosDrugLogisticsRouteMapper mosDrugLogisticsRouteMapper;
    @Autowired
    private MosDrugstoreMapper mosDrugstoreMapper;
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private AsynManage asynManage;
    @Autowired
    private MosOutpatientMainRelMapper mosOutpatientMainRelMapper;
    @Autowired
    private Camanage camanage;
    @Autowired
    private MosDrugVerifierMapper verifierMapper;
    @Autowired
    private DrugItemMapper drugItemMapper;
    public static final int ZERO = 0;
    public static final int ONE = 1;
    public static final Integer PASS_STATUS = 200;
    public static final String DOCTOR_TYPE = "doctor";
    private static List<String> unitList = new ArrayList();

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<MainDetailResVO> queryMainDetail(MainDetailReqVO vo) {
        log.info("======>\u533b\u5631\u8be6\u60c5 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        ArrayList presDetailList = new ArrayList();
        MainDetailResVO resVo = this.mosDrugMainMapper.queryMainDetail(vo.getMainId());
        if (resVo == null) {
            return BaseResponse.success();
        }
        List presDetailDtoList = this.mosDrugPrescriptionMapper.queryMultiPresList(vo.getMainId(), resVo.getHisRegNo(), resVo.getItemStatus(), vo.getType());
        List hisRecipeNos = presDetailDtoList.stream().map(PresDetailDataDTO::getHisRecipeNo).distinct().collect(Collectors.toList());
        if (StringUtils.isNotEmpty((String)vo.getHisRecipeNo()) && !resVo.getItemStatus().equals(DrugMainStatusEnum.UNDRUGS.getValue()) && !resVo.getItemStatus().equals(DrugMainStatusEnum.ZRYH_UNPAID.getValue())) {
            hisRecipeNos = hisRecipeNos.stream().filter(item -> vo.getHisRecipeNo().equals(item)).collect(Collectors.toList());
        }
        hisRecipeNos.stream().forEach(hisRecipeNo -> {
            PresDetailData presDetailData = new PresDetailData();
            ArrayList drugDetailList = new ArrayList();
            presDetailDtoList.stream().forEach(item -> {
                boolean flag = false;
                if (hisRecipeNo.equals(item.getHisRecipeNo())) {
                    PresDrugDetailData drugDetailData = new PresDrugDetailData();
                    BeanUtils.copyProperties((Object)item, (Object)drugDetailData, (String[])BeanHelper.getNullPropertyNames((Object)item));
                    if (!flag) {
                        BeanUtils.copyProperties((Object)item, (Object)presDetailData, (String[])BeanHelper.getNullPropertyNames((Object)item));
                        flag = true;
                    }
                    drugDetailList.add(drugDetailData);
                }
            });
            if (CollectionUtils.isNotEmpty(drugDetailList)) {
                drugDetailList.stream().forEach(item -> {
                    DrugItemEntity drugItemEntity;
                    if (unitList.contains(item.getWholePackingUnit()) && DrugTypeEnum.CM.getValue().equals(presDetailData.getPresType()) && Objects.nonNull(drugItemEntity = this.drugItemMapper.queryByCommonCode(item.getCommonCode(), resVo.getAppCode())) && Objects.nonNull(drugItemEntity.getMeasureNum())) {
                        item.setSingleDose(item.getSingleDose().divide(drugItemEntity.getMeasureNum()));
                        item.setMeasureUnit(item.getWholePackingUnit() + "[" + item.getDrugSpec() + "]");
                    }
                    item.setUnitPrice(new BigDecimal(item.getUnitPrice()).setScale(2, 4).toString());
                    item.setTotalPrice(new BigDecimal(item.getTotalPrice()).setScale(2, 4).toString());
                });
                presDetailData.setDrugDetailList(drugDetailList);
                if (presDetailData != null) {
                    presDetailList.add(presDetailData);
                }
            }
        });
        if (CollectionUtils.isNotEmpty(presDetailList)) {
            resVo.setPresDetailList(presDetailList);
        }
        if (StringUtils.isNotEmpty((String)vo.getType())) {
            List outLineList;
            if (DoctorTypeEnum.PATIENT.getValue().equals(vo.getType())) {
                int mergeCount;
                DoctorEntityInfoVO doctorVo = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(resVo.getPresDoctorId())));
                if (doctorVo != null) {
                    resVo.setPresDoctorAvatar(doctorVo.getHeadPortrait());
                    resVo.setProfession(doctorVo.getProfession());
                }
                if ((mergeCount = this.mosDrugMainMapper.getToSendCount(resVo.getHisRegNo(), DrugMainStatusEnum.TO_SEND.getValue(), Integer.valueOf(2))) > 0) {
                    resVo.setLogisticsFlag(Boolean.valueOf(true));
                } else {
                    resVo.setLogisticsFlag(Boolean.valueOf(false));
                }
                int logisticsUnpaidCount = this.mosDrugMainMapper.getToSendCount(resVo.getHisRegNo(), DrugMainStatusEnum.HYT_UNPAID.getValue(), null);
                if (logisticsUnpaidCount > 0 && (resVo.getItemStatus() == 20 || resVo.getItemStatus() == 50)) {
                    QueryMainIdsReqVO queryMainIdsReqVO = new QueryMainIdsReqVO();
                    queryMainIdsReqVO.setHisRegNo(resVo.getHisRegNo());
                    queryMainIdsReqVO.setStatus(DrugMainStatusEnum.HYT_UNPAID.getValue());
                    List mainIds = this.mosDrugPrescriptionMapper.queryMultiMainIds(queryMainIdsReqVO);
                    if (CollectionUtils.isNotEmpty((Collection)mainIds)) {
                        resVo.setLogisticsUnpaidMainId((String)mainIds.get(0));
                    }
                    resVo.setLogisticsUnpaidFlag(Boolean.valueOf(true));
                } else {
                    resVo.setLogisticsUnpaidFlag(Boolean.valueOf(false));
                }
                if (resVo.getLogisticsOrderId() != null && resVo.getItemStatus() > DrugMainStatusEnum.TO_SEND.getValue() && !DrugMainStatusEnum.GET_MEDICINE.getValue().equals(resVo.getItemStatus())) {
                    List routeList = null;
                    routeList = resVo.getDistributionType() != null && (DistributionTypeEnum.CITY_EXPRESS.getValue().equals(resVo.getDistributionType()) || DistributionTypeEnum.CROSS_POINT.getValue().equals(resVo.getDistributionType())) ? this.queryLogisticsRoute(resVo, resVo.getStoreId(), resVo.getDistributionType()) : (List)this.drugMainService.queryLogisticsRoute(resVo.getLogisticsOrderId()).getData();
                    if (CollectionUtils.isNotEmpty((Collection)routeList)) {
                        routeList.stream().forEach(mosDrugLogisticsRouteEntity -> {
                            resVo.setDeliveryName(mosDrugLogisticsRouteEntity.getDeliveryName());
                            resVo.setDeliveryPhone(mosDrugLogisticsRouteEntity.getDeliveryPhone());
                        });
                        MosDrugLogisticsRouteEntity mosDrugLogisticsRouteEntity2 = (MosDrugLogisticsRouteEntity)routeList.get(routeList.size() - 1);
                        if (!DrugMainStatusEnum.FINISH.getValue().equals(resVo.getItemStatus())) {
                            if ("15".equals(mosDrugLogisticsRouteEntity2.getOpCode())) {
                                resVo.setItemStatus(DrugMainStatusEnum.TO_DELIVERY.getValue());
                            }
                            if ("17".equals(mosDrugLogisticsRouteEntity2.getOpCode())) {
                                resVo.setItemStatus(DrugMainStatusEnum.SIGN_IN.getValue());
                            }
                        }
                        resVo.setLogisticsRouteRemark(mosDrugLogisticsRouteEntity2.getRemark());
                    }
                }
            }
            if (DoctorTypeEnum.SYSTEM.getValue().equals(vo.getType()) && StringUtils.isNotEmpty((String)resVo.getPatientId()) && CollectionUtils.isNotEmpty((Collection)(outLineList = this.drugMainManage.getOutLineList(resVo.getPatientId(), resVo.getAppCode())))) {
                resVo.setOutList(outLineList);
            }
        }
        if (DrugMainStatusEnum.TO_TAKE.getValue().equals(resVo.getItemStatus())) {
            Map map = null;
            List recipeNoList = resVo.getPresDetailList().stream().map(v -> v.getHisRecipeNo()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(recipeNoList) && (map = this.hisManage.getHisRecipeStatus(recipeNoList)) != null) {
                for (String item2 : recipeNoList) {
                    if (!HytHisRecipeStatusEnum.PAY.getValue().equals(map.get(item2))) continue;
                    DrugMainEntity drugMainEntity = new DrugMainEntity();
                    drugMainEntity.setxId(vo.getMainId());
                    drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                    this.mosDrugMainMapper.update(drugMainEntity);
                    resVo.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                }
            }
        }
        return BaseResponse.success((Object)resVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<SendPresDetailResVO> sendPresDetail(SendPresDetailReqVO vo) {
        log.info("======>\u5904\u65b9\u53d1\u8d27\u7ba1\u7406\u8ba2\u5355\u8be6\u60c5 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        boolean drugFlag = false;
        SendPresDetailResVO resVO = new SendPresDetailResVO();
        ArrayList<SendDrugItemData> sendDrugItemList = new ArrayList<SendDrugItemData>();
        ArrayList<SendMainDetailData> sendMainList = new ArrayList<SendMainDetailData>();
        List sendPresDetailDtoList = this.mosDrugLogisticsOrderMapper.queryMultiPresList(vo.getLogisticsId());
        if (CollectionUtils.isEmpty((Collection)sendPresDetailDtoList)) {
            return BaseResponse.success();
        }
        BeanUtils.copyProperties(sendPresDetailDtoList.get(0), (Object)resVO, (String[])BeanHelper.getNullPropertyNames(sendPresDetailDtoList.get(0)));
        List mainIds = sendPresDetailDtoList.stream().map(SendPresDetailDataDTO::getMainId).distinct().collect(Collectors.toList());
        for (String mainId : mainIds) {
            boolean mainFlag = false;
            ArrayList<String> recipeNos = new ArrayList<String>();
            SendMainDetailData sendMainDetailData = new SendMainDetailData();
            ArrayList<SendPresDetailData> sendPresDetailList = new ArrayList<SendPresDetailData>();
            for (SendPresDetailDataDTO item2 : sendPresDetailDtoList) {
                if (!drugFlag) {
                    SendDrugItemData sendDrugItemData = new SendDrugItemData();
                    BeanUtils.copyProperties((Object)item2, (Object)sendDrugItemData, (String[])BeanHelper.getNullPropertyNames((Object)item2));
                    sendDrugItemList.add(sendDrugItemData);
                }
                if (!mainId.equals(item2.getMainId())) continue;
                if (!mainFlag) {
                    BeanUtils.copyProperties((Object)item2, (Object)sendMainDetailData, (String[])BeanHelper.getNullPropertyNames((Object)item2));
                    mainFlag = true;
                }
                if (recipeNos.contains(item2.getHisRecipeNo())) continue;
                SendPresDetailData sendPresDetailData = new SendPresDetailData();
                BeanUtils.copyProperties((Object)item2, (Object)sendPresDetailData, (String[])BeanHelper.getNullPropertyNames((Object)item2));
                sendPresDetailList.add(sendPresDetailData);
                recipeNos.add(item2.getHisRecipeNo());
            }
            if (CollectionUtils.isNotEmpty(sendPresDetailList)) {
                sendMainDetailData.setSendPresDetailList(sendPresDetailList);
            }
            if (Objects.nonNull(sendMainDetailData)) {
                sendMainList.add(sendMainDetailData);
            }
            drugFlag = true;
        }
        if (CollectionUtils.isNotEmpty(sendDrugItemList)) {
            sendDrugItemList.stream().forEach(item -> {
                DrugItemEntity drugItemEntity;
                if (unitList.contains(item.getWholePackingUnit()) && DrugTypeEnum.CM.getValue().equals(Integer.valueOf(item.getPresType())) && Objects.nonNull(drugItemEntity = this.drugItemMapper.queryByCommonCode(item.getCommonCode(), AppCodeEnum.HYT.getValue())) && Objects.nonNull(drugItemEntity.getMeasureNum())) {
                    item.setSingleDose(item.getSingleDose().divide(drugItemEntity.getMeasureNum()));
                    item.setMeasureUnit(item.getWholePackingUnit() + "[" + item.getDrugSpec() + "]");
                }
                if (DrugTypeEnum.WCTM.getValue().equals(Integer.valueOf(item.getPresType()))) {
                    item.setUnitPrice(new BigDecimal(item.getUnitPrice()).setScale(2, 4).toString());
                    item.setTotalPrice(new BigDecimal(item.getTotalPrice()).setScale(2, 4).toString());
                }
            });
            resVO.setSendDrugItemList(sendDrugItemList);
        }
        if (CollectionUtils.isNotEmpty(sendMainList)) {
            resVO.setSendMainDetailList(sendMainList);
        }
        return BaseResponse.success((Object)resVO);
    }

    private List<MosDrugLogisticsRouteEntity> queryLogisticsRoute(MainDetailResVO resVO, String storeId, Integer distributionType) {
        Integer itemStatus = null;
        List<MosDrugLogisticsRouteEntity> mosDrugLogisticsRouteEntityList = this.mosDrugLogisticsRouteMapper.selectListByLogisticsOrderId(resVO.getLogisticsOrderId());
        List codeList = mosDrugLogisticsRouteEntityList.stream().map(v -> Integer.valueOf(v.getOpCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)mosDrugLogisticsRouteEntityList) || !codeList.contains(17)) {
            DrugstoreEntity drugstoreEntity = this.mosDrugstoreMapper.queryById(storeId);
            BaseResponse baseResponse = this.logisticsManage.localOrderFeed(resVO.getLogisticsOrderSeq(), drugstoreEntity, distributionType);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(baseResponse.getCode())) {
                List feedList = ((LocalOrderFeedResVO)baseResponse.getData()).getFeed();
                List localCodeList = feedList.stream().map(v -> (int)v.getOrderStatus()).collect(Collectors.toList());
                List drugMainEntityList = this.mosDrugMainMapper.getListByLogisticsOrderId(resVO.getLogisticsOrderId());
                for (FeedDetailVO feedDetailVO : feedList) {
                    if (codeList.contains(feedDetailVO.getOrderStatus())) continue;
                    MosDrugLogisticsRouteEntity routeEntity = new MosDrugLogisticsRouteEntity();
                    routeEntity.setOpCode(feedDetailVO.getOrderStatus().toString());
                    routeEntity.setRemark(feedDetailVO.getContent());
                    routeEntity.setAcceptTotalTime(feedDetailVO.getCreateTime());
                    routeEntity.setLogisticsOrderId(resVO.getLogisticsOrderId());
                    routeEntity.setMailNo(resVO.getMainNo());
                    routeEntity.setDeliveryName(feedDetailVO.getOperatorName());
                    routeEntity.setDeliveryPhone(feedDetailVO.getOperatorPhone());
                    this.mosDrugLogisticsRouteMapper.insertSelective(routeEntity);
                    mosDrugLogisticsRouteEntityList.add(routeEntity);
                    if (localCodeList.contains(15)) {
                        itemStatus = DrugMainStatusEnum.TO_DELIVERY.getValue();
                    }
                    if (!localCodeList.contains(17)) continue;
                    itemStatus = DrugMainStatusEnum.SIGN_IN.getValue();
                }
                if (itemStatus != null) {
                    for (DrugMainEntity drugMainEntity : drugMainEntityList) {
                        DrugMainEntity mainEntity = new DrugMainEntity();
                        mainEntity.setxId(drugMainEntity.getxId());
                        mainEntity.setItemStatus(itemStatus);
                        this.mosDrugMainMapper.update(mainEntity);
                    }
                }
            }
        }
        mosDrugLogisticsRouteEntityList = mosDrugLogisticsRouteEntityList.stream().sorted(Comparator.comparing(MosDrugLogisticsRouteEntity::getAcceptTotalTime)).collect(Collectors.toList());
        return mosDrugLogisticsRouteEntityList;
    }

    private synchronized boolean isAuditedPres(Integer itemStatus) {
        return !DrugMainStatusEnum.APPROVING.getValue().equals(itemStatus);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> pdf() {
        ArrayList<String> strList = new ArrayList<String>();
        List list = this.mosDrugMainMapper.queryForHytPdf();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (DrugMainEntity drugMainEntity : list) {
                String stamp = this.camanage.getStamp(drugMainEntity.getPresDoctorId(), drugMainEntity.getPresOrgan());
                if (StringUtils.isEmpty((String)stamp)) {
                    strList.add(drugMainEntity.getPresDoctorId());
                    continue;
                }
                drugMainEntity.setDoctorSign(stamp);
                this.mosDrugMainMapper.update(drugMainEntity);
                log.info("=======\u533b\u5631ID:{}", (Object)drugMainEntity.getxId());
                List presList = this.mosDrugPrescriptionMapper.queryByMainIds(Arrays.asList(drugMainEntity.getxId()));
                for (DrugPrescriptionEntity drugPrescriptionEntity : presList) {
                    this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), drugPrescriptionEntity.getxId());
                }
                this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), null);
            }
        }
        log.info("=======CA\u7b7e\u7ae0\u7f3a\u5931\u533b\u751fID\u96c6\u5408\uff1a{}", (Object)Arrays.toString(strList.toArray()));
        return null;
    }

    static {
        unitList.add("\u888b");
        unitList.add("\u6761");
    }
}

