/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugFrequencyEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUsageEntity;
import com.ebaiyihui.medicalcloud.service.HerbPrescriptionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/herb"})
@Api(tags={"\u8349\u836fAPI"})
public class HerbPrescriptionController {
    private static final Logger log = LoggerFactory.getLogger(HerbPrescriptionController.class);
    private final HerbPrescriptionService herbPrescriptionService;

    @GetMapping(value={"/v1/getDrugUsageList"})
    @ApiOperation(value="\u83b7\u53d6\u8349\u836f\u4f7f\u7528\u65b9\u6cd5", notes="\u83b7\u53d6\u8349\u836f\u4f7f\u7528\u65b9\u6cd5")
    public BaseResponse<List<DrugUsageEntity>> getDrugUsage(@RequestParam(value="useType") String useType) {
        List drugUsageList = this.herbPrescriptionService.getDrugUsageList(useType);
        return BaseResponse.success((Object)drugUsageList);
    }

    @GetMapping(value={"/v1/getFrequencyList"})
    @ApiOperation(value="\u83b7\u53d6\u9891\u6b21\u5217\u8868", notes="\u83b7\u53d6\u9891\u6b21\u5217\u8868")
    public BaseResponse<List<DrugFrequencyEntity>> getFrequencyList(@RequestParam(value="drugType") String drugType) {
        List list = this.herbPrescriptionService.getFrequencyList(drugType);
        return BaseResponse.success((Object)list);
    }

    public HerbPrescriptionController(HerbPrescriptionService herbPrescriptionService) {
        this.herbPrescriptionService = herbPrescriptionService;
    }
}

