/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.ConfirmPayDtoReq;
import com.ebaiyihui.medicalcloud.pojo.vo.AddOrdersReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientRegistryReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientSearchReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.UpdateOrdersStateReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.UpdatePresPriceReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.medicalcloud.service.NcefyPrescriptionService;
import com.ebaiyihui.medicalcloud.utils.ExcelUtils;
import com.ebaiyihui.medicalcloud.utils.excel.DrugDetailExcel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5357\u5927\u4e8c\u8282\u70b9\u5904\u65b9API"})
@RestController
@RequestMapping(value={"/api/ncefyPrescription"})
public class NcefyPrescriptionController {
    private static final Logger log = LoggerFactory.getLogger(NcefyPrescriptionController.class);
    @Autowired
    private NcefyPrescriptionService ncefyPrescriptionService;

    @ApiOperation(value="\u533b\u5631\u63a8\u9001\u63a5\u53e3", notes="\u533b\u5631\u63a8\u9001\u63a5\u53e3")
    @PostMapping(value={"/v1/addOrders"})
    public BaseResponse<Object> addOrders(@RequestBody AddOrdersReqVo addOrdersReqVo) {
        this.ncefyPrescriptionService.patientOrderRegistry(addOrdersReqVo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4fee\u6539\u533b\u5631\u63a5\u53e3", notes="\u4fee\u6539\u533b\u5631\u63a5\u53e3")
    @PostMapping(value={"/v1/updateOrdersState"})
    public BaseResponse<Object> updateOrdersState(@RequestBody UpdateOrdersStateReqVo updateOrdersStateReqVo) {
        this.ncefyPrescriptionService.updateOrdersState(updateOrdersStateReqVo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u533b\u5631\u63a5\u53e3", notes="\u903b\u8f91\u5220\u9664\u533b\u5631\u63a5\u53e3")
    @PostMapping(value={"/v1/deleteOrder"})
    public BaseResponse<Object> deleteOrder(@RequestParam(value="mainId", defaultValue="") String mainId) {
        this.ncefyPrescriptionService.deleteOrder(mainId);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u63a8\u9001\u60a3\u8005\u4fe1\u606f\u63a5\u53e3", notes="\u63a8\u9001\u60a3\u8005\u4fe1\u606f\u63a5\u53e3")
    @PostMapping(value={"/v1/patientRegistry"})
    public BaseResponse<Object> patientRegistry(@RequestBody PatientRegistryReqVo patientRegistryReqVo) {
        this.ncefyPrescriptionService.patientRegistry(patientRegistryReqVo);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u672a\u652f\u4ed8\u60a3\u8005\u4fe1\u606f\u63a5\u53e3", notes="\u672a\u652f\u4ed8\u60a3\u8005\u4fe1\u606f\u63a5\u53e3")
    @PostMapping(value={"/v1/getUnpaidPatientInfo"})
    public BaseResponse<Object> getUnpaidPatientInfo(@RequestBody @Validated UcCardListReqVO ucCardListReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.ncefyPrescriptionService.getUnpaidPatientInfo(ucCardListReqVO);
    }

    @ApiOperation(value="\u60a3\u8005\u68c0\u7d22\u7ed1\u5361\u63a5\u53e3", notes="\u60a3\u8005\u68c0\u7d22\u7ed1\u5361\u63a5\u53e3")
    @PostMapping(value={"/v1/getPatientTobind"})
    public BaseResponse<Object> getPatientTobind(@RequestBody @Validated PatientSearchReqVo patientSearchReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.ncefyPrescriptionService.getPatientTobind(patientSearchReqVo);
    }

    @ApiOperation(value="\u836f\u623f\u786e\u8ba4\u652f\u4ed8\u63a5\u53e3", notes="\u836f\u623f\u786e\u8ba4\u652f\u4ed8\u63a5\u53e3")
    @PostMapping(value={"/v1/confirmPay"})
    public BaseResponse<Object> confirmPay(@RequestBody @Validated ConfirmPayDtoReq confirmPayDtoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.ncefyPrescriptionService.confirmPay(confirmPayDtoReq);
    }

    @ApiOperation(value="\u5904\u65b9\u8ba2\u5355\u6279\u91cf\u5bfc\u51fa\u4e3aExcel")
    @PostMapping(value={"/v1/exportDrugDetailExcel"})
    public void exportDrugDetailExcel(@RequestParam(value="mainIds", defaultValue="") List<String> mainIds, HttpServletResponse response) throws IOException {
        List list = this.ncefyPrescriptionService.exportDrugDetailExcel(mainIds);
        ExcelUtils.exportExcel((List)list, null, (String)"\u5904\u65b9\u8ba2\u5355\u4fe1\u606f", DrugDetailExcel.class, (String)"\u5904\u65b9\u8ba2\u5355\u4fe1\u606f", (HttpServletResponse)response);
    }

    @PostMapping(value={"/v1/updatePresPriceInfo"})
    @ApiOperation(value="\u66f4\u65b0\u5904\u65b9\u4ef7\u683c", notes="\u66f4\u65b0\u5904\u65b9\u4ef7\u683c")
    public BaseResponse updatePresPrice(@RequestBody @Validated UpdatePresPriceReqVo updatePresPriceReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.ncefyPrescriptionService.updatePresPrice(updatePresPriceReqVo);
    }
}

