/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugNumCountDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugSpecDataDTO;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CountDrugNumsManage {
    private static final Logger log = LoggerFactory.getLogger(CountDrugNumsManage.class);

    public BaseResponse<Object> countDrugNums(DrugNumCountDTO drugNumCountDTO) {
        log.info("countDrugNums drugNumCountDTO ===>{}", (Object)JSON.toJSONString((Object)drugNumCountDTO));
        BaseResponse paramCheckRes = this.paramCheck(drugNumCountDTO);
        if (!paramCheckRes.isSuccess()) {
            log.info("countDrugNums paramCheck err ===> {}", (Object)paramCheckRes.getMsg());
            return BaseResponse.error((String)paramCheckRes.getMsg());
        }
        BigDecimal singleDoes = drugNumCountDTO.getSingleDoes();
        BigDecimal conversionRate = drugNumCountDTO.getConverRate();
        Integer days = drugNumCountDTO.getDays();
        BigDecimal measureNum = drugNumCountDTO.getMeasureNum();
        Integer minBillPackingNum = drugNumCountDTO.getMinBillPackingNum();
        BigDecimal times = conversionRate.multiply(new BigDecimal(days)).setScale(0, 0);
        BigDecimal molecule = singleDoes.multiply(times);
        BigDecimal denominator = measureNum.multiply(new BigDecimal(minBillPackingNum));
        BigDecimal countNum = molecule.divide(denominator, 0);
        int resNum = countNum.setScale(0, 0).intValue();
        log.info(" countDrugNums molecule===>{}, denominator ===>{} ,countNum ===>{} ,resNum ===>{}", new Object[]{molecule, denominator, countNum});
        return BaseResponse.success((Object)resNum);
    }

    private BaseResponse<String> paramCheck(DrugNumCountDTO drugNumCountDTO) {
        if (drugNumCountDTO == null) {
            return BaseResponse.error((String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3anull!");
        }
        if (drugNumCountDTO.getDays() == null || drugNumCountDTO.getDays() < 1) {
            return BaseResponse.error((String)"\u5468\u671f\u6570\u636e\u6709\u8bef!");
        }
        if (drugNumCountDTO.getMinBillPackingNum() == null || drugNumCountDTO.getMinBillPackingNum() < 1) {
            return BaseResponse.error((String)"\u6574\u5305\u88c5\u6570\u91cf\u6570\u636e\u6709\u8bef!");
        }
        BigDecimal temp = BigDecimal.valueOf(0.0);
        if (drugNumCountDTO.getSingleDoes() == null || drugNumCountDTO.getSingleDoes().compareTo(temp) <= 0) {
            return BaseResponse.error((String)"\u5355\u6b21\u5242\u91cf\u6570\u636e\u6709\u8bef!");
        }
        if (drugNumCountDTO.getConverRate() == null || drugNumCountDTO.getConverRate().compareTo(temp) <= 0) {
            return BaseResponse.error((String)"\u6362\u7b97\u7387\u6570\u636e\u6709\u8bef!");
        }
        if (drugNumCountDTO.getMeasureNum() == null || drugNumCountDTO.getMeasureNum().compareTo(temp) <= 0) {
            return BaseResponse.error((String)"\u6700\u5c0f\u5305\u88c5\u5242\u91cf\u6570\u636e\u6709\u8bef!");
        }
        return BaseResponse.success((Object)"\u9a8c\u8bc1\u901a\u8fc7!");
    }

    public String drugSpecData(DrugSpecDataDTO drugSpecDataDTO) {
        if (!this.drugSpecParamCheck(drugSpecDataDTO)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(new BigDecimal(StringUtil.getNoZeros((String)drugSpecDataDTO.getMeasureNum().toString()))).append(drugSpecDataDTO.getMeasureUnit()).append(" x ").append(new BigDecimal(StringUtil.getNoZeros((String)drugSpecDataDTO.getMinBillPackingNum().toString()))).append(drugSpecDataDTO.getMinBillPackingUnit()).append(" x ").append(1).append(drugSpecDataDTO.getWholePackingUnit());
        return sb.toString();
    }

    private boolean drugSpecParamCheck(DrugSpecDataDTO drugSpecDataDTO) {
        if (drugSpecDataDTO == null) {
            return false;
        }
        if (drugSpecDataDTO.getMinBillPackingNum() == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)drugSpecDataDTO.getMinBillPackingUnit())) {
            return false;
        }
        if (drugSpecDataDTO.getMeasureNum() == null || drugSpecDataDTO.getMeasureNum().compareTo(BigDecimal.valueOf(0.0)) <= 0) {
            return false;
        }
        if (StringUtils.isEmpty((String)drugSpecDataDTO.getMeasureUnit())) {
            return false;
        }
        return !StringUtils.isEmpty((String)drugSpecDataDTO.getWholePackingUnit());
    }
}

