/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.medicalcloud.common.enums.DistributionTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.GyhhStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.config.CommonConfig;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsRouteMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugstoreEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderRegEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsRouteEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.OrderThirdVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.BatchAddOrderResult;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.FreightQueryReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.FreightQueryResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalCreateOrderReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalCreateOrderResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalOrderFeedReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalOrderFeedResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalPreCreateOrderReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalPreCreateOrderResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LogisticsRouteInfoReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LogisticsRouteInfoResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.SfBatchAddOrderReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.SieveOrderReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.SieveOrderResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.LogisticsReqest;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.LogisticsVO;
import com.ebaiyihui.medicalcloud.utils.BYSignUtil;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.utils.JsonFormatUtils;
import com.ebaiyihui.medicalcloud.utils.XmlUtil;
import com.ebaiyihui.medicalcloud.utils.sign.NewSignUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class LogisticsManage {
    private static final Logger log = LoggerFactory.getLogger(LogisticsManage.class);
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugLogisticsRouteMapper mosDrugLogisticsRouteMapper;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public BaseResponse<List<LogisticsRouteInfoResVo>> queryRoute(LogisticsRouteInfoReqVo logisticsRouteInfoReqVo, HospitalConfigEntity configEntity) {
        logisticsRouteInfoReqVo.setAppId(this.commonConfig.getAppId());
        logisticsRouteInfoReqVo.setHospitalCode(configEntity.getHospitalCode());
        logisticsRouteInfoReqVo.setMerchantId(Long.valueOf(this.commonConfig.getMerchantId()));
        logisticsRouteInfoReqVo.setSecretKey(configEntity.getSecretKey());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", this.commonConfig.getAppId());
        map.put("hospitalCode", configEntity.getHospitalCode());
        map.put("merchantId", this.commonConfig.getMerchantId());
        map.put("orderNo", logisticsRouteInfoReqVo.getOrderNo());
        map.put("secretKey", configEntity.getSecretKey());
        Long timestamp = System.currentTimeMillis() / 1000L;
        logisticsRouteInfoReqVo.setTimestamp(timestamp);
        map.put("timestamp", timestamp.toString());
        String sign = null;
        try {
            sign = BYSignUtil.getSignature(map, (String)this.commonConfig.getAppSecret());
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        logisticsRouteInfoReqVo.setSign(sign);
        try {
            String url = new StringBuffer(this.nodeConfig.getLogistics()).append("/access/sfmedical/listOrderRoute").toString();
            String body = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)logisticsRouteInfoReqVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            if (baseResponse.isSuccess()) {
                return BaseResponse.success((Object)JSON.parseArray((String)JSON.toJSONString((Object)baseResponse.getData()), LogisticsRouteInfoResVo.class));
            }
            return BaseResponse.error((String)baseResponse.getMsg());
        }
        catch (Exception e) {
            log.error("queryRoute\u5f02\u5e38->{}", (Throwable)e);
            return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public SieveOrderResVO sieveOrder(SieveOrderReqVO vo, HospitalConfigEntity configEntity) {
        vo.setAppId(this.commonConfig.getAppId());
        vo.setHospitalCode(configEntity.getHospitalCode());
        vo.setMerchantId(Long.valueOf(this.commonConfig.getMerchantId()));
        vo.setSecretKey(configEntity.getSecretKey());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", this.commonConfig.getAppId());
        map.put("hospitalCode", configEntity.getHospitalCode());
        map.put("merchantId", this.commonConfig.getMerchantId());
        map.put("destAddress", vo.getDestAddress());
        map.put("srcAddress", vo.getSrcAddress());
        map.put("secretKey", configEntity.getSecretKey());
        Long timestamp = System.currentTimeMillis() / 1000L;
        vo.setTimestamp(timestamp);
        map.put("timestamp", timestamp.toString());
        String sign = null;
        try {
            sign = BYSignUtil.getSignature(map, (String)this.commonConfig.getAppSecret());
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        vo.setSign(sign);
        try {
            String url = new StringBuffer(this.nodeConfig.getLogistics()).append("/access/sfmedical/sieveOrder").toString();
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u76f4\u8fde\u4e0b\u5355\u63a5\u53e3-->URL:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)vo));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)vo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u76f4\u8fde\u4e0b\u5355\u63a5\u53e3\u7ed3\u679c----->{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) {
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code"))) {
                    return new SieveOrderResVO(true, null);
                }
                return new SieveOrderResVO(false, JSON.parseObject((String)result).getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }

    public BaseResponse<String> freightQuery(String logisticsType, FreightQueryReqVO vo, HospitalConfigEntity hospitalConfigEntity) {
        block6: {
            vo.setAppId(this.commonConfig.getAppId());
            vo.setHospitalCode(hospitalConfigEntity.getHospitalCode());
            vo.setMerchantId(Long.valueOf(this.commonConfig.getMerchantId()));
            vo.setSecretKey(hospitalConfigEntity.getSecretKey());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("appId", this.commonConfig.getAppId());
            map.put("hospitalCode", hospitalConfigEntity.getHospitalCode());
            map.put("merchantId", this.commonConfig.getMerchantId());
            map.put("destAddress", vo.getDestAddress());
            map.put("destCity", vo.getDestCity());
            map.put("destDistrict", vo.getDestDistrict());
            map.put("destProvince", vo.getDestProvince());
            map.put("expressType", vo.getExpressType());
            map.put("parcelWeighs", vo.getParcelWeighs());
            map.put("srcAddress", vo.getSrcAddress());
            map.put("srcCity", vo.getSrcCity());
            map.put("srcDistrict", vo.getSrcDistrict());
            map.put("srcProvince", vo.getSrcProvince());
            map.put("secretKey", hospitalConfigEntity.getSecretKey());
            Long timestamp = System.currentTimeMillis() / 1000L;
            vo.setTimestamp(timestamp);
            map.put("timestamp", timestamp.toString());
            String sign = null;
            try {
                sign = BYSignUtil.getSignature(map, (String)this.commonConfig.getAppSecret());
            }
            catch (Exception e) {
                log.error("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            vo.setSign(sign);
            try {
                String url = new StringBuffer(this.nodeConfig.getLogistics()).append("/access/sfmedical/freightQuery").toString();
                log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u65f6\u6548\u8fd0\u8d39\u63a5\u53e3-->URL:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)vo));
                String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)vo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
                log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u65f6\u6548\u8fd0\u8d39\u63a5\u53e3\u7ed3\u679c----->{}", (Object)result);
                if (!StringUtils.isNotEmpty((String)result)) break block6;
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONArray("data")) {
                    List list = JSONObject.parseArray((String)JSONObject.parseObject((String)result).getJSONArray("data").toJSONString(), FreightQueryResVO.class);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        BigDecimal price = ((FreightQueryResVO)list.get(0)).getPrice().divide(new BigDecimal(100)).add(hospitalConfigEntity.getOverweightAmount()).add(hospitalConfigEntity.getPackStandardMoney()).setScale(2, 4);
                        return BaseResponse.success((Object)price.toString());
                    }
                    break block6;
                }
                return BaseResponse.error((String)JSON.parseObject((String)result).getString("msg"));
            }
            catch (Exception e) {
                log.error("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
            }
        }
        return null;
    }

    public void save(String xml) {
        LogisticsReqest logisticsReqest = (LogisticsReqest)XmlUtil.convertToJavaBean((String)xml, LogisticsReqest.class);
        log.info("========>\u56fd\u6cf0\u534e\u8679\u4f20\u8fc7\u6765\u7684\u53c2\u6570:" + Objects.toString(logisticsReqest, null));
        List logisticsVOList = logisticsReqest.getLogisticsVOList();
        logisticsVOList = logisticsVOList.stream().sorted(Comparator.comparing(LogisticsVO::getOperationTime)).collect(Collectors.toList());
        for (LogisticsVO logisticsVO : logisticsVOList) {
            MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity;
            MosDrugLogisticsRouteEntity mosDrugLogisticsRouteEntity;
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.getByHisRecipeNo(logisticsVO.getPrescribeNo());
            if (Objects.isNull(drugMainEntity)) {
                log.error("logisticsVO.getPrescribeNo()->{}\u5904\u65b9\u4e0d\u5b58\u5728", (Object)logisticsVO.getPrescribeNo());
                continue;
            }
            if (drugMainEntity.getOrderType().equals(OrderTypeEnum.DRUG_ORDER.getValue())) {
                log.info("=========\u81ea\u53d6\u8ba2\u5355->{}", (Object)Objects.toString(drugMainEntity, null));
                if (!GyhhStatusEnum.SIGN_IN.getValue().equals(logisticsVO.getDeliverStatus())) continue;
                drugMainEntity.setItemStatus(DrugMainStatusEnum.GET_MEDICINE.getValue());
                this.mosDrugMainMapper.update(drugMainEntity);
                continue;
            }
            log.info("=========\u5feb\u9012\u8ba2\u5355->{}", (Object)Objects.toString(drugMainEntity, null));
            if (GyhhStatusEnum.UN_SEND.getValue().equals(logisticsVO.getDeliverStatus())) {
                if (!drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.TO_SEND.getValue())) continue;
                drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_SEND.getValue());
                this.mosDrugMainMapper.update(drugMainEntity);
                mosDrugLogisticsRouteEntity = this.getLogisticsRouteEntity(logisticsVO, drugMainEntity.getxId());
                this.mosDrugLogisticsRouteMapper.insert(mosDrugLogisticsRouteEntity);
                mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByPrimaryKey(mosDrugLogisticsRouteEntity.getLogisticsOrderId());
                mosDrugLogisticsOrderEntity.setMainNo(logisticsVO.getDeliverNo());
                this.mosDrugLogisticsOrderMapper.updateByPrimaryKey(mosDrugLogisticsOrderEntity);
                continue;
            }
            if (GyhhStatusEnum.SENT.getValue().equals(logisticsVO.getDeliverStatus())) {
                if (!drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.TO_SEND.getValue())) continue;
                drugMainEntity.setItemStatus(DrugMainStatusEnum.SENT.getValue());
                this.mosDrugMainMapper.update(drugMainEntity);
                mosDrugLogisticsRouteEntity = this.getLogisticsRouteEntity(logisticsVO, drugMainEntity.getxId());
                this.mosDrugLogisticsRouteMapper.insert(mosDrugLogisticsRouteEntity);
                mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByPrimaryKey(mosDrugLogisticsRouteEntity.getLogisticsOrderId());
                mosDrugLogisticsOrderEntity.setMainNo(logisticsVO.getDeliverNo());
                this.mosDrugLogisticsOrderMapper.updateByPrimaryKey(mosDrugLogisticsOrderEntity);
                continue;
            }
            if (GyhhStatusEnum.TO_DELIVERY.getValue().equals(logisticsVO.getDeliverStatus())) {
                if (!drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.SENT.getValue()) && !drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.TO_SEND.getValue())) continue;
                drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_DELIVERY.getValue());
                this.mosDrugMainMapper.update(drugMainEntity);
                mosDrugLogisticsRouteEntity = this.getLogisticsRouteEntity(logisticsVO, drugMainEntity.getxId());
                this.mosDrugLogisticsRouteMapper.insert(mosDrugLogisticsRouteEntity);
                mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByPrimaryKey(mosDrugLogisticsRouteEntity.getLogisticsOrderId());
                mosDrugLogisticsOrderEntity.setMainNo(logisticsVO.getDeliverNo());
                this.mosDrugLogisticsOrderMapper.updateByPrimaryKey(mosDrugLogisticsOrderEntity);
                continue;
            }
            if (!GyhhStatusEnum.SIGN_IN.getValue().equals(logisticsVO.getDeliverStatus()) && !drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.SENT.getValue()) && !drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.TO_SEND.getValue()) || !drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.TO_DELIVERY.getValue())) continue;
            drugMainEntity.setItemStatus(DrugMainStatusEnum.SIGN_IN.getValue());
            mosDrugLogisticsRouteEntity = this.getLogisticsRouteEntity(logisticsVO, drugMainEntity.getxId());
            this.mosDrugLogisticsRouteMapper.insert(mosDrugLogisticsRouteEntity);
            this.mosDrugMainMapper.update(drugMainEntity);
            mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByPrimaryKey(mosDrugLogisticsRouteEntity.getLogisticsOrderId());
            mosDrugLogisticsOrderEntity.setMainNo(logisticsVO.getDeliverNo());
            this.mosDrugLogisticsOrderMapper.updateByPrimaryKey(mosDrugLogisticsOrderEntity);
            this.threadPoolTaskExecutor.execute(() -> {
                LinkedHashMap data = new LinkedHashMap();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("value", drugMainEntity.getPresDoctorName());
                data.put("doctorName", map1);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("value", "\u836f\u54c1\u914d\u9001\u5b8c\u6210");
                data.put("issue", map2);
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("value", "\u60a8\u7684\u836f\u54c1\u5df2\u5b8c\u6210\u914d\u9001");
                data.put("info", map3);
                this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, null);
                QueryOrganDetailVO organDetailVO = this.doctorRetmoteManage.queryOrganDetail(Integer.valueOf(Integer.parseInt(drugMainEntity.getOrganId())));
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                HashMap<String, String> param = new HashMap<String, String>();
                if (organDetailVO.getTelphone() == null) {
                    param.put("hotline", "");
                } else {
                    param.put("hotline", organDetailVO.getTelphone());
                }
                log.info("=======\u51c6\u5907\u53d1\u8d77\u77ed\u4fe1\u63a8\u9001");
                this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy_pswc", drugMainEntity.getPatientPhone(), param);
            });
        }
    }

    private MosDrugLogisticsRouteEntity getLogisticsRouteEntity(LogisticsVO logisticsVO, String mainId) {
        MosDrugLogisticsRouteEntity mosDrugLogisticsRouteEntity = new MosDrugLogisticsRouteEntity();
        MosDrugLogisticsOrderRegEntity mosDrugLogisticsOrderRegEntity = this.mosDrugLogisticsOrderRegMapper.getByMainId1(mainId);
        mosDrugLogisticsRouteEntity.setLogisticsOrderId(mosDrugLogisticsOrderRegEntity.getLogisticsOrderId());
        mosDrugLogisticsRouteEntity.setAcceptTotalTime(logisticsVO.getOperationTime());
        mosDrugLogisticsRouteEntity.setOpCode(logisticsVO.getDeliverStatus());
        mosDrugLogisticsRouteEntity.setRemark(logisticsVO.getDeliverDescribe());
        mosDrugLogisticsRouteEntity.setMailNo(logisticsVO.getDeliverNo());
        mosDrugLogisticsRouteEntity.setCreateTime(new Date());
        mosDrugLogisticsRouteEntity.setUpdateTime(new Date());
        mosDrugLogisticsRouteEntity.setDeliveryName(logisticsVO.getDeliverBy());
        mosDrugLogisticsRouteEntity.setDeliveryPhone(logisticsVO.getPhoneNumber());
        return mosDrugLogisticsRouteEntity;
    }

    public BaseResponse<BatchAddOrderResult> batchAddOrder(List<OrderThirdVO> list, HospitalConfigEntity configEntity) {
        SfBatchAddOrderReqVO sfBatchAddOrderReqVO = new SfBatchAddOrderReqVO();
        sfBatchAddOrderReqVO.setAppId(this.commonConfig.getAppId());
        sfBatchAddOrderReqVO.setHospitalCode(configEntity.getHospitalCode());
        sfBatchAddOrderReqVO.setMerchantId(Long.valueOf(this.commonConfig.getMerchantId()));
        sfBatchAddOrderReqVO.setSecretKey(configEntity.getSecretKey());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", this.commonConfig.getAppId());
        map.put("hospitalCode", configEntity.getHospitalCode());
        map.put("merchantId", this.commonConfig.getMerchantId());
        map.put("orderThirds", JSON.toJSONString(list));
        map.put("secretKey", configEntity.getSecretKey());
        Long timestamp = System.currentTimeMillis() / 1000L;
        map.put("timestamp", timestamp.toString());
        try {
            String sign = BYSignUtil.getSignature(map, (String)this.commonConfig.getAppSecret());
            BYSignUtil.checkSign(map, (String)this.commonConfig.getAppSecret());
            sfBatchAddOrderReqVO.setOrderThirds(list);
            sfBatchAddOrderReqVO.setSign(sign);
            sfBatchAddOrderReqVO.setTimestamp(timestamp);
            String url = new StringBuffer(this.nodeConfig.getLogistics()).append("/access/sfmedical/batchAddOrder").toString();
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u6279\u91cf\u4e0b\u5355\u63a5\u53e3-->URL:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)sfBatchAddOrderReqVO));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)sfBatchAddOrderReqVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u6279\u91cf\u4e0b\u5355\u63a5\u53e3\u7ed3\u679c----->{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) {
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                    BatchAddOrderResult batchAddOrderResult = (BatchAddOrderResult)JSONObject.parseObject((String)JSONObject.parseObject((String)result).getString("data"), BatchAddOrderResult.class);
                    return BaseResponse.success((Object)batchAddOrderResult);
                }
                return BaseResponse.error((String)JSON.parseObject((String)result).getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
            throw new BusinessException("\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public BaseResponse<String> localPrCreateOrder(LocalPreCreateOrderReqVO vo, DrugstoreEntity drugstoreEntity, HospitalConfigEntity configEntity, Integer distributionType) {
        if (DistributionTypeEnum.CROSS_POINT.getValue().equals(distributionType)) {
            vo.setIsAppoint(Integer.valueOf(1));
            vo.setExpectTime(DateUtils.getLocalExpectTime((Long)(System.currentTimeMillis() / 1000L)));
            vo.setShopId(drugstoreEntity.getCrossShopId());
        } else {
            vo.setIsAppoint(Integer.valueOf(0));
            vo.setShopId(drugstoreEntity.getShopId());
        }
        vo.setDevId(Integer.valueOf(drugstoreEntity.getDevId()));
        vo.setMerchantId(this.commonConfig.getLocalMerchantId());
        vo.setAppId(this.commonConfig.getLocalAppId());
        vo.setShopType(this.commonConfig.getShopType());
        vo.setCityName(configEntity.getCity());
        vo.setWeight(Integer.valueOf(1000));
        vo.setProductType(Integer.valueOf(2));
        vo.setLbsType(Integer.valueOf(2));
        vo.setPayType(Integer.valueOf(1));
        vo.setIsInsured(Integer.valueOf(0));
        Long timestamp = System.currentTimeMillis() / 1000L;
        vo.setPushTime(timestamp);
        vo.setTimestamp(timestamp);
        try {
            String content = JSON.toJSONString((Object)JsonFormatUtils.transform((Object)vo));
            String sign = NewSignUtil.sign((String)content, (String)this.commonConfig.getLocalAppId(), (String)this.commonConfig.getLocalAppSecret());
            String url = new StringBuffer(this.nodeConfig.getLogistics()).append("/access2/sf/local/prCreateOrder?sign=").append(sign).toString();
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u987a\u4e30\u540c\u57ce\u9884\u521b\u5efa\u8ba2\u5355\u63a5\u53e3-->URL:{},\u53c2\u6570:{}", (Object)url, (Object)content);
            String result = HttpUtils.doPost((String)url, (String)content, (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u987a\u4e30\u540c\u57ce\u9884\u521b\u5efa\u8ba2\u5355\u63a5\u53e3\u7ed3\u679c----->{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) {
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                    LocalPreCreateOrderResVO resVO = (LocalPreCreateOrderResVO)JSONObject.parseObject((String)JsonFormatUtils.convert((String)JSONObject.parseObject((String)result).getString("data")), LocalPreCreateOrderResVO.class);
                    return BaseResponse.success((Object)resVO.getTotalPrice().divide(new BigDecimal(100)).add(configEntity.getOverweightAmount()).add(configEntity.getPackStandardMoney()).setScale(2, 4).toString());
                }
                return BaseResponse.error((String)JSON.parseObject((String)result).getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }

    public BaseResponse<LocalCreateOrderResVO> localCreateOrder(LocalCreateOrderReqVO vo, DrugstoreEntity drugstoreEntity, HospitalConfigEntity configEntity, Integer distributionType) {
        if (DistributionTypeEnum.CROSS_POINT.getValue().equals(distributionType)) {
            vo.setIsAppoint(Integer.valueOf(1));
            vo.setExpectTime(DateUtils.getLocalExpectTime((Long)(System.currentTimeMillis() / 1000L)));
            vo.setShopId(drugstoreEntity.getCrossShopId());
        } else {
            vo.setIsAppoint(Integer.valueOf(0));
            vo.setShopId(drugstoreEntity.getShopId());
        }
        vo.setDevId(Integer.valueOf(drugstoreEntity.getDevId()));
        vo.setMerchantId(this.commonConfig.getLocalMerchantId());
        vo.setAppId(this.commonConfig.getLocalAppId());
        vo.setShopType(this.commonConfig.getShopType());
        vo.setCityName(configEntity.getCity());
        vo.setWeight(Integer.valueOf(1000));
        vo.setProductType(Integer.valueOf(2));
        vo.setIsAppoint(Integer.valueOf(0));
        vo.setLbsType(Integer.valueOf(2));
        vo.setPayType(Integer.valueOf(1));
        vo.setIsInsured(Integer.valueOf(0));
        vo.setOrderSource("ZWBY");
        vo.setVersion(Integer.valueOf(17));
        Long timestamp = System.currentTimeMillis() / 1000L;
        vo.setPushTime(timestamp);
        vo.setTimestamp(timestamp);
        vo.setOrderTime(timestamp);
        try {
            String content = JSON.toJSONString((Object)JsonFormatUtils.transform((Object)vo));
            String sign = NewSignUtil.sign((String)content, (String)this.commonConfig.getLocalAppId(), (String)this.commonConfig.getLocalAppSecret());
            String url = new StringBuffer(this.nodeConfig.getLogistics()).append("/access2/sf/local/createOrder?sign=").append(sign).toString();
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u987a\u4e30\u540c\u57ce\u521b\u5efa\u8ba2\u5355\u63a5\u53e3-->URL:{},\u53c2\u6570:{}", (Object)url, (Object)content);
            String result = HttpUtils.doPost((String)url, (String)content, (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u987a\u4e30\u540c\u57ce\u521b\u5efa\u8ba2\u5355\u63a5\u53e3\u7ed3\u679c----->{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) {
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                    LocalCreateOrderResVO resVO = (LocalCreateOrderResVO)JSONObject.parseObject((String)JsonFormatUtils.convert((String)JSONObject.parseObject((String)result).getString("data")), LocalCreateOrderResVO.class);
                    return BaseResponse.success((Object)resVO);
                }
                return BaseResponse.error((String)JSON.parseObject((String)result).getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }

    public BaseResponse<LocalOrderFeedResVO> localOrderFeed(String orderId, DrugstoreEntity drugstoreEntity, Integer distributionType) {
        LocalOrderFeedReqVO vo = new LocalOrderFeedReqVO();
        if (DistributionTypeEnum.CROSS_POINT.getValue().equals(distributionType)) {
            vo.setShopId(drugstoreEntity.getCrossShopId());
        } else {
            vo.setShopId(drugstoreEntity.getShopId());
        }
        vo.setDevId(Integer.valueOf(drugstoreEntity.getDevId()));
        vo.setAppId(this.commonConfig.getLocalAppId());
        vo.setShopType(this.commonConfig.getShopType());
        vo.setOrderType(Integer.valueOf(2));
        vo.setOrderId(orderId);
        vo.setMerchantId(this.commonConfig.getLocalMerchantId());
        Long timestamp = System.currentTimeMillis() / 1000L;
        vo.setPushTime(timestamp);
        vo.setTimestamp(timestamp);
        try {
            String content = JSON.toJSONString((Object)JsonFormatUtils.transform((Object)vo));
            String sign = NewSignUtil.sign((String)content, (String)this.commonConfig.getLocalAppId(), (String)this.commonConfig.getLocalAppSecret());
            String url = new StringBuffer(this.nodeConfig.getLogistics()).append("/access2/sf/local/listOrderFeed?sign=").append(sign).toString();
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u987a\u4e30\u540c\u57ce\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u63a5\u53e3-->URL:{},\u53c2\u6570:{}", (Object)url, (Object)content);
            String result = HttpUtils.doPost((String)url, (String)content, (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u987a\u4e30\u540c\u57ce\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u63a5\u53e3\u7ed3\u679c----->{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) {
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSONObject.parseObject((String)result).getString("code")) && null != JSONObject.parseObject((String)result).getJSONObject("data")) {
                    LocalOrderFeedResVO resVO = (LocalOrderFeedResVO)JSONObject.parseObject((String)JsonFormatUtils.convert((String)JSONObject.parseObject((String)result).getString("data")), LocalOrderFeedResVO.class);
                    return BaseResponse.success((Object)resVO);
                }
                return BaseResponse.error((String)JSON.parseObject((String)result).getString("msg"));
            }
        }
        catch (Exception e) {
            log.error("=======>\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38 - \u83b7\u53d6\u5f02\u5e38", (Object)e.getMessage());
        }
        return null;
    }
}

