/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.medicalcloud.common.enums.AuditStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.FlatAccountTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.MerchantTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayBillOrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayChannelEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.RemarkTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.factory.PresRoamProcessStrategyFactory;
import com.ebaiyihui.medicalcloud.manage.GnHisManage;
import com.ebaiyihui.medicalcloud.mapper.MerchantConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionDetailMapper;
import com.ebaiyihui.medicalcloud.mapper.MosInspectionOtherFeeMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.ApplyRefundReq;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.CreateOrderDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.FlatAccountReq;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.PayOrderDtoReq;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugstoreEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MerchantConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosInspectionDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.ServicePayBillEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.UserAddressEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.ReconciliationVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundResVo;
import com.ebaiyihui.medicalcloud.service.DrugDetailService;
import com.ebaiyihui.medicalcloud.service.MerchantConfigService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugOrderService;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.service.MosDrugRemarkService;
import com.ebaiyihui.medicalcloud.service.PresRoamProcessRegService;
import com.ebaiyihui.medicalcloud.service.PresRoamProcessService;
import com.ebaiyihui.medicalcloud.service.ServicePayBillService;
import com.ebaiyihui.medicalcloud.service.UserAddressService;
import com.ebaiyihui.medicalcloud.utils.AppCodeUtil;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.HanyuPinyinUtil;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import com.ebaiyihui.medicalcloud.utils.SignUtil;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderPayManage {
    private static final Logger log = LoggerFactory.getLogger(OrderPayManage.class);
    @Autowired
    private MosDrugOrderService drugOrderService;
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private MerchantConfigService merchantConfigService;
    @Autowired
    private UserAddressService userAddressService;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Autowired
    private DrugDetailService drugDetailService;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private MosDrugRemarkService mosDrugRemarkService;
    @Autowired
    private PresRoamProcessRegService presRoamProcessRegService;
    @Autowired
    private ServicePayBillService servicePayBillService;
    @Autowired
    private MerchantConfigMapper merchantConfigMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private GnHisManage gnHisManage;
    @Resource
    private MosInspectionDetailMapper mosInspectionDetailMapper;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Resource
    private MosInspectionOtherFeeMapper mosInspectionOtherFeeMapper;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private RedisUtil redisUtil;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<JSONObject> createTrade(PayOrderDtoReq payOrderDtoReq) {
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(payOrderDtoReq.getMainId());
        DrugstoreEntity drugstoreEntity = null;
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByMainId(payOrderDtoReq.getMainId());
        DrugPrescriptionEntity drugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(payOrderDtoReq.getMainId());
        payOrderDtoReq.setMerchantType(MerchantTypeEnum.DRUG.getValue());
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(payOrderDtoReq.getPayChannel()) && StringUtil.isEmpty((String)payOrderDtoReq.getOpenId())) {
            return BaseResponse.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u65f6openId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (drugOrderEntity != null && drugOrderEntity.getStatus() >= OrderStatusEnum.PAID.getValue()) {
            return BaseResponse.error((String)"\u6b64\u8ba2\u5355\u5df2\u652f\u4ed8\u6216\u5df2\u8fc7\u671f");
        }
        if (drugOrderEntity != null && drugOrderEntity.getStatus().equals(OrderStatusEnum.TOPAY.getValue())) {
            log.info("\u521b\u5efa\u4ea4\u6613------>\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)drugOrderEntity));
            this.improveOrder(drugPrescriptionEntity, drugOrderEntity, payOrderDtoReq, drugstoreEntity);
            if (!drugOrderEntity.getOrderType().equals(payOrderDtoReq.getShippingType())) {
                drugOrderEntity.setOrderType(payOrderDtoReq.getShippingType());
                drugOrderEntity.setOrderSeq(GenSeqUtils.genOrderSeq((String)""));
            }
            this.drugOrderService.update(drugOrderEntity);
            log.info("\u521b\u5efa\u4ea4\u6613------>\u66f4\u65b0\u8ba2\u5355:{}", (Object)JSON.toJSONString((Object)drugOrderEntity));
            return this.callPayServer(drugOrderEntity, payOrderDtoReq);
        }
        drugOrderEntity = new DrugOrderEntity();
        log.info("\u533b\u5631\u7684\u4fe1\u606f\u662f:{}", (Object)drugMainEntity.toString());
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(drugMainEntity.getPresOrgan(), Integer.valueOf(1));
        drugOrderEntity.setxId(GenSeqUtils.getUniqueNo());
        drugOrderEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugOrderEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugOrderEntity.setMainId(payOrderDtoReq.getMainId());
        drugOrderEntity.setMerchantId(merchantConfigEntity.getMerchantSeq());
        drugOrderEntity.setOrderSeq(GenSeqUtils.genOrderSeq((String)""));
        drugOrderEntity.setOrderType(payOrderDtoReq.getShippingType());
        drugOrderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
        drugOrderEntity.setOrganCode(drugMainEntity.getPresOrgan());
        drugOrderEntity.setStatus(OrderStatusEnum.TOPAY.getValue());
        this.improveOrder(drugPrescriptionEntity, drugOrderEntity, payOrderDtoReq, drugstoreEntity);
        this.drugOrderService.insert(drugOrderEntity);
        return this.callPayServer(drugOrderEntity, payOrderDtoReq);
    }

    private void improveOrder(DrugPrescriptionEntity drugPrescriptionEntity, DrugOrderEntity drugOrderEntity, PayOrderDtoReq payOrderDtoReq, DrugstoreEntity drugstoreEntity) {
        BigDecimal totalPrice = BigDecimal.ZERO;
        drugOrderEntity.setPayMethod(payOrderDtoReq.getPayMethod());
        drugOrderEntity.setChannelCode(payOrderDtoReq.getPayChannel());
        if (drugstoreEntity != null) {
            boolean expressMedicine;
            totalPrice = totalPrice.add(drugPrescriptionEntity.getPrice()).add(drugstoreEntity.getServiceFee());
            boolean bl = expressMedicine = payOrderDtoReq.getShippingType().equals(OrderTypeEnum.COURIER_ORDER.getValue());
            if (expressMedicine) {
                UserAddressEntity userAddressEntity = this.userAddressService.queryByMainId(payOrderDtoReq.getMainId());
                totalPrice = totalPrice.add(userAddressEntity.getCourierPrice());
            }
            List list = this.drugDetailService.listByMainId(payOrderDtoReq.getMainId());
            for (DrugDetailEntity drugDetailEntity : list) {
                drugDetailEntity.setStoreId(payOrderDtoReq.getDrugStoreId());
                this.drugDetailService.updateById(drugDetailEntity);
            }
        } else {
            totalPrice = totalPrice.add(drugPrescriptionEntity.getPrice());
        }
        totalPrice = totalPrice.setScale(2, 4);
        drugOrderEntity.setPayAmount(totalPrice);
    }

    private BaseResponse<JSONObject> callPayServer(DrugOrderEntity drugOrderEntity, PayOrderDtoReq payOrderDtoReq) {
        log.info("=======drugOrderEntity:{},payOrderDtoReq:{}", (Object)JSON.toJSONString((Object)drugOrderEntity), (Object)JSON.toJSONString((Object)payOrderDtoReq));
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/create-order").toString();
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(payOrderDtoReq.getMainId());
        log.info("======drugMainEntity:{}", (Object)JSON.toJSONString((Object)drugMainEntity));
        CreateOrderDto createOrderDto = new CreateOrderDto();
        createOrderDto.setPayChannel(PayTypeEnum.WECHAT_PAY.getValue());
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(payOrderDtoReq.getPayChannel())) {
            createOrderDto.setUserSign(payOrderDtoReq.getOpenId());
            createOrderDto.setPayType("JSAPI");
        } else {
            createOrderDto.setPayType("APP");
        }
        createOrderDto.setApplyCode(drugOrderEntity.getMerchantId());
        createOrderDto.setOutTradeNo(drugOrderEntity.getOrderSeq());
        createOrderDto.setTotalAmount(drugOrderEntity.getPayAmount());
        createOrderDto.setActuallyAmount(drugOrderEntity.getPayAmount());
        createOrderDto.setMchCode(drugOrderEntity.getMerchantId());
        String firstLettersUp = HanyuPinyinUtil.getFirstLettersUp((String)drugMainEntity.getPresOrganName());
        log.info("\u533b\u9662\u9996\u5b57\u6bcd\u5927\u5199:{}", (Object)firstLettersUp);
        createOrderDto.setServiceCode(drugMainEntity.getPresOrgan() + "_" + firstLettersUp + "_" + "yyy");
        createOrderDto.setNonceStr(SignUtil.getNonceStr());
        createOrderDto.setPayNotifyUrl(this.nodeConfig.getAddress() + "/GNYFY/medicalcloud/api/order/pay/v1/notifyurl");
        createOrderDto.setProductInfo("\u4e92\u8054\u7f51\u533b\u7597-\u95e8\u8bca\u7f34\u8d39");
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(drugOrderEntity.getOrganCode(), payOrderDtoReq.getMerchantType());
        log.info("====merchantConfigEntity======:{}", (Object)JSON.toJSONString((Object)merchantConfigEntity));
        if (Objects.isNull(merchantConfigEntity)) {
            return BaseResponse.error((String)"\u8bf7\u68c0\u67e5\u652f\u4ed8\u914d\u7f6e");
        }
        Map paramMap = SignUtil.getKeyAndValue((Object)createOrderDto);
        String sign = SignUtil.createSign((Map)paramMap, (String)merchantConfigEntity.getApplyKey(), (String[])new String[0]);
        createOrderDto.setSign(sign);
        try {
            log.info("\u9884\u652f\u4ed8\u7684\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)createOrderDto));
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)createOrderDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u8bf7\u6c42\u9884\u652f\u4ed8\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            String code = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getJSONObject("data") != null) {
                return BaseResponse.success((Object)JSON.parseObject((String)respStr).getJSONObject("data"));
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> orderNotify(PayNotifyReqVO payNotifyReqVO, DrugOrderEntity drugOrderEntity, DrugMainEntity drugMainEntity) {
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.PAID.getValue());
        if (servicePayBillEntity != null) {
            return BaseResponse.success((Object)"SUCCESS");
        }
        this.savePayBill(payNotifyReqVO, drugOrderEntity, drugMainEntity);
        if (!PayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getReturnCode())) {
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        String processCode = this.presRoamProcessRegService.getProcessCodeByAppCodeOrHospitalNameFirstLetter(drugMainEntity.getPresOrgan(), drugMainEntity.getHospitalNameFirstLetter());
        PresRoamProcessService presRoamProcessService = PresRoamProcessStrategyFactory.getPresRoamProcessStrategy((String)processCode);
        CompletableFuture.runAsync(() -> {
            try {
                BaseResponse response = this.gnHisManage.hisPayPressNew(drugMainEntity.getxId(), payNotifyReqVO, Integer.valueOf(1));
                if (!response.isSuccess()) {
                    BaseOperationDto baseOperationDto = new BaseOperationDto();
                    baseOperationDto.setContent("\u652f\u4ed8his\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                    baseOperationDto.setMainId(drugOrderEntity.getMainId());
                    baseOperationDto.setOprationUser("system");
                    this.applyRefund(baseOperationDto);
                }
            }
            catch (Exception e) {
                log.error("\u5f02\u6b65\u8c03\u7528 hisPayPressNew \u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }, this.executor);
        return presRoamProcessService.orderNotify(payNotifyReqVO, drugOrderEntity, drugMainEntity);
    }

    private void savePayBill(PayNotifyReqVO payNotifyReqVO, DrugOrderEntity drugOrderEntity, DrugMainEntity drugMainEntity) {
        log.info("========payNotifyReqVO:{},drugOrderEntity:{},drugMainEntity:{}", new Object[]{JSON.toJSONString((Object)payNotifyReqVO), JSON.toJSONString((Object)drugOrderEntity), JSON.toJSONString((Object)drugMainEntity)});
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setAppCode(drugMainEntity.getPresOrgan());
        servicePayBillEntity.setApplyCode("");
        servicePayBillEntity.setDealAmount(payNotifyReqVO.getTotalAmount());
        servicePayBillEntity.setDealTradeNo(payNotifyReqVO.getDealTradeNo());
        servicePayBillEntity.setGoodsInfo("\u4e92\u8054\u7f51\u8bca\u7597-\u95e8\u8bca\u8d39");
        servicePayBillEntity.setOrderAmount(payNotifyReqVO.getTotalAmount());
        servicePayBillEntity.setOrganId(drugMainEntity.getOrganId());
        servicePayBillEntity.setOutTradeNo(drugOrderEntity.getOrderSeq());
        servicePayBillEntity.setPayChannel(payNotifyReqVO.getPayChannel());
        String firstLettersUp = HanyuPinyinUtil.getFirstLettersUp((String)drugMainEntity.getPresOrganName());
        log.info("\u533b\u9662\u9996\u5b57\u6bcd\u5927\u5199:{}", (Object)firstLettersUp);
        servicePayBillEntity.setServiceCode(drugMainEntity.getPresOrgan() + "_" + firstLettersUp + "_" + "yyy");
        servicePayBillEntity.setOrganName(drugMainEntity.getHospitalNameFirstLetter());
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(drugMainEntity.getPresOrgan(), MerchantTypeEnum.DRUG.getValue());
        log.info("=====merchantConfigEntity:{}", (Object)JSON.toJSONString((Object)merchantConfigEntity));
        if (Objects.nonNull(merchantConfigEntity)) {
            servicePayBillEntity.setApplyCode(merchantConfigEntity.getMerchantSeq());
        }
        if (payNotifyReqVO.getReturnCode().equalsIgnoreCase(PayStatusEnum.SUCCESS.getValue())) {
            servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.PAID.getValue());
        } else {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.PAID_FAIL.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.FAIL.getValue());
        }
        servicePayBillEntity.setTradeNo(payNotifyReqVO.getTradeNo());
        servicePayBillEntity.setTradeTime(payNotifyReqVO.getPayTime());
        servicePayBillEntity.setWorkServiceCode("yyy");
        log.info("\u836f\u54c1\u652f\u4ed8\u56de\u8c03\u4fdd\u5b58\u8d26\u5355\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.save(servicePayBillEntity);
    }

    public BaseResponse<String> applyRefund(BaseOperationDto baseOperationDto) {
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(baseOperationDto.getMainId());
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByMainIdAndOrderStatus(baseOperationDto.getMainId(), OrderStatusEnum.PAID.getValue());
        if (drugMainEntity == null || drugOrderEntity == null) {
            return BaseResponse.error((String)"\u6b64\u5904\u65b9\u4e0d\u5b58\u5728\u6216\u672a\u652f\u4ed8\u8be5\u5904\u65b9\uff01");
        }
        if (drugMainEntity.getItemStatus() >= DrugMainStatusEnum.SENT.getValue()) {
            return BaseResponse.error((String)"\u5f53\u524d\u5904\u65b9\u72b6\u6001\u4e0b\u4e0d\u652f\u6301\u9000\u6b3e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (OrderStatusEnum.REFUNDING.getValue().equals(drugOrderEntity.getStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(drugOrderEntity.getStatus())) {
            return BaseResponse.success((Object)"\u6b64\u8ba2\u5355\u6b63\u5728\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        return this.applyPayServerFund(drugMainEntity, drugOrderEntity, baseOperationDto);
    }

    public BaseResponse<String> applyRefundPart(BaseOperationDto baseOperationDto) {
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(baseOperationDto.getMainId());
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderMapper.queryByMainIdAndOrderStatusNew(baseOperationDto.getMainId());
        if (drugMainEntity == null || drugOrderEntity == null) {
            return BaseResponse.error((String)"\u6b64\u5904\u65b9\u4e0d\u5b58\u5728\u6216\u672a\u652f\u4ed8\u8be5\u5904\u65b9\uff01");
        }
        if (drugMainEntity.getItemStatus() >= DrugMainStatusEnum.SENT.getValue()) {
            return BaseResponse.error((String)"\u5f53\u524d\u5904\u65b9\u72b6\u6001\u4e0b\u4e0d\u652f\u6301\u9000\u6b3e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (OrderStatusEnum.REFUNDING.getValue().equals(drugOrderEntity.getStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(drugOrderEntity.getStatus())) {
            return BaseResponse.success((Object)"\u6b64\u8ba2\u5355\u6b63\u5728\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        ApplyRefundReq applyRefundReq = new ApplyRefundReq();
        applyRefundReq.setOutTradeNo(drugOrderEntity.getOrderSeq());
        applyRefundReq.setDealTradeNo(drugOrderEntity.getDealSeq());
        applyRefundReq.setMchCode(drugOrderEntity.getMerchantId());
        applyRefundReq.setPayChannel(drugOrderEntity.getPayMethod());
        applyRefundReq.setTotalAmount(drugOrderEntity.getPayAmount());
        Integer presType = drugMainEntity.getPresType();
        if (presType == 5 || presType == 6 || presType == 7) {
            List detailEntities = this.mosInspectionDetailMapper.selectListByTypeAndMainId(null, drugOrderEntity.getMainId());
            if (CollectionUtils.isEmpty((Collection)detailEntities)) {
                return BaseResponse.error((String)"\u627e\u4e0d\u5230\u68c0\u67e5\u68c0\u9a8c\u6cbb\u7597\u9879\u76ee\u8be6\u7ec6\u4fe1\u606f!");
            }
        } else {
            List drugDetailEntityList = this.drugDetailService.listByMainId(drugOrderEntity.getMainId());
            if (CollectionUtils.isEmpty((Collection)drugDetailEntityList)) {
                return BaseResponse.error((String)"\u627e\u4e0d\u5230\u836f\u54c1\u8be6\u7ec6\u4fe1\u606f!");
            }
        }
        BigDecimal refundFee = BigDecimal.ZERO;
        refundFee = drugOrderEntity.getPayAmount().setScale(2, RoundingMode.HALF_UP);
        if (baseOperationDto.getAmount() != null) {
            refundFee = baseOperationDto.getAmount().setScale(2, RoundingMode.HALF_UP);
        }
        applyRefundReq.setRefundAmount(refundFee);
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(drugMainEntity.getPresOrgan(), MerchantTypeEnum.DRUG.getValue());
        applyRefundReq.setApplyCode(merchantConfigEntity.getMerchantSeq());
        applyRefundReq.setNonceStr(SignUtil.getNonceStr());
        applyRefundReq.setRefundNotifyUrl(this.nodeConfig.getAddress() + "/GNYFY/medicalcloud/api/order/pay/v1/refundPart");
        Map paramMap = SignUtil.getKeyAndValue((Object)applyRefundReq);
        String sign = SignUtil.createSign((Map)paramMap, (String)merchantConfigEntity.getApplyKey(), (String[])new String[0]);
        applyRefundReq.setSign(sign);
        String url = this.nodeConfig.getPaySite() + "/trade/refund";
        log.info("\u8bf7\u6c42\u9000\u6b3e\u7684url\u662f:{}======\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)applyRefundReq));
        try {
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)applyRefundReq), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u90e8\u5206\u9000\u6b3e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)respStr);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSON.parseObject((String)respStr).getString("code"))) {
                drugOrderEntity.setStatus(OrderStatusEnum.REFUNDING.getValue());
                this.drugOrderService.update(drugOrderEntity);
                DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
                drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
                drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugRemarkEntity.setRemarkContent(baseOperationDto.getContent());
                drugRemarkEntity.setMainId(baseOperationDto.getMainId());
                drugRemarkEntity.setRemarkType(RemarkTypeEnum.REFUND.getValue());
                drugRemarkEntity.setRemarkUser(baseOperationDto.getOprationUser());
                drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.mosDrugRemarkService.insert(drugRemarkEntity);
                ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.PAID.getValue());
                servicePayBillEntity.setTradeTime(null);
                servicePayBillEntity.setId(null);
                servicePayBillEntity.setWorkServiceCode("yyy");
                servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDING.getValue());
                servicePayBillEntity.setCreateTime(new Date());
                servicePayBillEntity.setUpdateTime(new Date());
                servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDING.getValue());
                log.info("\u5bf9\u8d26\u5e73\u53f0\u5e73\u8d26\u63a5\u53e3\u9000\u6b3e\u4fdd\u5b58\u8d26\u5355:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
                this.servicePayBillService.save(servicePayBillEntity);
                return BaseResponse.success((Object)"\u63d0\u4ea4\u9000\u6b3e\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u884c\u5fae\u4fe1\u9000\u6b3e..");
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u7533\u8bf7\u9000\u6b3e\u5f02\u5e38");
        }
    }

    private BaseResponse<String> applyPayServerFund(DrugMainEntity drugMainEntity, DrugOrderEntity drugOrderEntity, BaseOperationDto baseOperationDto) {
        ApplyRefundReq applyRefundReq = new ApplyRefundReq();
        applyRefundReq.setOutTradeNo(drugOrderEntity.getOrderSeq());
        applyRefundReq.setDealTradeNo(drugOrderEntity.getDealSeq());
        applyRefundReq.setMchCode(drugOrderEntity.getMerchantId());
        applyRefundReq.setPayChannel(drugOrderEntity.getPayMethod());
        applyRefundReq.setTotalAmount(drugOrderEntity.getPayAmount());
        Integer presType = drugMainEntity.getPresType();
        if (presType == 5 || presType == 6 || presType == 7) {
            List detailEntities = this.mosInspectionDetailMapper.selectListByTypeAndMainId(null, drugOrderEntity.getMainId());
            if (CollectionUtils.isEmpty((Collection)detailEntities)) {
                return BaseResponse.error((String)"\u627e\u4e0d\u5230\u68c0\u67e5\u68c0\u9a8c\u6cbb\u7597\u9879\u76ee\u8be6\u7ec6\u4fe1\u606f!");
            }
        } else {
            List drugDetailEntityList = this.drugDetailService.listByMainId(drugOrderEntity.getMainId());
            if (CollectionUtils.isEmpty((Collection)drugDetailEntityList)) {
                return BaseResponse.error((String)"\u627e\u4e0d\u5230\u836f\u54c1\u8be6\u7ec6\u4fe1\u606f!");
            }
        }
        BigDecimal refundFee = BigDecimal.ZERO;
        refundFee = drugOrderEntity.getPayAmount().setScale(2, RoundingMode.HALF_UP);
        applyRefundReq.setRefundAmount(refundFee);
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(drugMainEntity.getPresOrgan(), MerchantTypeEnum.DRUG.getValue());
        log.info("====merchantConfigEntity:{}", (Object)JSON.toJSONString((Object)merchantConfigEntity));
        applyRefundReq.setApplyCode(merchantConfigEntity.getMerchantSeq());
        applyRefundReq.setNonceStr(SignUtil.getNonceStr());
        applyRefundReq.setRefundNotifyUrl(this.nodeConfig.getAddress() + "/GNYFY/medicalcloud/api/order/pay/v1/refund");
        Map paramMap = SignUtil.getKeyAndValue((Object)applyRefundReq);
        String sign = SignUtil.createSign((Map)paramMap, (String)merchantConfigEntity.getApplyKey(), (String[])new String[0]);
        applyRefundReq.setSign(sign);
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/refund").toString();
        log.info("\u8bf7\u6c42\u9000\u6b3e\u7684url\u662f:{}======\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)applyRefundReq));
        try {
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)applyRefundReq), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u9000\u6b3e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)respStr);
            if (ReturnCodeEnum.SUCCEED.getValue().equals(JSON.parseObject((String)respStr).getString("code"))) {
                drugOrderEntity.setStatus(OrderStatusEnum.REFUNDING.getValue());
                this.drugOrderService.update(drugOrderEntity);
                DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
                drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
                drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugRemarkEntity.setRemarkContent(baseOperationDto.getContent());
                drugRemarkEntity.setMainId(baseOperationDto.getMainId());
                drugRemarkEntity.setRemarkType(RemarkTypeEnum.REFUND.getValue());
                drugRemarkEntity.setRemarkUser(baseOperationDto.getOprationUser());
                drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.mosDrugRemarkService.insert(drugRemarkEntity);
                ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.PAID.getValue());
                servicePayBillEntity.setTradeTime(null);
                servicePayBillEntity.setId(null);
                servicePayBillEntity.setWorkServiceCode("yyy");
                servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDING.getValue());
                log.info("\u5bf9\u8d26\u5e73\u53f0\u5e73\u8d26\u63a5\u53e3\u9000\u6b3e\u4fdd\u5b58\u8d26\u5355:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
                this.servicePayBillService.save(servicePayBillEntity);
                return BaseResponse.success((Object)"\u63d0\u4ea4\u9000\u6b3e\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u884c\u5fae\u4fe1\u9000\u6b3e..");
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u7533\u8bf7\u9000\u6b3e\u5f02\u5e38");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> refundNotify(RefundCallBackReqVo refundNotifyReqVO) {
        if (!this.checkApplyKey(refundNotifyReqVO)) {
            return BaseResponse.error((String)"\u9a8c\u7b7e\u672a\u901a\u8fc7");
        }
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByOrderSeq(refundNotifyReqVO.getOutTradeNo());
        if (Objects.isNull(drugOrderEntity)) {
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        ServicePayBillEntity one = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.REFUNDED.getValue());
        if (Objects.nonNull(one)) {
            return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.REFUNDING.getValue());
        if (PayStatusEnum.SUCCESS.getValue().equalsIgnoreCase(refundNotifyReqVO.getReturnCode())) {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
        } else {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED_FAIL.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.FAIL.getValue());
        }
        servicePayBillEntity.setRefundNo(refundNotifyReqVO.getRefundNo());
        servicePayBillEntity.setRefundTime(refundNotifyReqVO.getRefundTime());
        servicePayBillEntity.setRefundAmount(refundNotifyReqVO.getRefundMoney());
        servicePayBillEntity.setOutRefundNo(refundNotifyReqVO.getOutTradeNo());
        log.info("\u836f\u54c1\u9000\u6b3e\u56de\u8c03\u63a5\u53e3\u66f4\u65b0\u8d26\u5355\u4fe1\u606f\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.update(servicePayBillEntity);
        drugOrderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
        drugOrderEntity.setRefundTime(refundNotifyReqVO.getRefundTime());
        this.drugOrderService.update(drugOrderEntity);
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(drugOrderEntity.getMainId());
        String processCode = this.presRoamProcessRegService.getProcessCodeByAppCodeOrHospitalNameFirstLetter(drugMainEntity.getPresOrgan(), drugMainEntity.getHospitalNameFirstLetter());
        PresRoamProcessService presRoamProcessService = PresRoamProcessStrategyFactory.getPresRoamProcessStrategy((String)processCode);
        drugMainEntity.setRefundStatus(OrderStatusEnum.REFUNDED.getValue());
        presRoamProcessService.refundNotify(drugMainEntity, refundNotifyReqVO);
        if (DrugMainStatusEnum.APPROVING.getValue().equals(drugMainEntity.getItemStatus())) {
            this.drugMainService.saveDrugExtend(drugMainEntity.getxId(), "", "", "", "\u5904\u65b9\u5f85\u5ba1\u6838\u72b6\u6001\u65f6\u9000\u6b3e\u4e86", AuditStatusEnum.FAIL_STATUS.getValue());
        }
        drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
        this.drugMainService.update(drugMainEntity);
        log.info("======\u8ba2\u5355:{}\u9000\u6b3e\u6210\u529f\uff0c\u8ba2\u5355\u72b6\u6001\u4fee\u6539\u6210\u529f", (Object)refundNotifyReqVO.getOutTradeNo());
        return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> refundNotifyPart(RefundCallBackReqVo refundNotifyReqVO) {
        List payBillList;
        if (!this.checkApplyKey(refundNotifyReqVO)) {
            return BaseResponse.error((String)"\u9a8c\u7b7e\u672a\u901a\u8fc7");
        }
        DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByOrderSeq(refundNotifyReqVO.getOutTradeNo());
        if (Objects.isNull(drugOrderEntity)) {
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillService.selectByOutTradeNoAndStatus(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.REFUNDING.getValue());
        if (Objects.isNull(servicePayBillEntity)) {
            return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        if (PayStatusEnum.SUCCESS.getValue().equalsIgnoreCase(refundNotifyReqVO.getReturnCode())) {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.SUCCESS.getValue());
        } else {
            servicePayBillEntity.setStatus(PayBillOrderStatusEnum.REFUNDED_FAIL.getValue());
            servicePayBillEntity.setTradeStatus(PayStatusEnum.FAIL.getValue());
        }
        servicePayBillEntity.setRefundNo(refundNotifyReqVO.getRefundNo());
        servicePayBillEntity.setRefundTime(refundNotifyReqVO.getRefundTime());
        servicePayBillEntity.setRefundAmount(refundNotifyReqVO.getRefundMoney());
        servicePayBillEntity.setOutRefundNo(refundNotifyReqVO.getOutTradeNo());
        log.info("\u90e8\u5206\u9000\u6b3e\u56de\u8c03\u63a5\u53e3\u66f4\u65b0\u8d26\u5355\u4fe1\u606f\u8ba2\u5355\u72b6\u6001:{}", (Object)JSON.toJSONString((Object)servicePayBillEntity));
        this.servicePayBillService.update(servicePayBillEntity);
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(drugOrderEntity.getMainId());
        String processCode = this.presRoamProcessRegService.getProcessCodeByAppCodeOrHospitalNameFirstLetter(drugMainEntity.getPresOrgan(), drugMainEntity.getHospitalNameFirstLetter());
        PresRoamProcessService presRoamProcessService = PresRoamProcessStrategyFactory.getPresRoamProcessStrategy((String)processCode);
        drugMainEntity.setRefundStatus(OrderStatusEnum.REFUNDED.getValue());
        presRoamProcessService.refundNotify(drugMainEntity, refundNotifyReqVO);
        if (DrugMainStatusEnum.APPROVING.getValue().equals(drugMainEntity.getItemStatus())) {
            this.drugMainService.saveDrugExtend(drugMainEntity.getxId(), "", "", "", "\u5904\u65b9\u5f85\u5ba1\u6838\u72b6\u6001\u65f6\u9000\u6b3e\u4e86", AuditStatusEnum.FAIL_STATUS.getValue());
        }
        if (!(payBillList = this.servicePayBillService.selectByOutTradeNoAndStatusList(drugOrderEntity.getOrderSeq(), PayBillOrderStatusEnum.REFUNDED.getValue())).isEmpty()) {
            BigDecimal totalRefundAmount = payBillList.stream().map(ServicePayBillEntity::getRefundAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (drugOrderEntity.getPayAmount().compareTo(totalRefundAmount) == 0) {
                drugOrderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
                drugOrderEntity.setRefundTime(refundNotifyReqVO.getRefundTime());
                this.drugOrderService.update(drugOrderEntity);
                drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
                this.drugMainService.update(drugMainEntity);
            } else {
                drugOrderEntity.setStatus(OrderStatusEnum.REFUNDED_PART.getValue());
                drugOrderEntity.setRefundTime(refundNotifyReqVO.getRefundTime());
                this.drugOrderService.update(drugOrderEntity);
            }
            String hisDetailNo = this.redisUtil.get("refund_part_:" + servicePayBillEntity.getTradeNo()).toString();
            ArrayList<String> presDetailNoList = new ArrayList<String>(Arrays.asList(hisDetailNo.split(",")));
            if (drugMainEntity.getPresType() == 5 || drugMainEntity.getPresType() == 6 || drugMainEntity.getPresType() == 7) {
                presDetailNoList.forEach(item -> {
                    MosInspectionDetailEntity detailEntity = this.mosInspectionDetailMapper.selectByHisDetailNo(item);
                    if (detailEntity != null) {
                        detailEntity.setIsRefund(Integer.valueOf(1));
                        this.mosInspectionDetailMapper.update(detailEntity);
                    }
                });
            } else {
                presDetailNoList.forEach(item -> {
                    DrugDetailEntity detailEntity = this.drugDetailService.selectByHisDetailNo(item);
                    if (detailEntity != null) {
                        detailEntity.setIsRefund(Integer.valueOf(1));
                        this.drugDetailService.updateById(detailEntity);
                    }
                });
            }
            this.redisUtil.del(new String[]{"refund_part_:" + servicePayBillEntity.getTradeNo()});
        }
        log.info("======\u8ba2\u5355:{}\u90e8\u5206\u9000\u6b3e\u6210\u529f\uff0c\u8ba2\u5355\u72b6\u6001\u4fee\u6539\u6210\u529f", (Object)refundNotifyReqVO.getOutTradeNo());
        return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
    }

    private boolean checkApplyKey(RefundCallBackReqVo refundNotifyReqVO) {
        String applyKey = this.merchantConfigMapper.queryApplyKeyByApplyId(refundNotifyReqVO.getApplyId());
        Map keyAndValue = SignUtil.getKeyAndValue((Object)refundNotifyReqVO);
        return SignUtil.checkSign((Map)keyAndValue, (String)applyKey);
    }

    public BaseResponse<List<ReconciliationVO>> queryReconciliationData(String date, String organCode) {
        organCode = AppCodeUtil.tranCode((String)organCode);
        List list = this.drugOrderService.queryReconciliationData(date, organCode);
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<String> flatAccount(FlatAccountReq flatAccountReq) {
        if (FlatAccountTypeEnum.REFUND_TYPE.getValue().equals(flatAccountReq.getType().toString())) {
            DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByBankTradeNo(flatAccountReq.getValue());
            if (drugOrderEntity == null) {
                return BaseResponse.error((String)"\u65e0\u6b64\u8ba2\u5355\uff0c\u8bf7\u6838\u5bf9\u7b2c\u4e09\u65b9\u6d41\u6c34\u53f7\u662f\u5426\u6b63\u786e");
            }
            if (OrderStatusEnum.TOPAY.getValue().equals(drugOrderEntity.getStatus())) {
                return BaseResponse.error((String)"\u6b64\u8ba2\u5355\u672a\u652f\u4ed8\u4e0d\u80fd\u8fdb\u884c\u9000\u6b3e");
            }
            if (OrderStatusEnum.REFUNDED.getValue().equals(drugOrderEntity.getStatus()) && OrderStatusEnum.REFUNDING.getValue().equals(drugOrderEntity.getStatus())) {
                return BaseResponse.error((String)"\u6b64\u8ba2\u5355\u5df2\u9000\u6b3e\u6216\u6b63\u5728\u9000\u6b3e\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u9000\u6b3e");
            }
            DrugMainEntity drugMainEntity = this.drugMainService.queryById(drugOrderEntity.getMainId());
            BaseOperationDto baseOperationDto = new BaseOperationDto();
            baseOperationDto.setOprationUser("system");
            baseOperationDto.setMainId(drugMainEntity.getxId());
            baseOperationDto.setContent("\u5bf9\u8d26\u5e73\u53f0\u5e73\u8d26\u9000\u6b3e");
            BaseResponse stringBaseResponse = this.applyPayServerFund(drugMainEntity, drugOrderEntity, baseOperationDto);
            if (ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(stringBaseResponse.getCode())) {
                return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
            }
        } else {
            DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByDealSeq(flatAccountReq.getDealSeq());
            if (drugOrderEntity == null) {
                return BaseResponse.error((String)"\u4e0d\u5b58\u5728\u6b64\u8ba2\u5355\uff0c\u8bf7\u68c0\u67e5\u652f\u4ed8\u7cfb\u7edf\u8ba2\u5355\u7f16\u53f7");
            }
            if (FlatAccountTypeEnum.PAY_SUCCESS.getValue().equalsIgnoreCase(flatAccountReq.getValue())) {
                if (OrderStatusEnum.PAID.getValue().equals(drugOrderEntity.getStatus())) {
                    return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
                }
                if (StringUtil.isEmpty((String)flatAccountReq.getBankTradeNo()) || StringUtil.isEmpty((String)flatAccountReq.getDealSeq()) || StringUtil.isEmpty((String)flatAccountReq.getPayTime()) || StringUtil.isEmpty((String)flatAccountReq.getMchId())) {
                    return BaseResponse.error((String)"\u4fee\u6539\u4e3a\u652f\u4ed8\u72b6\u6001\u5fc5\u8981\u6761\u4ef6\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5");
                }
                drugOrderEntity.setMchId(flatAccountReq.getMchId());
                drugOrderEntity.setBankTradeNo(flatAccountReq.getBankTradeNo());
                drugOrderEntity.setDealSeq(flatAccountReq.getDealSeq());
                drugOrderEntity.setPayTime(DateTimeUtil.parseTime((String)flatAccountReq.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                drugOrderEntity.setStatus(OrderStatusEnum.PAID.getValue());
                this.drugOrderService.update(drugOrderEntity);
                return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
            }
            if (OrderStatusEnum.REFUNDING.getValue().equals(drugOrderEntity.getStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(drugOrderEntity.getStatus())) {
                return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
            }
            drugOrderEntity.setRefundTime(DateTimeUtil.parseTime((String)flatAccountReq.getRefundTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            drugOrderEntity.setxRemark("\u5bf9\u8d26\u5e73\u53f0\u5e73\u8d26\u9000\u6b3e");
            drugOrderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
            this.drugOrderService.update(drugOrderEntity);
            return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        return BaseResponse.error((String)"\u5e73\u8d26\u5931\u8d25");
    }

    public BaseResponse<JSONObject> createTradeServer(PayReqVO payReqVO) {
        log.info("=====payReqVO========:{}", (Object)JSON.toJSONString((Object)payReqVO));
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/create-order").toString();
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(payReqVO.getMainId());
        log.info("=====drugMainEntity======:{}", (Object)JSON.toJSONString((Object)drugMainEntity));
        CreateOrderDto createOrderDto = new CreateOrderDto();
        createOrderDto.setPayChannel(payReqVO.getPayChannel());
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(payReqVO.getPayChannel())) {
            createOrderDto.setUserSign(payReqVO.getOpenId());
            createOrderDto.setPayType("JSAPI");
        } else {
            createOrderDto.setPayType("APP");
        }
        createOrderDto.setMchCode(payReqVO.getMerchantId());
        createOrderDto.setPayChannel(payReqVO.getPayMethod());
        createOrderDto.setApplyCode(payReqVO.getMerchantId());
        createOrderDto.setOutTradeNo(payReqVO.getOrderSeq());
        createOrderDto.setTotalAmount(payReqVO.getPayAmount());
        createOrderDto.setActuallyAmount(payReqVO.getPayAmount());
        createOrderDto.setProductInfo(payReqVO.getProductInfo());
        String firstLettersUp = HanyuPinyinUtil.getFirstLettersUp((String)drugMainEntity.getPresOrganName());
        log.info("=======\u533b\u9662\u9996\u5b57\u6bcd======:{}", (Object)firstLettersUp);
        createOrderDto.setServiceCode(drugMainEntity.getPresOrgan() + "_" + firstLettersUp + "_" + "yyy");
        createOrderDto.setNonceStr(SignUtil.getNonceStr());
        if (MerchantTypeEnum.DRUG.getValue().equals(payReqVO.getMerchantType())) {
            createOrderDto.setPayNotifyUrl(this.nodeConfig.getAddress() + "/GNYFY/medicalcloud/api/order/pay/v1/notifyurl");
            createOrderDto.setProductInfo("\u4e92\u8054\u7f51\u533b\u7597-\u95e8\u8bca\u7f34\u8d39");
        } else {
            createOrderDto.setPayNotifyUrl(this.nodeConfig.getAddress() + "/GNYFY/medicalcloud/api/order/pay/v1/logistics/payCall");
            createOrderDto.setProductInfo("\u836f\u54c1\u914d\u9001\u8d39");
        }
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(drugMainEntity.getPresOrgan(), payReqVO.getMerchantType());
        log.info("====merchantConfigEntity======:{}", (Object)JSON.toJSONString((Object)merchantConfigEntity));
        if (Objects.isNull(merchantConfigEntity)) {
            return BaseResponse.error((String)"\u8bf7\u68c0\u67e5\u652f\u4ed8\u914d\u7f6e");
        }
        Map paramMap = SignUtil.getKeyAndValue((Object)createOrderDto);
        String sign = SignUtil.createSign((Map)paramMap, (String)merchantConfigEntity.getApplyKey(), (String[])new String[0]);
        createOrderDto.setSign(sign);
        try {
            log.info("=======>\u8bf7\u6c42\u9884\u652f\u4ed8--->url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)createOrderDto));
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)createOrderDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("======>\u8bf7\u6c42\u9884\u652f\u4ed8\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            String code = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getJSONObject("data") != null) {
                return BaseResponse.success((Object)JSON.parseObject((String)respStr).getJSONObject("data"));
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error("\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public RefundResVo applyRefundServer(RefundReqVO vo) {
        String organCode;
        log.info("=======vo:{}", (Object)JSON.toJSONString((Object)vo));
        ApplyRefundReq applyRefundReq = new ApplyRefundReq();
        applyRefundReq.setOutTradeNo(vo.getOrderSeq());
        applyRefundReq.setDealTradeNo(vo.getDealSeq());
        applyRefundReq.setMchCode(vo.getMerchantId());
        applyRefundReq.setPayChannel(vo.getPayMethod());
        applyRefundReq.setTotalAmount(vo.getPayAmount());
        applyRefundReq.setRefundAmount(vo.getPayAmount().setScale(2, RoundingMode.HALF_UP));
        if (MerchantTypeEnum.DRUG.getValue().equals(vo.getMerchantType())) {
            DrugOrderEntity drugOrderEntity = this.drugOrderService.queryByDealSeq(vo.getDealSeq());
            organCode = drugOrderEntity.getOrganCode();
        } else {
            MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.queryDrugLogisticsOrderByDealSeq(vo.getDealSeq());
            organCode = mosDrugLogisticsOrderEntity.getAppCode();
        }
        log.info("=========organCode:{}", (Object)organCode);
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigService.queryByOrganCodeAndMerchantType(organCode, vo.getMerchantType());
        log.info("=====merchantConfigEntity:{}", (Object)JSON.toJSONString((Object)merchantConfigEntity));
        applyRefundReq.setApplyCode(merchantConfigEntity.getMerchantSeq());
        applyRefundReq.setNonceStr(SignUtil.getNonceStr());
        applyRefundReq.setRefundNotifyUrl("/GNYFY/medicalcloud/api/order/pay/v1/refund");
        applyRefundReq.setApplyCode(vo.getMerchantId());
        if (MerchantTypeEnum.DRUG.getValue().equals(vo.getMerchantType())) {
            applyRefundReq.setRefundNotifyUrl(this.nodeConfig.getAddress() + "/GNYFY/medicalcloud/api/order/pay/v1/refund");
        } else {
            applyRefundReq.setRefundNotifyUrl(this.nodeConfig.getAddress() + "/GNYFY/medicalcloud/api/order/pay/v1/refund/logistics");
        }
        Map paramMap = SignUtil.getKeyAndValue((Object)applyRefundReq);
        String sign = SignUtil.createSign((Map)paramMap, (String)merchantConfigEntity.getApplyKey(), (String[])new String[0]);
        applyRefundReq.setSign(sign);
        String url = new StringBuffer(this.nodeConfig.getPaySite()).append("/trade/refund").toString();
        try {
            log.info("=======>\u8bf7\u6c42\u9000\u6b3e\u7684url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)applyRefundReq));
            String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)applyRefundReq), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======>\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) {
                if (ReturnCodeEnum.SUCCEED.getValue().equals(JSON.parseObject((String)result).getString("code"))) {
                    return new RefundResVo(true, null);
                }
                return new RefundResVo(false, JSON.parseObject((String)result).getString("msg"));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u7533\u8bf7\u9000\u6b3e\u5f02\u5e38");
        }
        return new RefundResVo(false, "\u7cfb\u7edf\u5f02\u5e38");
    }
}

