/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.medicalcloud.pojo.vo.push.MedicalMoveMainCommonVO;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushMainPrescriptionErrorReceiver {
    private static final Logger log = LoggerFactory.getLogger(PushMainPrescriptionErrorReceiver.class);
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Autowired
    private RedisUtil redisUtil;

    @RabbitListener(queues={"prescription.push.main.error.test"})
    @RabbitHandler
    public void process(String mainInfo) {
        log.info("\u63a8\u9001\u5904\u65b9\u6d41\u8f6c\u5e73\u53f0\u5931\u8d25\u3001\u5f00\u59cb\u6d88\u8d39\u961f\u5217\u3001\u961f\u5217\u6d88\u8d39\u5185\u5bb9\u4e3a{}: ", (Object)mainInfo);
        if (StringUtils.isEmpty((String)mainInfo)) {
            log.info("\u961f\u5217\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        log.info("\u5f00\u59cb\u4eceredis\u4e2d\u83b7\u53d6\uff0ckey\u4e3a{}", (Object)mainInfo);
        String voString = (String)this.redisUtil.get(mainInfo);
        if (StringUtils.isEmpty((String)voString)) {
            log.info("\u7f13\u5b58\u4e2d\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        MedicalMoveMainCommonVO medicalMoveMainCommonVO = (MedicalMoveMainCommonVO)JSON.parseObject((String)voString, MedicalMoveMainCommonVO.class);
        if (Objects.isNull(medicalMoveMainCommonVO)) {
            log.info("\u7f13\u5b58\u4e2d\u653e\u7f6e\u7684\u5bf9\u8c61JSON\u683c\u5f0f\u4e0d\u5bf9");
            this.redisUtil.del(new String[]{mainInfo});
            return;
        }
        try {
            log.info("\u5f00\u59cb\u8bf7\u6c42\u91cd\u65b0\u63a8\u9001\u903b\u8f91,\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)medicalMoveMainCommonVO));
            this.mosDrugPrescriptionService.retryPushMain(medicalMoveMainCommonVO);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u63a8\u9001\u5904\u65b9\u4e1a\u52a1\u903b\u8f91\u53d1\u751f\u9519\u8bef\uff1a", (Throwable)e);
            return;
        }
        log.info("mq\u6d88\u606f\u6d88\u8d39\u5b8c\u6bd5\uff0c\u5904\u65b9\u63a8\u9001\u6210\u529f~");
    }
}

