/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.medicalcloud.common.enums.ApprovalBelongEnum;
import com.ebaiyihui.medicalcloud.common.enums.ApprovalStatusEnum;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.PatientInfoRemoteManage;
import com.ebaiyihui.medicalcloud.mapper.DualChannelApprovalMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DualChannelApprovalInfoEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientInfoRespVO;
import com.ebaiyihui.medicalcloud.pojo.vo.dualChannel.DualChannelApprovalCountVo;
import com.ebaiyihui.medicalcloud.pojo.vo.dualChannel.DualChannelApprovalInfoPdfVo;
import com.ebaiyihui.medicalcloud.pojo.vo.dualChannel.DualChannelApprovalInfoVo;
import com.ebaiyihui.medicalcloud.pojo.vo.dualChannel.DualChannelApprovalListVo;
import com.ebaiyihui.medicalcloud.pojo.vo.dualChannel.DualChannelApprovalQueryInfoVo;
import com.ebaiyihui.medicalcloud.pojo.vo.dualChannel.DualChannelDoctorApprovalVo;
import com.ebaiyihui.medicalcloud.pojo.vo.dualChannel.DualChannelManagerApprovalVo;
import com.ebaiyihui.medicalcloud.pojo.vo.dualChannel.DualChannelPatientApprovalVo;
import com.ebaiyihui.medicalcloud.service.DualChannelApprovalService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.utils.OSSClientUtil;
import com.ebaiyihui.medicalcloud.utils.PdfUtil;
import com.ebaiyihui.medicalcloud.utils.RandomUtils;
import com.ebaiyihui.medicalcloud.utils.id.SnowflakeIdWorker;
import com.github.pagehelper.PageHelper;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class DualChannelApprovalServiceImpl
implements DualChannelApprovalService {
    private static final Logger log = LoggerFactory.getLogger(DualChannelApprovalServiceImpl.class);
    private static final Integer AGREE = 1;
    public static final String PDF_PRIFIX = "byh-approval-";
    public static final String BASE_PATH = "yyy/prescription/template/";
    public static final String TEMPLATE_NAME = "gn-std-info-pdf.html";
    public static final String GET_YB_URL = "https://ihos.chinachdu.com/medicare/cz/medicalBusiness/getYbPatientInfo";
    @Autowired
    private DualChannelApprovalMapper dualChannelApprovalMapper;
    @Autowired
    private PatientInfoRemoteManage patientInfoRemoteManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> patientSubmit(DualChannelPatientApprovalVo vo) {
        log.info("\u60a3\u8005\u63d0\u4ea4\u5ba1\u6838\u4f20\u5165\u53c2\u6570\uff1a{}", (Object)vo);
        DoctorEntityInfoVO doctorDetail = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(vo.getDoctorId().trim())));
        if (ObjectUtils.isEmpty((Object)doctorDetail)) {
            return BaseResponse.error((String)"\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        PatientInfoRespVO patientInfo = this.patientInfoRemoteManage.getPatientInfoById(Long.valueOf(Long.parseLong(vo.getPatientId().trim())), vo.getAppCode(), doctorDetail.getOrganId().toString());
        if (ObjectUtils.isEmpty((Object)patientInfo)) {
            return BaseResponse.error((String)"\u60a3\u8005\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        String medicalInsuranceCardNumber = null;
        try {
            medicalInsuranceCardNumber = this.getYBNo(patientInfo.getCredNo());
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)"\u533b\u4fdd\u5361\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        DualChannelApprovalInfoEntity infoEntity = new DualChannelApprovalInfoEntity();
        BeanUtils.copyProperties((Object)vo, (Object)infoEntity);
        infoEntity.setPatientIdCard(patientInfo.getCredNo());
        infoEntity.setPatientPhone(patientInfo.getContactMobile());
        infoEntity.setMedicalInsuranceCardNumber(medicalInsuranceCardNumber);
        infoEntity.setDoctorDept(doctorDetail.getHospitalDeptName());
        String id = String.valueOf(SnowflakeIdWorker.nextId());
        infoEntity.setxId(id);
        infoEntity.setStatus(ApprovalStatusEnum.Doctor_Reviewing.getValue());
        this.dualChannelApprovalMapper.insert(infoEntity);
        if (!CollectionUtils.isEmpty((Collection)vo.getOtherInfo())) {
            this.dualChannelApprovalMapper.saveBatchPhotos(id, vo.getOtherInfo());
        }
        return BaseResponse.success();
    }

    public BaseResponse<String> doctorSubmit(DualChannelDoctorApprovalVo vo) {
        log.info("\u533b\u751f\u63d0\u4ea4\u5ba1\u6838\u4f20\u5165\u53c2\u6570\uff1a{}", (Object)vo);
        DoctorEntityInfoVO doctorDetail = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(vo.getDoctorId().trim())));
        if (ObjectUtils.isEmpty((Object)doctorDetail)) {
            return BaseResponse.error((String)"\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        DualChannelApprovalInfoEntity entity = this.dualChannelApprovalMapper.getByIdAndAppCode(vo.getXId(), vo.getAppCode());
        if (!ApprovalStatusEnum.Doctor_Reviewing.getValue().equals(entity.getStatus())) {
            return BaseResponse.error((String)"\u5ba1\u6838\u72b6\u6001\u6709\u8bef");
        }
        DualChannelApprovalInfoEntity infoEntity = new DualChannelApprovalInfoEntity();
        if (AGREE.equals(vo.getAgree())) {
            BeanUtils.copyProperties((Object)vo, (Object)infoEntity);
            Date diagnosisTime = DateUtils.parseY_M_DDate((String)vo.getDiagnosisTime());
            Date startTime = DateUtils.parseY_M_DDate((String)vo.getStartTime());
            Date endTime = DateUtils.parseY_M_DDate((String)vo.getEndTime());
            infoEntity.setDoctorSubmitTime(new Date());
            infoEntity.setDiagnosisTime(diagnosisTime);
            infoEntity.setStartTime(startTime);
            infoEntity.setEndTime(endTime);
            infoEntity.setStatus(ApprovalStatusEnum.Medical_Insurance_Department_Reviewing.getValue());
        } else {
            infoEntity.setxId(vo.getXId());
            infoEntity.setStatus(ApprovalStatusEnum.DOCTOR_Review_Failed.getValue());
            infoEntity.setAppCode(vo.getAppCode());
            infoEntity.setxRemark(vo.getXRemark());
        }
        this.dualChannelApprovalMapper.update(infoEntity);
        return BaseResponse.success();
    }

    public BaseResponse<String> managerSubmit(DualChannelManagerApprovalVo vo) {
        log.info("\u533b\u4fdd\u79d1\u63d0\u4ea4\u5ba1\u6838\u4f20\u5165\u53c2\u6570\uff1a{}", (Object)vo);
        DualChannelApprovalInfoEntity entity = this.dualChannelApprovalMapper.getByIdAndAppCode(vo.getXId(), vo.getAppCode());
        if (!ApprovalStatusEnum.Medical_Insurance_Department_Reviewing.getValue().equals(entity.getStatus())) {
            return BaseResponse.error((String)"\u5ba1\u6838\u72b6\u6001\u6709\u8bef");
        }
        DualChannelApprovalInfoEntity infoEntity = new DualChannelApprovalInfoEntity();
        infoEntity.setxId(vo.getXId());
        if (AGREE.equals(vo.getAgree())) {
            infoEntity.setStatus(ApprovalStatusEnum.Medical_Security_Branch_Reviewing.getValue());
            infoEntity.setAppCode(vo.getAppCode());
            infoEntity.setDeptRemark(vo.getRemark());
        } else {
            infoEntity.setStatus(ApprovalStatusEnum.DEPT_Review_Failed.getValue());
            infoEntity.setxRemark(vo.getRemark());
            infoEntity.setAppCode(vo.getAppCode());
        }
        this.dualChannelApprovalMapper.update(infoEntity);
        return BaseResponse.success();
    }

    public BaseResponse<String> medicalInsuranceSubmit(DualChannelManagerApprovalVo vo) {
        log.info("\u533b\u4fdd\u5c40\u63d0\u4ea4\u5ba1\u6838\u4f20\u5165\u53c2\u6570\uff1a{}", (Object)vo);
        DualChannelApprovalInfoEntity entity = this.dualChannelApprovalMapper.getByIdAndAppCode(vo.getXId(), vo.getAppCode());
        if (!ApprovalStatusEnum.Medical_Security_Branch_Reviewing.getValue().equals(entity.getStatus())) {
            return BaseResponse.error((String)"\u5ba1\u6838\u72b6\u6001\u6709\u8bef");
        }
        DualChannelApprovalInfoEntity infoEntity = new DualChannelApprovalInfoEntity();
        infoEntity.setxId(vo.getXId());
        if (AGREE.equals(vo.getAgree())) {
            infoEntity.setStatus(ApprovalStatusEnum.Approved.getValue());
            infoEntity.setRecordRemark(vo.getRemark());
            infoEntity.setTransitTime(new Date());
            infoEntity.setAppCode(vo.getAppCode());
        } else {
            infoEntity.setStatus(ApprovalStatusEnum.DEPT_Review_Failed.getValue());
            infoEntity.setxRemark(vo.getRemark());
            infoEntity.setAppCode(vo.getAppCode());
        }
        this.dualChannelApprovalMapper.update(infoEntity);
        return BaseResponse.success();
    }

    public BaseResponse<PageResult<DualChannelApprovalListVo>> getManagerList(DualChannelApprovalQueryInfoVo param) {
        log.info("\u7ba1\u7406\u7aef\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)param);
        PageResult result = new PageResult();
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        if (!StringUtils.isEmpty((Object)param.getStartTime())) {
            param.setStartTime(param.getStartTime() + " 00:00:00");
        }
        if (!StringUtils.isEmpty((Object)param.getEndTime())) {
            param.setEndTime(param.getEndTime() + " 23:59:59");
        }
        List list = this.dualChannelApprovalMapper.selectPage(param);
        log.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)list);
        result.setPageSize(param.getPageSize());
        result.setPageNum(param.getPageNum());
        result.setContent(list);
        result.setTotal(this.dualChannelApprovalMapper.selectCount(param.getAppCode(), param.getStatus(), param.getStartTime(), param.getEndTime(), param.getName()));
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<DualChannelApprovalCountVo> getCount(DualChannelApprovalQueryInfoVo param) {
        if (!StringUtils.isEmpty((Object)param.getStartTime())) {
            param.setStartTime(param.getStartTime() + " 00:00:00");
        }
        if (!StringUtils.isEmpty((Object)param.getEndTime())) {
            param.setEndTime(param.getEndTime() + " 23:59:59");
        }
        int approved = 0;
        int reviewFailed = 0;
        DualChannelApprovalCountVo vo = new DualChannelApprovalCountVo();
        vo.setTotal(Integer.valueOf(this.dualChannelApprovalMapper.selectCount(param.getAppCode(), param.getStatus(), param.getStartTime(), param.getEndTime(), param.getName())));
        if (ApprovalStatusEnum.DEPT_Review_Failed.getValue().equals(param.getStatus())) {
            reviewFailed = this.dualChannelApprovalMapper.selectCount(param.getAppCode(), ApprovalStatusEnum.DEPT_Review_Failed.getValue(), param.getStartTime(), param.getEndTime(), param.getName());
        } else if (ApprovalStatusEnum.Approved.getValue().equals(param.getStatus())) {
            approved = this.dualChannelApprovalMapper.selectCount(param.getAppCode(), ApprovalStatusEnum.Approved.getValue(), param.getStartTime(), param.getEndTime(), param.getName());
        } else if (ApprovalStatusEnum.ALL_STATUS.getValue().equals(param.getStatus())) {
            approved = this.dualChannelApprovalMapper.selectCount(param.getAppCode(), ApprovalStatusEnum.Approved.getValue(), param.getStartTime(), param.getEndTime(), param.getName());
            reviewFailed = this.dualChannelApprovalMapper.selectCount(param.getAppCode(), ApprovalStatusEnum.DEPT_Review_Failed.getValue(), param.getStartTime(), param.getEndTime(), param.getName());
        }
        vo.setApproved(Integer.valueOf(approved));
        vo.setReviewFailed(Integer.valueOf(reviewFailed));
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<PageResult<DualChannelApprovalListVo>> list(DualChannelApprovalQueryInfoVo param) {
        log.info("\u533b\u60a3\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)param);
        PageResult result = new PageResult();
        PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
        List list = this.dualChannelApprovalMapper.selectList(param);
        log.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)list);
        list.forEach(item -> {
            item.setPatientAge(String.valueOf(IdCardUtil.getAgeByIdCard((String)item.getPatientIdCard())));
            item.setGender(String.valueOf(IdCardUtil.getGenderByIdCard((String)item.getPatientIdCard())));
        });
        result.setPageSize(param.getPageSize());
        result.setPageNum(param.getPageNum());
        result.setContent(list);
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<DualChannelApprovalInfoVo> getDetail(String id, String appCode) {
        log.info("\u67e5\u8be2\u7684\u6750\u6599id\uff1a{}", (Object)id);
        DualChannelApprovalInfoVo vo = new DualChannelApprovalInfoVo();
        DualChannelApprovalInfoEntity infoEntity = this.dualChannelApprovalMapper.getByIdAndAppCode(id, appCode);
        BeanUtils.copyProperties((Object)infoEntity, (Object)vo);
        vo.setBelongName(ApprovalBelongEnum.getDesc((Integer)vo.getBelong()));
        vo.setPatientAge(String.valueOf(IdCardUtil.getAgeByIdCard((String)vo.getPatientIdCard())));
        vo.setGender(String.valueOf(IdCardUtil.getGenderByIdCard((String)vo.getPatientIdCard())));
        List approvalInfoPhotos = this.dualChannelApprovalMapper.getApprovalInfoPhotos(id);
        if (!CollectionUtils.isEmpty((Collection)approvalInfoPhotos)) {
            vo.setOtherPhotos(approvalInfoPhotos);
        }
        log.info("\u67e5\u8be2\u6750\u6599\u8be6\u60c5\uff1a{}", (Object)vo);
        return BaseResponse.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDualChannelExcel(String id, String appCode, HttpServletResponse response) {
        block16: {
            DualChannelApprovalInfoVo dualChannelApprovalInfoVo = null;
            DualChannelApprovalInfoPdfVo detail = new DualChannelApprovalInfoPdfVo();
            BaseResponse baseResponse = this.getDetail(id, appCode);
            if (baseResponse.isSuccess()) {
                dualChannelApprovalInfoVo = (DualChannelApprovalInfoVo)baseResponse.getData();
                if (ObjectUtils.isEmpty((Object)dualChannelApprovalInfoVo)) {
                    log.error("\u67e5\u8be2\u8be6\u60c5\u4e3a\u7a7a");
                } else {
                    BeanUtils.copyProperties((Object)dualChannelApprovalInfoVo, (Object)detail);
                    detail.setCreateTime(DateUtils.getYMD((Date)dualChannelApprovalInfoVo.getXCreateTime()));
                    detail.setDiagnosisTime(DateUtils.getYMD((Date)dualChannelApprovalInfoVo.getDiagnosisTime()));
                    detail.setStartTime(DateUtils.getYMD((Date)dualChannelApprovalInfoVo.getStartTime()));
                    detail.setEndTime(DateUtils.getYMD((Date)dualChannelApprovalInfoVo.getEndTime()));
                }
            } else {
                log.error("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25");
            }
            StringWriter out = new StringWriter();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ServletOutputStream respOut = null;
            try {
                Configuration configuration = new Configuration(Configuration.VERSION_2_3_25);
                StringTemplateLoader stringLoader = new StringTemplateLoader();
                byte[] downloadLocal = OSSClientUtil.downloadLocal((String)"yyy/prescription/template/gn-std-info-pdf.html");
                String templateContent = new String(downloadLocal, StandardCharsets.UTF_8);
                stringLoader.putTemplate("approvalTemplate", templateContent);
                configuration.setTemplateLoader((TemplateLoader)stringLoader);
                Template template = configuration.getTemplate("approvalTemplate", "utf-8");
                HashMap<String, DualChannelApprovalInfoPdfVo> map = new HashMap<String, DualChannelApprovalInfoPdfVo>();
                map.put("detail", detail);
                template.process(map, (Writer)out);
                String doc = out.toString();
                ArrayList<String> docList = new ArrayList<String>();
                String fileName = PDF_PRIFIX + detail.getXId() + RandomUtils.generateRandom((int)6) + ".pdf";
                docList.add(doc);
                boolean genPdf = PdfUtil.genPdf(docList, (OutputStream)os);
                if (genPdf) {
                    response.setCharacterEncoding("UTF-8");
                    response.setHeader("Access-Control-Allow-Origin", "*");
                    response.setHeader("content-Type", "application/pdf");
                    response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
                    respOut = response.getOutputStream();
                    respOut.write(os.toByteArray());
                    break block16;
                }
                throw new BusinessException("\u751f\u6210pdf\u5e76\u53d1\u9001\u81f3oss\u5931\u8d25");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    respOut.close();
                    os.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getYBNo(String idCardNo) throws Exception {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("mdtrt_cert_no", idCardNo);
        req.put("mdtrt_cert_type", "02");
        req.put("organCode", "360ZFB");
        String param = JSON.toJSONString(req);
        String postResult = HttpUtils.post((String)GET_YB_URL, (String)param);
        Map map = (Map)JSON.parseObject((String)postResult, Map.class);
        Map body = (Map)JSON.parseObject((String)JSON.toJSONString(map.get("body")), Map.class);
        Map output = (Map)JSON.parseObject((String)JSON.toJSONString(body.get("output")), Map.class);
        Map baseinfo = (Map)JSON.parseObject((String)JSON.toJSONString(output.get("baseinfo")), Map.class);
        String YBNo = (String)JSON.parseObject((String)JSON.toJSONString(baseinfo.get("psn_no")), String.class);
        return YBNo;
    }
}

