/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.OrganBasicInfoRespVO;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.common.pojo.vo.card.UcRegisterCardReqVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.common.enums.BaseStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.HospitalNamePinYinEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PrescriptionSourceEnum;
import com.ebaiyihui.medicalcloud.common.enums.RemarkTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.SexEnum;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.manage.Camanage;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.manage.MainManage;
import com.ebaiyihui.medicalcloud.manage.PatientInfoRemoteManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.QueryDrugDetailDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pay.ConfirmPayDtoReq;
import com.ebaiyihui.medicalcloud.pojo.entity.DiagnosticEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderRegEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.AddOEORIInfo;
import com.ebaiyihui.medicalcloud.pojo.vo.AddOrdersReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.DoctorInfoByHisDoctorCodeReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.PATIdentity;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientInfoMainRespVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientRegistryReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientSearchReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.UpdateOrdersStateReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.UpdatePresPriceReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.NcefyAddDiagnosisRtBodyVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.NcefyDiagnosisReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.NcefyDiagnosisResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.NcefyPaadDMDiagnoseVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.hyt.OrganizationResDTO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DiagnosticEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugDetailEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugMainEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugPrescriptionEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.DrugRemarkEntityPushVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.MedicalMoveMainCommonVO;
import com.ebaiyihui.medicalcloud.pojo.vo.push.MedicalMoveMainVO;
import com.ebaiyihui.medicalcloud.service.DiagnosticService;
import com.ebaiyihui.medicalcloud.service.DrugDetailService;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugOrderService;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.service.MosDrugRemarkService;
import com.ebaiyihui.medicalcloud.service.NcefyPrescriptionService;
import com.ebaiyihui.medicalcloud.service.PrescriptionPdfService;
import com.ebaiyihui.medicalcloud.utils.BeanHelper;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.HanyuPinyinUtil;
import com.ebaiyihui.medicalcloud.utils.RabbitMqUtils;
import com.ebaiyihui.medicalcloud.utils.RedisUtil;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import com.ebaiyihui.medicalcloud.utils.excel.DrugDetailExcel;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NcefyPrescriptionServiceImpl
implements NcefyPrescriptionService {
    private static final Logger log = LoggerFactory.getLogger(NcefyPrescriptionServiceImpl.class);
    public static final int M = 1;
    public static final int F = 2;
    private static final Integer TWENTY_FOUR_HOURS = 86400;
    private static final Integer PATIENT_ORDER_REGISTRY_TEN = 10;
    public static final String NCEFY = "NCEFY";
    public static final int ZERO = 0;
    public static final String MAN = "M";
    public static final int ONE = 1;
    public static final int FOUR = 4;
    public static final int TWO = 2;
    public static final String STOP_STATUS = "D";
    public static final String REVOKE_STATUS = "C";
    public static final int THIRTY = 30;
    public static final int SEVENTY_TWO_HOURS = 259200;
    public static final String CHANNEL_CODE_PATIENT_WX = "PATIENT_WX";
    public static final Short ZERO_SHORT = Short.parseShort("0");
    public static final String CRED_TYPE_CODE_IDENTITY_CARD = "01";
    public static final String CRED_TYPE_NAME_IDENTITY_CARD = "\u5c45\u6c11\u8eab\u4efd\u8bc1";
    public static final String CARD_TYPE_CODE_MEDICAL_CARD = "1702";
    public static final String CARD_TYPE_NAME_MEDICAL_CARD = "\u5c31\u8bca\u5361";
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MainManage mainManage;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private PatientInfoRemoteManage patientInfoRemoteManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Autowired
    private DrugDetailService detailService;
    @Autowired
    private MosDrugRemarkService mosDrugRemarkService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private Camanage camanage;
    @Autowired
    private MosDrugOrderService mosDrugOrderService;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private DiagnosticService diagnosticService;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private HisLogService hisLogService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolExecutor;
    @Autowired
    private RedisUtil redisUtil;
    public static final String ONE_STR = "1";
    public static final int THIRD = 3;
    public static final String YI_YAO_YUN = "yyy";
    public static final String MAIN_ORDER_RABBIT_INFO_SEPARATOR = "&&&-&&&";
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;

    public void patientRegistry(PatientRegistryReqVo patientRegistryReqVo) {
        this.redisTemplate.opsForValue().set((Object)patientRegistryReqVo.getPatPatientID(), (Object)JSON.toJSONString((Object)patientRegistryReqVo), 30L, TimeUnit.MINUTES);
    }

    public BaseResponse getUnpaidPatientInfo(UcCardListReqVO ucCardListReqVO) {
        OrganBasicInfoRespVO organBasicInfoRespVO = this.doctorRetmoteManage.queryOrganization(Integer.valueOf(ucCardListReqVO.getOrganCode()));
        ucCardListReqVO.setOrganCode(organBasicInfoRespVO.getOrganCode());
        List patientInfoResVOList = this.patientInfoRemoteManage.getUserBindPatientInfo(ucCardListReqVO);
        if (patientInfoResVOList == null || patientInfoResVOList.size() == 0) {
            log.info("\u672a\u627e\u5230\u7ed1\u5b9a\u7684\u5c31\u8bca\u5361");
            return BaseResponse.success();
        }
        List patientCredNoList = patientInfoResVOList.stream().map(v -> v.getIdentityCode()).collect(Collectors.toList());
        PatientInfoMainRespVO patientInfoMainRespVO = this.mosDrugMainMapper.getLastUnpaidMain(DrugMainStatusEnum.ZRYH_UNPAID.getValue(), ucCardListReqVO.getAppCode(), String.valueOf(organBasicInfoRespVO.getOrganId()), patientCredNoList, null);
        if (patientInfoMainRespVO == null) {
            log.info("\u5c31\u8bca\u5361\u5c1a\u4e0d\u5b58\u5728\u5f85\u652f\u4ed8\u5904\u65b9");
            return BaseResponse.success();
        }
        return BaseResponse.success((Object)patientInfoMainRespVO);
    }

    public BaseResponse getPatientTobind(PatientSearchReqVo patientSearchReqVo) {
        String patientCredNo = patientSearchReqVo.getPatientCredNo();
        String patTelephone = patientSearchReqVo.getPatTelephone();
        if (StringUtil.isEmpty((String)patientCredNo) && StringUtil.isEmpty((String)patTelephone)) {
            return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD, (String)"\u8eab\u4efd\u8bc1\u548c\u7535\u8bdd\u53f7\u7801\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        PatientInfoMainRespVO patientInfoMainRespVO = null;
        if (StringUtil.isNotEmpty((String)patientCredNo)) {
            ArrayList<String> patientCredNoList = new ArrayList<String>();
            patientCredNoList.add(patientCredNo);
            patientInfoMainRespVO = this.mosDrugMainMapper.getLastUnpaidMain(DrugMainStatusEnum.ZRYH_UNPAID.getValue(), patientSearchReqVo.getAppCode(), patientSearchReqVo.getOrganId(), patientCredNoList, null);
        }
        if (patientInfoMainRespVO == null && StringUtil.isNotEmpty((String)patTelephone)) {
            patientInfoMainRespVO = this.mosDrugMainMapper.getLastUnpaidMain(DrugMainStatusEnum.ZRYH_UNPAID.getValue(), patientSearchReqVo.getAppCode(), patientSearchReqVo.getOrganId(), null, patTelephone);
        }
        if (patientInfoMainRespVO == null) {
            log.info("\u672a\u627e\u5230\u6570\u636e");
            return BaseResponse.success();
        }
        this.registerorbind(patientSearchReqVo, patientInfoMainRespVO);
        return BaseResponse.success(patientInfoMainRespVO);
    }

    public BaseResponse confirmPay(ConfirmPayDtoReq confirmPayDtoReq) {
        log.info("======>>\u836f\u623f\u786e\u8ba4\u652f\u4ed8,\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)confirmPayDtoReq));
        String mainId = confirmPayDtoReq.getMainId();
        DrugMainEntity drugMainEntity = this.mosDrugMainService.queryById(mainId);
        DrugOrderEntity drugOrderEntity = this.mosDrugOrderService.queryByMainId(mainId);
        if (drugOrderEntity == null || drugMainEntity == null) {
            throw new BusinessException("\u786e\u8ba4\u652f\u4ed8\u67e5\u8be2\u8ba2\u5355\u6216\u533b\u5631\u65f6\u53d1\u751f\u5f02\u5e38\uff01");
        }
        if (OrderTypeEnum.DRUG_ORDER.getValue().equals(drugMainEntity.getOrderType())) {
            drugOrderEntity = this.getPayNotifyDrugOrderEntity(drugOrderEntity);
            this.mosDrugOrderService.update(drugOrderEntity);
            drugMainEntity.setOrderType(OrderTypeEnum.DRUG_ORDER.getValue());
            drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_TAKE.getValue());
            this.mosDrugMainService.update(drugMainEntity);
            if (HospitalNamePinYinEnum.NCDXDEFSYY.getValue().equals(drugMainEntity.getHospitalNameFirstLetter())) {
                RabbitMqUtils.senderDelayedPrescriptionOrder((RabbitTemplate)this.rabbitTemplate, (String)drugMainEntity.getxId(), (Integer)259200);
            }
            return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        drugOrderEntity = this.getPayNotifyDrugOrderEntity(drugOrderEntity);
        this.mosDrugOrderService.update(drugOrderEntity);
        drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOYING.getValue());
        drugMainEntity.setOrderType(OrderTypeEnum.COURIER_ORDER.getValue());
        this.mosDrugMainService.update(drugMainEntity);
        MosDrugLogisticsOrderRegEntity mosDrugLogisticsOrderRegEntity = this.mosDrugLogisticsOrderRegMapper.getByMainId1(drugMainEntity.getxId());
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByPrimaryKey(mosDrugLogisticsOrderRegEntity.getLogisticsOrderId());
        log.info("\u7269\u6d41\u8ba2\u5355\u4fe1\u606f->{}", (Object)Objects.toString(mosDrugLogisticsOrderEntity, null));
        if (mosDrugLogisticsOrderEntity == null) {
            return BaseResponse.success();
        }
        if (OrderStatusEnum.PAID.getValue().equals(mosDrugLogisticsOrderEntity.getOrderStatus())) {
            return BaseResponse.success();
        }
        this.threadPoolExecutor.execute(() -> {
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", drugMainEntity.getPresDoctorName());
            data.put("doctorName", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", "\u5904\u65b9\u652f\u4ed8\u6210\u529f");
            data.put("issue", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", "\u836f\u54c1\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u60a8\u9009\u62e9\u4e86\u836f\u54c1\u914d\u9001\u7684\u65b9\u5f0f");
            data.put("info", map3);
            this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/checkDrugPay/checkDrugPay?mainId=" + drugMainEntity.getxId());
        });
        mosDrugLogisticsOrderEntity.setOrderStatus(OrderStatusEnum.PAID.getValue());
        mosDrugLogisticsOrderEntity.setPayTime(new Date());
        mosDrugLogisticsOrderEntity.setPayMethod(PayTypeEnum.NCEFY_OFFLINE_MEDICAL_INS_PAY.getValue());
        this.mosDrugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
        return BaseResponse.success();
    }

    private DrugOrderEntity getPayNotifyDrugOrderEntity(DrugOrderEntity drugOrderEntity) {
        drugOrderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        drugOrderEntity.setPayTime(new Date());
        drugOrderEntity.setMchId("");
        return drugOrderEntity;
    }

    public List<DrugDetailExcel> exportDrugDetailExcel(List<String> mainIds) {
        List queryDrugDetailDtoList = this.mosDrugMainMapper.exportDrugDetailExcel(mainIds);
        ArrayList<DrugDetailExcel> result = new ArrayList<DrugDetailExcel>();
        if (queryDrugDetailDtoList != null && queryDrugDetailDtoList.size() > 0) {
            int index = 1;
            for (QueryDrugDetailDto queryDrugDetailDto : queryDrugDetailDtoList) {
                String itemStatusStr;
                DrugDetailExcel drugDetailExcel = new DrugDetailExcel();
                drugDetailExcel.setId(String.valueOf(index++));
                drugDetailExcel.setPresCode(queryDrugDetailDto.getPresCode());
                switch (queryDrugDetailDto.getItemStatus()) {
                    case 80: {
                        itemStatusStr = "\u5df2\u9000\u6b3e";
                        break;
                    }
                    case 100: {
                        itemStatusStr = "\u5f85\u7b7e\u6536";
                        break;
                    }
                    default: {
                        itemStatusStr = DrugMainStatusEnum.getDesc((Integer)queryDrugDetailDto.getItemStatus());
                    }
                }
                drugDetailExcel.setItemStatus(itemStatusStr);
                drugDetailExcel.setPatientName(queryDrugDetailDto.getPatientName());
                drugDetailExcel.setPatientGender(queryDrugDetailDto.getPatientGender() == Short.valueOf(SexEnum.MALE.getValue() + "") ? "\u7537" : "\u5973");
                drugDetailExcel.setPatientAge(queryDrugDetailDto.getPatientAge());
                drugDetailExcel.setPatientNo(queryDrugDetailDto.getPatientNo());
                drugDetailExcel.setPatientPhone(queryDrugDetailDto.getPatientPhone());
                drugDetailExcel.setPatientCredNo(queryDrugDetailDto.getPatientCredNo());
                drugDetailExcel.setPresDoctorName(queryDrugDetailDto.getPresDoctorName());
                drugDetailExcel.setPresDoctorCode(queryDrugDetailDto.getPresDoctorCode());
                drugDetailExcel.setPresDoctorPhone(queryDrugDetailDto.getPresDoctorPhone());
                drugDetailExcel.setPresOrganName(queryDrugDetailDto.getPresOrganName());
                drugDetailExcel.setPresDeptName(queryDrugDetailDto.getPresDeptName());
                drugDetailExcel.setRecipeDate(DateUtils.formatDateTime((Date)queryDrugDetailDto.getXCreateTime()));
                drugDetailExcel.setStoreName(queryDrugDetailDto.getStoreName());
                drugDetailExcel.setPharmaceuticalCompanyName(queryDrugDetailDto.getPharmaceuticalCompanyName());
                drugDetailExcel.setDrugName(queryDrugDetailDto.getDrugName());
                drugDetailExcel.setDrugSpec(queryDrugDetailDto.getDrugSpec());
                drugDetailExcel.setManufacturer(queryDrugDetailDto.getManufacturer());
                drugDetailExcel.setDrugUsage("\u6bcf\u6b21" + String.valueOf(queryDrugDetailDto.getSingleDose() == null ? BigDecimal.ZERO : queryDrugDetailDto.getSingleDose()) + queryDrugDetailDto.getMeasureUnit() + "," + queryDrugDetailDto.getUsageDesc() + "," + queryDrugDetailDto.getFrequencyDesc());
                drugDetailExcel.setAmount(queryDrugDetailDto.getAmount() != null ? String.valueOf(queryDrugDetailDto.getAmount().doubleValue()) : "0");
                drugDetailExcel.setUnitPrice(String.valueOf(queryDrugDetailDto.getUnitPrice()));
                drugDetailExcel.setTotalPrice(String.valueOf(queryDrugDetailDto.getTotalPrice()));
                drugDetailExcel.setBankTradeNo(queryDrugDetailDto.getBankTradeNo());
                BeanHelper.nullToEmpty((Object)drugDetailExcel);
                result.add(drugDetailExcel);
            }
        }
        return result;
    }

    private void registerorbind(PatientSearchReqVo patientSearchReqVo, PatientInfoMainRespVO patientInfoMainRespVO) {
        UcRegisterCardReqVO ucRegisterCardReqVO = new UcRegisterCardReqVO();
        ucRegisterCardReqVO.setAppCode(patientSearchReqVo.getAppCode());
        ucRegisterCardReqVO.setChannelCode(CHANNEL_CODE_PATIENT_WX);
        ucRegisterCardReqVO.setAccountId(patientSearchReqVo.getAccountId());
        ucRegisterCardReqVO.setUserId(patientSearchReqVo.getUserId());
        ucRegisterCardReqVO.setOperateUser(ZERO_SHORT);
        OrganBasicInfoRespVO organBasicInfoRespVO = this.doctorRetmoteManage.queryOrganization(Integer.valueOf(patientSearchReqVo.getOrganId()));
        ucRegisterCardReqVO.setOrganCode(organBasicInfoRespVO.getOrganCode());
        ucRegisterCardReqVO.setOrganName(patientInfoMainRespVO.getOrganName());
        ucRegisterCardReqVO.setPatientName(patientInfoMainRespVO.getPatientName());
        ucRegisterCardReqVO.setTel(patientInfoMainRespVO.getPatientPhone());
        ucRegisterCardReqVO.setCredNo(patientInfoMainRespVO.getPatientCredNo());
        ucRegisterCardReqVO.setCredTypeCode(CRED_TYPE_CODE_IDENTITY_CARD);
        ucRegisterCardReqVO.setCredTypeName(CRED_TYPE_NAME_IDENTITY_CARD);
        ucRegisterCardReqVO.setCardTypeCode(CARD_TYPE_CODE_MEDICAL_CARD);
        ucRegisterCardReqVO.setCardTypeName(CARD_TYPE_NAME_MEDICAL_CARD);
        ucRegisterCardReqVO.setIsPerson(ZERO_SHORT);
        this.patientInfoRemoteManage.registerorbind(ucRegisterCardReqVO);
    }

    public void patientOrderRegistry(AddOrdersReqVo addOrdersReqVo) {
        log.info("\u5f00\u59cb\u8bf7\u6c42\u63a8\u9001\u5904\u65b9\u5904\u7406\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)addOrdersReqVo);
        String uuid = UUIDUtils.getUUID();
        log.info("\u751f\u6210uuid\uff0c\u8fdb\u884c\u5b58\u50a8\uff0c\u4e3a\uff1a{}", (Object)uuid);
        addOrdersReqVo.setUuid(uuid);
        String rabbitInfo = addOrdersReqVo.getPatPatientID() + MAIN_ORDER_RABBIT_INFO_SEPARATOR + addOrdersReqVo.getPaadmVisitNumber() + MAIN_ORDER_RABBIT_INFO_SEPARATOR + uuid;
        log.info("\u5b58\u5165mq\uff0c\u5185\u5bb9\u4e3a:{}", (Object)rabbitInfo);
        RabbitMqUtils.senderRegistryPrescriptionOrder((RabbitTemplate)this.rabbitTemplate, (String)rabbitInfo, (Integer)PATIENT_ORDER_REGISTRY_TEN);
        log.info("\u5b58\u5165redis");
        this.redisUtil.set(addOrdersReqVo.getPatPatientID() + MAIN_ORDER_RABBIT_INFO_SEPARATOR + addOrdersReqVo.getPaadmVisitNumber(), (Object)JSON.toJSONString((Object)addOrdersReqVo), 1800L);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrders(AddOrdersReqVo addOrdersReqVo) {
        List paadDMDiagnoseVOList = this.getDiagnoses(addOrdersReqVo.getPaadmVisitNumber());
        List addOEORIInfoList = addOrdersReqVo.getAddOEORIInfoList();
        Map<String, List<AddOEORIInfo>> addOEORIInfoListMap = addOEORIInfoList.stream().collect(Collectors.groupingBy(AddOEORIInfo::getOeoriPrescNo));
        addOEORIInfoListMap.values().stream().forEach(oeoriInfoList -> {
            AddOEORIInfo addOEORIInfo = (AddOEORIInfo)oeoriInfoList.get(0);
            DrugMainEntity drugMainEntity = this.saveDrugMain(addOrdersReqVo.getPatPatientID(), addOrdersReqVo.getPaadmVisitNumber(), oeoriInfoList);
            String prescriptionAdmId = GenSeqUtils.getUniqueNo();
            DrugPrescriptionEntity drugPrescriptionEntity = this.savePrescription(drugMainEntity, prescriptionAdmId, oeoriInfoList);
            DiagnosticEntity diagnosticEntity = this.saveDiagnostic(paadDMDiagnoseVOList, drugMainEntity, oeoriInfoList, drugPrescriptionEntity);
            List drugDetailEntities = this.saveDrugsItemDetail(oeoriInfoList, drugMainEntity, drugPrescriptionEntity);
            DrugRemarkEntity remarkEntity = this.addRemark(drugMainEntity.getxId(), "", addOEORIInfo.getOeoriEnterDocDesc(), RemarkTypeEnum.ADD_PRES.getValue());
            try {
                this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), null);
            }
            catch (Exception e) {
                log.error("=============\u751f\u6210\u5904\u65b9\u7b3a\u5931\u8d25================" + e.getMessage());
            }
            DrugPrescriptionEntity drugPrescriptionEntityNew = this.mosDrugPrescriptionService.queryById(drugPrescriptionEntity.getxId());
            MedicalMoveMainVO medicalMoveMainVO = new MedicalMoveMainVO();
            medicalMoveMainVO.setDrugMainEntity(DrugMainEntityPushVO.getDrugMain((DrugMainEntity)drugMainEntity));
            medicalMoveMainVO.setDiagnosticEntity(DiagnosticEntityPushVO.getDrugMain((DiagnosticEntity)diagnosticEntity));
            medicalMoveMainVO.setDrugDetailEntity(DrugDetailEntityPushVO.getDrugMain((List)drugDetailEntities));
            medicalMoveMainVO.setDrugRemarkEntity(DrugRemarkEntityPushVO.getDrugMain((DrugRemarkEntity)remarkEntity));
            medicalMoveMainVO.setSourceType(Integer.valueOf(2));
            medicalMoveMainVO.setIsHaveAudit(Integer.valueOf(0));
            medicalMoveMainVO.setMainId(drugMainEntity.getxId());
            medicalMoveMainVO.setIsCallBack(Integer.valueOf(0));
            medicalMoveMainVO.setDrugPrescriptionEntity(DrugPrescriptionEntityPushVO.getDrugMain((DrugPrescriptionEntity)drugPrescriptionEntityNew));
            try {
                this.mosDrugPrescriptionService.pushMain(medicalMoveMainVO);
            }
            catch (Exception e) {
                log.error("\u5f53\u524d\u662f\u7b2c{}\u6b21\u5c1d\u8bd5\uff0c\u51fa\u73b0\u5f02\u5e38\uff0c{}", (Object)medicalMoveMainVO.getRetryCount(), (Object)e.getMessage());
                this.mosDrugPrescriptionService.retryAddMQ((MedicalMoveMainCommonVO)medicalMoveMainVO);
            }
        });
    }

    private synchronized boolean isRepeatPrescribe(AddOrdersReqVo addOrdersReqVo) {
        Object val = this.redisUtil.get(YI_YAO_YUN + addOrdersReqVo.getPaadmVisitNumber() + addOrdersReqVo.getPatPatientID());
        if (Objects.nonNull(val) && Objects.equals(val, ONE_STR)) {
            return true;
        }
        this.redisUtil.set(YI_YAO_YUN + addOrdersReqVo.getPaadmVisitNumber() + addOrdersReqVo.getPatPatientID(), (Object)ONE_STR, 3L);
        return false;
    }

    public void updateOrdersState(UpdateOrdersStateReqVo updateOrdersStateReqVo) {
        OrganizationResDTO organizationResDTO = this.doctorRetmoteManage.getByHospitalName("\u5357\u660c\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662");
        updateOrdersStateReqVo.getUpdateOEORIInfoList().stream().forEach(updateOEORIInfo -> {
            Integer status = 1;
            if (STOP_STATUS.equalsIgnoreCase(updateOEORIInfo.getOeoriStatusCode()) || REVOKE_STATUS.equalsIgnoreCase(updateOEORIInfo.getOeoriStatusCode())) {
                status = 0;
                log.info("\u72b6\u6001\u4e3a\u64a4\u9500");
            } else {
                log.info("\u72b6\u6001\u4e3a\u4e0d\u64a4\u9500");
            }
            boolean deleteFlag = false;
            if (status == 0) {
                DrugMainEntity drugMainEntity = this.mosDrugMainMapper.getByPresDetailHisIdAndHospitalId(updateOEORIInfo.getOeoriOrderItemID(), organizationResDTO.getId().toString());
                if (DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(drugMainEntity.getItemStatus())) {
                    DoctorEntityInfoVO doctorEntityInfoVO;
                    deleteFlag = true;
                    if (StringUtil.isNotEmpty((String)drugMainEntity.getPresDoctorId()) && Objects.nonNull(doctorEntityInfoVO = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(drugMainEntity.getPresDoctorId()))))) {
                        try {
                            UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                            String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                            HashMap<String, String> param = new HashMap<String, String>();
                            DrugPrescriptionEntity drugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(drugMainEntity.getxId());
                            param.put("presCode", drugPrescriptionEntity.getHisRecipeNo());
                            param.put("phone", "400-631-9377");
                            this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "ndefy-cxsb", doctorEntityInfoVO.getContactMobile(), param);
                        }
                        catch (Exception e) {
                            log.error("=============\u77ed\u4fe1\u63a8\u9001\u5931\u8d25================" + e.getMessage());
                        }
                    }
                }
            }
            if (deleteFlag) {
                this.mosDrugMainMapper.updateStatusByPresDetailHisIdAndHospitalId(status, updateOEORIInfo.getOeoriOrderItemID(), organizationResDTO.getId().toString());
            }
        });
    }

    public void deleteOrder(String mainId) {
        DrugMainEntity drugMainEntity = new DrugMainEntity();
        drugMainEntity.setxId(mainId);
        drugMainEntity.setStatus(Integer.valueOf(0));
        this.mosDrugMainMapper.update(drugMainEntity);
    }

    public BaseResponse updatePresPrice(UpdatePresPriceReqVo updatePresPriceReqVo) {
        DrugDetailEntity drugDetailEntity = this.detailService.getById(updatePresPriceReqVo.getPresDetailId());
        BigDecimal price = new BigDecimal(updatePresPriceReqVo.getDrugPrice());
        drugDetailEntity.setUnitPrice(price);
        drugDetailEntity.setTotalPrice(price.multiply(drugDetailEntity.getAmount()));
        drugDetailEntity.setAmountUnit(updatePresPriceReqVo.getWholePackingUnitName());
        drugDetailEntity.setWholePackingUnit(updatePresPriceReqVo.getWholePackingUnitName());
        this.detailService.updateById(drugDetailEntity);
        List drugDetailEntityList = this.detailService.listByMainId(drugDetailEntity.getMainId());
        double totalCostDouble = drugDetailEntityList.stream().mapToDouble(drugPrescriptionEntity -> drugPrescriptionEntity.getTotalPrice().doubleValue()).sum();
        BigDecimal totalCost = BigDecimal.valueOf(totalCostDouble);
        DrugPrescriptionEntity drugPrescriptionEntity2 = this.mosDrugPrescriptionService.queryByMainId(drugDetailEntity.getMainId());
        drugPrescriptionEntity2.setStorePrice(totalCost.setScale(4, 4));
        drugPrescriptionEntity2.setPrice(totalCost.setScale(2, 4));
        this.mosDrugPrescriptionService.update(drugPrescriptionEntity2);
        return BaseResponse.success();
    }

    private List<NcefyPaadDMDiagnoseVO> getDiagnoses(String paadmVisitNumber) {
        if (StringUtil.isEmpty((String)paadmVisitNumber)) {
            return new ArrayList<NcefyPaadDMDiagnoseVO>();
        }
        try {
            OrganizationResDTO organizationResDTO = this.doctorRetmoteManage.getByHospitalName("\u5357\u660c\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662");
            NcefyDiagnosisReqVO diagnosisReqVO = new NcefyDiagnosisReqVO();
            diagnosisReqVO.setPaadMVisitNumber(paadmVisitNumber);
            diagnosisReqVO.setTradeCode("");
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)diagnosisReqVO);
            HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/nandaer-front/diagnoses/getDiagnoses", organizationResDTO.getId().toString());
            BaseResponse baseResponse = this.hisManage.sendHis("/nandaer-front/diagnoses/getDiagnoses", frontRequest, NcefyDiagnosisResVO.class);
            hisLogEntity.setResponse(JSONObject.toJSONString((Object)baseResponse));
            this.hisLogService.update(hisLogEntity);
            if (baseResponse.isSuccess()) {
                NcefyAddDiagnosisRtBodyVO addDiagnosisRtBodyVO = ((NcefyDiagnosisResVO)baseResponse.getData()).getBody();
                return addDiagnosisRtBodyVO.getAddDiagnosisRt().getPaadmDiagnoseList().getPaadDMDiagnose();
            }
        }
        catch (Exception e) {
            log.error("=============\u4ecehis\u67e5\u8be2\u5728\u7ebf\u590d\u8bca\u8bca\u65ad\u4fe1\u606f\u5931\u8d25================" + e.getMessage());
        }
        return new ArrayList<NcefyPaadDMDiagnoseVO>();
    }

    private DrugRemarkEntity addRemark(String mainId, String content, String operationUser, Integer remarkType) {
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugRemarkEntity.setMainId(mainId);
        drugRemarkEntity.setRemarkContent(content);
        drugRemarkEntity.setRemarkUser(operationUser);
        drugRemarkEntity.setRemarkType(remarkType);
        this.mosDrugRemarkService.insert(drugRemarkEntity);
        return drugRemarkEntity;
    }

    private List<DrugDetailEntity> saveDrugsItemDetail(List<AddOEORIInfo> oeoriInfoList, DrugMainEntity drugMainEntity, DrugPrescriptionEntity drugPrescriptionEntity) {
        List drugCode = oeoriInfoList.stream().map(drugInfo -> drugInfo.getOeoriARCItmMastCode()).collect(Collectors.toList());
        List drugDetailEntityList = this.detailService.getByMainIds(drugMainEntity.getxId());
        drugDetailEntityList.stream().forEach(drugDetailEntity -> {
            if (!drugCode.contains(drugDetailEntity.getDrugCommonCode())) {
                this.detailService.deleteById(drugDetailEntity.getxId());
            }
        });
        ArrayList<DrugDetailEntity> entities = new ArrayList<DrugDetailEntity>();
        for (AddOEORIInfo addOEORIInfo : oeoriInfoList) {
            DrugDetailEntity oldDrugDetailEntity = this.detailService.getByMainIdAndDrugCommonCode(drugMainEntity.getxId(), addOEORIInfo.getOeoriARCItmMastCode());
            DrugDetailEntity drugDetailEntity2 = new DrugDetailEntity();
            drugDetailEntity2.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugDetailEntity2.setOrganCode(drugMainEntity.getPresOrgan());
            drugDetailEntity2.setMainId(drugMainEntity.getxId());
            drugDetailEntity2.setPresId(drugPrescriptionEntity.getxId());
            drugDetailEntity2.setUnitPrice(new BigDecimal(0));
            drugDetailEntity2.setTotalPrice(new BigDecimal(0));
            drugDetailEntity2.setSingleDose(new BigDecimal(addOEORIInfo.getOeoriDoseQty()));
            drugDetailEntity2.setMeasureUnit(addOEORIInfo.getOeoriDoseUnitDesc());
            drugDetailEntity2.setArcimCode(addOEORIInfo.getOeoriARCItmMastCode());
            drugDetailEntity2.setDrugName(addOEORIInfo.getOeoriARCItmMastDesc());
            drugDetailEntity2.setAmount(new BigDecimal(addOEORIInfo.getOeoriOrderQty()));
            drugDetailEntity2.setFrequencyDesc(addOEORIInfo.getOeoriFreqDesc());
            drugDetailEntity2.setUsageDesc(addOEORIInfo.getOeoriInstrDesc());
            String regEx = "[^0-9]";
            Pattern p = Pattern.compile(regEx);
            Matcher matcher = p.matcher(addOEORIInfo.getOeoriDurationDesc());
            drugDetailEntity2.setDuration(Integer.valueOf(matcher.replaceAll("").trim()));
            drugDetailEntity2.setDrugSpec(addOEORIInfo.getOeoriSpecification());
            drugDetailEntity2.setPresDetailsHisId(addOEORIInfo.getOeoriOrderItemID());
            if (Objects.isNull(oldDrugDetailEntity)) {
                drugDetailEntity2.setxId(GenSeqUtils.getUniqueNo());
                drugDetailEntity2.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.detailService.insert(drugDetailEntity2);
            } else {
                drugDetailEntity2.setxRowid(oldDrugDetailEntity.getxRowid());
                drugDetailEntity2.setxId(oldDrugDetailEntity.getxId());
                drugDetailEntity2.setxCreateTime(oldDrugDetailEntity.getxCreateTime());
                this.detailService.updateById(drugDetailEntity2);
            }
            entities.add(drugDetailEntity2);
        }
        return entities;
    }

    private DiagnosticEntity saveDiagnostic(List<NcefyPaadDMDiagnoseVO> paadDMDiagnoseVOList, DrugMainEntity drugMainEntity, List<AddOEORIInfo> oeoriInfoList, DrugPrescriptionEntity drugPrescriptionEntity) {
        if (paadDMDiagnoseVOList != null && paadDMDiagnoseVOList.size() > 0) {
            String diagnostic = "";
            for (NcefyPaadDMDiagnoseVO paadDMDiagnoseVO : paadDMDiagnoseVOList) {
                String currDiagnostic = paadDMDiagnoseVO.getPadDiagDesc();
                if (StringUtil.isEmpty((String)currDiagnostic)) continue;
                diagnostic = new StringBuffer(diagnostic).append(currDiagnostic).append(";").toString();
            }
            if (diagnostic.endsWith(";")) {
                diagnostic = diagnostic.substring(0, diagnostic.length() - 1);
            }
            if (StringUtil.isNotEmpty((String)diagnostic)) {
                DiagnosticEntity diagnosticEntity = new DiagnosticEntity();
                diagnosticEntity.setxId(drugPrescriptionEntity.getAdmId());
                diagnosticEntity.setDoctorCode(drugMainEntity.getPresDoctorCode());
                diagnosticEntity.setDoctorName(drugMainEntity.getPresDoctorName());
                diagnosticEntity.setDeptCode(drugMainEntity.getPresHisDeptCode());
                diagnosticEntity.setOrganCode(drugMainEntity.getPresOrgan());
                diagnosticEntity.setAdmId(drugPrescriptionEntity.getAdmId());
                diagnosticEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
                diagnosticEntity.setDiagnostic(diagnostic);
                DiagnosticEntity old = this.diagnosticService.getById(drugPrescriptionEntity.getAdmId());
                if (Objects.isNull(old)) {
                    diagnosticEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                    diagnosticEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                    return this.diagnosticService.insert(diagnosticEntity);
                }
                diagnosticEntity.setxRowid(old.getxRowid());
                this.diagnosticService.updateById(diagnosticEntity);
                return diagnosticEntity;
            }
            return null;
        }
        return null;
    }

    private DrugPrescriptionEntity savePrescription(DrugMainEntity drugMainEntity, String prescriptionAdmId, List<AddOEORIInfo> oeoriInfoList) {
        AddOEORIInfo addOEORIInfo = oeoriInfoList.get(0);
        DrugPrescriptionEntity oldDrugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(drugMainEntity.getxId());
        DrugPrescriptionEntity drugPrescriptionEntity = new DrugPrescriptionEntity();
        drugPrescriptionEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugPrescriptionEntity.setMainId(drugMainEntity.getxId());
        drugPrescriptionEntity.setHisRecipeNo(addOEORIInfo.getOeoriPrescNo());
        drugPrescriptionEntity.setDrugKindCount(Integer.valueOf(oeoriInfoList.size()));
        drugPrescriptionEntity.setRecipeDate(addOEORIInfo.getOeoriEnterDate() + " " + addOEORIInfo.getOeoriEnterTime());
        if (Objects.isNull(oldDrugPrescriptionEntity)) {
            drugPrescriptionEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugPrescriptionEntity.setAdmId(prescriptionAdmId);
            drugPrescriptionEntity.setxId(GenSeqUtils.getUniqueNo());
            drugPrescriptionEntity = this.mosDrugPrescriptionService.insert(drugPrescriptionEntity);
        } else {
            drugPrescriptionEntity.setxId(oldDrugPrescriptionEntity.getxId());
            drugPrescriptionEntity.setAdmId(oldDrugPrescriptionEntity.getAdmId());
            this.mosDrugPrescriptionService.update(drugPrescriptionEntity);
        }
        return drugPrescriptionEntity;
    }

    private DrugMainEntity saveDrugMain(String patPatientID, String paadmVisitNumber, List<AddOEORIInfo> oeoriInfoList) {
        AddOEORIInfo addOEORIInfo = oeoriInfoList.get(0);
        DrugMainEntity drugMainEntity = new DrugMainEntity();
        drugMainEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugMainEntity.setMedicalRecordNo(paadmVisitNumber);
        OrganizationResDTO organizationResDTO = this.doctorRetmoteManage.getByHospitalName("\u5357\u660c\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662");
        drugMainEntity.setPresOrgan(organizationResDTO.getAppCode());
        drugMainEntity.setOrganId(organizationResDTO.getId().toString());
        drugMainEntity.setPresOrgan(organizationResDTO.getAppCode());
        drugMainEntity.setPresOrganName(organizationResDTO.getOrganName());
        drugMainEntity.setAppCode(organizationResDTO.getAppCode());
        DoctorInfoByHisDoctorCodeReqVo doctorInfoByHisDoctorCodeReqVo = this.doctorRetmoteManage.getDoctorInfoByDoctorHisCodeAndHospitalId(addOEORIInfo.getOeoriEnterDocCode(), organizationResDTO.getId().toString());
        if (Objects.nonNull(doctorInfoByHisDoctorCodeReqVo)) {
            String doctorSign = this.camanage.getNCEFYStamp(doctorInfoByHisDoctorCodeReqVo.getDoctorId().toString(), organizationResDTO.getAppCode());
            drugMainEntity.setDoctorSign(doctorSign);
            drugMainEntity.setPresDoctorId(doctorInfoByHisDoctorCodeReqVo.getDoctorId().toString());
            drugMainEntity.setPresDoctorPhone("");
        }
        drugMainEntity.setPresDoctorCode(addOEORIInfo.getOeoriEnterDocCode());
        drugMainEntity.setPresDoctorName(addOEORIInfo.getOeoriEnterDocDesc());
        drugMainEntity.setPresHisDeptCode(addOEORIInfo.getOeoriEnterDeptCode());
        drugMainEntity.setPresDeptName(addOEORIInfo.getOeoriEnterDeptDesc());
        drugMainEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        drugMainEntity.setDrugSpeciesNum(Integer.valueOf(oeoriInfoList.size()));
        drugMainEntity.setItemStatus(DrugMainStatusEnum.ZRYH_UNPAID.getValue());
        drugMainEntity.setRemark(addOEORIInfo.getOeoriRemarks());
        drugMainEntity.setRefundStatus(BaseStatusEnum.VALID_STATUS.getValue());
        log.info("\u5f00\u59cb\u4eceredis\u4e2d\u8bfb\u53d6\u60a3\u8005\u4fe1\u606f\uff0cid:{}", (Object)patPatientID);
        Object patientRegistryJsonInfo = this.redisTemplate.opsForValue().get((Object)patPatientID);
        log.info("\u8bfb\u53d6\u5230\u60a3\u8005\u4fe1\u606f\uff0c\u4e3a:{}", (Object)JSON.toJSONString((Object)patientRegistryJsonInfo));
        if (Objects.nonNull(patientRegistryJsonInfo)) {
            PatientRegistryReqVo patientRegistryReqVo = (PatientRegistryReqVo)JSON.parseObject((String)patientRegistryJsonInfo.toString(), PatientRegistryReqVo.class);
            List patIdentityList = JSON.parseArray((String)JSON.toJSONString((Object)patientRegistryReqVo.getPatIdentityList()), PATIdentity.class);
            PATIdentity patIdentity = (PATIdentity)patIdentityList.get(0);
            drugMainEntity.setPatientPhone(patientRegistryReqVo.getPatTelephone());
            drugMainEntity.setPatientName(patientRegistryReqVo.getPatName());
            drugMainEntity.setPatientHisId(patientRegistryReqVo.getPatPatientID());
            drugMainEntity.setPatientAge(Integer.valueOf(IdCardUtil.getAgeByIdCard((String)patIdentity.getPatIdentityNum())));
            if (IdCardUtil.getGenderByIdCard((String)patIdentity.getPatIdentityNum()).equals(MAN)) {
                drugMainEntity.setPatientGender(Integer.valueOf(1));
            } else {
                drugMainEntity.setPatientGender(Integer.valueOf(2));
            }
            drugMainEntity.setPatientCredNo(patIdentity.getPatIdentityNum());
        }
        drugMainEntity.setPresType(DrugTypeEnum.WCTM.getValue());
        drugMainEntity.setServCodeName("\u5904\u65b9\u6d41\u8f6c");
        drugMainEntity.setPrescriptionSource(PrescriptionSourceEnum.HIS.getValue());
        drugMainEntity.setHospitalNameFirstLetter(HanyuPinyinUtil.getFirstLetters((String)drugMainEntity.getPresOrganName(), (HanyuPinyinCaseType)HanyuPinyinCaseType.UPPERCASE));
        drugMainEntity.setFetchMedicalCode("");
        DrugMainEntity oldHisDrugMainEntity = null;
        if (StringUtil.isEmpty((String)addOEORIInfo.getOeoriPrescNo())) {
            drugMainEntity.setItemStatus(DrugMainStatusEnum.ERROR.getValue());
        } else {
            oldHisDrugMainEntity = this.mosDrugMainMapper.getByHisRecipeNo(addOEORIInfo.getOeoriPrescNo());
        }
        if (null != oldHisDrugMainEntity) {
            drugMainEntity.setxRowid(oldHisDrugMainEntity.getxRowid());
            drugMainEntity.setxId(oldHisDrugMainEntity.getxId());
            drugMainEntity.setxCreateTime(oldHisDrugMainEntity.getxCreateTime());
            drugMainEntity.setTransactionId(oldHisDrugMainEntity.getTransactionId());
            drugMainEntity.setFailureTime(oldHisDrugMainEntity.getFailureTime());
            if (oldHisDrugMainEntity.getItemStatus().equals(DrugMainStatusEnum.APPROVING.getValue())) {
                drugMainEntity.setItemStatus(DrugMainStatusEnum.APPROVING.getValue());
            }
            this.mosDrugMainMapper.update(drugMainEntity);
        } else {
            drugMainEntity.setxId(GenSeqUtils.getUniqueNo());
            drugMainEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugMainEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugMainEntity.setTransactionId(UUIDUtils.getUUID());
            drugMainEntity.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)1));
            drugMainEntity = this.mosDrugMainService.insert(drugMainEntity);
            RabbitMqUtils.senderDelayedPrescriptionOrder((RabbitTemplate)this.rabbitTemplate, (String)drugMainEntity.getxId(), (Integer)TWENTY_FOUR_HOURS);
            if (DrugMainStatusEnum.ERROR.getValue() != drugMainEntity.getItemStatus()) {
                try {
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                    HashMap<String, String> param = new HashMap<String, String>();
                    String medicalName = addOEORIInfo.getOeoriARCItmMastDesc();
                    if (oeoriInfoList.size() > 1) {
                        medicalName = medicalName + "\u7b49\u836f\u54c1";
                    }
                    param.put("medicalName", medicalName);
                    param.put("phone", "400-631-9377");
                    this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "ndefy-yfqy", drugMainEntity.getPatientPhone(), param);
                }
                catch (Exception e) {
                    log.error("=============\u77ed\u4fe1\u63a8\u9001\u5931\u8d25================" + e.getMessage());
                }
            }
        }
        return drugMainEntity;
    }
}

