/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl.hyt;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.enums.VerifierDrugTypeEnum;
import com.ebaiyihui.medicalcloud.mapper.MosDrugVerifierMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugVerifierEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.verifier.AddVerifierReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.verifier.DeleteVerifierReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.verifier.QueryVerifierReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.verifier.QueryVerifierResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.verifier.SaveVerifierReqVO;
import com.ebaiyihui.medicalcloud.service.hyt.HytVerifierService;
import com.ebaiyihui.medicalcloud.utils.BeanHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HytVerifierServiceImpl
implements HytVerifierService {
    @Autowired
    MosDrugVerifierMapper verifierMapper;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> addVerifier(AddVerifierReqVO vo) {
        List verifierEntityList = this.verifierMapper.queryByDoctorId(vo.getDoctorId(), vo.getDrugType(), vo.getOrganId(), vo.getAppCode());
        if (CollectionUtils.isNotEmpty((Collection)verifierEntityList) && Objects.nonNull(verifierEntityList.get(0))) {
            return BaseResponse.error((String)"\u836f\u5e08\u5df2\u6dfb\u52a0");
        }
        MosDrugVerifierEntity drugVerifierEntity = new MosDrugVerifierEntity();
        BeanUtils.copyProperties((Object)vo, (Object)drugVerifierEntity, (String[])BeanHelper.getNullPropertyNames((Object)vo));
        this.verifierMapper.insertSelective(drugVerifierEntity);
        return BaseResponse.success((Object)drugVerifierEntity.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> deleteVerifier(DeleteVerifierReqVO vo) {
        this.verifierMapper.updateStatusByDoctorIds(vo.getDoctorIds());
        return BaseResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<QueryVerifierResVO> queryVerifier(QueryVerifierReqVO vo) {
        List<Object> cmVerifierList = new ArrayList();
        List<Object> wmVerifierList = new ArrayList();
        QueryVerifierResVO resVO = new QueryVerifierResVO();
        List queryVerifierDataList = this.verifierMapper.queryByAppCode(vo.getAppCode(), vo.getOrganId());
        if (CollectionUtils.isNotEmpty((Collection)queryVerifierDataList)) {
            cmVerifierList = queryVerifierDataList.stream().filter(item -> VerifierDrugTypeEnum.CM.getValue().equals(item.getDrugType())).collect(Collectors.toList());
            wmVerifierList = queryVerifierDataList.stream().filter(item -> VerifierDrugTypeEnum.WM.getValue().equals(item.getDrugType())).collect(Collectors.toList());
        }
        resVO.setCmVerifierList(cmVerifierList);
        resVO.setWmVerifierList(wmVerifierList);
        return BaseResponse.success((Object)resVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> saveVerifier(SaveVerifierReqVO vo) {
        this.verifierMapper.updateByAppCodeAndOrganId(vo.getAppCode(), vo.getOrganId());
        vo.getSaveVerifierData().forEach(item -> {
            MosDrugVerifierEntity drugVerifierEntity = new MosDrugVerifierEntity();
            BeanUtils.copyProperties((Object)item, (Object)drugVerifierEntity, (String[])BeanHelper.getNullPropertyNames((Object)item));
            drugVerifierEntity.setAppCode(vo.getAppCode());
            drugVerifierEntity.setOrganId(vo.getOrganId());
            this.verifierMapper.insertSelective(drugVerifierEntity);
        });
        return BaseResponse.success();
    }
}

