/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.webservice.service.impl;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.common.enums.OutReachMethodCodeEnum;
import com.ebaiyihui.medicalcloud.config.CommonConfig;
import com.ebaiyihui.medicalcloud.manage.LogisticsManage;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.OutReachPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.OutReachResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.RecipeNoVo;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.utils.XmlUtil;
import com.ebaiyihui.medicalcloud.webservice.manage.CloudMedicalManage;
import com.ebaiyihui.medicalcloud.webservice.manage.OutReachManage;
import com.ebaiyihui.medicalcloud.webservice.service.OutReachService;
import java.util.ArrayList;
import javax.jws.WebService;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@WebService(serviceName="OutReachService", targetNamespace="http://service.webservice.medicalcloud.ebaiyihui.com/", endpointInterface="com.ebaiyihui.medicalcloud.webservice.service.OutReachService")
@Component
@Service
public class OutReachServiceImpl
implements OutReachService {
    private static final Logger log = LoggerFactory.getLogger(OutReachServiceImpl.class);
    @Autowired
    private CommonConfig commonConfig;
    @Autowired
    private LogisticsManage logisticsManage;
    @Autowired
    private CloudMedicalManage cloudMedicalManage;
    @Autowired
    private HisLogService hisLogService;
    private static final String ZRYH_HIS_NAME = "ZRYHYY";
    private static final String HYT_HIS_NAME = "2291";
    @Autowired
    private OutReachManage outReachManage;

    public String process(String userCode, String methodCode, String xml) {
        log.info("============\u8fdb\u5165\u4e86weservice\u670d\u52a1==========");
        log.info("=======his\u8bf7\u6c42\u53c2\u6570\uff1a" + xml);
        OutReachResVO outReachResVO = new OutReachResVO();
        if (!userCode.equals(this.commonConfig.getHisUserCode())) {
            outReachResVO.setResultCode("0");
            outReachResVO.setResultContent("\u7528\u6237\u8eab\u4efd\u6821\u9a8c\u5931\u8d25\uff01");
            return XmlUtil.convertToXml((Object)outReachResVO);
        }
        if (methodCode.equals(OutReachMethodCodeEnum.SEND_RECIPE.getValue())) {
            log.info("======\u8c03\u7528\u4e86\u5f00\u5177\u5904\u65b9\u63a8\u9001\u63a5\u53e3====");
            this.outReachManage.synHisPrescription(xml);
            outReachResVO.setResultCode("0");
            outReachResVO.setResultContent("\u64cd\u4f5c\u6210\u529f");
            String url = new StringBuffer("SEND_RECIPE").append("_6001").toString();
            HisLogEntity hisLogEntity = this.hisLogService.insertEntity(xml, url, ZRYH_HIS_NAME);
            hisLogEntity.setResponse(XmlUtil.convertToXml((Object)outReachResVO));
            this.hisLogService.update(hisLogEntity);
            return XmlUtil.convertToXml((Object)outReachResVO);
        }
        if (methodCode.equals(OutReachMethodCodeEnum.SEND_CHECKED_EXPRESS_RECIPES.getValue())) {
            log.info("======\u8c03\u7528\u4e86\u5916\u914d\u5904\u65b9\u662f\u5426\u5ba1\u6838\u901a\u8fc7\u63a5\u53e3====");
            this.outReachManage.auditPrescription(xml);
            outReachResVO.setResultCode("0");
            outReachResVO.setResultContent("\u64cd\u4f5c\u6210\u529f");
            String url = new StringBuffer("SEND_CHECKED_EXPRESS_RECIPES").append("_6002").toString();
            HisLogEntity hisLogEntity = this.hisLogService.insertEntity(xml, url, ZRYH_HIS_NAME);
            hisLogEntity.setResponse(XmlUtil.convertToXml((Object)outReachResVO));
            this.hisLogService.update(hisLogEntity);
            return XmlUtil.convertToXml((Object)outReachResVO);
        }
        outReachResVO.setResultCode("1");
        outReachResVO.setResultContent("\u65b9\u6cd5\u7f16\u7801\u4e0d\u5b58\u5728");
        return XmlUtil.convertToXml((Object)outReachResVO);
    }

    public String deliverProcess(String userCode, String methodCode, String xml) {
        log.info("============\u8fdb\u5165\u4e86weservice\u670d\u52a1==========");
        log.info("=======\u534e\u9e3f\u8bf7\u6c42\u53c2\u6570\uff1a" + xml);
        OutReachResVO outReachResVO = new OutReachResVO();
        if (!userCode.equals(this.commonConfig.getGyhhUserCode())) {
            outReachResVO.setResultCode("0");
            outReachResVO.setResultContent("\u7528\u6237\u8eab\u4efd\u6821\u9a8c\u5931\u8d25\uff01");
            return XmlUtil.convertToXml((Object)outReachResVO);
        }
        if (methodCode.equals(OutReachMethodCodeEnum.DELIVER_STATUS.getValue())) {
            log.info("======\u8c03\u7528\u4e86\u7269\u6d41\u914d\u9001\u72b6\u6001\u5b9e\u65f6\u63a8\u9001\u63a5\u53e3====");
            outReachResVO.setResultCode("0");
            outReachResVO.setResultContent("\u64cd\u4f5c\u6210\u529f");
            String url = new StringBuffer("DELIVER_STATUS").append("_7001").toString();
            HisLogEntity hisLogEntity = this.hisLogService.insertEntity(xml, url, ZRYH_HIS_NAME);
            hisLogEntity.setResponse(XmlUtil.convertToXml((Object)outReachResVO));
            this.hisLogService.update(hisLogEntity);
            try {
                this.logisticsManage.save(xml);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u7269\u6d41\u4fe1\u606f\u5f02\u5e38->{}", (Throwable)e);
            }
            return XmlUtil.convertToXml((Object)outReachResVO);
        }
        if (methodCode.equals(OutReachMethodCodeEnum.DELIVER_COMPLETED.getValue())) {
            log.info("======\u8c03\u7528\u4e86\u7269\u6d41\u914d\u9001\u5b8c\u6210\u5b9e\u65f6\u63a8\u9001\u63a5\u53e3====");
            outReachResVO.setResultCode("0");
            outReachResVO.setResultContent("\u64cd\u4f5c\u6210\u529f");
            return XmlUtil.convertToXml((Object)outReachResVO);
        }
        outReachResVO.setResultCode("1");
        outReachResVO.setResultContent("\u65b9\u6cd5\u7f16\u7801\u4e0d\u5b58\u5728");
        return XmlUtil.convertToXml((Object)outReachResVO);
    }

    public String hytProcess(String transCode, String userCode, String xml) {
        log.info("============\u8fdb\u5165\u4e86weservice\u670d\u52a1==========");
        log.info("=======\uff1ahis\u533b\u4fdd\u6d41\u7a0b\u8bf7\u6c42\u53c2\u6570" + xml);
        OutReachResVO outReachResVO = new OutReachResVO();
        if (!userCode.equals(this.commonConfig.getHytUserCode())) {
            outReachResVO.setResultCode("1");
            outReachResVO.setResultContent("\u7528\u6237\u8eab\u4efd\u6821\u9a8c\u5931\u8d25\uff01");
            return XmlUtil.convertToXml((Object)outReachResVO);
        }
        if (transCode.equals(OutReachMethodCodeEnum.SERVICE_PAYMENT.getValue())) {
            log.info("======\u8c03\u7528\u4e86\u822a\u5929\u81ea\u52a9\u7f34\u8d39\u63a5\u53e3====");
            BaseResponse baseResponse = this.cloudMedicalManage.payment(xml);
            String url = new StringBuffer("SERVICE_PAYMENT").append("_8001").toString();
            HisLogEntity hisLogEntity = this.hisLogService.insertEntity(xml, url, HYT_HIS_NAME);
            if (baseResponse.isSuccess()) {
                outReachResVO.setResultCode("0");
                outReachResVO.setResultContent("\u64cd\u4f5c\u6210\u529f");
                hisLogEntity.setResponse(XmlUtil.convertToXml((Object)outReachResVO));
                this.hisLogService.update(hisLogEntity);
            } else {
                outReachResVO.setResultCode("1");
                outReachResVO.setResultContent(baseResponse.getMsg());
                hisLogEntity.setResponse(XmlUtil.convertToXml((Object)outReachResVO));
                this.hisLogService.update(hisLogEntity);
            }
            return XmlUtil.convertToXml((Object)outReachResVO);
        }
        outReachResVO.setResultCode("1");
        outReachResVO.setResultContent("\u65b9\u6cd5\u7f16\u7801\u4e0d\u5b58\u5728");
        return XmlUtil.convertToXml((Object)outReachResVO);
    }

    public static void main(String[] args) throws Exception {
        JaxWsDynamicClientFactory dcflient = JaxWsDynamicClientFactory.newInstance();
        Client client = dcflient.createClient("http://localhost:9097/outReach/cloudMedicalService.asmx?wsdl");
        OutReachPayReqVO outReachPayReqVO = new OutReachPayReqVO();
        outReachPayReqVO.setHisRegNo("outReachPayReqVO");
        outReachPayReqVO.setCardNo("0000433984");
        outReachPayReqVO.setTotalCost("90");
        outReachPayReqVO.setSelfCost("30");
        outReachPayReqVO.setHealCost("60");
        outReachPayReqVO.setPayMethod("WX");
        outReachPayReqVO.setBankTransNO("\u94f6\u884c\u4ea4\u6613\u6d41\u6c34\u53f7");
        outReachPayReqVO.setFeeDate("2020-09-22 18:22:11");
        outReachPayReqVO.setMerID("152341315");
        ArrayList<RecipeNoVo> recipeList = new ArrayList<RecipeNoVo>();
        RecipeNoVo recipeNoVo = new RecipeNoVo();
        recipeList.add(recipeNoVo);
        String xml = XmlUtil.convertToXml((Object)outReachPayReqVO);
        System.out.println(xml);
        String input = "<Request><hisRegNo>201704015241</hisRegNo><cardNo>0000433984</cardNo><totalCost>90</totalCost><selfCost>30</selfCost><healCost>60</healCost><bankTransNO>11111</bankTransNO><payMethod>WX</payMethod><feeDate>2020-09-22 18:22:11</feeDate><merID>152341315</merID><RecipeList><Recipeno>71271720</Recipeno></RecipeList></Request>";
        Object[] objects = client.invoke("hytProcess", new Object[]{"8001", "202004170003", input});
        System.out.println("*******" + objects[0].toString());
    }

    public String TransHisData(String xml, String transCode, String userCode) {
        log.info("============\u8fdb\u5165\u4e86weservice\u670d\u52a1\u8d63\u5357\u5904\u65b9\u63a8\u9001\u670d\u52a1\uff1a" + xml);
        return "";
    }
}

