/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.controller;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.ComplateOrBackDtoReq;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugMainItemStatusDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.ExpressOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.MultiPrescriptionResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.ObtainPresReq;
import com.ebaiyihui.medicalcloud.pojo.dto.OprationDrugMainDto;
import com.ebaiyihui.medicalcloud.pojo.dto.OutpatientQueryPresDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.PrescriptionDetailDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.QueryDrugMainListReq;
import com.ebaiyihui.medicalcloud.pojo.dto.QueryPharmacistMainDto;
import com.ebaiyihui.medicalcloud.pojo.dto.UserAddressReq;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.ConfirmReceiptResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.DoctorListResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.DoctorListResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.ManageListResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.ManageListResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PatientListResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PatientListResVO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PatientListResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PresDetailResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PresDetailResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PresDrugStockResDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PresDrugStockResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.QueryPresStatusResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.SaveDrugStoreResDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsRouteEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.UserAddressEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.ConfireResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.ConfirmMedicineReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.DrugstoreBuyDrugReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.GetMainIdsReq;
import com.ebaiyihui.medicalcloud.pojo.vo.MultiPrescriptionRequestVO;
import com.ebaiyihui.medicalcloud.pojo.vo.OutAddressResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.OutpatientQueryPresVO;
import com.ebaiyihui.medicalcloud.pojo.vo.OutsidePrescriptionReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientNoTypeVO;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryPresCountReq;
import com.ebaiyihui.medicalcloud.pojo.vo.QueryPresRequestVO;
import com.ebaiyihui.medicalcloud.pojo.vo.SelectInquiryDrugsReq;
import com.ebaiyihui.medicalcloud.pojo.vo.SelectInquiryDrugsRes;
import com.ebaiyihui.medicalcloud.pojo.vo.ToTakeVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataEChartReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataEChartResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.board.PrescriptionDataResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.icd.CountDiagnosticVo;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.WaybillRouteVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.AuditPrescriptionCountReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.AuditPrescriptionCountResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.ConfirmDrugstoreReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.ManageDescReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.ManageDescResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.OutExportReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.OutExportResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.PatientSignFinished;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.PresCountReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.PresCountResVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.SubmitAuditingReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.third.PrescriptionRegulatoryInfoVo;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.service.UserAddressService;
import com.ebaiyihui.medicalcloud.utils.ExcelUtils;
import com.ebaiyihui.medicalcloud.utils.excel.ExpressInfo;
import com.ebaiyihui.medicalcloud.utils.excel.ExpressSimpleEInfo;
import com.ebaiyihui.medicalcloud.utils.excel.PrescriptionInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5904\u65b9 API"})
@RestController
@RequestMapping(value={"/api/prescription"})
public class PrescriptionController {
    private static final Logger log = LoggerFactory.getLogger(PrescriptionController.class);
    @Autowired
    private MosDrugPrescriptionService drugPrescriptionService;
    @Autowired
    private UserAddressService userAddressService;
    @Autowired
    private MosDrugMainService drugMainService;

    @ApiOperation(value="\u5f00\u5177\u5904\u65b9", notes="\u533b\u751f\u7aef\u5f00\u5177\u5904\u65b9")
    @PostMapping(value={"/v1/obtainPres"})
    public BaseResponse<Object> obtainPres(@RequestBody @Validated ObtainPresReq obtainPresReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            return this.drugPrescriptionService.obtainPres(obtainPresReq);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6dfb\u52a0\u60a3\u8005\u6536\u8d27\u5730\u5740", notes="\u6dfb\u52a0\u6536\u8d27\u5730\u5740")
    @PostMapping(value={"/v1/saveUserShipAddress"})
    public BaseResponse<UserAddressEntity> saveUserShipAddress(@RequestBody @Validated UserAddressReq userAddressReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.userAddressService.saveUserShipAddress(userAddressReq);
    }

    @ApiOperation(value="\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u6536\u8d27\u5730\u5740", notes="\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u6536\u8d27\u5730\u5740")
    @PostMapping(value={"/v1/outpatient/address/get"})
    public BaseResponse<List<OutAddressResVO>> getOutpatientAddress(@RequestBody @Validated List<String> orderIds) {
        return this.userAddressService.getOutpatientAddress(orderIds);
    }

    @ApiOperation(value="\u5728\u7ebf\u95e8\u8bca\u5bfc\u51fa\u5904\u65b9\u8ba2\u5355\u6570\u636e", notes="\u5728\u7ebf\u95e8\u8bca\u5bfc\u51fa\u5904\u65b9\u8ba2\u5355\u6570\u636e")
    @PostMapping(value={"/v1/outpatient/export"})
    public BaseResponse<List<OutExportResVo>> exportOutPres(@RequestBody @Validated OutExportReqVo vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.exportOutPres(vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5904\u65b9\u6536\u8d27\u5730\u5740", notes="\u83b7\u53d6\u5904\u65b9\u6536\u8d27\u5730\u5740")
    @GetMapping(value={"/getPresAddress"})
    public BaseResponse<UserAddressEntity> getPresAddress(@RequestParam(value="mainId", defaultValue="") String mainId) {
        return this.userAddressService.getPresAddress(mainId);
    }

    @ApiOperation(value="\u5ba1\u6838\u533b\u5e08\u5217\u8868", notes="\u5ba1\u6838\u533b\u5e08\u5217\u8868(WEB\u7aef\u548cAPP\u7aef)")
    @PostMapping(value={"/v1/getDrugMainList"})
    public BaseResponse<PageResult<QueryPharmacistMainDto>> getDrugMainList(@RequestBody QueryDrugMainListReq queryDrugMainListReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugMainService.queryPharmacistMainList(queryDrugMainListReq);
    }

    @ApiOperation(value="web\u7aef\u5904\u65b9\u53d1\u8d27\u7ba1\u7406+\u5168\u90e8\u5904\u65b9\u5217\u8868", notes="web\u7aef\u5904\u65b9\u53d1\u8d27\u7ba1\u7406+\u5168\u90e8\u5904\u65b9\u5217\u8868")
    @PostMapping(value={"/v1/getDeliveryList"})
    public BaseResponse<PageResult<QueryPharmacistMainDto>> getDeliveryList(@RequestBody QueryDrugMainListReq queryDrugMainListReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugMainService.liveryList(queryDrugMainListReq.getPatientNoType(), queryDrugMainListReq.getOrganCode(), queryDrugMainListReq.getTypeTime(), queryDrugMainListReq.getStartTime(), queryDrugMainListReq.getEndTime(), queryDrugMainListReq.getPageIndex(), queryDrugMainListReq.getPageSize(), queryDrugMainListReq.getStatus(), queryDrugMainListReq.getSearch(), queryDrugMainListReq.getUserType(), queryDrugMainListReq.getAppCode(), queryDrugMainListReq.getDoctorId());
    }

    @ApiOperation(value="\u533b\u751f\u5ba1\u6838\u5904\u65b9", notes="\u5ba1\u6838\u5904\u65b9")
    @PostMapping(value={"/v1/auditOperation"})
    public BaseResponse<String> auditOperation(@RequestBody @Validated OprationDrugMainDto oprationDrugMainDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugMainService.auditOperation(oprationDrugMainDto);
    }

    @ApiOperation(value="\u4fee\u6539\u5904\u65b9\u72b6\u6001", notes="\u4fee\u6539\u5904\u65b9\u72b6\u6001")
    @PostMapping(value={"/v1/updateItemStatusByMainId"})
    public BaseResponse<String> updateItemStatusByMainId(@RequestBody @Validated DrugMainItemStatusDTO drugMainItemStatusDTO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        this.drugMainService.updateItemStatusByMainId(drugMainItemStatusDTO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5b8c\u6210\u6216\u8005\u9000\u56de\u8c03\u914d", notes="\u5b8c\u6210/\u9000\u56de\u8c03\u914d")
    @PostMapping(value={"/v1/completeAndBackDeployment"})
    public BaseResponse<String> completeAndBackDeployment(@RequestBody @Validated ComplateOrBackDtoReq complateOrBackDtoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugMainService.completeDeployment(complateOrBackDtoReq);
    }

    @ApiOperation(value="\u533b\u5e08\u6dfb\u52a0\u5907\u6ce8", notes="\u6dfb\u52a0\u5907\u6ce8")
    @PostMapping(value={"/v1/addNotes"})
    public BaseResponse<String> addNotes(@RequestBody @Validated BaseOperationDto baseOperationDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugMainService.addNotes(baseOperationDto);
    }

    @ApiOperation(value="\u5feb\u9012\u53d1\u8d27", notes="\u5feb\u9012\u53d1\u8d27")
    @PostMapping(value={"/v1/expressDelivery"})
    public BaseResponse<String> expressDelivery(@RequestBody @Validated ExpressOperationDto expressOperationDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.expressPres(expressOperationDto);
    }

    @PostMapping(value={"/v1/pagingList/manage"})
    @ApiOperation(value="\u7ba1\u7406\u7aef\u5904\u65b9\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u5904\u65b9\u5217\u8868\u3001\u72b6\u6001\u7b5b\u9009\u3001\u65f6\u95f4\u7b5b\u9009\u3001\u533b\u751f\u60a3\u8005\u59d3\u540d\u641c\u7d22")
    public BaseResponse<PageResult<ManageListResultDTO>> pagingManage(@RequestBody @Validated PageResult<ManageListResDTO> param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.pagingManage(param);
    }

    @PostMapping(value={"/v1/pagingList/manage/desc"})
    @ApiOperation(value="\u7ba1\u7406\u7aef\u5904\u65b9\u5217\u8868\u63cf\u8ff0", notes="\u7ba1\u7406\u7aef\u5904\u65b9\u5217\u8868\u63cf\u8ff0\uff0c\u5305\u62ec\u8ba2\u5355\u603b\u6570\u3001\u5e94\u6536\u91d1\u989d\u3001\u5b9e\u6536\u91d1\u989d")
    public BaseResponse<ManageDescResVo> getDesc(@RequestBody @Validated ManageDescReqVo vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.getDesc(vo);
    }

    @PostMapping(value={"/v1/pagingList/doctor"})
    @ApiOperation(value="\u533b\u751f\u7aef\u5904\u65b9\u5217\u8868", notes="\u533b\u751f\u7aef\u5904\u65b9\u5217\u8868")
    public BaseResponse<PageResult<DoctorListResultDTO>> pagingDoctor(@RequestBody @Validated PageResult<DoctorListResDTO> param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.pagingDoctor(param);
    }

    @PostMapping(value={"/v1/pagingPatientList"})
    @ApiOperation(value="\u60a3\u8005\u7aef\u5386\u53f2\u5904\u65b9\u5217\u8868", notes="\u60a3\u8005\u7aef\u5386\u53f2\u5904\u65b9\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="token", value="\u7528\u6237TOKEN", paramType="header"), @ApiImplicitParam(name="pageNum", value="\u5f53\u524d\u9875", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u9875\u5bb9\u91cf", paramType="query"), @ApiImplicitParam(name="organCode", value="\u673a\u6784code", paramType="query"), @ApiImplicitParam(name="mainType", value="0 \u7ebf\u4e0a 1 \u7ebf\u4e0b", paramType="query"), @ApiImplicitParam(name="patientIdList", value="patientIdList  \u60a3\u8005id \u96c6\u5408 ", dataType="list", paramType="query")})
    public BaseResponse<PageResult<PatientListResultDTO>> pagingPatientList(@RequestBody @Validated PatientListResVO resVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.pagingPatientList(resVO);
    }

    @PostMapping(value={"/v1/pagingPatient"})
    @ApiOperation(value="\u60a3\u8005\u7aef\u5904\u65b9\u5217\u8868", notes="\u60a3\u8005\u7aef\u5904\u65b9\u5217\u8868")
    public BaseResponse<PageResult<PatientListResultDTO>> pagingPatient(@RequestBody @Validated PageResult<PatientListResDTO> param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.pagingPatient(param);
    }

    @PostMapping(value={"/v1/presDetail"})
    @ApiOperation(value="\u901a\u7528\u5904\u65b9\u8be6\u60c5", notes="\u5904\u65b9\u8be6\u60c5")
    public BaseResponse<PresDetailResultDTO> presDetail(@RequestBody @Validated PresDetailResDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.presDetail(dto);
    }

    @GetMapping(value={"/v1/queryPresStatus"})
    @ApiOperation(value="\u67e5\u8be2\u5904\u65b9\u533b\u5631\u72b6\u6001", notes="\u67e5\u8be2\u5904\u65b9\u533b\u5631\u72b6\u6001")
    public BaseResponse<QueryPresStatusResultDTO> queryPresStatus(@RequestParam(value="mainId", defaultValue="") String mainId) {
        return this.drugPrescriptionService.queryPresStatus(mainId);
    }

    @GetMapping(value={"/v1/toStream"})
    @ApiOperation(value="pdf\u8f6c\u6362\u6210\u5b57\u8282\u6d41", notes="pdf\u8f6c\u6362\u6210\u5b57\u8282\u6d41")
    public BaseResponse<byte[]> toStream(@RequestParam(value="ossUrl", defaultValue="") String ossUrl) {
        return this.drugPrescriptionService.toStream(ossUrl);
    }

    @PostMapping(value={"/v1/confirmReceipt"})
    @ApiOperation(value="\u786e\u8ba4\u6536\u8d27+\u786e\u8ba4\u53d6\u836f", notes="\u60a3\u8005\u786e\u8ba4\u6536\u8d27")
    public BaseResponse<Object> confirmReceipt(@RequestBody @Validated ConfirmReceiptResDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.confirmReceipt(dto);
    }

    @GetMapping(value={"/v1/exportExpressExcel"})
    @ApiOperation(value="\u5bfc\u51fa\u6536\u8d27\u4fe1\u606fexcel", notes="\u5bfc\u51faexcel")
    public void exportExpressExcel(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="status", defaultValue="0") Integer status, @RequestParam(value="timeType", defaultValue="0") Integer timeType, @RequestParam(value="startTime", defaultValue="") String startTime, @RequestParam(value="doctorId") String doctorId, @RequestParam(value="userType", defaultValue="") Integer userType, @RequestParam(value="endTime", defaultValue="") String endTime, @RequestParam(value="search", defaultValue="") String search, HttpServletResponse response) throws IOException {
        List list = this.drugMainService.exportExressInfo(appCode, timeType, startTime, endTime, status, search, doctorId, userType);
        if ("NCEFY".equalsIgnoreCase(appCode)) {
            ExcelUtils.exportExcel((List)list, null, (String)"\u6536\u4ef6\u4fe1\u606f", ExpressInfo.class, (String)"\u6536\u4ef6\u4fe1\u606f", (HttpServletResponse)response);
            return;
        }
        String json = JSON.toJSONString((Object)list);
        List infos = JSON.parseArray((String)json, ExpressSimpleEInfo.class);
        ExcelUtils.exportExcel((List)infos, null, (String)"\u6536\u4ef6\u4fe1\u606f", ExpressSimpleEInfo.class, (String)"\u6536\u4ef6\u4fe1\u606f", (HttpServletResponse)response);
    }

    @PostMapping(value={"/queryPresCount"})
    @ApiOperation(value="\u5728\u7ebf\u95e8\u8bca\u67e5\u8be2\u5904\u65b9\u6570\u636e", notes="\u5728\u7ebf\u95e8\u8bca\u67e5\u8be2\u5904\u65b9\u6570\u636e")
    public BaseResponse<Integer> queryPresCount(@RequestBody @Validated QueryPresCountReq queryPresCountReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.queryPresCount(queryPresCountReq);
    }

    @PostMapping(value={"/v1/presDrugStock"})
    @ApiOperation(value="\u5904\u65b9\u836f\u54c1\u5e93\u5b58", notes="\u67e5\u8be2\u5904\u65b9\u836f\u54c1\u5e93\u5b58")
    public BaseResponse<List<PresDrugStockResultDTO>> presDrugStock(@RequestBody @Validated PresDrugStockResDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.presDrugStock(dto);
    }

    @PostMapping(value={"/v1/savedrugstore"})
    @ApiOperation(value="\u60a3\u8005\u7aef\u9009\u62e9\u836f\u623f", notes="\u60a3\u8005\u7aef\u9009\u62e9\u836f\u623f")
    public BaseResponse<Object> saveDrugStore(@RequestBody @Validated SaveDrugStoreResDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.saveDrugStore(dto);
    }

    @PostMapping(value={"/v1/confirmdrugstore"})
    @ApiOperation(value="\u60a3\u8005\u7aef\u786e\u8ba4\u836f\u623f", notes="\u60a3\u8005\u7aef\u786e\u8ba4\u836f\u623f")
    public BaseResponse<Object> confirmDrugstore(@RequestBody @Validated ConfirmDrugstoreReqVo vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.confirmDrugstore(vo);
    }

    @PostMapping(value={"/v1/getprescriptiondetail"})
    @ApiOperation(value="\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u5904\u65b9\u8be6\u60c5", notes="\u5728\u7ebf\u95e8\u8bca\u83b7\u53d6\u5904\u65b9\u8be6\u60c5")
    public BaseResponse<Object> getPrescriptionDetail(@RequestBody @Validated PrescriptionDetailDTO dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.getPrescriptionDetail(dto);
    }

    @PostMapping(value={"/v1/synchPres"})
    public BaseResponse<String> synchPres(@RequestParam(value="mainId", defaultValue="") String mainId) {
        return this.drugMainService.synchPres(mainId);
    }

    @PostMapping(value={"/v1/count"})
    @ApiOperation(value="\u5904\u65b9\u7edf\u8ba1", notes="\u6240\u4ee5\u5ba1\u6838\u5df2\u901a\u8fc7\u7684\u5904\u65b9\u6570")
    public BaseResponse<PresCountResVo> count(@RequestBody @Validated PresCountReqVo vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.count(vo);
    }

    @ApiOperation(value="\u7269\u6d41\u8def\u7531\u67e5\u8be2\u63a5\u53e3")
    @GetMapping(value={"queryLogisticsRoute"})
    public BaseResponse<List<MosDrugLogisticsRouteEntity>> queryLogisticsRoute(@RequestParam(value="logisticsOrderId") Long logisticsOrderId) {
        return this.drugMainService.queryLogisticsRoute(logisticsOrderId);
    }

    @ApiOperation(value="\u7269\u6d41\u8def\u7531\u56de\u8c03")
    @PostMapping(value={"logisticsRouteCall"})
    String logisticsRouteCall(@RequestBody WaybillRouteVo waybillRouteVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return bindingResult.getFieldError().getDefaultMessage();
        }
        return this.drugMainService.logisticsRouteCall(waybillRouteVo);
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u786e\u8ba4\u6536\u8d27\u5df2\u5b8c\u6210")
    @PostMapping(value={"patientSignFinished"})
    BaseResponse patientSignFinished(@RequestBody PatientSignFinished patientSignFinished, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        this.drugMainService.patientSignFinished(patientSignFinished);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u901a\u7528\u7248\u672c\u786e\u8ba4\u53d1\u8d27", notes="\u901a\u7528\u7248\u672c\u786e\u8ba4\u53d1\u8d27")
    @PostMapping(value={"/v1/comfire"})
    public BaseResponse<Object> comfire(@RequestBody @Validated ConfireResVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.confirmDelivery(vo);
    }

    @PostMapping(value={"/v1/comfireMachine"})
    @ApiOperation(value="\u7ebf\u4e0b\u53d6\u836f\u786e\u8ba4\u53d6\u836f", notes="\u7ebf\u4e0b\u53d6\u836f\u786e\u8ba4\u53d6\u836f")
    public BaseResponse<Object> confirmMedicine(@RequestBody @Validated ConfirmMedicineReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.confirmMedicine(vo);
    }

    @PostMapping(value={"/v1/getPrescriptionRegulatoryInfo"})
    public BaseResponse<List<PrescriptionRegulatoryInfoVo>> getPrescriptionRegulatoryInfo(@RequestBody List<String> admIdList) {
        return this.drugPrescriptionService.getPrescriptionRegulatoryInfo(admIdList);
    }

    @PostMapping(value={"/v1/getMultiPres"})
    @ApiOperation(value="\u591a\u5904\u65b9\u5217\u8868", notes="\u591a\u5904\u65b9\u5217\u8868")
    public BaseResponse<List<MultiPrescriptionResDTO>> getMultiPres(@RequestBody @Validated MultiPrescriptionRequestVO multiPrescriptionRequersVO, BindingResult bindingResult) {
        return this.drugPrescriptionService.getMultiPres(multiPrescriptionRequersVO);
    }

    @PostMapping(value={"/v1/synAddressInfo"})
    public BaseResponse<Object> synAddressInfo() {
        return this.drugPrescriptionService.synAddressInfo();
    }

    @PostMapping(value={"/v1/submitauditing"})
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6838", notes="\u4e2d\u65e5HIS\u5bf9\u63a5\u63d0\u4ea4\u5ba1\u6838")
    public BaseResponse<Object> submitAuditing(@RequestBody @Validated SubmitAuditingReqVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.submitAuditing(vo);
    }

    @GetMapping(value={"/countDiagnostic"})
    @ApiOperation(value="\u7edf\u8ba1\u8bca\u65ad")
    public BaseResponse<List<CountDiagnosticVo>> countDiagnostic() {
        return this.drugMainService.countDiagnostic();
    }

    @ApiOperation(value="\u7535\u5b50\u5904\u65b9\u5bfc\u51fa")
    @GetMapping(value={"/exportExcel"})
    public void exportExcel(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="itemStatus", defaultValue="") Integer itemStatus, @RequestParam(value="startTime", defaultValue="") String startTime, @RequestParam(value="endTime", defaultValue="") String endTime, @RequestParam(value="keyword", defaultValue="") String keyword, @RequestParam(value="expressFlag", defaultValue="") Integer expressFlag, @RequestParam(value="listId", defaultValue="") List<String> listId, HttpServletResponse response) throws IOException {
        List list = this.drugPrescriptionService.exportExcel(appCode, itemStatus, startTime, endTime, keyword, expressFlag, listId);
        ExcelUtils.exportExcel((List)list, null, (String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f", PrescriptionInfo.class, (String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f", (HttpServletResponse)response);
    }

    @PostMapping(value={"/v1/outsidePrescription"})
    @ApiOperation(value="\u5916\u914d\u5904\u65b9", notes="\u5916\u914d\u5904\u65b9")
    public BaseResponse<Object> outsidePrescription(@RequestBody @Validated OutsidePrescriptionReqVo outsidePrescriptionReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.outsidePrescription(outsidePrescriptionReqVo);
    }

    @PostMapping(value={"/v1/drugstoreBuyDrug"})
    @ApiOperation(value="\u836f\u623f\u81ea\u53d6", notes="\u836f\u623f\u81ea\u53d6")
    public BaseResponse<Object> drugstoreBuyDrug(@RequestBody @Validated DrugstoreBuyDrugReqVo drugstoreBuyDrugReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.drugstoreBuyDrug(drugstoreBuyDrugReqVo);
    }

    @GetMapping(value={"/v1/queryPresType"})
    @ApiOperation(value="\u5728\u7ebf\u590d\u8bca\u83b7\u53d6\u5f00\u5904\u65b9\u72b6\u6001", notes="\u5728\u7ebf\u590d\u8bca\u83b7\u53d6\u5f00\u5904\u65b9\u72b6\u6001")
    public BaseResponse<List<QueryPresRequestVO>> queryPresType(@RequestParam String admIds) {
        if ("".equals(admIds) || admIds.isEmpty()) {
            return BaseResponse.error((String)"admIds\u4e3a\u7a7a");
        }
        return this.drugPrescriptionService.queryPresType(admIds);
    }

    @PostMapping(value={"/v1/updateMainStatus"})
    @ApiOperation(value="\u5728\u7ebf\u8d2d\u836f\u4fee\u6539\u5904\u65b9\u72b6\u6001", notes="\u5728\u7ebf\u8d2d\u836f\u4fee\u6539\u5904\u65b9\u72b6\u6001")
    public BaseResponse<String> updateMainStatus(@RequestBody @Validated PatientNoTypeVO patientNoTypeVO) {
        return this.drugPrescriptionService.updateMainStatus(patientNoTypeVO);
    }

    @PostMapping(value={"/v1/toTake"})
    @ApiOperation(value="\u533b\u9662\u81ea\u53d6", notes="\u822a\u59290615\u4e0a\u7ebf\u7248\u672c")
    public BaseResponse<Object> toTake(@RequestBody @Validated ToTakeVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.toTake(vo);
    }

    @PostMapping(value={"/v1/getAuditPrescriptionCount"})
    @ApiOperation(value="\u836f\u5e08\u7aef\u67e5\u8be2\u5f85\u5ba1\u5904\u65b9\u3001\u5df2\u5ba1\u6838\u5904\u65b9\u3001\u603b\u8ba1", notes="")
    public BaseResponse<AuditPrescriptionCountResVo> getAuditPrescriptionCount(@RequestBody @Validated AuditPrescriptionCountReqVo auditPrescriptionCountReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.getAuditPrescriptionCount(auditPrescriptionCountReqVo);
    }

    @PostMapping(value={"/v1/getPresInfo"})
    @ApiOperation(value="\u4e2d\u65e5\u5728\u7ebf\u590d\u8bca\u83b7\u53d6\u5904\u65b9\u652f\u4ed8\u4fe1\u606f", notes="\u4e2d\u65e5\u5728\u7ebf\u590d\u8bca\u83b7\u53d6\u5904\u65b9\u652f\u4ed8\u4fe1\u606f")
    public BaseResponse<List<OutpatientQueryPresDTO>> getPresInfo(@RequestBody @Validated OutpatientQueryPresVO vo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.getPresInfo(vo);
    }

    @PostMapping(value={"/v1/getDrugsByAdmissionIdAndAppCode"})
    @ApiOperation(value="\u67e5\u8be2\u590d\u8bca\u75c5\u5386\u836f\u54c1", notes="\u67e5\u8be2\u590d\u8bca\u75c5\u5386\u836f\u54c1")
    public BaseResponse<List<SelectInquiryDrugsRes>> getDrugsByAdmissionIdAndAppCode(@RequestBody @Validated SelectInquiryDrugsReq selectInquiryDrugsReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.getDrugsByAdmissionIdAndAppCode(selectInquiryDrugsReq);
    }

    @PostMapping(value={"/v1/getMainIdsByAdmIdAndAppCode"})
    @ApiOperation(value="\u590d\u8bca\u8bb0\u5f55\u8be6\u60c5\u9875\u83b7\u53d6\u5f00\u5177\u7684\u5904\u65b9\u8bb0\u5f55", notes="\u590d\u8bca\u8bb0\u5f55\u8be6\u60c5\u9875\u83b7\u53d6\u5f00\u5177\u7684\u5904\u65b9\u8bb0\u5f55")
    public BaseResponse<List<String>> getMainIdsByAdmIdAndAppCode(@RequestBody @Validated GetMainIdsReq getMainIdsReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.getMainIdsByAdmIdAndAppCode(getMainIdsReq);
    }

    @PostMapping(value={"/v1/getDataBoard"})
    @ApiOperation(value="\u6570\u636e\u770b\u677f-\u5904\u65b9\u8ba2\u5355", notes="\u6570\u636e\u770b\u677f-\u5904\u65b9\u8ba2\u5355")
    public BaseResponse<PrescriptionDataResVO> getDataBoard(@RequestBody @Validated PrescriptionDataReqVO prescriptionDataReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.getDataBoard(prescriptionDataReqVO);
    }

    @PostMapping(value={"/v1/getDataBoardEChart"})
    @ApiOperation(value="\u6570\u636e\u770b\u677f-\u5904\u65b9\u8ba2\u5355-\u56fe\u8868", notes="\u6570\u636e\u770b\u677f-\u5904\u65b9\u8ba2\u5355-\u56fe\u8868")
    public BaseResponse<PrescriptionDataEChartResVO> getDataBoardEChart(@RequestBody @Validated PrescriptionDataEChartReqVO prescriptionDataEChartReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.drugPrescriptionService.getDataBoardEChart(prescriptionDataEChartReqVO);
    }

    @PostMapping(value={"/v1/exportExcelDataBoard"})
    @ApiOperation(value="\u6570\u636e\u770b\u677f-\u5904\u65b9\u8ba2\u5355-\u5bfc\u51faexcel", notes="\u6570\u636e\u770b\u677f-\u5904\u65b9\u8ba2\u5355-\u5bfc\u51faexcel")
    public BaseResponse exportExcelDataBoard(@RequestBody @Validated PrescriptionDataEChartReqVO prescriptionDataEChartReqVO, HttpServletResponse response, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        this.drugPrescriptionService.exportExcelDataBoard(prescriptionDataEChartReqVO, response);
        return null;
    }
}

