/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.manage;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.medicalcloud.common.constants.BusinessConstant;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.exception.AsynException;
import com.ebaiyihui.medicalcloud.pojo.im.Message;
import com.ebaiyihui.medicalcloud.pojo.vo.AccountVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PushSingleMsgDataVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PushSingleMsgReqVO;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import java.util.ArrayList;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;

@Service
@EnableAsync
public class AsynManage {
    private static final Logger log = LoggerFactory.getLogger(AsynManage.class);
    @Autowired
    private NodeConfig nodeConfig;

    @Async
    public <T> void imPushMsgByMainId(String businessCode, String mainId, String hisRecipeNo, String appCode, String userId, String admissionId, T message, Integer messageType) {
        try {
            log.info("=====\u533b\u5631:{}\u5f00\u59cb\u53d1\u9001IM\u63a8\u9001", (Object)mainId);
            PushSingleMsgReqVO pushSingleMsgReqVO = new PushSingleMsgReqVO();
            pushSingleMsgReqVO.setBusiCode("zxzx");
            pushSingleMsgReqVO.setUniqueId(admissionId);
            ArrayList<PushSingleMsgDataVO> dataVOList = new ArrayList<PushSingleMsgDataVO>();
            PushSingleMsgDataVO pushSingleMsgDataVO = new PushSingleMsgDataVO();
            pushSingleMsgDataVO.setActionType("system");
            AccountVO toAccountVO = new AccountVO();
            toAccountVO.setAppCode(appCode);
            toAccountVO.setUserId(userId);
            pushSingleMsgDataVO.setToAccount(toAccountVO);
            Message stringMessage = new Message();
            stringMessage.setBusinessCode(businessCode);
            stringMessage.setMainId(mainId);
            stringMessage.setMessageType(messageType);
            stringMessage.setData(message);
            stringMessage.setAdmissionId(admissionId);
            stringMessage.setHisRecipeNo(hisRecipeNo);
            pushSingleMsgDataVO.setMessage(JSON.toJSONString((Object)stringMessage));
            pushSingleMsgDataVO.setSyncFlag(BusinessConstant.COMMON_DELAY_TIME);
            dataVOList.add(pushSingleMsgDataVO);
            pushSingleMsgReqVO.setMsgData(dataVOList);
            String url = new StringBuffer(this.nodeConfig.getAddress()).append("/cloud/imsys/impush/pushsinglemsg").toString();
            log.info("IM\u63a8\u9001\u8bf7\u6c42url:{},\u53c2\u6570:{}", (Object)url, (Object)JSON.toJSONString((Object)pushSingleMsgReqVO));
            String dataStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)pushSingleMsgReqVO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("IM\u63a8\u9001\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)dataStr);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AsynException(e.getMessage());
        }
    }
}

