/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.medicalcloud.common.enums.AuditStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DistributionTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.RemarkTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.exception.AsynException;
import com.ebaiyihui.medicalcloud.manage.LogisticsManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.DrugExtendMapper;
import com.ebaiyihui.medicalcloud.mapper.HospitalConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugstoreMapper;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugExtendEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugstoreEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderRegEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.OrderThirdVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.AddressQueryReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.BatchAddOrderResult;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.ComfireSendReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.ExtraQueryReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.FreightQueryReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalCreateOrderReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalCreateOrderResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.LocalPreCreateOrderReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.OrderDetailVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.ReceiveVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.SieveOrderReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.SieveOrderResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendMainDetailData;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.main.SendPresDetailResVO;
import com.ebaiyihui.medicalcloud.service.DrugExtendService;
import com.ebaiyihui.medicalcloud.service.LogisticService;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.service.hyt.HytPrescriptionService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.excel.LogisticInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogisticServiceImpl
implements LogisticService {
    private static final Logger log = LoggerFactory.getLogger(LogisticServiceImpl.class);
    @Autowired
    private LogisticsManage logisticsManage;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private MosDrugPrescriptionService prescriptionService;
    @Autowired
    private DrugExtendService drugExtendService;
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private HytPrescriptionService hytPrescriptionService;
    @Autowired
    private DrugExtendMapper drugExtendMapper;
    @Autowired
    private MosDrugRemarkMapper drugRemarkMapper;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugstoreMapper mosDrugstoreMapper;

    public BaseResponse<String> extraQuery(ExtraQueryReqVO vo) {
        vo.setExpressType("2");
        vo.setExpressType("2");
        if (vo.getAppCode().equals(this.specialNodeConfig.getHyt()) && (vo.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u4e1c\u5de5\u4e1a\u533a") || vo.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u897f\u5de5\u4e1a\u533a"))) {
            return BaseResponse.success((Object)BigDecimal.valueOf(0.0).toString());
        }
        HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(vo.getAppCode());
        DrugMainEntity drugMainEntity = null;
        if (configEntity != null) {
            if (this.specialNodeConfig.getHyt().equals(vo.getAppCode()) && StringUtils.isNotEmpty((String)vo.getMainId())) {
                if (vo.getLatitude() == null || vo.getLongitude() == null) {
                    return BaseResponse.error((String)"\u7ecf\u7eac\u5ea6\u7f3a\u5931");
                }
                drugMainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
                if (drugMainEntity == null) {
                    return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u533b\u5631\u8bb0\u5f55");
                }
            }
            if (StringUtils.isNotEmpty((String)vo.getMainId()) && drugMainEntity != null && drugMainEntity.getPatientNoType() != null && drugMainEntity.getPatientNoType() == 3) {
                if (vo.getDistributionType() == null) {
                    vo.setDistributionType(DistributionTypeEnum.CITY_EXPRESS.getValue());
                }
                DrugstoreEntity drugstoreEntity = this.mosDrugstoreMapper.queryById(drugMainEntity.getStoreId());
                LocalPreCreateOrderReqVO reqVO = new LocalPreCreateOrderReqVO();
                reqVO.setUserLat(vo.getLatitude());
                reqVO.setUserLng(vo.getLongitude());
                reqVO.setUserAddress(vo.getDestProvince() + vo.getDestCity() + vo.getDestDistrict() + vo.getDestAddress());
                return this.logisticsManage.localPrCreateOrder(reqVO, drugstoreEntity, configEntity, vo.getDistributionType());
            }
            SieveOrderReqVO sieveOrderReqVO = new SieveOrderReqVO();
            sieveOrderReqVO.setDestAddress(vo.getDestProvince() + vo.getDestCity() + vo.getDestDistrict() + vo.getDestAddress());
            sieveOrderReqVO.setSrcAddress(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress());
            SieveOrderResVO sieveOrderResVO = null;
            try {
                sieveOrderResVO = this.logisticsManage.sieveOrder(sieveOrderReqVO, configEntity);
            }
            catch (Exception e) {
                log.error("ERROR", (Throwable)e);
            }
            if (sieveOrderResVO != null && sieveOrderResVO.isFlag()) {
                FreightQueryReqVO freightQueryReqVO = new FreightQueryReqVO();
                BeanUtils.copyProperties((Object)vo, (Object)freightQueryReqVO);
                freightQueryReqVO.setSrcProvince(configEntity.getProvince());
                freightQueryReqVO.setSrcCity(configEntity.getCity());
                freightQueryReqVO.setSrcDistrict(configEntity.getDistrict());
                freightQueryReqVO.setSrcAddress(configEntity.getDetailAddress());
                return this.logisticsManage.freightQuery(vo.getLogisticsType(), freightQueryReqVO, configEntity);
            }
        }
        return BaseResponse.error((String)"\u7cfb\u7edf\u5f02\u5e38");
    }

    public BaseResponse<String> addressQuery(AddressQueryReqVO vo) {
        HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(vo.getAppCode());
        if (configEntity != null) {
            return BaseResponse.success((Object)(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress()));
        }
        return BaseResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u533b\u9662\u4fe1\u606f");
    }

    public List<LogisticInfo> exportExcel(String appCode, Integer timeType, String startTime, String endTime, Integer status, String search, List<Long> listId) {
        log.info("========>\u6570\u636e\u5bfc\u5165\u5165\u53c2------>appCode={},timeType={},startTime={},endTime={},status{},search,listId", new Object[]{appCode, timeType, startTime, endTime, status, search, listId});
        log.info("=======" + JSONObject.toJSONString(listId));
        ArrayList listStatus = new ArrayList();
        this.getDrugStatus(listStatus);
        List list = this.mosDrugLogisticsOrderMapper.getList(appCode, listStatus, status, search, timeType, startTime, endTime, listId);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList<LogisticInfo> infoList = new ArrayList<LogisticInfo>();
            Integer i = 1;
            for (MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity : list) {
                List mosDrugLogisticsOrderRegEntityList = this.mosDrugLogisticsOrderRegMapper.getByLogisticsOrderId(mosDrugLogisticsOrderEntity.getId());
                for (MosDrugLogisticsOrderRegEntity mosDrugLogisticsOrderRegEntity : mosDrugLogisticsOrderRegEntityList) {
                    DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mosDrugLogisticsOrderRegEntity.getMainId());
                    DrugPrescriptionEntity prescriptionEntity = this.prescriptionService.queryByMainId(mosDrugLogisticsOrderRegEntity.getMainId());
                    LogisticInfo logisticInfo = new LogisticInfo();
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                    logisticInfo.setId(String.valueOf(n));
                    logisticInfo.setOrderSeq(mosDrugLogisticsOrderEntity.getOrderSeq());
                    logisticInfo.setLogisticsName(mosDrugLogisticsOrderEntity.getLogisticsName());
                    logisticInfo.setMainNO(mosDrugLogisticsOrderEntity.getMainNo());
                    logisticInfo.setSrcName(mosDrugLogisticsOrderEntity.getSrcName());
                    logisticInfo.setDestName(mosDrugLogisticsOrderEntity.getDestName());
                    logisticInfo.setDestPhone(mosDrugLogisticsOrderEntity.getDestPhone());
                    logisticInfo.setDestAddress(mosDrugLogisticsOrderEntity.getDestAddress());
                    String result = "";
                    result = drugMainEntity.getItemStatus() == DrugMainStatusEnum.TO_SEND.getValue() ? DrugMainStatusEnum.TO_SEND.getDesc() : (drugMainEntity.getItemStatus() == DrugMainStatusEnum.TO_DELIVERY.getValue() ? DrugMainStatusEnum.TO_DELIVERY.getDesc() : (drugMainEntity.getItemStatus() == DrugMainStatusEnum.TO_TRANSPORT.getValue() ? DrugMainStatusEnum.TO_TRANSPORT.getDesc() : (drugMainEntity.getItemStatus() == DrugMainStatusEnum.SIGN_IN.getValue() ? DrugMainStatusEnum.SIGN_IN.getDesc() : DrugMainStatusEnum.FINISH.getDesc())));
                    logisticInfo.setStatus(result);
                    logisticInfo.setUpdateTime(mosDrugLogisticsOrderEntity.getUpdateTime().toString());
                    logisticInfo.setPrice(mosDrugLogisticsOrderEntity.getLogisticsBasisAmount().add(mosDrugLogisticsOrderEntity.getOverweightAmount()).add(mosDrugLogisticsOrderEntity.getPackageAmout()).toString());
                    logisticInfo.setHospitalName(mosDrugLogisticsOrderEntity.getHospitalName());
                    logisticInfo.setPresDoctorName(drugMainEntity.getPresDoctorName());
                    logisticInfo.setPatientName(drugMainEntity.getPatientName());
                    logisticInfo.setPatientNo(drugMainEntity.getPatientNo());
                    logisticInfo.setCount(this.mosDrugPrescriptionMapper.getCount(mosDrugLogisticsOrderRegEntity.getMainId()).toString());
                    logisticInfo.setOtherPrice(prescriptionEntity.getPrice().toString());
                    DrugExtendEntity extendEntity = this.drugExtendService.getByMainId(mosDrugLogisticsOrderRegEntity.getMainId());
                    if (Objects.nonNull(extendEntity)) {
                        logisticInfo.setDeployer(extendEntity.getDeployer());
                        logisticInfo.setDeployTime(extendEntity.getDeployTime() == null ? "" : DateTimeUtil.formatTime((Date)extendEntity.getDeployTime()));
                        logisticInfo.setSender(extendEntity.getSender());
                        logisticInfo.setSendTime(extendEntity.getSendTime() == null ? "" : DateTimeUtil.formatTime((Date)extendEntity.getSendTime()));
                    }
                    infoList.add(logisticInfo);
                }
            }
            return infoList;
        }
        return null;
    }

    private void getDrugStatus(List<Integer> listStatus) {
        listStatus.add(DrugMainStatusEnum.TO_SEND.getValue());
        listStatus.add(DrugMainStatusEnum.TO_TRANSPORT.getValue());
        listStatus.add(DrugMainStatusEnum.TO_DELIVERY.getValue());
        listStatus.add(DrugMainStatusEnum.SIGN_IN.getValue());
        listStatus.add(DrugMainStatusEnum.SENT.getValue());
        listStatus.add(DrugMainStatusEnum.FINISH.getValue());
    }

    public BaseResponse<Object> confirmSend(ComfireSendReqVO vo) {
        log.info("======>\u786e\u8ba4\u53d1\u8d27 - \u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        String mainNo = "";
        SendPresDetailReqVO reqVO = new SendPresDetailReqVO();
        reqVO.setLogisticsId(vo.getLogisticsOrderId());
        BaseResponse response = this.hytPrescriptionService.sendPresDetail(reqVO);
        if (response == null) {
            return BaseResponse.error((String)"\u533b\u5631\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByPrimaryKey(Long.valueOf(vo.getLogisticsOrderId()));
        if (mosDrugLogisticsOrderEntity == null) {
            return BaseResponse.error((String)"\u7269\u6d41\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
        }
        SendPresDetailResVO resVO = (SendPresDetailResVO)response.getData();
        if (mosDrugLogisticsOrderEntity.getAppCode().equals(this.specialNodeConfig.getHyt()) && (mosDrugLogisticsOrderEntity.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u4e1c\u5de5\u4e1a\u533a") || mosDrugLogisticsOrderEntity.getDestAddress().contains("\u822a\u5929\u4e8c\u9662\u897f\u5de5\u4e1a\u533a"))) {
            log.info("===\u822a\u5929\u4e8c\u9662\u4e1c\u5de5\u4e1a\u533a\uff0c\u822a\u5929\u4e8c\u9662\u897f\u5de5\u4e1a\u533a\u514d\u7269\u6d41\u53d1\u8d27====");
            List mainIds = resVO.getSendMainDetailList().stream().map(v -> v.getMainId()).collect(Collectors.toList());
            mainIds.stream().forEach(mainId -> {
                DrugMainEntity tempDrugMainEntity = this.mosDrugMainMapper.queryById(mainId);
                tempDrugMainEntity.setItemStatus(DrugMainStatusEnum.SENT.getValue());
                this.mosDrugMainMapper.update(tempDrugMainEntity);
            });
            return BaseResponse.success((Object)"\u8be5\u60a3\u8005\u4e3a\u822a\u5929\u4e8c\u9662\u804c\u5de5\uff0c\u533b\u9662\u4f1a\u6709\u4e13\u4eba\u53d6\u836f\uff0c\u836f\u623f\u65e0\u9700\u914d\u9001");
        }
        mosDrugLogisticsOrderEntity.setRemark(mosDrugLogisticsOrderEntity.getRemark() + "    " + vo.getSendRemark());
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByAppcode(mosDrugLogisticsOrderEntity.getAppCode());
        if (DistributionTypeEnum.CROSS_POINT.getValue().equals(mosDrugLogisticsOrderEntity.getDistributionType()) || DistributionTypeEnum.CITY_EXPRESS.getValue().equals(mosDrugLogisticsOrderEntity.getDistributionType())) {
            String storeId;
            if (CollectionUtils.isNotEmpty((Collection)resVO.getSendMainDetailList()) && StringUtils.isNotEmpty((String)(storeId = ((SendMainDetailData)resVO.getSendMainDetailList().get(0)).getStoreId()))) {
                DrugstoreEntity drugstoreEntity = this.mosDrugstoreMapper.queryById(storeId);
                LocalCreateOrderReqVO localCreateOrderReqVO = new LocalCreateOrderReqVO();
                ReceiveVO receiveVO = new ReceiveVO();
                receiveVO.setCityName(mosDrugLogisticsOrderEntity.getDestCity());
                receiveVO.setUserName(mosDrugLogisticsOrderEntity.getDestName());
                receiveVO.setUserPhone(mosDrugLogisticsOrderEntity.getDestPhone());
                receiveVO.setUserAddress(mosDrugLogisticsOrderEntity.getDestAddress());
                receiveVO.setUserLat(mosDrugLogisticsOrderEntity.getDestLatitude());
                receiveVO.setUserLng(mosDrugLogisticsOrderEntity.getDestLongitude());
                OrderDetailVO orderDetailVO = new OrderDetailVO();
                orderDetailVO.setTotalPrice(Integer.valueOf(mosDrugLogisticsOrderEntity.getPayAmount().subtract(mosDrugLogisticsOrderEntity.getOverweightAmount()).subtract(mosDrugLogisticsOrderEntity.getPackageAmout()).multiply(new BigDecimal(100)).intValue()));
                orderDetailVO.setProductType(Integer.valueOf(2));
                orderDetailVO.setWeightGram(Integer.valueOf(1000));
                orderDetailVO.setProductNum(Integer.valueOf(1));
                orderDetailVO.setProductTypeNum(Integer.valueOf(1));
                localCreateOrderReqVO.setReceive(receiveVO);
                localCreateOrderReqVO.setOrderDetail(orderDetailVO);
                localCreateOrderReqVO.setUserLat(mosDrugLogisticsOrderEntity.getDestLatitude());
                localCreateOrderReqVO.setUserLng(mosDrugLogisticsOrderEntity.getDestLongitude());
                localCreateOrderReqVO.setUserAddress(mosDrugLogisticsOrderEntity.getDestAddress());
                localCreateOrderReqVO.setShopOrderId(mosDrugLogisticsOrderEntity.getOrderSeq());
                localCreateOrderReqVO.setRemark(mosDrugLogisticsOrderEntity.getRemark());
                BaseResponse baseResponse = this.logisticsManage.localCreateOrder(localCreateOrderReqVO, drugstoreEntity, hospitalConfigEntity, mosDrugLogisticsOrderEntity.getDistributionType());
                if (baseResponse == null) {
                    return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                if (!ReturnCodeEnum.SUCCEED.getValue().equals(baseResponse.getCode())) {
                    return BaseResponse.error((String)baseResponse.getMsg());
                }
                mainNo = ((LocalCreateOrderResVO)baseResponse.getData()).getSfBillId();
            }
        } else {
            OrderThirdVO orderThirdVO = new OrderThirdVO();
            ArrayList<OrderThirdVO> list = new ArrayList<OrderThirdVO>();
            orderThirdVO.setPatientName(resVO.getPatientName());
            orderThirdVO.setPatientPhone(resVO.getPatientPhone());
            orderThirdVO.setBspOrderNo(mosDrugLogisticsOrderEntity.getOrderSeq());
            orderThirdVO.setPayMethod(mosDrugLogisticsOrderEntity.getLogisticsPayMethod().toString());
            orderThirdVO.setExpressType(mosDrugLogisticsOrderEntity.getExpressType().toString());
            orderThirdVO.setSrcName(mosDrugLogisticsOrderEntity.getSrcName());
            orderThirdVO.setSrcPhone(mosDrugLogisticsOrderEntity.getSrcPhone());
            orderThirdVO.setSrcProvince(mosDrugLogisticsOrderEntity.getSrcProvince());
            orderThirdVO.setSrcCity(mosDrugLogisticsOrderEntity.getSrcCity());
            orderThirdVO.setSrcAddress(mosDrugLogisticsOrderEntity.getSrcAddress());
            orderThirdVO.setSrcDistrict(mosDrugLogisticsOrderEntity.getSrcDistrict());
            orderThirdVO.setDestName(mosDrugLogisticsOrderEntity.getDestName());
            orderThirdVO.setDestPhone(mosDrugLogisticsOrderEntity.getDestPhone());
            orderThirdVO.setDestProvince(mosDrugLogisticsOrderEntity.getDestProvince());
            orderThirdVO.setDestCity(mosDrugLogisticsOrderEntity.getDestCity());
            orderThirdVO.setDestAddress(mosDrugLogisticsOrderEntity.getDestDetailAddress());
            orderThirdVO.setDestDistrict(mosDrugLogisticsOrderEntity.getDestDistrict());
            orderThirdVO.setParcelWeighs(mosDrugLogisticsOrderEntity.getParcelWeighs());
            orderThirdVO.setPackagesNo(Integer.valueOf(mosDrugLogisticsOrderEntity.getPackageNo() == null ? 1 : mosDrugLogisticsOrderEntity.getPackageNo()));
            orderThirdVO.setDepositumInfo(mosDrugLogisticsOrderEntity.getDepositumInfo());
            orderThirdVO.setDepositumNo(mosDrugLogisticsOrderEntity.getDepositumNo() == null ? "1" : mosDrugLogisticsOrderEntity.getDepositumNo().toString());
            orderThirdVO.setMonthlyCard(mosDrugLogisticsOrderEntity.getMonthlyCard());
            orderThirdVO.setProductCode(mosDrugLogisticsOrderEntity.getProductCode());
            orderThirdVO.setRemark(mosDrugLogisticsOrderEntity.getRemark());
            list.add(orderThirdVO);
            BaseResponse baseResponse = this.logisticsManage.batchAddOrder(list, hospitalConfigEntity);
            if (baseResponse == null || baseResponse.getData() == null) {
                return BaseResponse.error((String)"\u8c03\u7528\u7269\u6d41\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            if (CollectionUtils.isNotEmpty((Collection)((BatchAddOrderResult)baseResponse.getData()).getFailResult())) {
                return BaseResponse.error((String)((BatchAddOrderResult.FailResultBean)((BatchAddOrderResult)baseResponse.getData()).getFailResult().get(0)).getMessage());
            }
            mainNo = ((BatchAddOrderResult.SuccessResultBean)((BatchAddOrderResult)baseResponse.getData()).getSuccessResult().get(0)).getMailNo();
        }
        if (StringUtils.isNotEmpty((String)mainNo)) {
            mosDrugLogisticsOrderEntity.setMainNo(mainNo);
        }
        this.mosDrugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
        List mainIds = resVO.getSendMainDetailList().stream().map(v -> v.getMainId()).collect(Collectors.toList());
        mainIds.stream().forEach(mainId -> {
            DrugExtendEntity drugExtendEntity = this.drugExtendMapper.getByMainId(mainId);
            if (drugExtendEntity == null) {
                drugExtendEntity = new DrugExtendEntity();
                drugExtendEntity.setDeployTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setMainId(mainId);
                drugExtendEntity.setxId(GenSeqUtils.getUniqueNo());
                drugExtendEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setAuditStatus(AuditStatusEnum.PASS_STATUS.getValue());
                this.drugExtendMapper.insert(drugExtendEntity);
            } else {
                drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setSender(vo.getSender());
                drugExtendEntity.setSendTime(new Date());
                drugExtendEntity.setSendRemark(vo.getSendRemark());
                this.drugExtendMapper.updateById(drugExtendEntity);
            }
            DrugRemarkEntity remarkEntity = new DrugRemarkEntity();
            remarkEntity.setRemarkType(RemarkTypeEnum.CONFIRMSHIPMENT.getValue());
            remarkEntity.setMainId(mainId);
            remarkEntity.setRemarkUser(vo.getSender());
            remarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            remarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            remarkEntity.setxId(GenSeqUtils.getUniqueNo());
            this.drugRemarkMapper.insert(remarkEntity);
            DrugMainEntity tempDrugMainEntity = this.mosDrugMainMapper.queryById(mainId);
            tempDrugMainEntity.setItemStatus(DrugMainStatusEnum.SENT.getValue());
            this.mosDrugMainMapper.update(tempDrugMainEntity);
        });
        new Thread(() -> {
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", resVO.getPresDoctorName());
            data.put("doctorName", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", "\u836f\u54c1\u8c03\u914d\u5b8c\u6210");
            data.put("issue", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", "\u836f\u54c1\u5df2\u8c03\u914d\u5b8c\u6210\uff0c\u6b63\u5728\u5b89\u6392\u7269\u6d41\u8fdb\u884c\u53d1\u8d27\u3002");
            data.put("info", map3);
            this.pushManage.iWeChatPush(resVO.getAppCode(), "inquiry_common_notify", this.pushManage.getOpenId(resVO.getAppCode(), resVO.getPatientUserId()), data, null);
            try {
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(resVO.getAppCode(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("doctorName", resVO.getPresDoctorName());
                this.pushManage.iSMSPush("ali", resVO.getAppCode(), signCode, "yyy-apps", resVO.getPatientPhone(), hashMap);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new AsynException(e.getMessage());
            }
        }).start();
        return BaseResponse.success();
    }
}

