/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.SpecialDrugFlagEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.mapper.DrugAliasMapper;
import com.ebaiyihui.medicalcloud.mapper.DrugFrequencyMapper;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugGroupMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugItemUsageRelMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPriceMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugReasonMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugUnitMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugUsageMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugstoreMapper;
import com.ebaiyihui.medicalcloud.mapper.OrganDrugRelMapper;
import com.ebaiyihui.medicalcloud.mapper.PharmaceuticalCompanyDrugRelMapper;
import com.ebaiyihui.medicalcloud.mapper.PharmaceuticalCompanyMapper;
import com.ebaiyihui.medicalcloud.mapper.StoreDrugRelMapper;
import com.ebaiyihui.medicalcloud.mapper.StoreStockRelMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.CountDrugDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemDetailFrequency;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemDetailQueryResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemDetailReason;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemQueryResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugItemResDto;
import com.ebaiyihui.medicalcloud.pojo.dto.HospDrug;
import com.ebaiyihui.medicalcloud.pojo.dto.SynchronizationDeugItemDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.DrugItemReqDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.drug.DrugSearchResultDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.his.ResponseResDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugAliasEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugFrequencyEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemUsageRelEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPriceEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUnitEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUsageEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugReasonEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.OrganDrugRelEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.PharmaceuticalCompanyDrugRelEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.PharmaceuticalCompanyEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.StoreDrugRelEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.StoreStockRelEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.AddDrugItemVO;
import com.ebaiyihui.medicalcloud.pojo.vo.DrugItemVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.DrugCountReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.PatientChooseDrugReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.drugItem.PatientChooseDrugResVo;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.service.ManageDrugItemService;
import com.ebaiyihui.medicalcloud.utils.AppCodeUtil;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.HanyuPinyinUtil;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import com.ebaiyihui.medicalcloud.utils.excel.DrugItemChineseExcel;
import com.ebaiyihui.medicalcloud.utils.excel.DrugItemExcel;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ManageDrugItemServiceImpl
implements ManageDrugItemService {
    private static final Logger log = LoggerFactory.getLogger(ManageDrugItemServiceImpl.class);
    public static final int ONE = 1;
    public static final int ZERO = 0;
    @Autowired
    private DrugItemMapper drugItemMapper;
    @Autowired
    private MosDrugPriceMapper mosDrugPriceMapper;
    @Autowired
    private DrugAliasMapper drugAliasMapper;
    @Autowired
    private MosDrugItemUsageRelMapper mosDrugItemUsageRelMapper;
    @Autowired
    private StoreDrugRelMapper storeDrugRelMapper;
    @Autowired
    private OrganDrugRelMapper organDrugRelMapper;
    @Autowired
    private MosDrugUnitMapper mosDrugUnitMapper;
    @Autowired
    private MosDrugUsageMapper mosDrugUsageMapper;
    @Autowired
    private DrugFrequencyMapper drugFrequencyMapper;
    @Autowired
    private MosDrugReasonMapper mosDrugReasonMapper;
    @Autowired
    private StoreStockRelMapper storeStockRelMapper;
    @Autowired
    private MosDrugstoreMapper mosDrugstoreMapper;
    @Autowired
    private MosDrugGroupMapper mosDrugGroupMapper;
    @Autowired
    private PharmaceuticalCompanyMapper pharmaceuticalCompanyMapper;
    @Autowired
    private PharmaceuticalCompanyDrugRelMapper pharmaceuticalCompanyDrugRelMapper;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private HisLogService hisLogService;
    public static final String ACCESS_TOKEN = "02c426435c354de5aadfa8e03252c4a5";

    public BaseResponse<List<DrugItemResDto>> findDrugItemList(Integer pageIndex, Integer pageSize, Integer status, String appCode, String search, String pharmaceuticalCompanyId, Integer specialDrugType) {
        appCode = AppCodeUtil.tranCode((String)appCode);
        ArrayList<DrugItemResDto> listRes = new ArrayList<DrugItemResDto>();
        int total = 0;
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List drugItemEntityList = this.drugItemMapper.getList(status, appCode, search, pharmaceuticalCompanyId, specialDrugType);
        total = this.drugItemMapper.getList(status, appCode, search, pharmaceuticalCompanyId, specialDrugType).size();
        for (DrugItemReqDTO drugItemEntity : drugItemEntityList) {
            DrugItemUsageRelEntity usageRelEntity;
            DrugItemResDto resVO = new DrugItemResDto();
            BeanUtils.copyProperties((Object)drugItemEntity, (Object)resVO);
            resVO.setDrugItemId(drugItemEntity.getxId());
            DrugPriceEntity priceEntity = this.mosDrugPriceMapper.getByDrugIdAndStoreId(drugItemEntity.getxId(), appCode);
            if (Objects.isNull(priceEntity)) {
                resVO.setPrice(drugItemEntity.getPrice());
            } else {
                resVO.setPrice(priceEntity.getPrice());
            }
            List listAlias = this.drugAliasMapper.getByDrugId(drugItemEntity.getxId());
            ArrayList<String> list = new ArrayList<String>();
            if (!listAlias.isEmpty()) {
                for (DrugAliasEntity drugAliasEntity : listAlias) {
                    list.add(drugAliasEntity.getDrugAlias());
                }
            }
            if ((usageRelEntity = this.mosDrugItemUsageRelMapper.getByDrugId(drugItemEntity.getxId())) != null) {
                resVO.setUsageId(usageRelEntity.getUsageId());
            }
            resVO.setIsDistributionStatic(Integer.valueOf(StringUtils.isNotEmpty((String)drugItemEntity.getSpecialDrugFlag()) && drugItemEntity.getSpecialDrugFlag().contains(SpecialDrugFlagEnum.STZS.getValue()) ? 1 : 0));
            resVO.setLineDrugType(Integer.valueOf(drugItemEntity.getSpecialDrugFlag() != null && drugItemEntity.getSpecialDrugFlag().contains(SpecialDrugFlagEnum.OUTLINE.getValue()) ? 1 : 0));
            resVO.setDrugAlias(list);
            resVO.setCount(Integer.valueOf(total));
            listRes.add(resVO);
        }
        return BaseResponse.success(listRes);
    }

    public BaseResponse<CountDrugDto> findDrugCount(String appCode) {
        appCode = AppCodeUtil.tranCode((String)appCode);
        Integer count = this.drugItemMapper.getDrugItemCount(appCode);
        Integer count2 = this.drugItemMapper.getStockCount(appCode);
        Integer count3 = this.drugItemMapper.getStopCount(appCode);
        CountDrugDto countDrugDto = new CountDrugDto();
        countDrugDto.setDrugItemCount(count.intValue());
        countDrugDto.setStockCount(count2.intValue());
        countDrugDto.setStopCount(count3.intValue());
        return BaseResponse.success((Object)countDrugDto);
    }

    public BaseResponse<String> updateDrugItemStatus(List<String> ids, Integer status) {
        log.info("\u4fee\u6539\u836f\u54c1\u72b6\u6001=====>ids:{},status:{}", ids, (Object)status);
        ArrayList<StoreStockRelEntity> list = new ArrayList<StoreStockRelEntity>();
        for (String id : ids) {
            StoreStockRelEntity entity = new StoreStockRelEntity();
            entity.setDrugId(id);
            DrugItemEntity drugItemEntity = this.drugItemMapper.getById(id);
            log.info("\u4fee\u6539\u836f\u54c1\u72b6\u6001=====>drugItemEntity:{}", (Object)JSON.toJSONString((Object)drugItemEntity));
            if (drugItemEntity.getStatus() == status) continue;
            if (drugItemEntity.getStatus() == 1 && status == 3) {
                entity.setStatus(Integer.valueOf(0));
            }
            if (drugItemEntity.getStatus() == 3 && status == 1) {
                entity.setStatus(Integer.valueOf(1));
            }
            list.add(entity);
            drugItemEntity.setStatus(status);
            this.drugItemMapper.updateById(drugItemEntity);
        }
        log.info("\u4fee\u6539\u836f\u54c1\u72b6\u6001=====>\u4fee\u6539\u5e93\u5b58:{}", (Object)JSON.toJSONString(list));
        if (CollectionUtils.isNotEmpty(list)) {
            this.storeStockRelMapper.updateBatchByDrugId(list);
        }
        return BaseResponse.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    public BaseResponse<String> deleteDrugItemById(String drugId) {
        DrugItemEntity drugItemEntity = this.drugItemMapper.getById(drugId);
        if (drugItemEntity == null) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u836f\u54c1\u76f8\u5173\u4fe1\u606f\u6216\u5f53\u524d\u836f\u54c1\u5df2\u7ecf\u5220\u9664");
        }
        ArrayList<StoreStockRelEntity> list = new ArrayList<StoreStockRelEntity>();
        StoreStockRelEntity entity = new StoreStockRelEntity();
        entity.setDrugId(drugId);
        entity.setStatus(Integer.valueOf(0));
        list.add(entity);
        if (drugItemEntity.getStatus() == 1) {
            this.storeStockRelMapper.updateBatchByDrugId(list);
        }
        drugItemEntity.setStatus(Integer.valueOf(0));
        this.drugItemMapper.updateById(drugItemEntity);
        ArrayList<String> parm = new ArrayList<String>();
        parm.add(drugId);
        return BaseResponse.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> addDrugItem(AddDrugItemVO vo) {
        StoreStockRelEntity stockRelEntity;
        vo.setAppCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        String commonCode = this.drugItemMapper.getByCommonCode(vo.getCommonCode(), vo.getAppCode());
        if (StringUtils.isNotEmpty((String)commonCode)) {
            return BaseResponse.error((String)"\u901a\u7528\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        DrugItemEntity entity = new DrugItemEntity();
        String drugId = GenSeqUtils.getUniqueNo();
        entity.setCommonName(vo.getCommonName());
        entity.setCommonCode(vo.getCommonCode());
        entity.setProductName(vo.getProductName());
        entity.setProductCode(vo.getProductCode());
        if (StringUtils.isNotEmpty((String)vo.getMinBillPackingUnitId())) {
            entity.setMinBillPackingUnitId(vo.getMinBillPackingUnitId());
            entity.setMinBillPackingUnitName(this.mosDrugUnitMapper.queryById(vo.getMinBillPackingUnitId()).getUnitName());
        }
        if (StringUtils.isNotEmpty((String)vo.getStockPackingUnitId())) {
            entity.setStockPackingUnitId(vo.getMinBillPackingUnitId());
            entity.setStockPackingUnitName(this.mosDrugUnitMapper.queryById(vo.getMinBillPackingUnitId()).getUnitName());
        }
        if (StringUtils.isNotEmpty((String)vo.getMeasureUnitId())) {
            entity.setMeasureUnitId(vo.getMeasureUnitId());
            entity.setMeasureUnitName(this.mosDrugUnitMapper.queryById(vo.getMeasureUnitId()).getUnitName());
        }
        if (StringUtils.isNotEmpty((String)vo.getWholePackingUnitId())) {
            entity.setWholePackingUnitId(vo.getWholePackingUnitId());
            entity.setWholePackingUnitName(this.mosDrugUnitMapper.queryById(vo.getWholePackingUnitId()).getUnitName());
            entity.setSpecPackingUnitId(vo.getMinBillPackingUnitId());
            entity.setSpecPackingUnitName(this.mosDrugUnitMapper.queryById(vo.getMinBillPackingUnitId()).getUnitName());
        }
        entity.setMinBillPackingNum(vo.getMinBillPackingNum());
        entity.setManufacturer(vo.getManufacturer());
        entity.setMeasureNum(vo.getMeasureNum());
        entity.setDosageForm(vo.getDosageForm());
        entity.setStorageConditions(vo.getStorageConditions());
        entity.setxId(drugId);
        entity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        entity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        entity.setWholePackingNum(vo.getWholePackingNum());
        entity.setDrugSpec(vo.getDrugSpec());
        entity.setHospitalDrugSpec(vo.getDrugSpec());
        entity.setStatus(vo.getStatus());
        entity.setType(Integer.valueOf(1));
        entity.setAppCode(vo.getAppCode());
        entity.setPrice(vo.getPrice());
        entity.setSpecialDrugFlag(Integer.valueOf(1).equals(vo.getLineDrugType()) ? SpecialDrugFlagEnum.OUTLINE.getValue() : null);
        entity.setSpecialDrugFlag(Integer.valueOf(1).equals(vo.getIsDistributionStatic()) ? entity.getSpecialDrugFlag() + "," + SpecialDrugFlagEnum.STZS.getValue() : entity.getSpecialDrugFlag());
        this.drugItemMapper.insert(entity);
        StoreDrugRelEntity storeDrugRelEntity = new StoreDrugRelEntity();
        storeDrugRelEntity.setDrugId(entity.getxId());
        storeDrugRelEntity.setStatus(Integer.valueOf(1));
        storeDrugRelEntity.setxId(GenSeqUtils.getUniqueNo());
        storeDrugRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        storeDrugRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.storeDrugRelMapper.insert(storeDrugRelEntity);
        DrugItemUsageRelEntity usageRelEntity = new DrugItemUsageRelEntity();
        usageRelEntity.setStatus(Integer.valueOf(1));
        usageRelEntity.setDrugId(entity.getxId());
        usageRelEntity.setUsageId(vo.getUsageId());
        usageRelEntity.setxId(GenSeqUtils.getUniqueNo());
        usageRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        usageRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.mosDrugItemUsageRelMapper.insert(usageRelEntity);
        if (CollectionUtils.isNotEmpty((Collection)vo.getDrugAlias())) {
            this.drugAliasMapper(vo.getDrugAlias(), vo.getCommonCode(), vo.getAppCode(), entity.getxId());
        }
        OrganDrugRelEntity organDrugRelEntity = new OrganDrugRelEntity();
        organDrugRelEntity.setDrugId(entity.getxId());
        organDrugRelEntity.setOrganCode(vo.getAppCode());
        organDrugRelEntity.setArcimPrice(vo.getPrice());
        organDrugRelEntity.setStatus(Integer.valueOf(1));
        organDrugRelEntity.setxId(GenSeqUtils.getUniqueNo());
        organDrugRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        organDrugRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.organDrugRelMapper.insert(organDrugRelEntity);
        DrugPriceEntity priceEntity = new DrugPriceEntity();
        priceEntity.setDrugId(entity.getxId());
        priceEntity.setPrice(vo.getPrice());
        priceEntity.setxId(GenSeqUtils.getUniqueNo());
        priceEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        priceEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        priceEntity.setOrganDrugRelId(organDrugRelEntity.getxId());
        this.mosDrugPriceMapper.insert(priceEntity);
        if (StringUtils.isNotEmpty((String)vo.getPharmaceuticalCompanyId())) {
            PharmaceuticalCompanyDrugRelEntity pharmaceuticalCompanyDrugRelEntity = new PharmaceuticalCompanyDrugRelEntity();
            pharmaceuticalCompanyDrugRelEntity.setId(GenSeqUtils.getUniqueNo());
            pharmaceuticalCompanyDrugRelEntity.setDrugId(drugId);
            pharmaceuticalCompanyDrugRelEntity.setPharmaceuticalCompanyId(vo.getPharmaceuticalCompanyId());
            this.pharmaceuticalCompanyDrugRelMapper.insertSelective(pharmaceuticalCompanyDrugRelEntity);
        }
        ArrayList<StoreStockRelEntity> storeStockRelEntities = new ArrayList<StoreStockRelEntity>();
        List storeIds = this.mosDrugstoreMapper.getIdsByStatus(Integer.valueOf(1), vo.getAppCode());
        if (vo.getStatus() == 1) {
            for (String storeId : storeIds) {
                stockRelEntity = new StoreStockRelEntity();
                stockRelEntity.setxId(GenSeqUtils.getUniqueNo());
                stockRelEntity.setStockStatus(Integer.valueOf(1));
                stockRelEntity.setStatus(Integer.valueOf(1));
                stockRelEntity.setStoreId(storeId);
                stockRelEntity.setDrugId(drugId);
                storeStockRelEntities.add(stockRelEntity);
            }
        }
        if (vo.getStatus() == 3) {
            for (String storeId : storeIds) {
                stockRelEntity = new StoreStockRelEntity();
                stockRelEntity.setxId(GenSeqUtils.getUniqueNo());
                stockRelEntity.setStockStatus(Integer.valueOf(1));
                stockRelEntity.setStatus(Integer.valueOf(0));
                stockRelEntity.setStoreId(storeId);
                stockRelEntity.setDrugId(drugId);
                storeStockRelEntities.add(stockRelEntity);
            }
        }
        if (CollectionUtils.isNotEmpty(storeStockRelEntities)) {
            this.storeStockRelMapper.insertBatch(storeStockRelEntities);
        }
        return BaseResponse.success((Object)"\u65b0\u589e\u6210\u529f");
    }

    public BaseResponse<String> updateDrugItem(AddDrugItemVO vo) {
        log.info("========>\u4fee\u6539\u836f\u54c1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)vo));
        vo.setAppCode(AppCodeUtil.tranCode((String)vo.getAppCode()));
        DrugItemEntity entity = this.drugItemMapper.getById(vo.getDrugItemId());
        if (entity == null) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u836f\u54c1\u76f8\u5173\u4fe1\u606f\u6216\u5f53\u524d\u836f\u54c1\u5df2\u7ecf\u5220\u9664");
        }
        String commonCode = this.drugItemMapper.getByCommonCode(vo.getCommonCode(), vo.getAppCode());
        if (StringUtils.isNotEmpty((String)commonCode) && !entity.getCommonCode().equals(vo.getCommonCode())) {
            return BaseResponse.error((String)"\u901a\u7528\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        entity.setCommonName(vo.getCommonName());
        entity.setCommonCode(vo.getCommonCode());
        entity.setProductName(vo.getProductName());
        entity.setProductCode(vo.getProductCode());
        if (StringUtils.isNotEmpty((String)vo.getMinBillPackingUnitId())) {
            entity.setMinBillPackingUnitId(vo.getMinBillPackingUnitId());
            entity.setMinBillPackingUnitName(this.mosDrugUnitMapper.queryById(vo.getMinBillPackingUnitId()).getUnitName());
        }
        if (StringUtils.isNotEmpty((String)vo.getStockPackingUnitId())) {
            entity.setStockPackingUnitId(vo.getMinBillPackingUnitId());
            entity.setStockPackingUnitName(this.mosDrugUnitMapper.queryById(vo.getMinBillPackingUnitId()).getUnitName());
        }
        if (StringUtils.isNotEmpty((String)vo.getMeasureUnitId())) {
            entity.setMeasureUnitId(vo.getMeasureUnitId());
            entity.setMeasureUnitName(this.mosDrugUnitMapper.queryById(vo.getMeasureUnitId()).getUnitName());
        }
        if (StringUtils.isNotEmpty((String)vo.getWholePackingUnitId())) {
            entity.setWholePackingUnitId(vo.getWholePackingUnitId());
            entity.setWholePackingUnitName(this.mosDrugUnitMapper.queryById(vo.getWholePackingUnitId()).getUnitName());
            entity.setSpecPackingUnitId(vo.getMinBillPackingUnitId());
            entity.setSpecPackingUnitName(this.mosDrugUnitMapper.queryById(vo.getMinBillPackingUnitId()).getUnitName());
        }
        entity.setMinBillPackingNum(vo.getMinBillPackingNum());
        entity.setMeasureNum(vo.getMeasureNum());
        entity.setManufacturer(vo.getManufacturer());
        entity.setDosageForm(vo.getDosageForm());
        entity.setStorageConditions(vo.getStorageConditions());
        entity.setWholePackingNum(vo.getWholePackingNum());
        entity.setDrugSpec(vo.getDrugSpec());
        entity.setHospitalDrugSpec(vo.getDrugSpec());
        entity.setStatus(vo.getStatus());
        entity.setPrice(vo.getPrice());
        entity.setSpecialDrugFlag(null);
        entity.setSpecialDrugFlag(Integer.valueOf(1).equals(vo.getLineDrugType()) ? SpecialDrugFlagEnum.OUTLINE.getValue() : null);
        entity.setSpecialDrugFlag(Integer.valueOf(1).equals(vo.getIsDistributionStatic()) ? entity.getSpecialDrugFlag() + "," + SpecialDrugFlagEnum.STZS.getValue() : entity.getSpecialDrugFlag());
        this.drugItemMapper.updateById(entity);
        DrugPriceEntity priceEntityReq = new DrugPriceEntity();
        priceEntityReq.setDrugId(entity.getxId());
        DrugPriceEntity priceEntity = this.mosDrugPriceMapper.getByDrugIdAndStoreId(entity.getxId(), vo.getAppCode());
        if (priceEntity == null) {
            priceEntityReq.setPrice(vo.getPrice());
            priceEntityReq.setPrice(vo.getPrice());
            priceEntityReq.setxId(GenSeqUtils.getUniqueNo());
            priceEntityReq.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            priceEntityReq.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            this.mosDrugPriceMapper.insert(priceEntityReq);
        } else {
            priceEntity.setPrice(vo.getPrice());
            this.mosDrugPriceMapper.update(priceEntity);
        }
        DrugItemUsageRelEntity usageRelEntityReq = new DrugItemUsageRelEntity();
        usageRelEntityReq.setDrugId(entity.getxId());
        DrugItemUsageRelEntity usageRelEntity = this.mosDrugItemUsageRelMapper.getByDrugId(entity.getxId());
        if (usageRelEntity == null) {
            usageRelEntityReq.setStatus(Integer.valueOf(1));
            usageRelEntityReq.setUsageId(vo.getUsageId());
            usageRelEntityReq.setxId(GenSeqUtils.getUniqueNo());
            usageRelEntityReq.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            usageRelEntityReq.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            this.mosDrugItemUsageRelMapper.insert(usageRelEntityReq);
        } else {
            usageRelEntity.setUsageId(vo.getUsageId());
            this.mosDrugItemUsageRelMapper.update(usageRelEntity);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getDrugAlias())) {
            List list = this.drugAliasMapper.getByDrugId(entity.getxId());
            if (list == null || list.isEmpty()) {
                this.drugAliasMapper(vo.getDrugAlias(), vo.getCommonCode(), vo.getAppCode(), entity.getxId());
            } else {
                List names = vo.getDrugAlias();
                this.compareAlias(names, list);
                if (!names.isEmpty()) {
                    this.drugAliasMapper(names, vo.getCommonCode(), vo.getAppCode(), entity.getxId());
                }
                if (!list.isEmpty()) {
                    for (DrugAliasEntity entityda : list) {
                        entityda.setStatus(Integer.valueOf(0));
                        this.drugAliasMapper.updateById(entityda);
                    }
                }
            }
        }
        if (StringUtils.isNotEmpty((String)vo.getPharmaceuticalCompanyId())) {
            PharmaceuticalCompanyDrugRelEntity pharmaceuticalCompanyDrugRelEntity = this.pharmaceuticalCompanyDrugRelMapper.selectByDrugId(vo.getDrugItemId());
            if (ObjectUtils.isEmpty((Object)pharmaceuticalCompanyDrugRelEntity)) {
                pharmaceuticalCompanyDrugRelEntity = new PharmaceuticalCompanyDrugRelEntity();
                pharmaceuticalCompanyDrugRelEntity.setStatus(Byte.valueOf("1"));
                pharmaceuticalCompanyDrugRelEntity.setPharmaceuticalCompanyId(vo.getPharmaceuticalCompanyId());
                pharmaceuticalCompanyDrugRelEntity.setDrugId(vo.getDrugItemId());
                pharmaceuticalCompanyDrugRelEntity.setCreateTime(new Date());
                pharmaceuticalCompanyDrugRelEntity.setUpdateTime(new Date());
                this.pharmaceuticalCompanyDrugRelMapper.insert(pharmaceuticalCompanyDrugRelEntity);
            } else {
                pharmaceuticalCompanyDrugRelEntity.setPharmaceuticalCompanyId(vo.getPharmaceuticalCompanyId());
                pharmaceuticalCompanyDrugRelEntity.setStatus(Byte.valueOf("1"));
                this.pharmaceuticalCompanyDrugRelMapper.updateByPrimaryKeySelective(pharmaceuticalCompanyDrugRelEntity);
            }
        }
        return BaseResponse.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    public BaseResponse<List<DrugUnitEntity>> findDrugUnit() {
        List drugUnitEntityList = this.mosDrugUnitMapper.findDrugUnit();
        if (drugUnitEntityList == null) {
            return BaseResponse.error((String)"\u6ca1\u6709\u5355\u4f4d");
        }
        return BaseResponse.success((Object)drugUnitEntityList);
    }

    public BaseResponse<List<DrugUsageEntity>> findDrugUsage(String hospitalName) {
        log.info("\u67e5\u8be2\u836f\u54c1\u7684\u670d\u7528\u65b9\u5f0f,{}", (Object)hospitalName);
        String hospitalNameFirstLetter = this.getHospitalNameFirstLetter(hospitalName);
        List drugUsageEntityList = new ArrayList();
        drugUsageEntityList = this.mosDrugUsageMapper.findDrugUsageByHospitalNameFirstLetter(hospitalNameFirstLetter);
        if (CollectionUtils.isEmpty(drugUsageEntityList)) {
            drugUsageEntityList = this.mosDrugUsageMapper.findDrugUsageByHospitalNameFirstLetter(null);
        }
        log.info("\u67e5\u8be2\u836f\u54c1\u7684\u670d\u7528\u65b9\u5f0fdrugUsageEntityList:{}", (Object)JSON.toJSONString(drugUsageEntityList));
        if (drugUsageEntityList == null) {
            return BaseResponse.error((String)"\u6682\u65e0\u670d\u7528\u6a21\u5f0f");
        }
        return BaseResponse.success(drugUsageEntityList);
    }

    public BaseResponse<DrugSearchResultDTO> findDrugItemByDrugAlias(String drugAlias, String doctorId, String appCode, Integer type) {
        List itemList;
        appCode = AppCodeUtil.tranCode((String)appCode);
        if (type == 1) {
            itemList = this.drugItemMapper.getByDrugAlias(drugAlias, appCode, type);
            for (DrugItemQueryResultDTO item : itemList) {
                item.setDrugSpec(item.getDrugSpec());
            }
        } else if (type == 2) {
            itemList = this.drugItemMapper.getByDrugAlia(drugAlias, appCode, type);
            for (DrugItemQueryResultDTO item : itemList) {
                StringBuilder sb = new StringBuilder();
                sb.append(new BigDecimal(StringUtil.getNoZeros((String)item.getMeasureNum().toString()))).append(item.getMeasureUnit());
                item.setDrugSpec(sb.toString());
            }
        } else if (type == 3) {
            itemList = this.drugItemMapper.getByDrug(drugAlias, appCode, type);
            for (DrugItemQueryResultDTO item : itemList) {
                StringBuilder sb = new StringBuilder();
                sb.append(item.getMeasureNum()).append(item.getMeasureUnit());
                item.setDrugSpec(sb.toString());
            }
        } else {
            itemList = this.drugItemMapper.getDrugAlias(drugAlias, appCode, type);
            for (DrugItemQueryResultDTO item : itemList) {
                if (item.getType() == 1) {
                    item.setDrugSpec(item.getDrugSpec());
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(new BigDecimal(StringUtil.getNoZeros((String)item.getMeasureNum().toString()))).append(item.getMeasureUnit());
                item.setDrugSpec(sb.toString());
            }
        }
        List groupList = this.mosDrugGroupMapper.queryLikeGroupName(drugAlias, doctorId, type);
        DrugSearchResultDTO dto = new DrugSearchResultDTO();
        dto.setGroupList(groupList);
        dto.setItemList(this.exceptOutline(itemList));
        log.info("\u6839\u636e\u836f\u54c1\u522b\u540d\u67e5\u8be2\u51fa\u7684\u4fe1\u606f====" + JSONObject.toJSONString((Object)dto));
        return BaseResponse.success((Object)dto);
    }

    private List<DrugItemQueryResultDTO> exceptOutline(List<DrugItemQueryResultDTO> drugItemList) {
        if (drugItemList == null || drugItemList.size() == 0) {
            return drugItemList;
        }
        for (int i = drugItemList.size() - 1; i >= 0; --i) {
            String specialDrugFlag = drugItemList.get(i).getSpecialDrugFlag();
            if (!StringUtil.isNotEmpty((String)specialDrugFlag) || !Arrays.asList(specialDrugFlag.split(",")).contains(SpecialDrugFlagEnum.OUTLINE.getValue())) continue;
            drugItemList.remove(i);
        }
        return drugItemList;
    }

    public BaseResponse<List<DrugFrequencyEntity>> findDrugFrequency(String hospitalName) {
        String hospitalNameFirstLetter = this.getHospitalNameFirstLetter(hospitalName);
        List frequencyEntityList = new ArrayList();
        frequencyEntityList = this.drugFrequencyMapper.getAllByHospitalNameFirstLetter(hospitalNameFirstLetter);
        if (frequencyEntityList == null) {
            frequencyEntityList = this.drugFrequencyMapper.getAllByHospitalNameFirstLetter(null);
        }
        return BaseResponse.success(frequencyEntityList);
    }

    public BaseResponse<List<MosDrugReasonEntity>> findDrugReason() {
        List mosDrugReasonEntities = this.mosDrugReasonMapper.getAll();
        if (mosDrugReasonEntities == null) {
            return BaseResponse.error((String)"\u4fe1\u606f\u4e3a\u7a7a");
        }
        return BaseResponse.success((Object)mosDrugReasonEntities);
    }

    public BaseResponse<DrugItemDto> findDrugItemById(String drugId, String appCode) {
        appCode = AppCodeUtil.tranCode((String)appCode);
        DrugItemEntity entity = this.drugItemMapper.getById(drugId);
        if (entity == null || entity.getStatus() == 0) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u836f\u54c1\u76f8\u5173\u4fe1\u606f");
        }
        DrugItemDto drugItemDto = new DrugItemDto();
        BeanUtils.copyProperties((Object)entity, (Object)drugItemDto);
        drugItemDto.setDrugItemId(entity.getxId());
        DrugPriceEntity priceEntity = this.mosDrugPriceMapper.getByDrugIdAndStoreId(entity.getxId(), appCode);
        if (priceEntity != null) {
            drugItemDto.setPrice(priceEntity.getPrice());
        } else {
            drugItemDto.setPrice(entity.getPrice());
        }
        DrugItemUsageRelEntity usageRelEntity = this.mosDrugItemUsageRelMapper.getByDrugId(entity.getxId());
        if (usageRelEntity != null) {
            drugItemDto.setUsageId(usageRelEntity.getUsageId());
        }
        List listAlias = this.drugAliasMapper.getByDrugId(entity.getxId());
        ArrayList<String> list = new ArrayList<String>();
        if (!listAlias.isEmpty()) {
            for (DrugAliasEntity drugAliasEntity : listAlias) {
                list.add(drugAliasEntity.getDrugAlias());
            }
        }
        drugItemDto.setDrugAlias(list);
        PharmaceuticalCompanyEntity pharmaceuticalCompanyEntity = this.pharmaceuticalCompanyMapper.selectByDrugId(entity.getxId());
        if (pharmaceuticalCompanyEntity != null) {
            drugItemDto.setPharmaceuticalCompanyId(pharmaceuticalCompanyEntity.getId());
            drugItemDto.setPharmaceuticalCompanyName(pharmaceuticalCompanyEntity.getPharmaceuticalCompanyName());
        }
        drugItemDto.setIsDistributionStatic(Integer.valueOf(StringUtils.isNotEmpty((String)entity.getSpecialDrugFlag()) && entity.getSpecialDrugFlag().contains(SpecialDrugFlagEnum.STZS.getValue()) ? 1 : 0));
        drugItemDto.setLineDrugType(Integer.valueOf(entity.getSpecialDrugFlag() != null && entity.getSpecialDrugFlag().contains(SpecialDrugFlagEnum.OUTLINE.getValue()) ? 1 : 0));
        return BaseResponse.success((Object)drugItemDto);
    }

    public BaseResponse<List<DrugUnitEntity>> findDrugUnitByType(Integer type) {
        List listAlias = this.mosDrugUnitMapper.findDrugUnitByType(type);
        if (listAlias.isEmpty()) {
            return BaseResponse.error((String)"\u5355\u4f4d\u4e3a\u7a7a");
        }
        return BaseResponse.success((Object)listAlias);
    }

    public BaseResponse<DrugItemDetailQueryResultDTO> queryDetail(String drugCode, String hospitalName) {
        log.info("\u836f\u54c1\u7f16\u7801:{},\u533b\u9662\u9996\u5b57\u6bcd\u540d\u5b57\u5927\u5199:{}", (Object)drugCode, (Object)hospitalName);
        DrugItemDetailQueryResultDTO resultDTO = new DrugItemDetailQueryResultDTO();
        String hospitalNameFirstLetter = this.getHospitalNameFirstLetter(hospitalName);
        List drugUsageEntityList = new ArrayList();
        drugUsageEntityList = this.mosDrugUsageMapper.findDrugUsageByHospitalNameFirstLetter(hospitalNameFirstLetter);
        if (CollectionUtils.isEmpty(drugUsageEntityList)) {
            drugUsageEntityList = this.mosDrugUsageMapper.findDrugUsageByHospitalNameFirstLetter(null);
        }
        resultDTO.setUsageList(drugUsageEntityList);
        List frequencyEntityList = new ArrayList();
        frequencyEntityList = this.drugFrequencyMapper.getAllByHospitalNameFirstLetter(hospitalNameFirstLetter);
        if (CollectionUtils.isEmpty(frequencyEntityList)) {
            frequencyEntityList = this.drugFrequencyMapper.getAllByHospitalNameFirstLetter(null);
        }
        ArrayList<DrugItemDetailFrequency> frequencyList = new ArrayList<DrugItemDetailFrequency>();
        for (DrugFrequencyEntity frequencyEntity : frequencyEntityList) {
            DrugItemDetailFrequency frequency = new DrugItemDetailFrequency();
            frequency.setFrequencyCode(frequencyEntity.getFrequencyCode());
            frequency.setFrequencyDesc(frequencyEntity.getFrequencyDesc());
            frequency.setFrequencyId(frequencyEntity.getxId());
            frequency.setFrequencyRate(frequencyEntity.getFrequencyRate());
            frequency.setHospitalNameFirstLetter(frequencyEntity.getHospitalNameFirstLetter());
            frequencyList.add(frequency);
        }
        resultDTO.setFrequencyList(frequencyList);
        List reasonEntityList = this.mosDrugReasonMapper.getAll();
        ArrayList<DrugItemDetailReason> reasonList = new ArrayList<DrugItemDetailReason>();
        for (MosDrugReasonEntity reasonEntity : reasonEntityList) {
            DrugItemDetailReason reason = new DrugItemDetailReason();
            reason.setReasonCode(reasonEntity.getReasonCode());
            reason.setReasonDesc(reasonEntity.getReasonDesc());
            reason.setReasonId(reasonEntity.getXId());
            reasonList.add(reason);
        }
        resultDTO.setReasonList(reasonList);
        log.info("\u67e5\u8be2\u836f\u54c1\u9879\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)resultDTO));
        return BaseResponse.success((Object)resultDTO);
    }

    private void drugAliasMapper(List<String> list, String commonCode, String appCode, String drugId) {
        for (String drugAlia : list) {
            DrugAliasEntity drugAliasEntity = new DrugAliasEntity();
            drugAliasEntity.setDrugAlias(drugAlia);
            drugAliasEntity.setDrugCode(commonCode);
            drugAliasEntity.setOrganCode(appCode);
            drugAliasEntity.setDrugId(drugId);
            drugAliasEntity.setStatus(Integer.valueOf(1));
            drugAliasEntity.setxId(GenSeqUtils.getUniqueNo());
            drugAliasEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugAliasEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            this.drugAliasMapper.insert(drugAliasEntity);
        }
    }

    private void compareAlias(List<String> listAlias, List<DrugAliasEntity> listEntity) {
        for (int i = 0; i < listAlias.size(); ++i) {
            for (int j = 0; j < listEntity.size() && !CollectionUtils.isEmpty(listAlias) && !CollectionUtils.isEmpty(listAlias); ++j) {
                if (!listAlias.get(i).equals(listEntity.get(j).getDrugAlias())) continue;
                listAlias.remove(i);
                listEntity.remove(j);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> importItem(String appCode, String hospitalName, MultipartFile file) {
        String XLS = "xls";
        String XLSX = "xlsx";
        HSSFWorkbook workbook = null;
        String fileName = file.getOriginalFilename();
        ArrayList<DrugItemEntity> drugItemEntityList = new ArrayList<DrugItemEntity>();
        ArrayList<DrugPriceEntity> drugPriceEntityList = new ArrayList<DrugPriceEntity>();
        ArrayList<DrugItemUsageRelEntity> drugItemUsageRelEntityList = new ArrayList<DrugItemUsageRelEntity>();
        ArrayList<OrganDrugRelEntity> organDrugRelEntityList = new ArrayList<OrganDrugRelEntity>();
        ArrayList storeStockRelEntities = new ArrayList();
        ArrayList<DrugAliasEntity> drugAliasEntityList = new ArrayList<DrugAliasEntity>();
        if (fileName.endsWith(XLS)) {
            try {
                workbook = new HSSFWorkbook(file.getInputStream());
            }
            catch (Exception e) {
                log.error("ERROR", (Throwable)e);
            }
        } else if (fileName.endsWith(XLSX)) {
            try {
                workbook = new XSSFWorkbook(file.getInputStream());
            }
            catch (Exception e) {
                log.error("ERROR", (Throwable)e);
            }
        } else {
            return BaseResponse.error((String)"\u8bf7\u5bfc\u5165\u6b63\u786eExcel\u6587\u4ef6");
        }
        Sheet sheet = workbook.getSheetAt(0);
        int rows = sheet.getLastRowNum();
        if (rows == 0) {
            return BaseResponse.error((String)"\u836f\u54c1\u6570\u636e\u4e3a0");
        }
        for (int i = 1; i < rows + 1; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            log.info("======================\u7b2c" + i + "\u884c\u6570\u636e");
            String drugId = GenSeqUtils.getUniqueNo();
            BigDecimal price = new BigDecimal(row.getCell(14).getStringCellValue().trim());
            DrugItemEntity entity = new DrugItemEntity();
            entity.setAppCode(appCode);
            entity.setxId(drugId);
            entity.setProductName(row.getCell(0).getStringCellValue().trim());
            entity.setProductCode(drugId);
            entity.setCommonName(row.getCell(2).getStringCellValue().trim());
            entity.setCommonCode(row.getCell(3).getStringCellValue().trim());
            entity.setWholePackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(1), row.getCell(4).getStringCellValue().trim()));
            entity.setWholePackingNum(new BigDecimal(row.getCell(5).getStringCellValue().trim()));
            String minBillPackingUnitId = this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), row.getCell(6).getStringCellValue().trim());
            entity.setMinBillPackingUnitId(minBillPackingUnitId);
            entity.setMinBillPackingNum(new BigDecimal(row.getCell(7).getStringCellValue().trim()));
            entity.setMeasureUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(4), row.getCell(8).getStringCellValue().trim()));
            entity.setMeasureNum(new BigDecimal(row.getCell(9).getStringCellValue().trim()));
            entity.setStockPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), row.getCell(10).getStringCellValue().trim()));
            entity.setDosageForm(row.getCell(11) == null ? "" : row.getCell(11).getStringCellValue().trim());
            entity.setManufacturer(row.getCell(12) == null ? "" : row.getCell(12).getStringCellValue().trim());
            entity.setStorageConditions("");
            entity.setType(Integer.valueOf(1));
            entity.setDrugSpec(row.getCell(16) == null ? "" : row.getCell(16).getStringCellValue().trim());
            entity.setDrugProperty(row.getCell(17) == null ? "" : row.getCell(17).getStringCellValue().trim());
            try {
                entity.setxCreateTime(new Date());
                entity.setxUpdateTime(new Date());
            }
            catch (Exception exception) {
                // empty catch block
            }
            entity.setSpecPackingUnitId(minBillPackingUnitId);
            entity.setStatus(Integer.valueOf(1));
            drugItemEntityList.add(entity);
            OrganDrugRelEntity organDrugRelEntity = new OrganDrugRelEntity();
            organDrugRelEntity.setDrugId(drugId);
            organDrugRelEntity.setOrganCode(appCode);
            organDrugRelEntity.setArcimPrice(price);
            organDrugRelEntity.setStatus(Integer.valueOf(1));
            organDrugRelEntity.setxId(GenSeqUtils.getUniqueNo());
            organDrugRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            organDrugRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            organDrugRelEntityList.add(organDrugRelEntity);
            DrugPriceEntity priceEntity = new DrugPriceEntity();
            priceEntity.setDrugId(drugId);
            priceEntity.setPrice(price);
            priceEntity.setxId(GenSeqUtils.getUniqueNo());
            priceEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            priceEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            priceEntity.setOrganDrugRelId(organDrugRelEntity.getxId());
            drugPriceEntityList.add(priceEntity);
            DrugItemUsageRelEntity usageRelEntity = new DrugItemUsageRelEntity();
            usageRelEntity.setStatus(Integer.valueOf(1));
            usageRelEntity.setDrugId(drugId);
            String desc = row.getCell(15).getStringCellValue().trim();
            log.info("-----------desc" + JSON.toJSONString((Object)desc));
            String hospitalNameFirstLetter = this.getHospitalNameFirstLetter(hospitalName);
            DrugUsageEntity entity1 = this.mosDrugUsageMapper.getByDescAndHospitalNameFirstLetter(desc, hospitalNameFirstLetter);
            log.info("------------\u7528\u6cd5" + JSON.toJSONString((Object)entity1));
            usageRelEntity.setUsageId(entity1.getxId());
            usageRelEntity.setxId(GenSeqUtils.getUniqueNo());
            usageRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            usageRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugItemUsageRelEntityList.add(usageRelEntity);
            ArrayList drugAlias = new ArrayList();
            Collections.addAll(drugAlias, row.getCell(13).getStringCellValue().split(","));
            for (String drugAlia : drugAlias) {
                DrugAliasEntity drugAliasEntity = new DrugAliasEntity();
                drugAliasEntity.setDrugAlias(drugAlia);
                drugAliasEntity.setDrugCode(drugId);
                drugAliasEntity.setOrganCode(appCode);
                drugAliasEntity.setDrugId(drugId);
                drugAliasEntity.setStatus(Integer.valueOf(1));
                drugAliasEntity.setxId(GenSeqUtils.getUniqueNo());
                drugAliasEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugAliasEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugAliasEntityList.add(drugAliasEntity);
            }
        }
        if (CollectionUtils.isNotEmpty(drugItemEntityList)) {
            int drugItemCount = this.drugItemMapper.insertBatch(drugItemEntityList);
            log.info("======================{}", (Object)drugItemCount);
            this.organDrugRelMapper.insertBatch(organDrugRelEntityList);
            this.mosDrugPriceMapper.insertBatch(drugPriceEntityList);
            this.mosDrugItemUsageRelMapper.insertBatch(drugItemUsageRelEntityList);
            this.drugAliasMapper.insertBatch(drugAliasEntityList);
        }
        return BaseResponse.success((Object)"\u5bfc\u5165\u5b8c\u6210");
    }

    public BaseResponse<Object> synchronizationDeugItem() {
        String url = new StringBuffer(this.nodeConfig.getSynchronizationDeugItem()).append("beijing-zryh-api/systemCorresponding/correspondingHospDrug").toString();
        String respStr = "";
        SynchronizationDeugItemDTO synchronizationDeugItemDTO = new SynchronizationDeugItemDTO();
        List list = this.drugItemMapper.getAll();
        ArrayList<HospDrug> hospDrugList = new ArrayList<HospDrug>();
        for (DrugItemEntity drugItemEntity : list) {
            HospDrug hospDrug = new HospDrug();
            if (drugItemEntity.getPrice() == null) {
                drugItemEntity.setPrice(new BigDecimal(0));
            }
            hospDrug.setHospDrugId(drugItemEntity.getxId());
            hospDrug.setHospDrugPrice(drugItemEntity.getPrice().toString());
            hospDrug.setHospDrugGenericName(drugItemEntity.getCommonName());
            hospDrug.setHospDrugTradeName(drugItemEntity.getProductName());
            StringBuilder sb = new StringBuilder();
            log.info("============\u836f\u54c1id" + drugItemEntity.getxId());
            sb.append(drugItemEntity.getMeasureNum()).append(drugItemEntity.getMeasureUnitId()).append(" x ").append(drugItemEntity.getMinBillPackingNum()).append(drugItemEntity.getMinBillPackingUnitName()).append(" x ").append(1).append(drugItemEntity.getWholePackingUnitName());
            hospDrug.setHospDrugSpec(sb.toString());
            hospDrug.setHospDrugCompanyName(drugItemEntity.getManufacturer());
            hospDrugList.add(hospDrug);
        }
        synchronizationDeugItemDTO.setAccess_token(ACCESS_TOKEN);
        synchronizationDeugItemDTO.setHospDrugList(hospDrugList);
        try {
            log.info("=========\u540c\u6b65\u836f\u54c1\u8bf7\u6c42\u8def\u5f84" + url);
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)synchronizationDeugItemDTO), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("=======\u540c\u6b65\u836f\u54c1\u8fd4\u56de\u4fe1\u606f" + respStr);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        String code = JSON.parseObject((String)respStr).getString("code");
        return BaseResponse.success((Object)code);
    }

    public BaseResponse<Object> getDrugCount(DrugCountReqVo drugCountReqVo) {
        log.info("======\u822a\u5929his\u67e5\u8be2\u836f\u54c1\u5e93\u5b58\u524d\u7aef\u51fa\u5165\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)drugCountReqVo));
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)drugCountReqVo);
        BaseResponse baseResponse = this.hisManage.sendHis("/hyt-his/api/v1/drug/getDrugCount", frontRequest, ResponseResDTO.class);
        DrugItemEntity drugItemEntity = this.drugItemMapper.queryByCommonCode(drugCountReqVo.getDrugCode(), drugCountReqVo.getAppCode());
        HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/hyt-his/api/v1/drug/getDrugCount", drugItemEntity.getHospitalId());
        hisLogEntity.setResponse(JSONObject.toJSONString((Object)baseResponse));
        this.hisLogService.update(hisLogEntity);
        return BaseResponse.success((Object)baseResponse.getData());
    }

    public BaseResponse<List<PatientChooseDrugResVo>> selectDrugByParams(PatientChooseDrugReqVo patientChooseDrugReqVo) {
        String pharmaceuticalCompanyName;
        String commonName = patientChooseDrugReqVo.getDrugCommonName();
        if (commonName.contains(patientChooseDrugReqVo.getDrugSpec())) {
            int index = commonName.indexOf(patientChooseDrugReqVo.getDrugSpec());
            commonName = commonName.substring(0, index - 1);
        }
        List drugItemEntityList = this.drugItemMapper.selectDrugByParams(commonName, patientChooseDrugReqVo.getAppCode(), patientChooseDrugReqVo.getPharmaceuticalCompanyId());
        PharmaceuticalCompanyEntity pharmaceuticalCompany = this.pharmaceuticalCompanyMapper.selectByPrimaryKey(patientChooseDrugReqVo.getPharmaceuticalCompanyId());
        String string = pharmaceuticalCompanyName = StringUtil.isEmpty((String)pharmaceuticalCompany.getPharmaceuticalCompanyName()) ? "" : pharmaceuticalCompany.getPharmaceuticalCompanyName();
        if (CollectionUtils.isEmpty((Collection)drugItemEntityList)) {
            return BaseResponse.success();
        }
        List patientChooseDrugResVoList = drugItemEntityList.stream().filter(drugItemEntity -> patientChooseDrugReqVo.getDrugSpec().equalsIgnoreCase(drugItemEntity.getHospitalDrugSpec())).map(drugItemEntity -> {
            PatientChooseDrugResVo patientChooseDrugResVo = new PatientChooseDrugResVo();
            patientChooseDrugResVo.setCommonCode(drugItemEntity.getCommonCode());
            patientChooseDrugResVo.setCommonName(drugItemEntity.getCommonName());
            patientChooseDrugResVo.setDrugSpec(drugItemEntity.getDrugSpec());
            patientChooseDrugResVo.setManufacturer(drugItemEntity.getManufacturer());
            patientChooseDrugResVo.setWholePackingUnitName(drugItemEntity.getWholePackingUnitName());
            patientChooseDrugResVo.setPrice(drugItemEntity.getPrice());
            patientChooseDrugResVo.setMedicalCompany(pharmaceuticalCompanyName);
            String specialDrugFlag = drugItemEntity.getSpecialDrugFlag();
            patientChooseDrugResVo.setInjectionDrugFlag(StringUtil.isNotEmpty((String)specialDrugFlag) && Arrays.asList(specialDrugFlag.split(",")).contains(SpecialDrugFlagEnum.STZS.getValue()));
            return patientChooseDrugResVo;
        }).collect(Collectors.toList());
        return BaseResponse.success(patientChooseDrugResVoList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> importChineseItem(String appCode, String hospitalName, MultipartFile file) {
        String hospitalNameFirstLetter = this.getHospitalNameFirstLetter(hospitalName);
        String XLS = "xls";
        String XLSX = "xlsx";
        HSSFWorkbook workbook = null;
        String fileName = file.getOriginalFilename();
        ArrayList<DrugItemEntity> drugItemEntityList = new ArrayList<DrugItemEntity>();
        ArrayList<DrugPriceEntity> drugPriceEntityList = new ArrayList<DrugPriceEntity>();
        ArrayList<DrugItemUsageRelEntity> drugItemUsageRelEntityList = new ArrayList<DrugItemUsageRelEntity>();
        ArrayList<StoreStockRelEntity> storeStockRelEntities = new ArrayList<StoreStockRelEntity>();
        ArrayList<DrugAliasEntity> drugAliasEntityList = new ArrayList<DrugAliasEntity>();
        if (fileName.endsWith(XLS)) {
            try {
                workbook = new HSSFWorkbook(file.getInputStream());
            }
            catch (Exception e) {
                log.error("ERROR", (Throwable)e);
            }
        } else if (fileName.endsWith(XLSX)) {
            try {
                workbook = new XSSFWorkbook(file.getInputStream());
            }
            catch (Exception e) {
                log.error("ERROR", (Throwable)e);
            }
        } else {
            return BaseResponse.error((String)"\u8bf7\u5bfc\u5165\u6b63\u786eExcel\u6587\u4ef6");
        }
        Sheet sheet = workbook.getSheetAt(0);
        int rows = sheet.getLastRowNum();
        if (rows == 0) {
            return BaseResponse.error((String)"\u836f\u54c1\u6570\u636e\u4e3a0");
        }
        for (int i = 1; i < rows + 1; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            try {
                String drugId = GenSeqUtils.getUniqueNo();
                DrugItemEntity entity = new DrugItemEntity();
                entity.setxId(drugId);
                entity.setAppCode(appCode);
                entity.setType(DrugTypeEnum.CM.getValue());
                entity.setCommonCode(row.getCell(0) == null ? drugId : row.getCell(0).getStringCellValue().trim());
                entity.setProductName(row.getCell(1).getStringCellValue().trim());
                entity.setProductCode(drugId);
                entity.setCommonName(row.getCell(2).getStringCellValue().trim());
                entity.setWholePackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(1), row.getCell(3).getStringCellValue().trim()));
                System.out.println("=============" + row.getCell(4).getStringCellValue().trim());
                entity.setWholePackingNum(new BigDecimal(row.getCell(4).getStringCellValue()));
                entity.setMinBillPackingNum(new BigDecimal(row.getCell(4).getStringCellValue()));
                entity.setMeasureUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(4), row.getCell(6).getStringCellValue().trim()));
                entity.setMeasureNum(new BigDecimal(row.getCell(5).getStringCellValue().trim()));
                entity.setManufacturer(row.getCell(7) == null ? "" : row.getCell(6).getStringCellValue().trim());
                entity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                entity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugItemEntityList.add(entity);
                DrugPriceEntity priceEntity = new DrugPriceEntity();
                priceEntity.setDrugId(drugId);
                priceEntity.setPrice(new BigDecimal(row.getCell(9).getStringCellValue().trim()));
                priceEntity.setxId(GenSeqUtils.getUniqueNo());
                priceEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                priceEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugPriceEntityList.add(priceEntity);
                DrugItemUsageRelEntity usageRelEntity = new DrugItemUsageRelEntity();
                usageRelEntity.setStatus(Integer.valueOf(1));
                usageRelEntity.setDrugId(drugId);
                usageRelEntity.setUsageId(this.mosDrugUsageMapper.getByDescAndHospitalNameFirstLetter(row.getCell(8).getStringCellValue().trim(), hospitalNameFirstLetter).getxId());
                usageRelEntity.setxId(GenSeqUtils.getUniqueNo());
                usageRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                usageRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugItemUsageRelEntityList.add(usageRelEntity);
                DrugAliasEntity drugAliasEntity = new DrugAliasEntity();
                drugAliasEntity.setDrugAlias(row.getCell(2).getStringCellValue());
                drugAliasEntity.setDrugCode(drugId);
                drugAliasEntity.setOrganCode(appCode);
                drugAliasEntity.setDrugId(drugId);
                drugAliasEntity.setStatus(Integer.valueOf(1));
                drugAliasEntity.setxId(GenSeqUtils.getUniqueNo());
                drugAliasEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugAliasEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugAliasEntityList.add(drugAliasEntity);
                List storeIds = this.mosDrugstoreMapper.getIdsByStatus(Integer.valueOf(1), appCode);
                for (String storeId : storeIds) {
                    StoreStockRelEntity stockRelEntity = new StoreStockRelEntity();
                    stockRelEntity.setxId(GenSeqUtils.getUniqueNo());
                    stockRelEntity.setStockStatus(Integer.valueOf(1));
                    stockRelEntity.setStatus(Integer.valueOf(1));
                    stockRelEntity.setStoreId(storeId);
                    stockRelEntity.setDrugId(drugId);
                    storeStockRelEntities.add(stockRelEntity);
                }
                continue;
            }
            catch (Exception e) {
                log.error("ERROR", (Throwable)e);
                return BaseResponse.error((String)("\u7b2c" + i + "\u884c\u4fe1\u606f\u6709\u8bef"));
            }
        }
        if (CollectionUtils.isNotEmpty(drugItemEntityList)) {
            this.drugItemMapper.insertBatch1(drugItemEntityList);
            this.mosDrugPriceMapper.insertBatch(drugPriceEntityList);
            this.mosDrugItemUsageRelMapper.insertBatch(drugItemUsageRelEntityList);
            this.drugAliasMapper.insertBatch(drugAliasEntityList);
        }
        return BaseResponse.success((Object)"\u5bfc\u5165\u5b8c\u6210");
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> importWestern(String appCode, Integer type, String hospitalName, String pharmaceuticalCompanyId, List<DrugItemExcel> drugItemExcelList) {
        String hospitalNameFirstLetter = this.getHospitalNameFirstLetter(hospitalName);
        List list = this.drugItemMapper.getByAppCodeAndtype(appCode, type);
        ArrayList drugItemVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (DrugItemExcel drugItemExcel : drugItemExcelList) {
                boolean b = false;
                for (DrugItemEntity drugItemEntity : list) {
                    if (!drugItemEntity.getCommonCode().equals(drugItemExcel.getCommonCode()) || !drugItemEntity.getAppCode().equals(appCode)) continue;
                    PharmaceuticalCompanyDrugRelEntity phaCompanyDrugRelEntity = this.pharmaceuticalCompanyDrugRelMapper.selectByDrugId(drugItemEntity.getxId());
                    if (!StringUtils.isBlank((String)pharmaceuticalCompanyId) && !Objects.isNull(phaCompanyDrugRelEntity) && !pharmaceuticalCompanyId.equals(phaCompanyDrugRelEntity.getPharmaceuticalCompanyId())) continue;
                    b = true;
                    break;
                }
                if (b) continue;
                this.savaDrugItem(drugItemExcel, appCode, type, hospitalNameFirstLetter, pharmaceuticalCompanyId);
            }
        } else {
            for (DrugItemExcel drugItemExcel : drugItemExcelList) {
                this.savaDrugItem(drugItemExcel, appCode, type, hospitalNameFirstLetter, pharmaceuticalCompanyId);
            }
        }
        return BaseResponse.success((Object)"\u5bfc\u5165\u5b8c\u6210");
    }

    private void savaDrugItem(DrugItemExcel drugItemExcel, String appCode, Integer type, String hospitalNameFirstLetter, String pharmaceuticalCompanyId) {
        String drugId = GenSeqUtils.getUniqueNo();
        DrugItemEntity entity = new DrugItemEntity();
        entity.setAppCode(appCode);
        entity.setxId(drugId);
        entity.setProductCode(drugItemExcel.getCommonCode());
        entity.setProductName(drugItemExcel.getProductName());
        entity.setCommonName(drugItemExcel.getCommonName());
        entity.setCommonCode(drugItemExcel.getCommonCode());
        entity.setWholePackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(1), drugItemExcel.getWholePackingUnitId()));
        entity.setWholePackingUnitName(drugItemExcel.getWholePackingUnitId());
        entity.setMinBillPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemExcel.getMinBillPackingUnitId()));
        entity.setMinBillPackingUnitName(drugItemExcel.getMinBillPackingUnitId());
        if (StringUtils.isNotBlank((String)drugItemExcel.getMinBillPackingNum())) {
            entity.setMinBillPackingNum(new BigDecimal(drugItemExcel.getMinBillPackingNum()));
        }
        entity.setMeasureUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(4), drugItemExcel.getMeasureUnitId()));
        entity.setMeasureUnitName(drugItemExcel.getMeasureUnitId());
        if (StringUtils.isNotBlank((String)drugItemExcel.getMeasureNum())) {
            entity.setMeasureNum(new BigDecimal(drugItemExcel.getMeasureNum()));
        }
        entity.setManufacturer(drugItemExcel.getManufacturer());
        entity.setSpecPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemExcel.getMinBillPackingUnitId()));
        entity.setSpecPackingUnitName(drugItemExcel.getMinBillPackingUnitId());
        entity.setDrugSpec(drugItemExcel.getDrugSpec());
        entity.setHospitalDrugSpec(drugItemExcel.getHospitalDrugSpec());
        entity.setDrugProperty(drugItemExcel.getDrugProperty());
        entity.setDrugApprovalNumber(drugItemExcel.getDrugApprovalNumber());
        entity.setStockPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemExcel.getWholePackingUnitId()));
        entity.setStockPackingUnitName(drugItemExcel.getWholePackingUnitId());
        entity.setDosageForm(drugItemExcel.getDosageForm());
        entity.setType(type);
        entity.setPrice(new BigDecimal(drugItemExcel.getPrice()));
        entity.setxCreateTime(new Date());
        entity.setxUpdateTime(new Date());
        entity.setStatus(Integer.valueOf(1));
        DrugPriceEntity priceEntity = new DrugPriceEntity();
        priceEntity.setDrugId(drugId);
        priceEntity.setPrice(new BigDecimal(drugItemExcel.getPrice()));
        priceEntity.setxId(GenSeqUtils.getUniqueNo());
        priceEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        priceEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        DrugItemUsageRelEntity usageRelEntity = new DrugItemUsageRelEntity();
        usageRelEntity.setStatus(Integer.valueOf(1));
        usageRelEntity.setDrugId(drugId);
        DrugUsageEntity drugUsageEntity = new DrugUsageEntity();
        drugUsageEntity = this.mosDrugUsageMapper.getByDescAndHospitalNameFirstLetter(drugItemExcel.getUsage(), hospitalNameFirstLetter);
        if (drugUsageEntity == null) {
            drugUsageEntity = this.mosDrugUsageMapper.getByDescAndHospitalNameFirstLetter(drugItemExcel.getUsage(), null);
        }
        if (Objects.nonNull(drugUsageEntity)) {
            usageRelEntity.setUsageId(drugUsageEntity.getxId());
        }
        usageRelEntity.setxId(GenSeqUtils.getUniqueNo());
        usageRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        usageRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.drugItemMapper.insert(entity);
        this.mosDrugPriceMapper.insert(priceEntity);
        this.mosDrugItemUsageRelMapper.insert(usageRelEntity);
        if (StringUtil.isNotEmpty((String)pharmaceuticalCompanyId)) {
            PharmaceuticalCompanyDrugRelEntity pharmaceuticalCompanyDrugRelEntity = new PharmaceuticalCompanyDrugRelEntity();
            pharmaceuticalCompanyDrugRelEntity.setId(GenSeqUtils.getUniqueNo());
            pharmaceuticalCompanyDrugRelEntity.setPharmaceuticalCompanyId(pharmaceuticalCompanyId);
            pharmaceuticalCompanyDrugRelEntity.setDrugId(drugId);
            pharmaceuticalCompanyDrugRelEntity.setStatus(Byte.valueOf("1"));
            this.pharmaceuticalCompanyDrugRelMapper.insert(pharmaceuticalCompanyDrugRelEntity);
        }
        if (StringUtils.isNotBlank((String)drugItemExcel.getDrugAlias())) {
            ArrayList drugAlias = new ArrayList();
            Collections.addAll(drugAlias, drugItemExcel.getDrugAlias().split(" "));
            for (String drugAlia : drugAlias) {
                DrugAliasEntity drugAliasEntity = new DrugAliasEntity();
                drugAliasEntity.setDrugAlias(drugAlia);
                drugAliasEntity.setDrugCode(drugId);
                drugAliasEntity.setOrganCode(appCode);
                drugAliasEntity.setDrugId(drugId);
                drugAliasEntity.setStatus(Integer.valueOf(1));
                drugAliasEntity.setxId(GenSeqUtils.getUniqueNo());
                drugAliasEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugAliasEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.drugAliasMapper.insert(drugAliasEntity);
            }
        }
    }

    private void updateDrugItem(DrugItemEntity drugItemEntity, DrugItemExcel drugItemExcel, String hospitalNameFirstLetter) {
        String hospitalNameFirstLetter1 = this.getHospitalNameFirstLetter(hospitalNameFirstLetter);
        DrugPriceEntity drugPriceEntity = this.mosDrugPriceMapper.getByDrugId(drugItemEntity.getxId());
        DrugItemUsageRelEntity drugItemUsageRelEntity = this.mosDrugItemUsageRelMapper.getByDrugId(drugItemEntity.getxId());
        List drugAliasEntities = this.drugAliasMapper.getByDrugId(drugItemEntity.getxId());
        drugItemEntity.setProductName(drugItemExcel.getProductName());
        drugItemEntity.setCommonName(drugItemExcel.getCommonName());
        drugItemEntity.setCommonCode(drugItemExcel.getCommonCode());
        drugItemEntity.setHospitalDrugSpec(drugItemExcel.getHospitalDrugSpec());
        drugItemEntity.setWholePackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(1), drugItemExcel.getWholePackingUnitId()));
        drugItemEntity.setWholePackingUnitName(drugItemExcel.getWholePackingUnitId());
        drugItemEntity.setMinBillPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemExcel.getMinBillPackingUnitId()));
        drugItemEntity.setMinBillPackingUnitName(drugItemExcel.getMinBillPackingUnitId());
        drugItemEntity.setMinBillPackingNum(new BigDecimal(drugItemExcel.getMinBillPackingNum()));
        drugItemEntity.setMeasureUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(4), drugItemExcel.getMeasureUnitId()));
        drugItemEntity.setMeasureUnitName(drugItemExcel.getMeasureUnitId());
        drugItemEntity.setMeasureNum(new BigDecimal(drugItemExcel.getMeasureNum()));
        drugItemEntity.setManufacturer(drugItemExcel.getManufacturer());
        drugItemEntity.setDrugSpec(drugItemExcel.getDrugSpec());
        drugItemEntity.setDrugProperty(drugItemExcel.getDrugProperty());
        drugItemEntity.setDrugApprovalNumber(drugItemExcel.getDrugApprovalNumber());
        drugItemEntity.setStockPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemExcel.getWholePackingUnitId()));
        drugItemEntity.setStockPackingUnitName(drugItemExcel.getWholePackingUnitId());
        drugItemEntity.setDosageForm(drugItemExcel.getDosageForm());
        drugItemEntity.setStatus(Integer.valueOf(1));
        drugItemEntity.setPrice(new BigDecimal(drugItemExcel.getPrice()));
        drugItemEntity.setxUpdateTime(new Date());
        drugPriceEntity.setPrice(new BigDecimal(drugItemExcel.getPrice()));
        drugItemUsageRelEntity.setUsageId(this.mosDrugUsageMapper.getByDescAndHospitalNameFirstLetter(drugItemExcel.getUsage(), hospitalNameFirstLetter1).getxId());
        drugItemUsageRelEntity.setxUpdateTime(new Date());
        if (CollectionUtils.isNotEmpty((Collection)drugAliasEntities)) {
            for (DrugAliasEntity drugAliasEntity : drugAliasEntities) {
                drugAliasEntity.setDrugAlias(drugItemExcel.getDrugAlias());
                drugAliasEntity.setxUpdateTime(new Date());
                this.drugAliasMapper.updateById(drugAliasEntity);
            }
        } else {
            ArrayList drugAlias = new ArrayList();
            Collections.addAll(drugAlias, drugItemExcel.getDrugAlias().split(","));
            for (String drugAlia : drugAlias) {
                DrugAliasEntity drugAliasEntity = new DrugAliasEntity();
                drugAliasEntity.setDrugAlias(drugAlia);
                drugAliasEntity.setDrugCode(drugItemEntity.getCommonCode());
                drugAliasEntity.setOrganCode(drugItemEntity.getAppCode());
                drugAliasEntity.setDrugId(drugItemEntity.getxId());
                drugAliasEntity.setStatus(Integer.valueOf(1));
                drugAliasEntity.setxId(GenSeqUtils.getUniqueNo());
                drugAliasEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugAliasEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.drugAliasMapper.insert(drugAliasEntity);
            }
        }
        System.out.println("===========" + JSONObject.toJSONString((Object)drugItemEntity));
        this.drugItemMapper.updateById(drugItemEntity);
        this.mosDrugPriceMapper.update(drugPriceEntity);
        this.mosDrugItemUsageRelMapper.update(drugItemUsageRelEntity);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<Object> importChineseMedicine(String appCode, Integer type, String hospitalName, List<DrugItemChineseExcel> drugItemExcelList) {
        String hospitalNameFirstLetter = this.getHospitalNameFirstLetter(hospitalName);
        List list = this.drugItemMapper.getByAppCodeAndtype(appCode, type);
        ArrayList<DrugItemVo> drugItemVoList = new ArrayList<DrugItemVo>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (DrugItemChineseExcel drugItemChineseExcel : drugItemExcelList) {
                boolean b = false;
                for (DrugItemEntity drugItemEntity : list) {
                    if (!drugItemEntity.getCommonCode().equals(drugItemChineseExcel.getCommonCode()) || !drugItemEntity.getAppCode().equals(appCode)) continue;
                    b = true;
                    this.updateChineseMedicine(drugItemEntity, drugItemChineseExcel, hospitalNameFirstLetter);
                    break;
                }
                if (b) continue;
                this.savaChineseMedicine(drugItemChineseExcel, appCode, type, hospitalNameFirstLetter);
            }
        } else {
            for (DrugItemChineseExcel drugItemChineseExcel : drugItemExcelList) {
                this.savaChineseMedicine(drugItemChineseExcel, appCode, type, hospitalNameFirstLetter);
            }
        }
        for (DrugItemEntity drugItemEntity : list) {
            boolean r = false;
            for (DrugItemChineseExcel drugItemChineseExcel : drugItemExcelList) {
                if (!drugItemEntity.getCommonCode().equals(drugItemChineseExcel.getCommonCode()) || !drugItemEntity.getAppCode().equals(appCode)) continue;
                r = true;
                break;
            }
            if (r) continue;
            DrugItemVo drugItemVo = new DrugItemVo();
            drugItemVo.setCommonCode(drugItemEntity.getCommonCode());
            drugItemVo.setAppCode(appCode);
            drugItemVo.setType(type);
            drugItemVoList.add(drugItemVo);
        }
        if (CollectionUtils.isNotEmpty(drugItemVoList)) {
            for (DrugItemVo drugItemVo : drugItemVoList) {
                log.info("=========" + JSONObject.toJSONString((Object)drugItemVo));
                DrugItemEntity itemEntity = this.drugItemMapper.getByCommonCodeAndAppcode(drugItemVo.getCommonCode(), drugItemVo.getAppCode(), type);
                itemEntity.setStatus(Integer.valueOf(0));
                this.drugItemMapper.updateById(itemEntity);
            }
        }
        return BaseResponse.success((Object)"\u5bfc\u5165\u5b8c\u6210");
    }

    private String getHospitalNameFirstLetter(String hospitalNameFirstLetter) {
        String hospitalNameFirstLetter1 = null;
        if (StringUtils.isNotEmpty((String)hospitalNameFirstLetter)) {
            hospitalNameFirstLetter1 = HanyuPinyinUtil.getFirstLetters((String)hospitalNameFirstLetter, (HanyuPinyinCaseType)HanyuPinyinCaseType.UPPERCASE);
        }
        return hospitalNameFirstLetter1;
    }

    private void savaChineseMedicine(DrugItemChineseExcel drugItemChineseExcel, String appCode, Integer type, String hospitalNameFirstLetter) {
        String drugId = GenSeqUtils.getUniqueNo();
        DrugItemEntity entity = new DrugItemEntity();
        entity.setAppCode(appCode);
        entity.setxId(drugId);
        entity.setProductCode(drugId);
        entity.setProductName(drugItemChineseExcel.getProductName());
        entity.setCommonName(drugItemChineseExcel.getCommonName());
        entity.setCommonCode(drugItemChineseExcel.getCommonCode());
        entity.setWholePackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(1), drugItemChineseExcel.getWholePackingUnitId()));
        entity.setWholePackingUnitName(drugItemChineseExcel.getWholePackingUnitId());
        entity.setWholePackingNum(new BigDecimal(drugItemChineseExcel.getWholePackingNum()));
        entity.setMinBillPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemChineseExcel.getWholePackingUnitId()));
        entity.setMinBillPackingUnitName(drugItemChineseExcel.getWholePackingUnitId());
        entity.setMinBillPackingNum(new BigDecimal(drugItemChineseExcel.getWholePackingNum()));
        entity.setMeasureUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(4), drugItemChineseExcel.getMeasureUnitId()));
        entity.setMeasureUnitName(drugItemChineseExcel.getMeasureUnitId());
        if (StringUtils.isNotBlank((String)drugItemChineseExcel.getMeasureNum())) {
            entity.setMeasureNum(new BigDecimal(drugItemChineseExcel.getMeasureNum()));
        }
        entity.setManufacturer(drugItemChineseExcel.getManufacturer());
        entity.setDrugSpec(drugItemChineseExcel.getDrugSpec());
        entity.setDrugProperty(drugItemChineseExcel.getDrugProperty());
        entity.setDrugApprovalNumber(drugItemChineseExcel.getDrugApprovalNumber());
        entity.setStockPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemChineseExcel.getWholePackingUnitId()));
        entity.setStockPackingUnitName(drugItemChineseExcel.getWholePackingUnitId());
        entity.setDosageForm(drugItemChineseExcel.getDosageForm());
        entity.setSpecPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemChineseExcel.getWholePackingUnitId()));
        entity.setSpecPackingUnitName(drugItemChineseExcel.getWholePackingUnitId());
        entity.setType(type);
        entity.setPrice(new BigDecimal(drugItemChineseExcel.getPrice()));
        try {
            entity.setxCreateTime(new Date());
            entity.setxUpdateTime(new Date());
        }
        catch (Exception exception) {
            // empty catch block
        }
        entity.setStatus(Integer.valueOf(1));
        DrugPriceEntity priceEntity = new DrugPriceEntity();
        priceEntity.setDrugId(entity.getxId());
        priceEntity.setPrice(new BigDecimal(drugItemChineseExcel.getPrice()));
        priceEntity.setxId(GenSeqUtils.getUniqueNo());
        priceEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        priceEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        DrugItemUsageRelEntity usageRelEntity = new DrugItemUsageRelEntity();
        usageRelEntity.setStatus(Integer.valueOf(1));
        usageRelEntity.setDrugId(entity.getxId());
        DrugUsageEntity entity1 = null;
        entity1 = this.mosDrugUsageMapper.getByDescAndHospitalNameFirstLetter(drugItemChineseExcel.getUsage(), hospitalNameFirstLetter);
        if (entity1 == null) {
            entity1 = this.mosDrugUsageMapper.getByDescAndHospitalNameFirstLetter(drugItemChineseExcel.getUsage(), null);
        }
        log.info("------------\u7528\u6cd5" + JSON.toJSONString((Object)entity1));
        if (entity1 != null) {
            usageRelEntity.setUsageId(entity1.getxId());
        }
        usageRelEntity.setxId(GenSeqUtils.getUniqueNo());
        usageRelEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        usageRelEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.drugItemMapper.insert(entity);
        this.mosDrugPriceMapper.insert(priceEntity);
        this.mosDrugItemUsageRelMapper.insert(usageRelEntity);
        DrugAliasEntity drugAliasEntity = new DrugAliasEntity();
        drugAliasEntity.setDrugAlias(drugItemChineseExcel.getCommonName());
        drugAliasEntity.setDrugCode(entity.getCommonCode());
        drugAliasEntity.setOrganCode(entity.getAppCode());
        drugAliasEntity.setDrugId(entity.getxId());
        drugAliasEntity.setStatus(Integer.valueOf(1));
        drugAliasEntity.setxId(GenSeqUtils.getUniqueNo());
        drugAliasEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugAliasEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.drugAliasMapper.insert(drugAliasEntity);
    }

    private void updateChineseMedicine(DrugItemEntity drugItemEntity, DrugItemChineseExcel drugItemChineseExcel, String hospitalNameFirstLetter) {
        DrugPriceEntity drugPriceEntity = this.mosDrugPriceMapper.getByDrugId(drugItemEntity.getxId());
        DrugItemUsageRelEntity drugItemUsageRelEntity = this.mosDrugItemUsageRelMapper.getByDrugId(drugItemEntity.getxId());
        List drugAliasEntities = this.drugAliasMapper.getByDrugId(drugItemEntity.getxId());
        drugItemEntity.setProductName(drugItemChineseExcel.getProductName());
        drugItemEntity.setCommonName(drugItemChineseExcel.getCommonName());
        drugItemEntity.setCommonCode(drugItemChineseExcel.getCommonCode());
        drugItemEntity.setWholePackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(1), drugItemChineseExcel.getWholePackingUnitId()));
        drugItemEntity.setWholePackingUnitName(drugItemChineseExcel.getWholePackingUnitId());
        drugItemEntity.setWholePackingNum(new BigDecimal(drugItemChineseExcel.getWholePackingNum()));
        drugItemEntity.setMinBillPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemChineseExcel.getWholePackingUnitId()));
        drugItemEntity.setMinBillPackingUnitName(drugItemChineseExcel.getWholePackingUnitId());
        drugItemEntity.setMinBillPackingNum(new BigDecimal(drugItemChineseExcel.getWholePackingNum()));
        drugItemEntity.setMeasureUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(4), drugItemChineseExcel.getMeasureUnitId()));
        drugItemEntity.setMeasureUnitName(drugItemChineseExcel.getMeasureUnitId());
        if (StringUtils.isNotBlank((String)drugItemChineseExcel.getMeasureNum())) {
            drugItemEntity.setMeasureNum(new BigDecimal(drugItemChineseExcel.getMeasureNum()));
        }
        drugItemEntity.setManufacturer(drugItemChineseExcel.getManufacturer());
        drugItemEntity.setDrugSpec(drugItemChineseExcel.getDrugSpec());
        drugItemEntity.setDrugProperty(drugItemChineseExcel.getDrugProperty());
        drugItemEntity.setDrugApprovalNumber(drugItemChineseExcel.getDrugApprovalNumber());
        drugItemEntity.setStockPackingUnitId(this.mosDrugUnitMapper.findDrugUnitIdByType(Integer.valueOf(3), drugItemChineseExcel.getWholePackingUnitId()));
        drugItemEntity.setStockPackingUnitName(drugItemChineseExcel.getWholePackingUnitId());
        drugItemEntity.setDosageForm(drugItemChineseExcel.getDosageForm());
        drugItemEntity.setStatus(Integer.valueOf(1));
        drugItemEntity.setPrice(new BigDecimal(drugItemChineseExcel.getPrice()));
        drugItemEntity.setxUpdateTime(new Date());
        drugPriceEntity.setPrice(new BigDecimal(drugItemChineseExcel.getPrice()));
        DrugUsageEntity drugUsageEntity = this.mosDrugUsageMapper.getByDescAndHospitalNameFirstLetter(drugItemChineseExcel.getUsage(), hospitalNameFirstLetter);
        if (drugUsageEntity != null) {
            drugItemUsageRelEntity.setUsageId(drugUsageEntity.getxId());
        }
        drugItemUsageRelEntity.setxUpdateTime(new Date());
        for (DrugAliasEntity drugAliasEntity : drugAliasEntities) {
            drugAliasEntity.setDrugAlias(drugItemChineseExcel.getCommonName());
            drugAliasEntity.setxUpdateTime(new Date());
            this.drugAliasMapper.updateById(drugAliasEntity);
        }
        this.drugItemMapper.updateById(drugItemEntity);
        this.mosDrugPriceMapper.update(drugPriceEntity);
        this.mosDrugItemUsageRelMapper.update(drugItemUsageRelEntity);
    }
}

