/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.common.constants.BusinessConstant;
import com.ebaiyihui.medicalcloud.common.enums.AppCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.AuditStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.BaseStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.BusinessCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.HisExpressTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.HytHisRecipeStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.LogisticsStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PrescriptionSourceEnum;
import com.ebaiyihui.medicalcloud.common.enums.PushCodeInfoEnum;
import com.ebaiyihui.medicalcloud.common.enums.RemarkTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.ReturnCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.UserEnum;
import com.ebaiyihui.medicalcloud.common.enums.UserTypeEnum;
import com.ebaiyihui.medicalcloud.config.NodeConfig;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.exception.AsynException;
import com.ebaiyihui.medicalcloud.manage.AsynManage;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.DrugMainManage;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.manage.OrderPayManage;
import com.ebaiyihui.medicalcloud.manage.PatientInfoRemoteManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.HisLogMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsRouteMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugstoreMapper;
import com.ebaiyihui.medicalcloud.mapper.StoreDoctorRelMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.ComplateOrBackDtoReq;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugMainItemStatusDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.HytRecipeDataDTO;
import com.ebaiyihui.medicalcloud.pojo.dto.OprationDrugMainDto;
import com.ebaiyihui.medicalcloud.pojo.dto.QueryDrugMainListReq;
import com.ebaiyihui.medicalcloud.pojo.dto.QueryPharmacistMainDto;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PresDetailResultDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DiagnosticEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugExtendEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPriceEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugUnitEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugstoreEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderRegEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsRouteEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosOutpatientMainRelEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosSynchPresRecordEntity;
import com.ebaiyihui.medicalcloud.pojo.im.MessageData;
import com.ebaiyihui.medicalcloud.pojo.vo.DocWorkInfoDto;
import com.ebaiyihui.medicalcloud.pojo.vo.FromOutlineVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientInfoRespVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PharmaceutistResVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PresDetailVO;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.detail.StoreDoctorResData;
import com.ebaiyihui.medicalcloud.pojo.vo.his.HuaHongResultVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.LogisticsRecipeReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.icd.CountDiagnosticVo;
import com.ebaiyihui.medicalcloud.pojo.vo.logistics.WaybillRouteVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pres.PatientSignFinished;
import com.ebaiyihui.medicalcloud.pojo.vo.third.DrugInfo;
import com.ebaiyihui.medicalcloud.pojo.vo.third.MesDrugDetail;
import com.ebaiyihui.medicalcloud.pojo.vo.third.MesPatient;
import com.ebaiyihui.medicalcloud.pojo.vo.third.PrescriptionInfo;
import com.ebaiyihui.medicalcloud.pojo.vo.third.SynchPresReq;
import com.ebaiyihui.medicalcloud.pojo.vo.third.ZryhYunTaiRequest;
import com.ebaiyihui.medicalcloud.pojo.vo.third.ZryhYunTaiResponseVo;
import com.ebaiyihui.medicalcloud.pojo.vo.webservice.AuditPrescriptionVo;
import com.ebaiyihui.medicalcloud.service.DiagnosticService;
import com.ebaiyihui.medicalcloud.service.DrugDetailService;
import com.ebaiyihui.medicalcloud.service.DrugExtendService;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugOrderService;
import com.ebaiyihui.medicalcloud.service.MosDrugPrescriptionService;
import com.ebaiyihui.medicalcloud.service.MosDrugPriceService;
import com.ebaiyihui.medicalcloud.service.MosDrugRemarkService;
import com.ebaiyihui.medicalcloud.service.MosDrugUnitService;
import com.ebaiyihui.medicalcloud.service.MosOutpatientMainRelService;
import com.ebaiyihui.medicalcloud.service.MosSynchPresRecordService;
import com.ebaiyihui.medicalcloud.service.PrescriptionPdfService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.HanyuPinyinUtil;
import com.ebaiyihui.medicalcloud.utils.HttpUtils;
import com.ebaiyihui.medicalcloud.utils.RabbitMqUtils;
import com.ebaiyihui.medicalcloud.utils.RandomUtils;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import com.ebaiyihui.medicalcloud.utils.excel.ExpressInfo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MosDrugMainServiceImpl
implements MosDrugMainService {
    private static final Logger log = LoggerFactory.getLogger(MosDrugMainServiceImpl.class);
    public static final int SEVENTY_TWO_HOURS = 259200;
    public static final int FORTY_EIGHT_HOURS = 172800;
    public static final int WAIT_AUDIT = 1;
    public static final int RATIONALE = 2;
    public static final int NO_RATIONALE = 3;
    private static final Integer CARD_TYPE_SELF_EXPENSE = 1;
    private static final Integer CARD_TYPE_PUSH_EXPENSE = 2;
    public static final int ONE_THOUSAND_METERS = 10000;
    public static final int ONE = 1;
    public static final String ZERO_STR = "0";
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private DrugExtendService drugExtendService;
    @Autowired
    private MosDrugOrderService mosDrugOrderService;
    @Autowired
    private MosDrugPrescriptionService prescriptionService;
    @Autowired
    private DiagnosticService diagnosticService;
    @Autowired
    private DrugDetailService detailService;
    @Autowired
    private MosDrugRemarkService drugRemarkService;
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private AsynManage asynManage;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private MosDrugstoreMapper mosDrugstoreMapper;
    @Autowired
    private NodeConfig nodeConfig;
    @Autowired
    private MosOutpatientMainRelService mosOutpatientMainRelService;
    @Autowired
    private PatientInfoRemoteManage patientInfoRemoteManage;
    @Autowired
    private MosSynchPresRecordService mosSynchPresRecordService;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private MosDrugLogisticsRouteMapper mosDrugLogisticsRouteMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private DrugMainManage drugMainManage;
    @Autowired
    private MosDrugPrescriptionService mosDrugPrescriptionService;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private MosDrugMainService mosDrugMainService;
    @Autowired
    private DrugItemMapper drugItemMapper;
    @Autowired
    private MosDrugUnitService drugUnitService;
    @Autowired
    private MosDrugPriceService mosDrugPriceService;
    @Autowired
    private MosDrugOrderMapper mosDrugOrderMapper;
    @Autowired
    private HisLogService hisLogService;
    @Autowired
    private HisLogMapper hisLogMapper;
    @Autowired
    private StoreDoctorRelMapper storeDoctorRelMapper;

    public DrugMainEntity queryById(String xId) {
        return this.mosDrugMainMapper.queryById(xId);
    }

    public DrugMainEntity insert(DrugMainEntity mosDrugMain) {
        this.mosDrugMainMapper.insert(mosDrugMain);
        return this.queryById(mosDrugMain.getxId());
    }

    public DrugMainEntity update(DrugMainEntity mosDrugMain) {
        this.mosDrugMainMapper.update(mosDrugMain);
        return this.queryById(mosDrugMain.getxId());
    }

    public BaseResponse<PageResult<QueryPharmacistMainDto>> queryPharmacistMainList(QueryDrugMainListReq queryDrugMainListReq) {
        if (StringUtils.isBlank((String)queryDrugMainListReq.getAppCode())) {
            queryDrugMainListReq.setAppCode(queryDrugMainListReq.getOrganCode());
        }
        StringBuilder type = new StringBuilder();
        if (StringUtils.isNotEmpty((String)queryDrugMainListReq.getDoctorId()) && StringUtils.isNotEmpty((String)queryDrugMainListReq.getOrganId())) {
            List infoDtos = this.doctorRetmoteManage.getDocWorkInfoService(queryDrugMainListReq.getOrganId(), queryDrugMainListReq.getDoctorId());
            if (CollectionUtils.isNotEmpty((Collection)infoDtos)) {
                for (DocWorkInfoDto infoDto : infoDtos) {
                    if ("cfglzy".equalsIgnoreCase(infoDto.getServiceCode()) && Integer.valueOf(1).equals(infoDto.getAuthStatus()) && Integer.valueOf(1).equals(infoDto.getStatus())) {
                        type.append("3,");
                        break;
                    }
                    if (!"cfgl".equalsIgnoreCase(infoDto.getServiceCode()) || !Integer.valueOf(1).equals(infoDto.getAuthStatus()) || !Integer.valueOf(1).equals(infoDto.getStatus())) continue;
                    type.append("4,");
                }
            }
            type = new StringBuilder(StringUtils.isEmpty((String)type.toString()) ? "-1" : type.substring(0, type.length() - 1));
        }
        String drugMainParamIds = "";
        if (StringUtils.isNotBlank((String)queryDrugMainListReq.getAppSearch())) {
            List drugMainIdParamList = this.detailService.getMainIdByLikeDrugNameAndAppCode(queryDrugMainListReq.getAppSearch(), queryDrugMainListReq.getAppCode());
            drugMainParamIds = String.join((CharSequence)",", drugMainIdParamList);
        }
        PageHelper.startPage((int)queryDrugMainListReq.getPageIndex(), (int)queryDrugMainListReq.getPageSize());
        Page queryPharmacistMainDtoPage = this.mosDrugMainMapper.queryPharmacistMainList(queryDrugMainListReq.getAppCode(), queryDrugMainListReq.getTypeTime(), queryDrugMainListReq.getStartTime(), queryDrugMainListReq.getEndTime(), queryDrugMainListReq.getStatus(), type.toString(), queryDrugMainListReq.getSearch(), queryDrugMainListReq.getAppSearch(), drugMainParamIds, queryDrugMainListReq.getOrderType());
        List queryPharmacistMainDtoList = queryPharmacistMainDtoPage.getResult();
        PageResult pageResult = new PageResult();
        if (CollectionUtils.isEmpty((Collection)queryPharmacistMainDtoList)) {
            return BaseResponse.success((Object)pageResult);
        }
        List drugMainIdList = queryPharmacistMainDtoList.stream().map(queryPharmacistMainDto -> queryPharmacistMainDto.getXId().trim()).collect(Collectors.toList());
        String drugMainIds = String.join((CharSequence)",", drugMainIdList);
        List drugDetailEntityList = this.detailService.getByMainIds(drugMainIds);
        Map<String, List<DrugDetailEntity>> drugDetailEntityListMap = drugDetailEntityList.stream().collect(Collectors.groupingBy(drugDetailEntity -> drugDetailEntity.getMainId()));
        List drugRemarkEntityList = this.drugRemarkService.getBatchNewestRemarkEntityByMainIds(drugMainIds);
        Map<String, List<DrugRemarkEntity>> drugRemarkEntityListMap = drugRemarkEntityList.stream().collect(Collectors.groupingBy(DrugRemarkEntity::getMainId));
        List drugExtendEntityList = this.drugExtendService.getListByMainIds(drugMainIds);
        Map<String, DrugExtendEntity> drugExtendEntityListMap = drugExtendEntityList.stream().collect(Collectors.toMap(DrugExtendEntity::getMainId, drugExtendEntity -> drugExtendEntity));
        for (QueryPharmacistMainDto mainDto : queryPharmacistMainDtoList) {
            List<DrugDetailEntity> tempDrugDetailEntityList;
            List<DrugRemarkEntity> drugRemarkEntities;
            if (!this.specialNodeConfig.getZryh().equals(queryDrugMainListReq.getAppCode()) && (DrugTypeEnum.WM.getValue().equals(mainDto.getPresType()) || DrugTypeEnum.CTM.getValue().equals(mainDto.getPresType())) && StringUtils.isNotEmpty((String)queryDrugMainListReq.getVersion()) && "0508".equals(queryDrugMainListReq.getVersion())) {
                mainDto.setPresType(DrugTypeEnum.WCTM.getValue().toString());
            }
            if (CollectionUtils.isNotEmpty(drugRemarkEntities = drugRemarkEntityListMap.get(mainDto.getXId()))) {
                DrugRemarkEntity drugRemarkEntity = drugRemarkEntities.get(drugRemarkEntities.size() - 1);
                mainDto.setRemarkUser(drugRemarkEntity.getRemarkUser());
            }
            if (CollectionUtils.isEmpty(tempDrugDetailEntityList = drugDetailEntityListMap.get(mainDto.getXId()))) {
                mainDto.setDrugNameDes("");
            } else if (tempDrugDetailEntityList.size() == 1) {
                mainDto.setDrugNameDes("\u542b" + tempDrugDetailEntityList.get(0).getDrugName() + "\u5171" + tempDrugDetailEntityList.size() + "\u79cd\u836f\u54c1");
            } else {
                mainDto.setDrugNameDes("\u542b" + tempDrugDetailEntityList.get(0).getDrugName() + "...\u7b49\u5171" + tempDrugDetailEntityList.size() + "\u79cd\u836f\u54c1");
            }
            DrugExtendEntity drugExtendEntity2 = drugExtendEntityListMap.get(mainDto.getXId());
            if (this.specialNodeConfig.getHyt().equals(queryDrugMainListReq.getAppCode()) && StringUtils.isNotBlank((String)mainDto.getHisRecipeNo())) {
                mainDto.setItemStatusDesc("\u5408\u7406");
                mainDto.setAuditStatus(Integer.valueOf(2));
            } else if (DrugMainStatusEnum.APPROVING.getValue().equals(mainDto.getItemStatus())) {
                mainDto.setItemStatusDesc("\u5f85\u5ba1\u6838");
                mainDto.setAuditStatus(Integer.valueOf(1));
            } else if (drugExtendEntity2 != null && AuditStatusEnum.PASS_STATUS.getValue().equals(drugExtendEntity2.getAuditStatus())) {
                mainDto.setItemStatusDesc("\u5408\u7406");
                mainDto.setAuditStatus(Integer.valueOf(2));
            } else {
                mainDto.setItemStatusDesc("\u4e0d\u5408\u7406");
                mainDto.setAuditStatus(Integer.valueOf(3));
            }
            mainDto.setPresTypeMsg(DrugTypeEnum.getDesc((Integer)Integer.valueOf(mainDto.getPresType())));
        }
        pageResult.setContent(queryPharmacistMainDtoList);
        pageResult.setTotal(Integer.parseInt(String.valueOf(queryPharmacistMainDtoPage.getTotal())));
        pageResult.setTotalPages(queryPharmacistMainDtoPage.getPages());
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<PageResult<QueryPharmacistMainDto>> liveryList(Integer patientNoType, String organCode, Integer type, String startTime, String endTime, Integer pageIndex, Integer pageSize, Integer status, String search, Integer userType, String appCode, String doctorId) {
        List recipeNoList;
        Map map = null;
        if (StringUtils.isEmpty((String)appCode)) {
            appCode = organCode;
        }
        ArrayList<Integer> listStatus = new ArrayList<Integer>();
        if (StringUtil.isNotEmpty((String)startTime)) {
            startTime = startTime + " 00:00:00";
        }
        if (StringUtil.isNotEmpty((String)endTime)) {
            endTime = endTime + " 23:59:59";
        }
        List<String> storeIdList = new ArrayList<String>();
        if (1 == userType) {
            if (this.specialNodeConfig.getNcefy().equalsIgnoreCase(appCode)) {
                List storeDoctorResDataList = this.storeDoctorRelMapper.queryByDoctorId(doctorId);
                if (CollectionUtils.isNotEmpty((Collection)storeDoctorResDataList)) {
                    storeIdList = storeDoctorResDataList.stream().map(StoreDoctorResData::getStoreId).collect(Collectors.toList());
                } else {
                    storeIdList.add(ZERO_STR);
                }
            }
            this.getDrugMainStatus(listStatus);
        } else {
            for (DrugMainStatusEnum drugMainStatusEnum : DrugMainStatusEnum.values()) {
                listStatus.add(drugMainStatusEnum.getValue());
            }
        }
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List mainDtoList = this.mosDrugMainMapper.getCommonDrugMainList(patientNoType, appCode, listStatus, status, search, type, startTime, endTime, storeIdList);
        if (CollectionUtils.isNotEmpty((Collection)mainDtoList) && this.specialNodeConfig.getHyt().equals(appCode) && CollectionUtils.isNotEmpty(recipeNoList = mainDtoList.stream().map(v -> v.getHisRecipeNo()).collect(Collectors.toList()))) {
            map = this.hisManage.getHisRecipeStatus(recipeNoList);
        }
        for (QueryPharmacistMainDto dto : mainDtoList) {
            if (map == null) continue;
            DrugMainEntity drugMainEntity = null;
            DrugOrderEntity drugOrderEntity = null;
            if (HytHisRecipeStatusEnum.REFUND.getValue().equals(map.get(dto.getHisRecipeNo()))) {
                drugMainEntity = new DrugMainEntity();
                drugOrderEntity = this.mosDrugOrderMapper.queryByMainId(dto.getXId());
                drugMainEntity.setxId(dto.getXId());
                dto.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
                drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOY_BACK.getValue());
                if (drugOrderEntity != null) {
                    drugOrderEntity.setxId(drugOrderEntity.getxId());
                    drugOrderEntity.setStatus(OrderStatusEnum.HIS_REFUNDED.getValue());
                }
            }
            if (HytHisRecipeStatusEnum.PAY.getValue().equals(map.get(dto.getHisRecipeNo())) && OrderTypeEnum.DRUG_ORDER.getValue().toString().equals(dto.getMainOrderType())) {
                drugMainEntity = new DrugMainEntity();
                drugMainEntity.setxId(dto.getXId());
                dto.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
                drugMainEntity.setItemStatus(DrugMainStatusEnum.FINISH.getValue());
            }
            if (drugMainEntity != null) {
                this.mosDrugMainMapper.update(drugMainEntity);
            }
            if (drugOrderEntity == null) continue;
            this.mosDrugOrderMapper.update(drugOrderEntity);
        }
        PageInfo pageInfo = new PageInfo(mainDtoList);
        PageResult pageResult = new PageResult(pageIndex.intValue(), pageSize.intValue());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(mainDtoList);
        return BaseResponse.success((Object)pageResult);
    }

    private void getDrugMainStatus(List<Integer> listStatus) {
        listStatus.add(DrugMainStatusEnum.DEPLOYING.getValue());
        listStatus.add(DrugMainStatusEnum.DEPLOY_BACK.getValue());
        listStatus.add(DrugMainStatusEnum.TO_SEND.getValue());
        listStatus.add(DrugMainStatusEnum.SENT.getValue());
        listStatus.add(DrugMainStatusEnum.TO_TAKE.getValue());
        listStatus.add(DrugMainStatusEnum.GET_MEDICINE.getValue());
        listStatus.add(DrugMainStatusEnum.SIGN_IN.getValue());
        listStatus.add(DrugMainStatusEnum.FINISH.getValue());
        listStatus.add(DrugMainStatusEnum.TO_TRANSPORT.getValue());
        listStatus.add(DrugMainStatusEnum.TO_DELIVERY.getValue());
        listStatus.add(DrugMainStatusEnum.OFFLINE_CONFIRM.getValue());
    }

    public List<ExpressInfo> exportExressInfo(String appCode, Integer type, String startTime, String endTime, Integer status, String search, String doctorId, Integer userType) {
        List<String> storeIdList = new ArrayList<String>();
        if (this.specialNodeConfig.getNcefy().equalsIgnoreCase(appCode)) {
            List storeDoctorResDataList = this.storeDoctorRelMapper.queryByDoctorId(doctorId);
            if (CollectionUtils.isNotEmpty((Collection)storeDoctorResDataList)) {
                storeIdList = storeDoctorResDataList.stream().map(StoreDoctorResData::getStoreId).collect(Collectors.toList());
            } else {
                storeIdList.add(ZERO_STR);
            }
        }
        ArrayList listStatus = new ArrayList();
        this.getDrugMainStatus(listStatus);
        List list = this.mosDrugMainMapper.getCommonDrugMainList(null, appCode, listStatus, status, search, type, startTime, endTime, storeIdList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<ExpressInfo>();
        }
        ArrayList<ExpressInfo> infoList = new ArrayList<ExpressInfo>();
        Integer i = 1;
        for (QueryPharmacistMainDto mainDto : list) {
            DrugMainEntity drugMainEntity = this.queryById(mainDto.getXId());
            DrugPrescriptionEntity prescriptionEntity = this.prescriptionService.queryByMainId(mainDto.getXId());
            DiagnosticEntity diagnosticEntity = this.diagnosticService.getById(prescriptionEntity.getAdmId());
            DrugExtendEntity extendEntity = this.drugExtendService.getByMainId(mainDto.getXId());
            List detailEntityList = this.detailService.listByMainId(mainDto.getXId());
            DrugOrderEntity orderEntity = this.mosDrugOrderService.queryByMainIdAndOrderStatus(mainDto.getXId(), OrderStatusEnum.PAID.getValue());
            MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByMainId(drugMainEntity.getxId());
            DrugRemarkEntity drugRemarkEntity = this.drugRemarkService.queryByMainIdAndRamarkType(mainDto.getXId(), RemarkTypeEnum.TAKE_MEDICAL.getValue());
            ExpressInfo expressInfo = new ExpressInfo();
            Integer n = i;
            i = i + 1;
            Integer n2 = i;
            expressInfo.setId(String.valueOf(n));
            expressInfo.setOrderId(mainDto.getXId());
            expressInfo.setMainTime(DateTimeUtil.formatTime((Date)drugMainEntity.getxCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
                BigDecimal drugCount = BigDecimal.ZERO;
                for (DrugDetailEntity detailEntity : detailEntityList) {
                    drugCount = detailEntity.getAmount().add(drugCount);
                }
                expressInfo.setDrugCount(drugCount == null ? ZERO_STR : String.valueOf(drugCount.doubleValue()));
            }
            expressInfo.setPatientName(drugMainEntity.getPatientName());
            expressInfo.setDrugNames(detailEntityList.stream().map(DrugDetailEntity::getDrugName).collect(Collectors.joining(",")));
            expressInfo.setDiagnosis(diagnosticEntity == null ? "" : diagnosticEntity.getDiagnostic());
            expressInfo.setPatientNo(drugMainEntity.getPatientNo());
            expressInfo.setRecipientPhone(mosDrugLogisticsOrderEntity == null ? "" : mosDrugLogisticsOrderEntity.getDestPhone());
            expressInfo.setRecipientUser(mosDrugLogisticsOrderEntity == null ? "" : mosDrugLogisticsOrderEntity.getDestName());
            expressInfo.setRecipientAddress(mosDrugLogisticsOrderEntity == null ? "" : mosDrugLogisticsOrderEntity.getDestAddress());
            expressInfo.setOrderDoctorName(drugMainEntity.getPresDoctorName());
            expressInfo.setOrderDoctorNo(drugMainEntity.getPresDoctorId());
            expressInfo.setPresCount("1");
            expressInfo.setDrugPrice(Objects.isNull(prescriptionEntity.getPrice()) ? "" : prescriptionEntity.getPrice().toString());
            expressInfo.setPayMethod(orderEntity == null ? "" : (orderEntity.getPayMethod().equals(PayTypeEnum.WECHAT_PAY.getValue()) ? "\u5fae\u4fe1" : "\u652f\u4ed8\u5b9d"));
            expressInfo.setDealSeq(orderEntity == null ? "" : orderEntity.getDealSeq());
            expressInfo.setOtherPrice(mosDrugLogisticsOrderEntity == null ? "" : (mosDrugLogisticsOrderEntity.getPayAmount() == null ? "" : mosDrugLogisticsOrderEntity.getPayAmount().toString()));
            if (CollectionUtils.isNotEmpty((Collection)detailEntityList) && StringUtils.isNotEmpty((String)((DrugDetailEntity)detailEntityList.get(0)).getStoreId())) {
                System.out.println(((DrugDetailEntity)detailEntityList.get(0)).getStoreId());
                DrugstoreEntity drugstoreEntity = this.mosDrugstoreMapper.queryById(((DrugDetailEntity)detailEntityList.get(0)).getStoreId());
                if (drugstoreEntity != null && drugstoreEntity.getServiceFee() != null) {
                    expressInfo.setOtherPrice(drugstoreEntity.getServiceFee().toString());
                } else {
                    expressInfo.setOtherPrice("0.0");
                }
            }
            expressInfo.setPayMethod(orderEntity == null ? "" : (orderEntity.getPayMethod().equals(PayTypeEnum.WECHAT_PAY.getValue()) ? "\u5fae\u4fe1" : "\u652f\u4ed8\u5b9d"));
            expressInfo.setOrderSeq(orderEntity == null ? "" : orderEntity.getOrderSeq());
            expressInfo.setAuditUser(extendEntity == null ? "" : extendEntity.getVerifier());
            expressInfo.setAuditUserNo(extendEntity == null ? "" : extendEntity.getVerifierCode());
            String result = drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.DEPLOY_BACK.getValue()) || DrugMainStatusEnum.PHARMACIST_BACK.getValue().equals(drugMainEntity.getItemStatus()) ? "\u4e0d\u901a\u8fc7" : "\u901a\u8fc7";
            expressInfo.setAuditResult(result);
            expressInfo.setProvisUser(extendEntity == null ? "" : extendEntity.getDeployer());
            expressInfo.setProvisTime(extendEntity == null ? "" : DateTimeUtil.formatTime((Date)extendEntity.getDeployTime()));
            expressInfo.setExpressUser(mosDrugLogisticsOrderEntity == null ? "" : mosDrugLogisticsOrderEntity.getSrcName());
            expressInfo.setExpressTime(mosDrugLogisticsOrderEntity == null ? "" : DateTimeUtil.formatTime((Date)mosDrugLogisticsOrderEntity.getCreateTime()));
            expressInfo.setExpressNo2(mosDrugLogisticsOrderEntity == null ? "" : mosDrugLogisticsOrderEntity.getMainNo());
            expressInfo.setTakeTime(drugRemarkEntity == null ? "" : DateTimeUtil.formatTime((Date)drugRemarkEntity.getxCreateTime()));
            infoList.add(expressInfo);
        }
        return infoList;
    }

    public List<DrugMainEntity> getByAppCodeAndItemStatus(String appCode, String ItemStatus) {
        return this.mosDrugMainMapper.getByAppCodeAndItemStatus(appCode, ItemStatus);
    }

    public BaseResponse<String> auditOperation(OprationDrugMainDto oprationDrugMainDto) {
        String userId;
        log.info("\u5ba1\u6838\u5904\u65b9\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)oprationDrugMainDto));
        DrugMainEntity mainEntity = this.queryById(oprationDrugMainDto.getMainId());
        MosOutpatientMainRelEntity outpatientMainRelEntity = this.mosOutpatientMainRelService.getByMainId(oprationDrugMainDto.getMainId());
        PresDetailResultDTO detailResultDTO = this.mosDrugMainMapper.queryPresDetail(oprationDrugMainDto.getMainId());
        Integer itemStatus = null;
        String status = "";
        String remark = "";
        String drugDesc = "";
        Integer mainStatus = DrugMainStatusEnum.PHARMACIST_BACK.getValue();
        if (mainEntity == null) {
            return BaseResponse.error((String)"\u6b64\u5904\u65b9\u4e0d\u5b58\u5728");
        }
        boolean isAuditedPres = this.isAuditedPres(mainEntity.getItemStatus());
        if (isAuditedPres) {
            return BaseResponse.error((String)"\u8be5\u5904\u65b9\u5df2\u7ecf\u88ab\u5ba1\u6838\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c");
        }
        if (!this.specialNodeConfig.getZryh().equals(mainEntity.getPresOrgan())) {
            RabbitMqUtils.senderDelayedPrescriptionOrder((RabbitTemplate)this.rabbitTemplate, (String)mainEntity.getxId(), (Integer)259200);
            mainEntity.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
        }
        itemStatus = oprationDrugMainDto.getOpration().equals(1) ? DrugMainStatusEnum.ZRYH_UNPAID.getValue() : DrugMainStatusEnum.PHARMACIST_BACK.getValue();
        mainEntity.setItemStatus(itemStatus);
        this.update(mainEntity);
        this.saveDrugExtend(oprationDrugMainDto.getMainId(), oprationDrugMainDto.getOprationUser(), oprationDrugMainDto.getOperationId(), oprationDrugMainDto.getDoctorSign(), oprationDrugMainDto.getContent(), oprationDrugMainDto.getOpration());
        this.addRemark(oprationDrugMainDto.getMainId(), oprationDrugMainDto.getContent(), oprationDrugMainDto.getOprationUser(), RemarkTypeEnum.VERIFIER.getValue());
        if (DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(itemStatus) || DrugMainStatusEnum.DEPLOYING.getValue().equals(itemStatus)) {
            status = "\u5df2\u901a\u8fc7";
            remark = "\u5ba1\u6838\u901a\u8fc7\uff0c\u5904\u65b9\u5df2\u53d1\u9001\u60a3\u8005";
            mainStatus = 200;
            try {
                userId = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(mainEntity.getPresDoctorId()))).getUserId();
                if (outpatientMainRelEntity != null && StringUtils.isNotEmpty((String)outpatientMainRelEntity.getAdmissionId())) {
                    String patientMsg = "\u533b\u751f\u7ed9\u60a8\u5f00\u5177\u4e86\u4e00\u4e2a\u5904\u65b9,\u5904\u65b9\u8be6\u60c5\u8bf7\u67e5\u770b" + oprationDrugMainDto.getMainId();
                    this.asynManage.imPushMsgByMainId(BusinessCodeEnum.OBTAIN.getValue(), oprationDrugMainDto.getMainId(), "", "EHOS_PATIENT", mainEntity.getPatientUserId(), outpatientMainRelEntity.getAdmissionId(), (Object)patientMsg, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
                }
                this.pushManage.iAppMsgPush(UserEnum.DOCTOR.getDesc(), mainEntity.getPresOrgan(), PushCodeInfoEnum.ZRYH_CHECK_PASS_PRES.getBusiCode(), "\u60a8\u7684\u5904\u65b9\u7533\u8bf7\u5df2\u901a\u8fc7\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u3002", PushCodeInfoEnum.ZRYH_CHECK_PASS_PRES.getDesc(), PushCodeInfoEnum.ZRYH_CHECK_PASS_PRES.getDesc(), PushCodeInfoEnum.ZRYH_CHECK_PASS_PRES.getActionCode(), PushCodeInfoEnum.ZRYH_CHECK_PASS_PRES.getValueCode().toString(), mainEntity.getxId(), this.doctorRetmoteManage.getDevice(userId, UserTypeEnum.DOCTOR.getValue(), mainEntity.getPresOrgan()));
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new AsynException(e.getMessage());
            }
            try {
                String doctorPhone = this.doctorRetmoteManage.getDoctorPhone(Long.valueOf(Long.parseLong(mainEntity.getPresDoctorId())));
                if (StringUtil.isNotEmpty((String)doctorPhone)) {
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(mainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("doctorCode");
                    this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_cfshtg", doctorPhone, new HashMap());
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new AsynException(e.getMessage());
            }
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", mainEntity.getPresDoctorName());
            data.put("doctorName", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", "\u5904\u65b9\u5df2\u5f00\u5177");
            data.put("issue", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", "\u60a8\u7684\u5904\u65b9\u5df2\u5f00\u5177\uff0c\u8bf7\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u67e5\u770b\u5904\u65b9\u8be6\u60c5");
            data.put("info", map3);
            this.pushManage.iWeChatPush(mainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(mainEntity.getPresOrgan(), mainEntity.getPatientUserId()), data, "/prescription/pages/status/status?mainId=" + mainEntity.getxId());
            try {
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(mainEntity.getPresOrgan(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_hzsdcf", mainEntity.getPatientPhone(), new HashMap());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new AsynException(e.getMessage());
            }
        }
        status = DrugMainStatusEnum.PHARMACIST_BACK.getDesc();
        remark = "\u5904\u65b9\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u8be5\u5904\u65b9\u5df2\u9000\u56de";
        try {
            userId = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(mainEntity.getPresDoctorId()))).getUserId();
            this.pushManage.iAppMsgPush(UserEnum.DOCTOR.getDesc(), mainEntity.getPresOrgan(), PushCodeInfoEnum.ZRYH_CHECK_FAIL_PRES.getBusiCode(), "\u60a8\u7684\u5904\u65b9\u7533\u8bf7\u672a\u901a\u8fc7\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u3002", PushCodeInfoEnum.ZRYH_CHECK_FAIL_PRES.getDesc(), PushCodeInfoEnum.ZRYH_CHECK_FAIL_PRES.getDesc(), PushCodeInfoEnum.ZRYH_CHECK_FAIL_PRES.getActionCode(), PushCodeInfoEnum.ZRYH_CHECK_FAIL_PRES.getValueCode().toString(), mainEntity.getxId(), this.doctorRetmoteManage.getDevice(userId, UserTypeEnum.DOCTOR.getValue(), mainEntity.getPresOrgan()));
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AsynException(e.getMessage());
        }
        try {
            UcConfigurationVO configurationVO = this.pushManage.getClientCode(mainEntity.getPresOrgan(), "sms");
            String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("doctorCode");
            this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_cfshwtg", mainEntity.getPresDoctorPhone(), new HashMap());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AsynException(e.getMessage());
        }
        try {
            int drugCount = 0;
            String drugName = "";
            String presType = "";
            DrugDetailEntity drugDetailEntity = new DrugDetailEntity();
            drugDetailEntity.setMainId(mainEntity.getxId());
            List drugDetailList = this.detailService.listByMainId(mainEntity.getxId());
            if (CollectionUtils.isNotEmpty((Collection)drugDetailList)) {
                drugCount = drugDetailList.size();
                drugName = ((DrugDetailEntity)drugDetailList.get(0)).getDrugName();
            }
            drugDesc = drugCount == 1 ? "\u542b" + drugName + "\u5171" + drugCount + "\u79cd\u836f\u54c1" : "\u542b" + drugName + "...\u7b49\u5171" + drugCount + "\u79cd\u836f\u54c1";
            if (mainEntity.getPresType() != null) {
                presType = DrugTypeEnum.getDesc((Integer)mainEntity.getPresType());
            }
            String doctorMsg = "\u60a8\u7ed9\u60a3\u8005" + mainEntity.getPatientName() + "\u5f00\u5177\u4e86\u4e00\u4e2a\u5904\u65b9,\u5904\u65b9\u8be6\u60c5\u8bf7\u67e5\u770b" + mainEntity.getxId();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("msg", (Object)doctorMsg);
            jsonObject.put("mainId", (Object)mainEntity.getxId());
            jsonObject.put("presType", (Object)(presType + "\u5904\u65b9"));
            jsonObject.put("status", (Object)status);
            jsonObject.put("diagnostic", (Object)(StringUtils.isEmpty((String)detailResultDTO.getDiagnostic()) ? "" : detailResultDTO.getDiagnostic()));
            jsonObject.put("drugDesc", (Object)drugDesc);
            jsonObject.put("remark", (Object)remark);
            jsonObject.put("itemStatus", (Object)mainStatus);
            String doctorUserId = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(mainEntity.getPresDoctorId()))).getUserId();
            this.asynManage.imPushMsgByMainId(BusinessCodeEnum.OBTAIN.getValue(), mainEntity.getxId(), "", "EHOS_DOCTOR", doctorUserId, outpatientMainRelEntity.getAdmissionId(), (Object)jsonObject, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AsynException(e.getMessage());
        }
        try {
            this.prescriptionPdfService.setPresPdf(oprationDrugMainDto.getMainId(), null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("========\u4e0a\u6d77\u5408\u7406\u7528\u836f\u6267\u884c\u524d=======");
        this.mosDrugPrescriptionService.getAuditResultResVo(oprationDrugMainDto.getMainId(), "1");
        log.info("========\u4e0a\u6d77\u5408\u7406\u7528\u836f\u6267\u884c\u540e=======");
        return BaseResponse.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    private synchronized boolean isAuditedPres(Integer itemStatus) {
        return !DrugMainStatusEnum.APPROVING.getValue().equals(itemStatus);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> addNotes(BaseOperationDto baseOperationDto) {
        DrugMainEntity drugMainEntity = this.queryById(baseOperationDto.getMainId());
        if (drugMainEntity == null) {
            return BaseResponse.error((String)"\u6b64\u5904\u65b9\u4e0d\u5b58\u5728");
        }
        this.addRemark(baseOperationDto.getMainId(), baseOperationDto.getContent(), baseOperationDto.getOprationUser(), RemarkTypeEnum.REMARK.getValue());
        return BaseResponse.success((Object)"\u5907\u6ce8\u6dfb\u52a0\u6210\u529f");
    }

    public void addRemark(String mainId, String content, String operationUser, Integer remardType) {
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugRemarkEntity.setMainId(mainId);
        drugRemarkEntity.setRemarkContent(content);
        drugRemarkEntity.setRemarkUser(operationUser);
        drugRemarkEntity.setRemarkType(remardType);
        this.drugRemarkService.insert(drugRemarkEntity);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> completeDeployment(ComplateOrBackDtoReq complateOrBackDtoReq) {
        log.info("=======>\u5b8c\u6210\u8c03\u914d\u9000\u56de\u53c2\u6570-->{}", (Object)JSON.toJSONString((Object)complateOrBackDtoReq));
        DrugMainEntity drugMainEntity = this.queryById(complateOrBackDtoReq.getMainId());
        if (drugMainEntity.getPatientNoType() != null && drugMainEntity.getPatientNoType() != 3) {
            DrugOrderEntity orderEntity = this.mosDrugOrderService.queryByMainId(complateOrBackDtoReq.getMainId());
            if (orderEntity != null && orderEntity.getOrderType() == null) {
                DrugMainEntity drugMainInfo = this.mosDrugMainMapper.queryById(complateOrBackDtoReq.getMainId());
                orderEntity.setOrderType(drugMainInfo.getOrderType());
            }
            if (drugMainEntity == null || orderEntity == null) {
                return BaseResponse.error((String)"\u6b64\u5904\u65b9\u4e0d\u5b58\u5728\uff01");
            }
            if (OrderStatusEnum.REFUNDED.getValue().equals(orderEntity.getStatus()) || OrderStatusEnum.REFUNDING.getValue().equals(orderEntity.getStatus())) {
                return BaseResponse.error((String)"\u6b64\u5904\u65b9\u7684\u8ba2\u5355\u5df2\u7ecf\u9000\u6b3e\u6216\u662f\u6b63\u5728\u9000\u6b3e\uff0c\u4e0d\u53ef\u8fdb\u884c\u8c03\u914d\u64cd\u4f5c\uff01");
            }
        }
        Integer mainStatus = 0;
        if (BaseStatusEnum.VALID_STATUS.getValue().equals(complateOrBackDtoReq.getOperation())) {
            DrugOrderEntity drugOrderEntity;
            if (drugMainEntity.getOrderType() == null && (drugOrderEntity = this.mosDrugOrderService.queryByMainIdAndOrderStatus(complateOrBackDtoReq.getMainId(), OrderStatusEnum.PAID.getValue())) != null) {
                drugMainEntity.setOrderType(drugOrderEntity.getOrderType());
            }
            mainStatus = drugMainEntity.getOrderType().equals(OrderTypeEnum.COURIER_ORDER.getValue()) ? DrugMainStatusEnum.TO_SEND.getValue() : DrugMainStatusEnum.TO_TAKE.getValue();
        } else {
            mainStatus = DrugMainStatusEnum.DEPLOY_BACK.getValue();
        }
        DrugExtendEntity drugExtendEntity = this.drugExtendService.getByMainId(complateOrBackDtoReq.getMainId());
        if (drugExtendEntity == null) {
            drugExtendEntity = new DrugExtendEntity();
            drugExtendEntity.setDeployer(complateOrBackDtoReq.getOprationUser());
            drugExtendEntity.setDeployRemark(complateOrBackDtoReq.getContent());
            drugExtendEntity.setDeployTime(DateUtils.getThisDateTime((Date)new Date()));
            drugExtendEntity.setMainId(drugMainEntity.getxId());
            drugExtendEntity.setxId(GenSeqUtils.getUniqueNo());
            drugExtendEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugExtendEntity.setAuditStatus(AuditStatusEnum.PASS_STATUS.getValue());
            this.drugExtendService.insert(drugExtendEntity);
        } else {
            drugExtendEntity.setDeployer(complateOrBackDtoReq.getOprationUser());
            drugExtendEntity.setDeployRemark(complateOrBackDtoReq.getContent());
            drugExtendEntity.setDeployTime(DateUtils.getThisDateTime((Date)new Date()));
            this.drugExtendService.updateById(drugExtendEntity);
        }
        DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
        drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
        drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugRemarkEntity.setRemarkContent(complateOrBackDtoReq.getContent());
        drugRemarkEntity.setMainId(complateOrBackDtoReq.getMainId());
        drugRemarkEntity.setRemarkType(RemarkTypeEnum.DEPLOYMENT.getValue());
        drugRemarkEntity.setRemarkUser(complateOrBackDtoReq.getOprationUser());
        drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.drugRemarkService.insert(drugRemarkEntity);
        drugMainEntity.setItemStatus(mainStatus);
        this.update(drugMainEntity);
        if (DrugMainStatusEnum.DEPLOY_BACK.getValue().equals(mainStatus)) {
            this.automaticRefund(complateOrBackDtoReq.getMainId(), "\u8c03\u914d\u7f3a\u8d27\u9000\u6b3e", complateOrBackDtoReq.getOprationUser());
        }
        try {
            this.prescriptionPdfService.setPresPdf(complateOrBackDtoReq.getMainId(), null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (DrugMainStatusEnum.TO_TAKE.getValue().equals(mainStatus)) {
            this.pushManage.iAppMsgPush(UserEnum.PATIENT.getDesc(), drugMainEntity.getPresOrgan(), PushCodeInfoEnum.DEPLOY.getBusiCode(), "\u60a8\u7684\u5904\u65b9\u5df2\u8c03\u914d\u5b8c\u6210\uff0c\u8bf7\u5c3d\u5feb\u5230\u836f\u623f\u53d6\u836f", "\u8c03\u914d\u5b8c\u6210\u901a\u77e5", PushCodeInfoEnum.DEPLOY.getDesc(), PushCodeInfoEnum.DEPLOY.getActionCode(), PushCodeInfoEnum.DEPLOY.getValueCode().toString(), drugMainEntity.getxId(), this.doctorRetmoteManage.getDevice(drugMainEntity.getPatientUserId(), UserTypeEnum.PATIENT.getValue(), drugMainEntity.getPresOrgan()));
            new Thread(() -> {
                LinkedHashMap data = new LinkedHashMap();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("value", drugMainEntity.getPresDoctorName());
                data.put("doctorName", map1);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("value", "\u836f\u54c1\u8c03\u914d\u5b8c\u6210");
                data.put("issue", map2);
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("value", "\u836f\u54c1\u914d\u836f\u5b8c\u6210\uff0c\u8bf7\u5c3d\u5feb\u524d\u5f80\u533b\u9662\u836f\u623f\u8fdb\u884c\u53d6\u836f");
                data.put("info", map3);
                this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/detial/detial?mainId=" + drugMainEntity.getxId());
                try {
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("doctorName", drugMainEntity.getPresDoctorName());
                    this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy-apps", drugMainEntity.getPatientPhone(), hashMap);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new AsynException(e.getMessage());
                }
            }).start();
        }
        return BaseResponse.success((Object)"\u8c03\u914d\u5b8c\u6210");
    }

    public void saveDrugExtend(String mainId, String doctorName, String doctorCode, String doctorSign, String remark, Integer auditStatus) {
        if (StringUtils.isNotEmpty((String)mainId)) {
            DrugExtendEntity drugExtendEntity = this.drugExtendService.getByMainId(mainId);
            if (drugExtendEntity == null) {
                drugExtendEntity = new DrugExtendEntity();
                drugExtendEntity.setxId(GenSeqUtils.getUniqueNo());
                drugExtendEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setMainId(mainId);
                drugExtendEntity.setVerifier(doctorName);
                drugExtendEntity.setVerifierCode(doctorCode);
                log.info("=========\u533b\u751fcode" + doctorCode);
                DoctorEntityInfoVO verifierVO = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(doctorCode)));
                if (verifierVO != null) {
                    drugExtendEntity.setVerifierDeptName(verifierVO.getHospitalDeptName());
                    QueryOrganDetailVO organDetailVO = this.doctorRetmoteManage.queryOrganDetail(verifierVO.getOrganId());
                    if (organDetailVO != null) {
                        drugExtendEntity.setVerifierOrganName(StringUtils.isEmpty((String)organDetailVO.getOrganName()) ? "" : organDetailVO.getOrganName());
                    }
                    drugExtendEntity.setVerifierPhone(StringUtils.isEmpty((String)verifierVO.getContactMobile()) ? "" : verifierVO.getContactMobile());
                }
                drugExtendEntity.setVerifyTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setVerifyRemark(remark);
                drugExtendEntity.setAuditStatus(auditStatus);
                drugExtendEntity.setVerifySign(doctorSign);
                this.drugExtendService.insert(drugExtendEntity);
            } else {
                drugExtendEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setVerifyTime(DateUtils.getThisDateTime((Date)new Date()));
                drugExtendEntity.setVerifyRemark(remark);
                drugExtendEntity.setAuditStatus(auditStatus);
                drugExtendEntity.setVerifySign(doctorSign);
                this.drugExtendService.updateById(drugExtendEntity);
            }
        }
    }

    public void automaticRefund(String mainId, String remark, String remarkUser) {
        BaseOperationDto baseOperationDto = new BaseOperationDto();
        baseOperationDto.setMainId(mainId);
        baseOperationDto.setOprationUser(remarkUser);
        baseOperationDto.setContent(remark);
        BaseResponse stringBaseResponse = this.orderPayManage.applyRefund(baseOperationDto);
        if (ReturnCodeEnum.FAILURE.getValue().equalsIgnoreCase(stringBaseResponse.getCode())) {
            log.info("\u9000\u6b3e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u662f:{}", (Object)stringBaseResponse.getMsg());
            throw new RuntimeException("\u9000\u6b3e\u5f02\u5e38!!");
        }
    }

    private void synchronizePres(DrugMainEntity drugMainEntity, List<DrugDetailEntity> drugDetailEntityList) {
        MosOutpatientMainRelEntity mosOutpatientMainRelEntity = this.mosOutpatientMainRelService.getByMainId(drugMainEntity.getxId());
        PresDetailResultDTO reqDTO = this.mosDrugMainMapper.queryPresDetail(drugMainEntity.getxId());
        SynchPresReq synchPresReq = new SynchPresReq();
        synchPresReq.setAccess_token(this.specialNodeConfig.getAccessToken());
        synchPresReq.setDoctorName(drugMainEntity.getPresDoctorName());
        synchPresReq.setHisprescriptionId(drugMainEntity.getxId());
        synchPresReq.setEmployeeCardNo(drugMainEntity.getPresDoctorCode());
        synchPresReq.setHospitalName(drugMainEntity.getPresOrganName());
        synchPresReq.setSymptoms(mosOutpatientMainRelEntity.getDiseaseDescription());
        synchPresReq.setDepartmentId(drugMainEntity.getPresDeptCode());
        synchPresReq.setDepartmentName(drugMainEntity.getPresDeptName());
        synchPresReq.setPrescriptionType("39");
        synchPresReq.setDiagnoseName(StringUtils.isEmpty((String)reqDTO.getDiagnostic()) ? "" : reqDTO.getDiagnostic());
        synchPresReq.setMedicalFee(ZERO_STR);
        synchPresReq.setPatientCard(drugMainEntity.getPatientNo());
        synchPresReq.setHisPatientId(drugMainEntity.getPatientId());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemoteManage.getPatientInfoById(Long.valueOf(Long.parseLong(drugMainEntity.getPatientId().trim())), drugMainEntity.getPresOrgan(), this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(drugMainEntity.getPresDoctorId().trim()))).getOrganId().toString());
        MesPatient mesPatient = new MesPatient();
        mesPatient.setAreaCode("+86");
        mesPatient.setBirthday(patientInfoRespVO.getBirthdate());
        mesPatient.setPatientSex(patientInfoRespVO.getGender().toString());
        mesPatient.setCertificateId(patientInfoRespVO.getCredNo());
        mesPatient.setPatientName(drugMainEntity.getPatientName());
        mesPatient.setPhoneNo(drugMainEntity.getPatientPhone());
        synchPresReq.setMesPatient(mesPatient);
        ArrayList<MesDrugDetail> mesDrugDetails = new ArrayList<MesDrugDetail>();
        for (DrugDetailEntity drugDetailEntity : drugDetailEntityList) {
            MesDrugDetail mesDrugDetail = new MesDrugDetail();
            mesDrugDetail.setDrugId(drugDetailEntity.getDrugId());
            mesDrugDetail.setSpec(drugDetailEntity.getDrugSpec());
            mesDrugDetail.setAmount(drugDetailEntity.getAmount().setScale(0, 4).toString());
            mesDrugDetail.setForm(drugDetailEntity.getFrequencyDesc());
            mesDrugDetail.setHospDrugPrice(drugDetailEntity.getUnitPrice().toString());
            mesDrugDetails.add(mesDrugDetail);
        }
        synchPresReq.setMesDrugDetailList(mesDrugDetails);
        String url = this.nodeConfig.getAddHospitalPrescription();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("projectCode", "ZRYHYY");
        log.info("\u7ed9\u56fd\u836f\u534e\u6cf0\u540c\u6b65\u5904\u65b9\u7684\u8bf7\u6c42\u662f:{}======header\u662f:{}===\u53c2\u6570\u662f:{}", new Object[]{url, headMap, JSON.toJSONString((Object)synchPresReq)});
        try {
            String resData = HttpUtils.post((String)url, headMap, (String)JSON.toJSONString((Object)synchPresReq));
            log.info("\u5904\u65b9:{}\u540c\u6b65\u56fd\u836f\u534e\u6cf0\u5904\u65b9\u8fd4\u56de\u7684\u7ed3\u679c\u662f:{}", (Object)drugMainEntity.getxId(), (Object)resData);
            Integer code = JSONObject.parseObject((String)resData).getInteger("code");
            String responseMessge = JSONObject.parseObject((String)resData).getString("message");
            String responseData = JSONObject.parseObject((String)resData).getString("responseData");
            MosSynchPresRecordEntity synchPresRecordEntity = new MosSynchPresRecordEntity();
            synchPresRecordEntity.setDoctorName(synchPresReq.getDoctorName());
            synchPresRecordEntity.setMainId(drugMainEntity.getxId());
            synchPresRecordEntity.setPatientIdCard(patientInfoRespVO.getCredNo());
            synchPresRecordEntity.setPatientName(drugMainEntity.getPatientName());
            synchPresRecordEntity.setCompensateTimes(Integer.valueOf(0));
            synchPresRecordEntity.setPatientPhone(drugMainEntity.getPatientPhone());
            synchPresRecordEntity.setRequestBody(JSON.toJSONString((Object)synchPresReq));
            synchPresRecordEntity.setResponseCode(code);
            synchPresRecordEntity.setResponseData(responseData);
            synchPresRecordEntity.setResponseMessage(responseMessge);
            this.mosSynchPresRecordService.insert(synchPresRecordEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public BaseResponse<String> synchPres(String mainId) {
        DrugMainEntity mainEntity = this.queryById(mainId);
        if (mainEntity == null) {
            return BaseResponse.error((String)"\u9700\u8981\u540c\u6b65\u7684\u5904\u65b9\u4e0d\u5b58\u5728!");
        }
        if (this.specialNodeConfig.getZryh().equalsIgnoreCase(mainEntity.getPresOrgan()) && DrugMainStatusEnum.ZRYH_UNPAID.getValue().equals(mainEntity.getItemStatus()) && DrugTypeEnum.WM.getValue().equals(mainEntity.getPresType())) {
            MosSynchPresRecordEntity synchPresRecordEntity = this.mosSynchPresRecordService.queryListByMainId(mainId);
            List drugDetailEntities = this.detailService.listByMainId(mainEntity.getxId());
            if (synchPresRecordEntity == null && CollectionUtils.isNotEmpty((Collection)drugDetailEntities) && DrugTypeEnum.WM.getValue().equals(mainEntity.getPresType())) {
                this.synchronizePres(mainEntity, drugDetailEntities);
            }
        }
        return BaseResponse.success((Object)"\u6613\u590d\u8bca\u5904\u65b9\u540c\u6b65\u6210\u529f");
    }

    public BaseResponse<List<MosDrugLogisticsRouteEntity>> queryLogisticsRoute(Long logisticsOrderId) {
        List mosDrugLogisticsRouteEntityList = this.mosDrugLogisticsRouteMapper.selectListByLogisticsOrderId(logisticsOrderId);
        mosDrugLogisticsRouteEntityList = mosDrugLogisticsRouteEntityList.stream().sorted(Comparator.comparing(MosDrugLogisticsRouteEntity::getAcceptTotalTime)).collect(Collectors.toList());
        return BaseResponse.success(mosDrugLogisticsRouteEntityList);
    }

    public String logisticsRouteCall(WaybillRouteVo waybillRouteVo) {
        log.info("\u7269\u6d41\u8def\u7531\u4fe1\u606f->{}", (Object)waybillRouteVo.toString());
        List mosDrugLogisticsOrderRegEntityList = this.mosDrugLogisticsOrderRegMapper.selectByLogisticsOrderSeq(waybillRouteVo.getOrderId());
        if (CollectionUtils.isEmpty((Collection)mosDrugLogisticsOrderRegEntityList)) {
            return "SUCCESS";
        }
        MosDrugLogisticsRouteEntity mosDrugLogisticsRouteEntity = new MosDrugLogisticsRouteEntity();
        mosDrugLogisticsRouteEntity.setOpCode(waybillRouteVo.getOpCode());
        mosDrugLogisticsRouteEntity.setRemark(waybillRouteVo.getRemark());
        mosDrugLogisticsRouteEntity.setAcceptTotalTime(waybillRouteVo.getAcceptTime());
        mosDrugLogisticsRouteEntity.setLogisticsOrderId(((MosDrugLogisticsOrderRegEntity)mosDrugLogisticsOrderRegEntityList.get(0)).getLogisticsOrderId());
        mosDrugLogisticsRouteEntity.setMailNo(waybillRouteVo.getMailNo());
        mosDrugLogisticsRouteEntity.setAcceptAddress(waybillRouteVo.getAcceptAddress());
        if (waybillRouteVo.getOpCode().equals(LogisticsStatusEnum.FORTY_FOUR.getValue())) {
            String deliveryInfo = waybillRouteVo.getRemark().split(":")[1];
            String deliveryName = deliveryInfo.split(",")[0];
            String deliveryPhone = waybillRouteVo.getRemark().split(":")[2].substring(0, 11);
            mosDrugLogisticsRouteEntity.setDeliveryPhone(deliveryPhone);
            mosDrugLogisticsRouteEntity.setDeliveryName(deliveryName);
        }
        this.mosDrugLogisticsRouteMapper.insertSelective(mosDrugLogisticsRouteEntity);
        if (LogisticsStatusEnum.FIFTY.getValue().equals(waybillRouteVo.getOpCode())) {
            mosDrugLogisticsOrderRegEntityList.stream().forEach(mosDrugLogisticsOrderRegEntity -> this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.TO_TRANSPORT.getValue(), mosDrugLogisticsOrderRegEntity.getMainId()));
        } else if (LogisticsStatusEnum.FORTY_FOUR.getValue().equals(waybillRouteVo.getOpCode())) {
            mosDrugLogisticsOrderRegEntityList.stream().forEach(mosDrugLogisticsOrderRegEntity -> this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.TO_DELIVERY.getValue(), mosDrugLogisticsOrderRegEntity.getMainId()));
            new Thread(() -> {
                String mainId = ((MosDrugLogisticsOrderRegEntity)mosDrugLogisticsOrderRegEntityList.get(0)).getMainId();
                DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mainId);
                LinkedHashMap data = new LinkedHashMap();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("value", drugMainEntity.getPresDoctorName());
                data.put("doctorName", map1);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("value", "\u836f\u54c1\u5373\u5c06\u6d3e\u9001");
                data.put("issue", map2);
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("value", "\u5373\u5c06\u914d\u9001\u8bf7\u6ce8\u610f\u67e5\u6536\uff0c\u524d\u5f80\u5c0f\u7a0b\u5e8f\u67e5\u770b\u8be6\u60c5");
                data.put("info", map3);
                this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/status/status?mainId=" + drugMainEntity.getxId());
            }).start();
        } else if (LogisticsStatusEnum.EIGHTY.getValue().equals(waybillRouteVo.getOpCode())) {
            mosDrugLogisticsOrderRegEntityList.stream().forEach(mosDrugLogisticsOrderRegEntity -> {
                DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mosDrugLogisticsOrderRegEntity.getMainId());
                if (!DrugMainStatusEnum.FINISH.getValue().equals(drugMainEntity.getItemStatus())) {
                    this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.SIGN_IN.getValue(), mosDrugLogisticsOrderRegEntity.getMainId());
                    RabbitMqUtils.senderDelayedLogisticsOrder((RabbitTemplate)this.rabbitTemplate, (String)waybillRouteVo.getOrderId(), (Integer)259200);
                }
            });
            new Thread(() -> {
                String mainId = ((MosDrugLogisticsOrderRegEntity)mosDrugLogisticsOrderRegEntityList.get(0)).getMainId();
                DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mainId);
                LinkedHashMap data = new LinkedHashMap();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("value", drugMainEntity.getPresDoctorName());
                data.put("doctorName", map1);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("value", "\u836f\u54c1\u914d\u9001\u5b8c\u6210");
                data.put("issue", map2);
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("value", "\u836f\u54c1\u914d\u9001\u5b8c\u6210\uff0c\u8bf7\u60a8\u4ed4\u7ec6\u6838\u5bf9\u3002");
                data.put("info", map3);
                this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/status/status?mainId=" + drugMainEntity.getxId());
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                HashMap<String, String> hash = new HashMap<String, String>();
                hash.put("doctorName", drugMainEntity.getPresDoctorName());
                this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy-hzqshw", drugMainEntity.getPatientPhone(), new HashMap());
            }).start();
        }
        return "SUCCESS";
    }

    public void patientSignFinished(PatientSignFinished patientSignForVo) {
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(patientSignForVo.getMainId());
        if (!drugMainEntity.getItemStatus().equals(DrugMainStatusEnum.FINISH)) {
            this.mosDrugMainMapper.updateItemStatusById(DrugMainStatusEnum.FINISH.getValue(), patientSignForVo.getMainId());
        }
    }

    public void updateItemStatusByMainId(DrugMainItemStatusDTO drugMainItemStatusDTO) {
        this.mosDrugMainMapper.updateItemStatusById(drugMainItemStatusDTO.getItemStatus(), drugMainItemStatusDTO.getMainId());
    }

    public List<DrugMainEntity> selectByItemStatusAndAppCode(Integer itemStatus, String appCode) {
        List drugMainEntityList = this.mosDrugMainMapper.selectByItemStatusAndAppCode(itemStatus, appCode);
        return drugMainEntityList;
    }

    public void prescriptionPush(ZryhYunTaiRequest<List<PrescriptionInfo>> zryhYunTaiRequestVo) {
        List prescriptionInfoList = (List)zryhYunTaiRequestVo.getData();
        List mosOutpatientMainRelEntityList = this.mosOutpatientMainRelService.getByOrderSeq(((PrescriptionInfo)(prescriptionInfoList = prescriptionInfoList.stream().filter(prescriptionInfo -> prescriptionInfo != null).collect(Collectors.toList())).get(0)).getAccessVisitId());
        if (CollectionUtils.isEmpty((Collection)mosOutpatientMainRelEntityList)) {
            this.saveHisPrescription(prescriptionInfoList);
            return;
        }
        if (CollectionUtils.isEmpty(mosOutpatientMainRelEntityList = mosOutpatientMainRelEntityList.stream().filter(mosOutpatientMainRelEntity -> StringUtils.isNotBlank((String)mosOutpatientMainRelEntity.getHisRegNo())).collect(Collectors.toList()))) {
            this.saveHisPrescription(prescriptionInfoList);
            return;
        }
        List drugMainEntityList = mosOutpatientMainRelEntityList.stream().map(mosOutpatientMainRelEntity -> {
            DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(mosOutpatientMainRelEntity.getMainId());
            return drugMainEntity;
        }).filter(drugMainEntity -> Objects.nonNull(drugMainEntity)).collect(Collectors.toList());
        List accPresNoList = prescriptionInfoList.stream().map(prescriptionInfo -> prescriptionInfo.getAccPresNo()).collect(Collectors.toList());
        drugMainEntityList.stream().forEach(drugMainEntity -> {
            DrugPrescriptionEntity drugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(drugMainEntity.getxId());
            if (!accPresNoList.contains(drugPrescriptionEntity.getHisRecipeNo())) {
                this.mosDrugMainMapper.deleteById(drugMainEntity.getxId());
            }
        });
        this.saveHisPrescription(prescriptionInfoList);
        String url = "/sendCheckedExpressRecipes";
        log.info("=======\u8bb0\u5f55\u4fdd\u5b58his\u63a5\u53e3\u65e5\u5fd7");
        HisLogEntity hisLogEntity = new HisLogEntity();
        hisLogEntity.setxId(GenSeqUtils.getUniqueNo());
        hisLogEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        hisLogEntity.setInterfaceName(url);
        hisLogEntity.setOrganCode(((DrugMainEntity)drugMainEntityList.get(0)).getOrganId());
        hisLogEntity.setRequest(JSONObject.toJSONString(zryhYunTaiRequestVo));
        log.info("=======\u8bb0\u5f55\u4fdd\u5b58his\u63a5\u53e3\u65e5\u5fd7\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)hisLogEntity));
        this.hisLogMapper.insert(hisLogEntity);
    }

    private void saveHisPrescription(List<PrescriptionInfo> prescriptionInfoList) {
        for (PrescriptionInfo prescriptionInfo : prescriptionInfoList) {
            DrugMainEntity tempDrugMainEntity;
            if (prescriptionInfo == null || Objects.nonNull(tempDrugMainEntity = this.mosDrugMainMapper.getByHisRecipeNo(prescriptionInfo.getAccPresNo())) && !DrugMainStatusEnum.UNDRUGS.getValue().equals(tempDrugMainEntity.getItemStatus()) && !DrugMainStatusEnum.APPROVING.getValue().equals(tempDrugMainEntity.getItemStatus()) && !DrugMainStatusEnum.PHARMACIST_BACK.getValue().equals(tempDrugMainEntity.getItemStatus())) continue;
            if (CollectionUtils.isEmpty((Collection)prescriptionInfo.getDiagList())) {
                log.error("\u5904\u65b9\u8bca\u65ad\u4e3anull->{}", (Object)Objects.toString(prescriptionInfo, null));
                continue;
            }
            List diagInfoList = prescriptionInfo.getDiagList().stream().filter(diagInfo -> diagInfo != null).collect(Collectors.toList());
            prescriptionInfo.setDiagList(diagInfoList);
            if (CollectionUtils.isEmpty((Collection)prescriptionInfo.getDrugList())) {
                log.error("\u5904\u65b9\u836f\u54c1\u4e3anull->{}", (Object)Objects.toString(prescriptionInfo, null));
                continue;
            }
            List drugInfoList = prescriptionInfo.getDrugList().stream().filter(drugInfo -> drugInfo != null && drugInfo.getDelectFlag() == 0).collect(Collectors.toList());
            prescriptionInfo.setDrugList(drugInfoList);
            if (CollectionUtils.isEmpty(drugInfoList)) {
                log.error("\u5904\u65b9\u836f\u54c1\u4e3anull->{}", (Object)Objects.toString(prescriptionInfo, null));
                continue;
            }
            boolean flag = false;
            for (DrugInfo drugInfo2 : drugInfoList) {
                DrugItemEntity drugItemEntity = this.drugItemMapper.queryByCommonCode(drugInfo2.getDrugLocalCode(), "ZRYH");
                if (drugItemEntity != null) continue;
                log.error("\u836f\u54c1\u4e0d\u5b58\u5728->{}", (Object)Objects.toString(drugInfo2, null));
                flag = true;
                break;
            }
            if (flag) {
                log.error("\u5904\u65b9\u4e2d\u5b58\u5728app\u4e0d\u5b58\u5728\u7684\u836f\u54c1->{}", (Object)Objects.toString(prescriptionInfo, null));
                break;
            }
            List mosOutpatientMainRelEntityList = this.mosOutpatientMainRelService.getByOrderSeq(prescriptionInfo.getAccessVisitId());
            if (CollectionUtils.isEmpty((Collection)mosOutpatientMainRelEntityList)) {
                log.error("\u5728\u7ebf\u590d\u8bca\u5173\u8054\u4e0d\u4e0a");
                continue;
            }
            MosOutpatientMainRelEntity mosOutpatientMainRelEntity = (MosOutpatientMainRelEntity)mosOutpatientMainRelEntityList.get(0);
            FromOutlineVO fromOutlineVO = this.drugMainManage.getOutLineInfo(mosOutpatientMainRelEntity.getOrderId(), mosOutpatientMainRelEntity.getAdmissionId(), mosOutpatientMainRelEntity.getAppCode());
            if (fromOutlineVO == null) {
                log.error("\u8c03\u7528\u5728\u7ebf\u95ee\u8bca\u5931\u8d25");
                continue;
            }
            DrugMainEntity oldDrugMainEntity = this.mosDrugMainMapper.queryById(mosOutpatientMainRelEntity.getMainId());
            ArrayList<String> stdInvalidDrugList = new ArrayList<String>();
            stdInvalidDrugList.add("\u9ebb\u9189\u7c7b");
            stdInvalidDrugList.add("\u6613\u5236\u6bd2");
            stdInvalidDrugList.add("\u4e8c\u7c7b\u7cbe\u795e\u836f");
            stdInvalidDrugList.add("\u4e00\u7c7b\u7cbe\u795e\u836f");
            stdInvalidDrugList.add("\u6bd2\u836f\u7c7b");
            ArrayList<String> invalidDrug = new ArrayList<String>();
            for (DrugInfo drugInfo3 : drugInfoList) {
                DrugItemEntity drugItemEntity = this.drugItemMapper.queryByCommonCode(drugInfo3.getDrugLocalCode(), "ZRYH");
                if (StringUtils.isBlank((String)drugItemEntity.getDrugProperty()) || !stdInvalidDrugList.contains(drugItemEntity.getDrugProperty())) continue;
                invalidDrug.add(drugItemEntity.getCommonName());
            }
            if (!CollectionUtils.isEmpty(invalidDrug)) {
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(oldDrugMainEntity.getPresOrgan(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("doctorCode");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("patientName", oldDrugMainEntity.getPatientName());
                map.put("medicalName", String.join((CharSequence)"\u3001", invalidDrug));
                map.put("order", prescriptionInfo.getAccPresNo());
                this.pushManage.iSMSPush("ali", oldDrugMainEntity.getPresOrgan(), signCode, "yyy-cfht", oldDrugMainEntity.getPresDoctorPhone(), map);
                continue;
            }
            if (prescriptionInfo.getHisSourceType().equals(String.valueOf(HisExpressTypeEnum.TRIPARTITE_PHARMACY.getValue()))) {
                prescriptionInfo.setExpressFlag(Integer.valueOf(Integer.parseInt(prescriptionInfo.getHisSourceType())));
            } else {
                prescriptionInfo.setExpressFlag(prescriptionInfo.getDeliveryFlag());
            }
            DrugMainEntity drugMainEntity = this.saveDrugMain(oldDrugMainEntity, fromOutlineVO, prescriptionInfo);
            MosOutpatientMainRelEntity oldMosOutpatientMainRelEntity = this.mosOutpatientMainRelService.getByMainId(drugMainEntity.getxId());
            mosOutpatientMainRelEntity.setMainId(drugMainEntity.getxId());
            mosOutpatientMainRelEntity.setHisRegNo(prescriptionInfo.getClinicNo());
            mosOutpatientMainRelEntity.setXUpdateTime(new Date());
            mosOutpatientMainRelEntity.setOrderSeq(fromOutlineVO.getOrderSeq());
            if (Objects.isNull(oldMosOutpatientMainRelEntity)) {
                mosOutpatientMainRelEntity.setXId(GenSeqUtils.getUniqueNo());
                mosOutpatientMainRelEntity.setXCreateTime(new Date());
                this.mosOutpatientMainRelService.insert(mosOutpatientMainRelEntity);
            } else {
                mosOutpatientMainRelEntity.setXId(oldMosOutpatientMainRelEntity.getXId());
                mosOutpatientMainRelEntity.setXCreateTime(oldMosOutpatientMainRelEntity.getXCreateTime());
                this.mosOutpatientMainRelService.update(mosOutpatientMainRelEntity);
            }
            String prescriptionAdmId = GenSeqUtils.getUniqueNo();
            DrugPrescriptionEntity drugPrescriptionEntity = this.savePrescription(drugMainEntity, prescriptionAdmId, prescriptionInfo);
            DiagnosticEntity diagnosticEntity = this.saveDiagnostic(drugMainEntity, prescriptionInfo, drugPrescriptionEntity);
            this.saveDrugsItemDetail(prescriptionInfo, drugMainEntity, drugPrescriptionEntity);
            this.addRemark(drugMainEntity.getxId(), "", fromOutlineVO.getPresDoctorName(), RemarkTypeEnum.ADD_PRES.getValue());
            if (HisExpressTypeEnum.NON_DELIVERABLE.getValue().equals(prescriptionInfo.getExpressFlag()) || HisExpressTypeEnum.DELIVERABLE.getValue().equals(prescriptionInfo.getExpressFlag())) {
                RabbitMqUtils.senderDelayedPrescriptionOrder((RabbitTemplate)this.rabbitTemplate, (String)drugMainEntity.getxId(), (Integer)259200);
            }
            PresDetailVO presDetailVO = new PresDetailVO();
            BeanUtils.copyProperties((Object)drugMainEntity, (Object)presDetailVO);
            presDetailVO.setDiseaseTags(fromOutlineVO.getTags());
            presDetailVO.setDiseaseDescription(fromOutlineVO.getDescription());
            presDetailVO.setNeedHelp(fromOutlineVO.getQuestion());
            try {
                this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), null);
            }
            catch (Exception e) {
                log.error("=============\u751f\u6210\u5904\u65b9\u7b3a\u5931\u8d25================");
            }
            if (!Objects.isNull(tempDrugMainEntity)) continue;
            List drugList = prescriptionInfo.getDrugList();
            this.threadPoolTaskExecutor.execute(() -> {
                List list;
                int drugCount = 0;
                String drugName = "";
                if (CollectionUtils.isNotEmpty((Collection)drugList)) {
                    drugCount = drugList.size();
                    drugName = ((DrugInfo)drugList.get(0)).getDrugChemName();
                }
                String drugDesc = drugCount == 1 ? "\u542b" + drugName + "\u5171" + drugCount + "\u79cd\u836f\u54c1" : "\u542b" + drugName + "...\u7b49\u5171" + drugCount + "\u79cd\u836f\u54c1";
                String patientMsg = "\u533b\u751f\u5df2\u5f00\u5177\u5904\u65b9\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("msg", (Object)patientMsg);
                jsonObject.put("mainId", (Object)drugMainEntity.getxId());
                jsonObject.put("prescriptionId", (Object)drugPrescriptionEntity.getxId());
                jsonObject.put("presType", (Object)(DrugTypeEnum.getDesc((Integer)drugMainEntity.getPresType()) + "\u5904\u65b9"));
                jsonObject.put("expressFlagDesc", (Object)HisExpressTypeEnum.getByValue((int)drugMainEntity.getExpressFlag()).getDisplay());
                jsonObject.put("diagnostic", (Object)diagnosticEntity.getDiagnostic());
                jsonObject.put("drugDesc", (Object)drugDesc);
                this.asynManage.imPushMsgByMainId(BusinessCodeEnum.OBTAIN.getValue(), drugMainEntity.getxId(), "", "EHOS_PATIENT", drugMainEntity.getPatientUserId(), mosOutpatientMainRelEntity.getAdmissionId(), (Object)jsonObject, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
                LinkedHashMap data = new LinkedHashMap();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("value", drugMainEntity.getPresDoctorName());
                data.put("doctorName", map1);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("value", "\u5904\u65b9\u5df2\u5f00\u5177");
                data.put("issue", map2);
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("value", "\u60a8\u7684\u5904\u65b9\u5df2\u5f00\u5177\uff0c\u8bf7\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u67e5\u770b\u8be6\u60c5");
                data.put("info", map3);
                this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/detial/detial?mainId=" + drugMainEntity.getxId());
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                HashMap patientMap = new HashMap();
                this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy_hzsdcf", drugMainEntity.getPatientPhone(), patientMap);
                if (Integer.valueOf(prescriptionInfo.getExpressFlag()).equals(HisExpressTypeEnum.TRIPARTITE_PHARMACY.getValue()) && CollectionUtils.isNotEmpty((Collection)(list = this.doctorRetmoteManage.getPharmaceutist(drugMainEntity.getPresOrgan())))) {
                    for (PharmaceutistResVO resVO : list) {
                        this.pushManage.iAppMsgPush(UserEnum.DOCTOR.getDesc(), drugMainEntity.getPresOrgan(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getBusiCode(), "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u5904\u65b9\u5f85\u5ba1\u6838\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b", "\u5904\u65b9\u5ba1\u6838\u63d0\u9192", PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getDesc(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getActionCode(), PushCodeInfoEnum.ZRYH_RECEIVE_PRES.getValueCode().toString(), "", this.doctorRetmoteManage.getDevice(this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(resVO.getDoctorCode()))).getUserId(), UserTypeEnum.DOCTOR.getValue(), AppCodeEnum.ZRYH.getValue()));
                    }
                }
            });
        }
    }

    public BaseResponse<List<CountDiagnosticVo>> countDiagnostic() {
        List diagnosticEntityList = this.diagnosticService.selectAll();
        ArrayList diagnosticEntities = new ArrayList();
        diagnosticEntityList.stream().forEach(diagnosticEntity -> {
            if (StringUtils.isNotBlank((String)diagnosticEntity.getIcdName())) {
                if (diagnosticEntity.getIcdName().contains(";")) {
                    ArrayList<String> icdNameList = new ArrayList<String>(Arrays.asList(diagnosticEntity.getIcdName().split(";")));
                    DiagnosticEntity diagnosticEntity1 = new DiagnosticEntity();
                    BeanUtils.copyProperties((Object)diagnosticEntity, (Object)diagnosticEntity1);
                    diagnosticEntity1.setIcdName((String)icdNameList.get(0));
                    diagnosticEntities.add(diagnosticEntity1);
                } else {
                    diagnosticEntities.add(diagnosticEntity);
                }
            }
        });
        Map map = diagnosticEntities.stream().collect(Collectors.groupingBy(DiagnosticEntity::getIcdName, Collectors.toList()));
        ArrayList countDiagnosticVoList = new ArrayList();
        map.keySet().forEach(icdName -> {
            List diagnosticEntitys = (List)map.get(icdName);
            CountDiagnosticVo countDiagnosticVo = new CountDiagnosticVo();
            countDiagnosticVo.setIcdName(icdName);
            List deptNameList = diagnosticEntitys.stream().map(diagnosticEntity -> {
                DrugPrescriptionEntity drugPrescriptionEntity = this.mosDrugPrescriptionService.queryByAdmId(diagnosticEntity.getxId());
                DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(drugPrescriptionEntity.getMainId());
                return drugMainEntity.getPresDeptName();
            }).filter(deptName -> !deptName.equals("\u8fdc\u7a0b\u4f1a\u8bca\u4e2d\u5fc3")).collect(Collectors.toList());
            countDiagnosticVo.setAccessNum(Integer.valueOf(deptNameList.size()));
            deptNameList = deptNameList.stream().distinct().collect(Collectors.toList());
            String deptNames = String.join((CharSequence)",", deptNameList);
            countDiagnosticVo.setDeptNames(deptNames);
            countDiagnosticVoList.add(countDiagnosticVo);
        });
        List countDiagnosticList = countDiagnosticVoList.stream().sorted(Comparator.comparing(CountDiagnosticVo::getAccessNum).reversed()).collect(Collectors.toList());
        return BaseResponse.success(countDiagnosticList);
    }

    public ZryhYunTaiResponseVo auditPrescription(ZryhYunTaiRequest<AuditPrescriptionVo> requestZryhYunTaiRequestVo) {
        boolean flag;
        BaseResponse huaHongResultResponse;
        int i;
        FrontRequest frontRequest;
        LogisticsRecipeReqVO logisticsRecipeReqVO;
        String code;
        AuditPrescriptionVo auditPrescriptionVo = (AuditPrescriptionVo)requestZryhYunTaiRequestVo.getData();
        DrugMainEntity mainEntity = this.mosDrugMainMapper.getByHisRecipeNo(auditPrescriptionVo.getRecipeNo());
        String url = "/sendCheckedExpressRecipes";
        log.info("=======\u8bb0\u5f55\u4fdd\u5b58his\u63a5\u53e3\u65e5\u5fd7");
        HisLogEntity hisLogEntity = new HisLogEntity();
        hisLogEntity.setxId(GenSeqUtils.getUniqueNo());
        hisLogEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        hisLogEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        hisLogEntity.setInterfaceName(url);
        hisLogEntity.setOrganCode(mainEntity.getOrganId());
        hisLogEntity.setRequest(JSONObject.toJSONString(requestZryhYunTaiRequestVo));
        log.info("=======\u8bb0\u5f55\u4fdd\u5b58his\u63a5\u53e3\u65e5\u5fd7\u7684\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)hisLogEntity));
        this.hisLogMapper.insert(hisLogEntity);
        if (mainEntity.getItemStatus().equals(DrugMainStatusEnum.UNDRUGS.getValue())) {
            return ZryhYunTaiResponseVo.error((String)"\u60a3\u8005\u8fd8\u672a\u9009\u62e9\u53d6\u836f\u65b9\u5f0f\uff0c\u4e0d\u80fd\u5ba1\u6838");
        }
        log.info("============\u533b\u5631\u4fe1\u606f" + JSONObject.toJSONString((Object)mainEntity));
        MosOutpatientMainRelEntity outpatientMainRelEntity = this.mosOutpatientMainRelService.getByMainId(mainEntity.getxId());
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByMainId(mainEntity.getxId());
        Integer itemStatus = null;
        itemStatus = !auditPrescriptionVo.getIsChecked().equals(String.valueOf(1)) ? DrugMainStatusEnum.PHARMACIST_BACK.getValue() : (OrderTypeEnum.DRUG_ORDER.getValue().equals(mainEntity.getOrderType()) ? DrugMainStatusEnum.TO_TAKE.getValue() : (Double.valueOf(mosDrugLogisticsOrderEntity.getDestDeliveryDistance()) > 10000.0 || mainEntity.getPatientNoType().equals(CARD_TYPE_SELF_EXPENSE) ? DrugMainStatusEnum.ZRYH_UNPAID.getValue() : DrugMainStatusEnum.TO_SEND.getValue()));
        if (itemStatus.equals(DrugMainStatusEnum.TO_SEND.getValue())) {
            code = mainEntity.getFetchMedicalCode();
            if (StringUtils.isBlank((String)code)) {
                code = RandomUtils.generateRandom((int)6);
            }
            mainEntity.setFetchMedicalCode(code);
            logisticsRecipeReqVO = this.hisManage.getLogisticsRecipeReqVO(mainEntity.getxId(), mosDrugLogisticsOrderEntity.getDestAddress(), code);
            frontRequest = new FrontRequest();
            frontRequest.setBody((Object)logisticsRecipeReqVO);
            for (i = 0; i <= 3; ++i) {
                huaHongResultResponse = this.hisManage.sendHis("/zryh-his/api/v1/logistics/synLogisticsRecipe", frontRequest, HuaHongResultVo.class);
                flag = huaHongResultResponse.getCode().equals("1");
                mainEntity.setxRemark(huaHongResultResponse.toString());
                HisLogEntity logEntity = this.hisLogService.savaEntity(frontRequest, "/zryh-his/api/v1/logistics/synLogisticsRecipe", mainEntity.getOrganId());
                logEntity.setResponse(JSONObject.toJSONString((Object)huaHongResultResponse));
                this.hisLogService.update(logEntity);
                if (flag) break;
            }
        }
        if (itemStatus.equals(DrugMainStatusEnum.TO_TAKE.getValue())) {
            code = mainEntity.getFetchMedicalCode();
            if (StringUtils.isBlank((String)code)) {
                code = RandomUtils.generateRandom((int)6);
            }
            mainEntity.setFetchMedicalCode(code);
            logisticsRecipeReqVO = this.hisManage.getLogisticsRecipeReqVO(mainEntity.getxId(), "\u4e2d\u65e5\u53cb\u597d\u533b\u9662\u95e8\u8bca\u4e8c\u697c\u9001\u836f\u5230\u5bb6\u7a97\u53e3\u81ea\u53d6", code);
            frontRequest = new FrontRequest();
            frontRequest.setBody((Object)logisticsRecipeReqVO);
            for (i = 0; i <= 3; ++i) {
                huaHongResultResponse = this.hisManage.sendHis("/zryh-his/api/v1/logistics/synLogisticsRecipe", frontRequest, Object.class);
                flag = huaHongResultResponse.getCode().equals("1");
                mainEntity.setxRemark(huaHongResultResponse.toString());
                HisLogEntity entity = this.hisLogService.savaEntity(frontRequest, "/zryh-his/api/v1/logistics/synLogisticsRecipe", mainEntity.getOrganId());
                entity.setResponse(JSONObject.toJSONString((Object)huaHongResultResponse));
                this.hisLogService.update(entity);
                if (flag) break;
            }
            RabbitMqUtils.senderDelayedPrescriptionOrder((RabbitTemplate)this.rabbitTemplate, (String)mainEntity.getxId(), (Integer)259200);
        }
        mainEntity.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
        mainEntity.setItemStatus(itemStatus);
        this.mosDrugMainService.update(mainEntity);
        this.mosDrugMainService.saveDrugExtend(mainEntity.getxId(), auditPrescriptionVo.getPharmacistName(), auditPrescriptionVo.getPharmacistCode(), "", auditPrescriptionVo.getReason(), Integer.valueOf(auditPrescriptionVo.getIsChecked()));
        this.mosDrugMainService.addRemark(mainEntity.getxId(), auditPrescriptionVo.getReason(), "his", RemarkTypeEnum.VERIFIER.getValue());
        this.threadPoolTaskExecutor.execute(() -> {
            if (auditPrescriptionVo.getIsChecked().equals(String.valueOf(1))) {
                MessageData imData;
                String patientMsg;
                String signCode;
                HashMap<String, String> map;
                LinkedHashMap data = new LinkedHashMap();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("value", mainEntity.getPresDoctorName());
                data.put("doctorName", map1);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("value", "\u5904\u65b9\u5ba1\u6838\u901a\u8fc7");
                data.put("issue", map2);
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("value", "\u60a8\u7684\u5904\u65b9\u5df2\u5ba1\u6838\u901a\u8fc7\uff0c\u8bf7\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u67e5\u770b\u8be6\u60c5");
                data.put("info", map3);
                this.pushManage.iWeChatPush(mainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(mainEntity.getPresOrgan(), mainEntity.getPatientUserId()), data, "/prescription/pages/detial/detial?mainId=" + mainEntity.getxId());
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(mainEntity.getPresOrgan(), "sms");
                if (Objects.nonNull(mosDrugLogisticsOrderEntity)) {
                    if (Double.valueOf(mosDrugLogisticsOrderEntity.getDestDeliveryDistance()) > 10000.0 || mainEntity.getPatientNoType().equals(CARD_TYPE_SELF_EXPENSE)) {
                        map = new HashMap();
                        map.put("doctorName", mainEntity.getPresDoctorName());
                        map.put("medical", "\u836f\u5e08");
                        signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                        this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_hzshtg", mainEntity.getPatientPhone(), map);
                        patientMsg = "\u5904\u65b9\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u8bf7\u70b9\u51fb\u524d\u5f80\u652f\u4ed8";
                        imData = new MessageData();
                        imData.setText(patientMsg);
                        this.asynManage.imPushMsgByMainId(BusinessCodeEnum.AUDIT.getValue(), mainEntity.getxId(), "", "EHOS_PATIENT", mainEntity.getPatientUserId(), outpatientMainRelEntity.getAdmissionId(), (Object)imData, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
                    } else if (Double.valueOf(mosDrugLogisticsOrderEntity.getDestDeliveryDistance()) < 10000.0 && mainEntity.getPatientNoType().equals(CARD_TYPE_PUSH_EXPENSE)) {
                        map = new HashMap();
                        map.put("doctor", mainEntity.getPresDoctorName());
                        map.put("fetchMedicalCode", mainEntity.getFetchMedicalCode());
                        signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                        this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_hzapps", mainEntity.getPatientPhone(), map);
                        patientMsg = "\u5904\u65b9\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u8bf7\u7b49\u5f85\u836f\u54c1\u914d\u9001\uff0c\u6536\u5230\u836f\u54c1\u540e\uff0c\u8bf7\u51ed\u53d6\u836f\u7801\u300c" + mainEntity.getFetchMedicalCode() + "\u300d\u5b8c\u6210\u53d6\u836f";
                        imData = new MessageData();
                        imData.setText(patientMsg);
                        this.asynManage.imPushMsgByMainId(BusinessCodeEnum.AUDIT.getValue(), mainEntity.getxId(), "", "EHOS_PATIENT", mainEntity.getPatientUserId(), outpatientMainRelEntity.getAdmissionId(), (Object)imData, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
                    }
                }
                if (OrderTypeEnum.DRUG_ORDER.getValue().equals(mainEntity.getOrderType())) {
                    map = new HashMap<String, String>();
                    map.put("doctorName", mainEntity.getPresDoctorName());
                    map.put("medical", "\u836f\u5e08");
                    map.put("fetchMedicalCode", mainEntity.getFetchMedicalCode());
                    signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                    this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_hzqy", mainEntity.getPatientPhone(), map);
                    patientMsg = "\u5904\u65b9\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u8bf7\u524d\u5f80\u4e2d\u65e5\u53cb\u597d\u533b\u9662\u95e8\u8bca\u4e8c\u697c\u9001\u836f\u5230\u5bb6\u7a97\u53e3\uff0c\u8bf7\u51ed\u53d6\u836f\u7801\u300c" + mainEntity.getFetchMedicalCode() + "\u300d\u5b8c\u6210\u53d6\u836f";
                    imData = new MessageData();
                    imData.setText(patientMsg);
                    this.asynManage.imPushMsgByMainId(BusinessCodeEnum.AUDIT.getValue(), mainEntity.getxId(), "", "EHOS_PATIENT", mainEntity.getPatientUserId(), outpatientMainRelEntity.getAdmissionId(), (Object)imData, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
                }
                this.prescriptionPdfService.setPresPdf(mainEntity.getxId(), null);
            } else {
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(mainEntity.getPresOrgan(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("doctorCode");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("patientName", mainEntity.getPatientName());
                map.put("orderId", auditPrescriptionVo.getRecipeNo());
                this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_yscfshwtg", mainEntity.getPresDoctorPhone(), map);
                LinkedHashMap data = new LinkedHashMap();
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("value", mainEntity.getPresDoctorName());
                data.put("doctorName", map1);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("value", "\u5904\u65b9\u5ba1\u6838\u672a\u901a\u8fc7");
                data.put("issue", map2);
                HashMap<String, String> map3 = new HashMap<String, String>();
                map3.put("value", "\u60a8\u7684\u5904\u65b9\u672a\u5ba1\u6838\u901a\u8fc7\uff0c\u8bf7\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u67e5\u770b\u8be6\u60c5");
                data.put("info", map3);
                this.pushManage.iWeChatPush(mainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(mainEntity.getPresOrgan(), mainEntity.getPatientUserId()), data, "/prescription/pages/detial/detial?mainId=" + mainEntity.getxId());
                signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                HashMap<String, String> patientMap = new HashMap<String, String>();
                patientMap.put("doctorName", mainEntity.getPresDoctorName());
                patientMap.put("phoneNumber", "010-84205927");
                this.pushManage.iSMSPush("ali", mainEntity.getPresOrgan(), signCode, "yyy_hzcfshwtg", mainEntity.getPatientPhone(), patientMap);
                String patientMsg = "\u5904\u65b9\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u8bf7\u7b49\u5f85\u533b\u751f\u91cd\u65b0\u5f00\u5177\u5904\u65b9";
                MessageData imData = new MessageData();
                imData.setText(patientMsg);
                this.asynManage.imPushMsgByMainId(BusinessCodeEnum.AUDIT.getValue(), mainEntity.getxId(), "", "EHOS_PATIENT", mainEntity.getPatientUserId(), outpatientMainRelEntity.getAdmissionId(), (Object)imData, BusinessConstant.SERVICE_SYSTEM_FREE_TYPE);
            }
        });
        return ZryhYunTaiResponseVo.success((Object)"");
    }

    private void saveDrugsItemDetail(PrescriptionInfo prescriptionPushReqVo, DrugMainEntity drugMainEntity, DrugPrescriptionEntity drugPrescriptionEntity) {
        List drugInfoList = prescriptionPushReqVo.getDrugList();
        List drugCode = drugInfoList.stream().map(drugInfo -> drugInfo.getDrugLocalCode()).collect(Collectors.toList());
        List drugDetailEntityList = this.detailService.getByMainIds(drugMainEntity.getxId());
        drugDetailEntityList.stream().forEach(drugDetailEntity -> {
            if (!drugCode.contains(drugDetailEntity.getDrugCommonCode())) {
                this.detailService.deleteById(drugDetailEntity.getxId());
            }
        });
        for (DrugInfo drugInfo2 : drugInfoList) {
            if (drugInfo2.getDelectFlag() == 1) continue;
            DrugDetailEntity oldDrugDetailEntity = this.detailService.getByMainIdAndDrugCommonCode(drugMainEntity.getxId(), drugInfo2.getDrugLocalCode());
            DrugDetailEntity drugDetailEntity2 = new DrugDetailEntity();
            drugDetailEntity2.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugDetailEntity2.setOrganCode(drugMainEntity.getPresOrgan());
            drugDetailEntity2.setMainId(drugMainEntity.getxId());
            drugDetailEntity2.setPresId(drugPrescriptionEntity.getxId());
            DrugItemEntity drugItemEntity = this.drugItemMapper.queryByCommonCode(drugInfo2.getDrugLocalCode(), drugMainEntity.getPresOrgan());
            if (Objects.nonNull(drugItemEntity)) {
                drugDetailEntity2.setDrugId(drugItemEntity.getxId());
                drugDetailEntity2.setMinBillPackingNum(drugItemEntity.getMinBillPackingNum());
                DrugUnitEntity minPack = this.drugUnitService.queryById(drugItemEntity.getMinBillPackingUnitId());
                drugDetailEntity2.setMinBillPackingUnit(minPack.getUnitName());
                drugDetailEntity2.setMeasureNum(drugItemEntity.getMeasureNum());
                drugDetailEntity2.setManufacturer(drugItemEntity.getManufacturer());
                DrugUnitEntity measureUnit = this.drugUnitService.queryById(drugItemEntity.getMeasureUnitId());
                drugDetailEntity2.setMeasureUnit(measureUnit.getUnitName());
                DrugUnitEntity wholePackingUnit = this.drugUnitService.queryById(drugItemEntity.getWholePackingUnitId());
                drugDetailEntity2.setWholePackingUnit(wholePackingUnit.getUnitName());
                if (StringUtils.isBlank((String)drugInfo2.getMinPackUnit())) {
                    drugDetailEntity2.setAmountUnit(wholePackingUnit.getUnitName());
                }
                DrugPriceEntity drugPriceEntity = this.mosDrugPriceService.getByOranCodeAndItemId(drugMainEntity.getPresOrgan(), drugItemEntity.getxId());
                drugDetailEntity2.setUnitPrice(drugPriceEntity.getPrice());
                if (StringUtils.isBlank((String)drugInfo2.getMinPackUnit()) || minPack.getUnitName().equals(wholePackingUnit.getUnitName())) {
                    drugDetailEntity2.setTotalPrice(drugPriceEntity.getPrice().multiply(new BigDecimal(drugInfo2.getMinPackNum())).setScale(2, RoundingMode.HALF_UP));
                } else if (!minPack.getUnitName().equals(wholePackingUnit.getUnitName()) && drugInfo2.getMinPackUnit().equals(wholePackingUnit.getUnitName())) {
                    drugDetailEntity2.setTotalPrice(drugPriceEntity.getPrice().multiply(new BigDecimal(drugInfo2.getMinPackNum())).setScale(2, RoundingMode.HALF_UP));
                } else {
                    BigDecimal totalPrice = drugPriceEntity.getPrice().multiply(BigDecimal.valueOf(drugInfo2.getMinPackNum().intValue()).divide(drugItemEntity.getMinBillPackingNum())).setScale(2, RoundingMode.HALF_UP);
                    drugDetailEntity2.setTotalPrice(totalPrice);
                }
            }
            drugDetailEntity2.setSingleDose(new BigDecimal(drugInfo2.getOneDosage()));
            drugDetailEntity2.setDrugCommonCode(drugInfo2.getDrugLocalCode());
            drugDetailEntity2.setDrugName(drugInfo2.getDrugChemName());
            drugDetailEntity2.setAmount(new BigDecimal(drugInfo2.getMinPackNum()));
            drugDetailEntity2.setAmountUnit(drugInfo2.getMinPackUnit());
            drugDetailEntity2.setFrequencyDesc(drugInfo2.getFrequency());
            drugDetailEntity2.setUsageDesc(drugInfo2.getDrugUsage());
            drugDetailEntity2.setDuration(Integer.valueOf(drugInfo2.getMedicineDays()));
            drugDetailEntity2.setDrugSpec(drugInfo2.getDrugSpecifications());
            if (Objects.isNull(oldDrugDetailEntity)) {
                drugDetailEntity2.setxId(GenSeqUtils.getUniqueNo());
                drugDetailEntity2.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
                this.detailService.insert(drugDetailEntity2);
                continue;
            }
            drugDetailEntity2.setxRowid(oldDrugDetailEntity.getxRowid());
            drugDetailEntity2.setxId(oldDrugDetailEntity.getxId());
            drugDetailEntity2.setxCreateTime(oldDrugDetailEntity.getxCreateTime());
            this.detailService.updateById(drugDetailEntity2);
        }
    }

    private DrugPrescriptionEntity savePrescription(DrugMainEntity drugMainEntity, String prescriptionAdmId, PrescriptionInfo prescriptionPushReqVo) {
        DrugPrescriptionEntity oldDrugPrescriptionEntity = this.mosDrugPrescriptionService.queryByMainId(drugMainEntity.getxId());
        DrugPrescriptionEntity drugPrescriptionEntity = new DrugPrescriptionEntity();
        drugPrescriptionEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugPrescriptionEntity.setMainId(drugMainEntity.getxId());
        drugPrescriptionEntity.setHisRecipeNo(prescriptionPushReqVo.getAccPresNo());
        drugPrescriptionEntity.setRecipeDate(prescriptionPushReqVo.getPresDate());
        BigDecimal totalCost = new BigDecimal(prescriptionPushReqVo.getTotalCost());
        drugPrescriptionEntity.setStorePrice(totalCost.setScale(4, 4));
        drugPrescriptionEntity.setPrice(totalCost.setScale(2, 4));
        if (Objects.isNull(oldDrugPrescriptionEntity)) {
            drugPrescriptionEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugPrescriptionEntity.setAdmId(prescriptionAdmId);
            drugPrescriptionEntity.setxId(GenSeqUtils.getUniqueNo());
            drugPrescriptionEntity = this.mosDrugPrescriptionService.insert(drugPrescriptionEntity);
        } else {
            drugPrescriptionEntity.setxId(oldDrugPrescriptionEntity.getxId());
            drugPrescriptionEntity.setAdmId(oldDrugPrescriptionEntity.getAdmId());
            this.mosDrugPrescriptionService.update(drugPrescriptionEntity);
        }
        return drugPrescriptionEntity;
    }

    private DiagnosticEntity saveDiagnostic(DrugMainEntity drugMainEntity, PrescriptionInfo prescriptionPushReqVo, DrugPrescriptionEntity drugPrescriptionEntity) {
        DiagnosticEntity oldDiagnosticEntity = this.diagnosticService.getById(drugPrescriptionEntity.getAdmId());
        DiagnosticEntity diagnosticEntity = new DiagnosticEntity();
        diagnosticEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        diagnosticEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        diagnosticEntity.setDoctorCode(drugMainEntity.getPresDoctorCode());
        diagnosticEntity.setDoctorName(drugMainEntity.getPresDoctorName());
        diagnosticEntity.setOrganCode(drugMainEntity.getPresOrgan());
        List diagInfoList = prescriptionPushReqVo.getDiagList();
        List icdCodeList = diagInfoList.stream().map(diagVo -> diagVo.getDiagCode()).collect(Collectors.toList());
        String icdCodes = String.join((CharSequence)";", icdCodeList);
        List icdNameList = diagInfoList.stream().map(diagVo -> diagVo.getDiagResult()).collect(Collectors.toList());
        String icdNames = String.join((CharSequence)";", icdNameList);
        diagnosticEntity.setDiagnostic(icdNames);
        diagnosticEntity.setIcdCode(icdCodes);
        diagnosticEntity.setIcdName(icdNames);
        if (Objects.isNull(oldDiagnosticEntity)) {
            diagnosticEntity.setxId(drugPrescriptionEntity.getAdmId());
            diagnosticEntity.setAdmId(GenSeqUtils.getUniqueNo());
            diagnosticEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            diagnosticEntity = this.diagnosticService.insert(diagnosticEntity);
        } else {
            diagnosticEntity.setxRowid(oldDiagnosticEntity.getxRowid());
            diagnosticEntity.setAdmId(oldDiagnosticEntity.getAdmId());
            diagnosticEntity.setxId(oldDiagnosticEntity.getxId());
            this.diagnosticService.updateById(diagnosticEntity);
        }
        return diagnosticEntity;
    }

    private DrugMainEntity saveDrugMain(DrugMainEntity oldDrugMainEntity, FromOutlineVO fromOutlineVO, PrescriptionInfo prescriptionInfo) {
        log.info("\u4fdd\u5b58\u533b\u5631\u4fe1\u606f");
        DrugMainEntity drugMainEntity = new DrugMainEntity();
        drugMainEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        drugMainEntity.setPresOrgan(oldDrugMainEntity.getAppCode());
        drugMainEntity.setOrganId(oldDrugMainEntity.getOrganId());
        drugMainEntity.setPresOrgan(oldDrugMainEntity.getPresOrgan());
        drugMainEntity.setPresDoctorId(fromOutlineVO.getPresDoctorId());
        drugMainEntity.setPresDoctorCode(fromOutlineVO.getPresDoctorCode());
        drugMainEntity.setStdFirstDeptName(oldDrugMainEntity.getStdFirstDeptName());
        drugMainEntity.setStdSecondDeptName(oldDrugMainEntity.getStdSecondDeptName());
        drugMainEntity.setDoctorSign(oldDrugMainEntity.getDoctorSign());
        drugMainEntity.setPresDoctorName(fromOutlineVO.getPresDoctorName());
        drugMainEntity.setPresDeptCode(fromOutlineVO.getPresDeptCode());
        drugMainEntity.setPresDoctorPhone(fromOutlineVO.getPresDoctorPhone());
        drugMainEntity.setPresDeptName(fromOutlineVO.getPresDeptName());
        drugMainEntity.setPresOrganName(oldDrugMainEntity.getPresOrganName());
        drugMainEntity.setStatus(BaseStatusEnum.VALID_STATUS.getValue());
        List drugInfoList = prescriptionInfo.getDrugList().stream().filter(drugInfo -> drugInfo != null).collect(Collectors.toList());
        drugMainEntity.setDrugSpeciesNum(Integer.valueOf(drugInfoList.size()));
        if (HisExpressTypeEnum.NON_DELIVERABLE.getValue().equals(prescriptionInfo.getExpressFlag())) {
            drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_TAKE.getValue());
        } else if (HisExpressTypeEnum.DELIVERABLE.getValue().equals(prescriptionInfo.getExpressFlag())) {
            drugMainEntity.setItemStatus(DrugMainStatusEnum.UNDRUGS.getValue());
        } else {
            drugMainEntity.setItemStatus(DrugMainStatusEnum.APPROVING.getValue());
        }
        drugMainEntity.setRefundStatus(BaseStatusEnum.VALID_STATUS.getValue());
        drugMainEntity.setPatientId(fromOutlineVO.getPatientId());
        drugMainEntity.setPatientUserId(oldDrugMainEntity.getPatientUserId());
        drugMainEntity.setPatientName(fromOutlineVO.getPatientName());
        drugMainEntity.setPatientNoType(oldDrugMainEntity.getPatientNoType());
        drugMainEntity.setPatientNo(fromOutlineVO.getPatientNo());
        drugMainEntity.setPatientGender(Integer.valueOf(Integer.parseInt(fromOutlineVO.getPatientGender())));
        drugMainEntity.setPatientPhone(oldDrugMainEntity.getPatientPhone());
        drugMainEntity.setPatientCredNo(oldDrugMainEntity.getPatientCredNo());
        DrugInfo drugInfo2 = (DrugInfo)prescriptionInfo.getDrugList().get(0);
        if (drugInfo2.getDrugFlag() == 0) {
            drugMainEntity.setPresType(DrugTypeEnum.CTM.getValue());
        } else if (drugInfo2.getDrugFlag() == 2) {
            drugMainEntity.setPresType(DrugTypeEnum.CM.getValue());
        } else {
            drugMainEntity.setPresType(drugInfo2.getDrugFlag());
        }
        drugMainEntity.setServCode(StringUtils.isEmpty((String)fromOutlineVO.getServCode()) ? "" : fromOutlineVO.getServCode());
        drugMainEntity.setServCodeName(StringUtils.isEmpty((String)fromOutlineVO.getServCodeName()) ? "" : fromOutlineVO.getServCodeName());
        drugMainEntity.setPatientPhone(oldDrugMainEntity.getPatientPhone());
        drugMainEntity.setPatientCredNo(oldDrugMainEntity.getPatientCredNo());
        drugMainEntity.setPatientNoType(oldDrugMainEntity.getPatientNoType());
        drugMainEntity.setPatientAge(oldDrugMainEntity.getPatientAge());
        drugMainEntity.setExpressFlag(Integer.valueOf(prescriptionInfo.getExpressFlag()));
        drugMainEntity.setPrescriptionSource(PrescriptionSourceEnum.HIS.getValue());
        drugMainEntity.setHospitalNameFirstLetter(HanyuPinyinUtil.getFirstLetters((String)drugMainEntity.getPresOrganName(), (HanyuPinyinCaseType)HanyuPinyinCaseType.UPPERCASE));
        DrugMainEntity oldHisDrugMainEntity = this.mosDrugMainMapper.getByHisRecipeNo(prescriptionInfo.getAccPresNo());
        if (Objects.isNull(oldHisDrugMainEntity)) {
            drugMainEntity.setxId(GenSeqUtils.getUniqueNo());
            drugMainEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugMainEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugMainEntity.setTransactionId(UUIDUtils.getUUID());
            drugMainEntity.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
            drugMainEntity = this.insert(drugMainEntity);
        } else {
            drugMainEntity.setxRowid(oldHisDrugMainEntity.getxRowid());
            drugMainEntity.setxId(oldHisDrugMainEntity.getxId());
            drugMainEntity.setxCreateTime(oldHisDrugMainEntity.getxCreateTime());
            drugMainEntity.setTransactionId(oldHisDrugMainEntity.getTransactionId());
            drugMainEntity.setFailureTime(oldHisDrugMainEntity.getFailureTime());
            if (oldHisDrugMainEntity.getItemStatus().equals(DrugMainStatusEnum.APPROVING.getValue())) {
                drugMainEntity.setItemStatus(DrugMainStatusEnum.APPROVING.getValue());
            }
            if (oldHisDrugMainEntity.getItemStatus().equals(DrugMainStatusEnum.PHARMACIST_BACK.getValue())) {
                drugMainEntity.setFetchMedicalCode("");
                drugMainEntity.setOrderType(null);
            }
            this.mosDrugMainMapper.update(drugMainEntity);
        }
        return drugMainEntity;
    }

    public List<HytRecipeDataDTO> getRecipeByAppCodeAndItemStatus(String appCode, String status) {
        return this.mosDrugMainMapper.getRecipeByAppCodeAndItemStatus(appCode, status);
    }
}

