/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.doctoruser.api.pojo.vo.account.DoctorInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateTimeUtil;
import com.ebaiyihui.medicalcloud.annotation.PresRoamProcessCode;
import com.ebaiyihui.medicalcloud.common.enums.DistributionTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.HospitalNamePinYinEnum;
import com.ebaiyihui.medicalcloud.common.enums.MerchantTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayChannelEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.RemarkTypeEnum;
import com.ebaiyihui.medicalcloud.exception.AsynException;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.OrderPayManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.HospitalConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.MerchantConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderRegMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugRemarkMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugstoreMapper;
import com.ebaiyihui.medicalcloud.mapper.StoreDoctorRelMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.dto.DrugOrderDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugRemarkEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugstoreEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MerchantConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderRegEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.drugstore.detail.StoreDoctorResData;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundResVo;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugOrderService;
import com.ebaiyihui.medicalcloud.service.MosDrugstoreService;
import com.ebaiyihui.medicalcloud.service.PresRoamProcessService;
import com.ebaiyihui.medicalcloud.service.PrescriptionPdfService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.DistanceUtil;
import com.ebaiyihui.medicalcloud.utils.GenSeqUtils;
import com.ebaiyihui.medicalcloud.utils.RabbitMqUtils;
import com.ebaiyihui.medicalcloud.utils.RandomUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
@PresRoamProcessCode(value="COMMON_PROCESS")
public class PresRoamCommonProcessServiceImpl
implements PresRoamProcessService {
    private static final Logger log = LoggerFactory.getLogger(PresRoamCommonProcessServiceImpl.class);
    @Autowired
    private PushManage pushManage;
    @Autowired
    private MosDrugOrderMapper drugOrderMapper;
    @Autowired
    private MerchantConfigMapper merchantConfigMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper drugLogisticsOrderMapper;
    @Autowired
    private MosDrugLogisticsOrderRegMapper drugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugMainMapper mosDrugMainMapper;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private MosDrugRemarkMapper drugRemarkMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private StoreDoctorRelMapper storeDoctorRelMapper;
    @Autowired
    private MosDrugOrderService drugOrderService;
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private MosDrugLogisticsOrderRegMapper mosDrugLogisticsOrderRegMapper;
    @Autowired
    private MosDrugLogisticsOrderMapper mosDrugLogisticsOrderMapper;
    @Autowired
    private PrescriptionPdfService prescriptionPdfService;
    @Autowired
    private MosDrugstoreService drugstoreService;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolExecutor;
    private static final String RETURNCODE = "SUCCESS";
    @Autowired
    private MosDrugstoreMapper mosDrugstoreMapper;
    public static final int SEVENTY_TWO_HOURS = 259200;
    public static final int THIRD = 3;

    public BaseResponse<Object> createTradeOrder(DrugPayReqVO drugPayReqVO) {
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(drugPayReqVO.getPayChannel()) && StringUtils.isEmpty((String)drugPayReqVO.getOpenId())) {
            return BaseResponse.error((String)"\u5fae\u4fe1\u5c0f\u7a0b\u5e8fopenId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DrugOrderDTO drugOrderDTO = this.drugOrderMapper.queryOrderByMainId(drugPayReqVO.getMainId());
        log.info("======>\u836f\u54c1\u652f\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)drugOrderDTO));
        if (drugOrderDTO == null) {
            return BaseResponse.error((String)"\u7535\u5b50\u5904\u65b9\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (BigDecimal.ZERO.equals(drugOrderDTO.getPrice())) {
            return BaseResponse.error((String)"\u836f\u54c1\u8d39\u7528\u4e0d\u80fd\u4e3a0\u5143");
        }
        if (drugOrderDTO.getOrderStatus() != null) {
            if (drugOrderDTO.getOrderStatus().equals(OrderStatusEnum.PAID.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u652f\u4ed8,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (drugOrderDTO.getOrderStatus().equals(OrderStatusEnum.PAYING.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u652f\u4ed8\u5904\u7406\u4e2d,\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            }
            if (drugOrderDTO.getOrderStatus().equals(OrderStatusEnum.EXPIRED.getValue())) {
                return BaseResponse.error((String)"\u8ba2\u5355\u5df2\u8fc7\u671f");
            }
        }
        DrugOrderEntity drugOrderEntity = this.drugOrderMapper.queryByMainId(drugPayReqVO.getMainId());
        if (OrderTypeEnum.COURIER_ORDER.getValue().equals(drugPayReqVO.getOrderType())) {
            HospitalConfigEntity configEntity = this.hospitalConfigMapper.selectByAppcode(drugPayReqVO.getAppCode());
            if (configEntity == null) {
                return BaseResponse.error((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u533b\u9662\u4fe1\u606f");
            }
            if (Objects.isNull(drugOrderEntity)) {
                this.insertDrugOrderInfo(drugPayReqVO, drugOrderDTO);
            } else {
                this.updateDrugOrderEntity(drugPayReqVO, drugOrderEntity);
            }
            MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainId(drugPayReqVO.getMainId());
            if (Objects.isNull(mosDrugLogisticsOrderEntity)) {
                this.insertLogisticsOrderInfo(drugPayReqVO, configEntity);
            } else {
                this.updateLogisticsOrderInfo(drugPayReqVO, configEntity);
            }
        } else if (Objects.nonNull(drugOrderEntity)) {
            this.updateDrugOrderEntity(drugPayReqVO, drugOrderEntity);
        } else {
            this.insertDrugOrderInfo(drugPayReqVO, drugOrderDTO);
        }
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(drugPayReqVO.getMainId());
        drugMainEntity.setOrderType(drugPayReqVO.getOrderType());
        if (OrderTypeEnum.DRUG_ORDER.getValue().equals(drugPayReqVO.getOrderType())) {
            drugMainEntity.setStoreId(drugPayReqVO.getStoreId());
            String code = RandomUtils.generateRandom((int)6);
            drugMainEntity.setFetchMedicalCode(code);
        } else {
            drugMainEntity.setStoreId(drugPayReqVO.getLogisticsPayReqVO().getDeliveryStoreId());
        }
        this.drugMainService.update(drugMainEntity);
        try {
            if (HospitalNamePinYinEnum.NCDXDEFSYY.getValue().equals(drugMainEntity.getHospitalNameFirstLetter())) {
                this.prescriptionPdfService.setPresPdf(drugMainEntity.getxId(), null);
            }
        }
        catch (Exception e) {
            log.error("=============\u751f\u6210\u5904\u65b9\u7b3a\u5931\u8d25================" + e.getMessage());
        }
        return BaseResponse.success();
    }

    private void insertLogisticsOrderInfo(DrugPayReqVO vo, HospitalConfigEntity configEntity) {
        if (vo.getLogisticsPayReqVO().getDistributionType() == null) {
            vo.getLogisticsPayReqVO().setDistributionType(DistributionTypeEnum.CITY_EXPRESS.getValue());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
        MerchantConfigEntity merchantEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantType(vo.getLogisticsPayReqVO().getAppCode(), Integer.valueOf(1));
        MosDrugLogisticsOrderEntity orderEntityOne = new MosDrugLogisticsOrderEntity();
        String orderSeq = GenSeqUtils.genOrderSeq((String)"");
        orderEntityOne.setPayMethod(vo.getLogisticsPayReqVO().getPayMethod());
        orderEntityOne.setPayAmount(vo.getLogisticsPayReqVO().getExtra());
        orderEntityOne.setChannelCode(vo.getLogisticsPayReqVO().getPayChannel());
        orderEntityOne.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        orderEntityOne.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        orderEntityOne.setOrderSeq(orderSeq);
        orderEntityOne.setMchId(merchantEntity.getMerchantSeq());
        if (StringUtils.isBlank((String)vo.getLogisticsPayReqVO().getDeliveryStoreId())) {
            orderEntityOne.setLogisticsBasisAmount(vo.getLogisticsPayReqVO().getExtra().subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
            orderEntityOne.setOverweightAmount(configEntity.getOverweightAmount());
            orderEntityOne.setPackageAmout(configEntity.getPackStandardMoney());
        }
        orderEntityOne.setInvoiceNum(vo.getLogisticsPayReqVO().getInvoiceNum());
        orderEntityOne.setInvoiceTitle(vo.getLogisticsPayReqVO().getInvoiceTitle());
        orderEntityOne.setDestProvince(vo.getLogisticsPayReqVO().getDestProvince());
        orderEntityOne.setDestCity(vo.getLogisticsPayReqVO().getDestCity());
        orderEntityOne.setDestDistrict(vo.getLogisticsPayReqVO().getDestDistrict());
        orderEntityOne.setDestDetailAddress(vo.getLogisticsPayReqVO().getDestAddress());
        orderEntityOne.setDestAddress(vo.getLogisticsPayReqVO().getDestProvince() + vo.getLogisticsPayReqVO().getDestCity() + vo.getLogisticsPayReqVO().getDestDistrict() + vo.getLogisticsPayReqVO().getDestAddress());
        orderEntityOne.setDestAddressId(vo.getLogisticsPayReqVO().getDestAddressId());
        orderEntityOne.setDestLatitude(vo.getLogisticsPayReqVO().getLatitude());
        orderEntityOne.setDestLongitude(vo.getLogisticsPayReqVO().getLongitude());
        orderEntityOne.setDestName(vo.getLogisticsPayReqVO().getDestName());
        orderEntityOne.setDestPhone(vo.getLogisticsPayReqVO().getDestPhone());
        orderEntityOne.setAppCode(vo.getLogisticsPayReqVO().getAppCode());
        orderEntityOne.setDepositumInfo("\u836f\u54c1");
        if (StringUtils.isBlank((String)vo.getLogisticsPayReqVO().getDeliveryStoreId())) {
            orderEntityOne.setExpressType(Integer.valueOf(vo.getLogisticsPayReqVO().getExpressType() == null ? 1 : vo.getLogisticsPayReqVO().getExpressType()));
            orderEntityOne.setLogisticsPayMethod(Integer.valueOf(vo.getLogisticsPayReqVO().getLogisticsPayeMthod()));
            orderEntityOne.setPackStandardMoney(configEntity.getPackStandardMoney().toString());
            orderEntityOne.setMonthlyCard(configEntity.getMonthlyCard());
            orderEntityOne.setSrcProvince(configEntity.getProvince());
            orderEntityOne.setSrcCity(configEntity.getCity());
            orderEntityOne.setSrcDistrict(configEntity.getDistrict());
            orderEntityOne.setSrcDetailAddress(configEntity.getDetailAddress());
            orderEntityOne.setSrcAddress(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress());
            orderEntityOne.setSrcName(configEntity.getName());
            orderEntityOne.setSrcPhone(configEntity.getPhone());
            Double deliveryDistance = DistanceUtil.distance((double)Double.parseDouble(configEntity.getLatitude()), (double)Double.parseDouble(configEntity.getLongitude()), (double)Double.parseDouble(vo.getLogisticsPayReqVO().getLatitude()), (double)Double.parseDouble(vo.getLogisticsPayReqVO().getLongitude()));
            orderEntityOne.setDestDeliveryDistance(deliveryDistance.toString());
        } else {
            String deliveryStoreId = vo.getLogisticsPayReqVO().getDeliveryStoreId();
            if (StringUtils.isNotBlank((String)deliveryStoreId)) {
                DrugstoreEntity drugstoreEntity = this.drugstoreService.queryById(deliveryStoreId);
                orderEntityOne.setSrcAddress(drugstoreEntity.getStoreAddress());
                orderEntityOne.setSrcPhone(drugstoreEntity.getStoreTelephone());
                orderEntityOne.setSrcName(drugstoreEntity.getStoreName());
                orderEntityOne.setDeliveryStoreId(deliveryStoreId);
            }
        }
        if (DrugTypeEnum.CM.getValue().equals(vo.getLogisticsPayReqVO().getPresType())) {
            orderEntityOne.setProductCode("CHINESE_HERBAL");
        } else {
            orderEntityOne.setProductCode("OTHER");
        }
        orderEntityOne.setLogisticsName(vo.getLogisticsPayReqVO().getLogisticsType());
        orderEntityOne.setHospitalId(drugMainEntity.getOrganId());
        orderEntityOne.setHospitalName(drugMainEntity.getPresOrganName());
        orderEntityOne.setBizSysSeq(merchantEntity.getBizSysSeq());
        orderEntityOne.setOrderStatus(OrderStatusEnum.TOPAY.getValue());
        orderEntityOne.setRemark("\u60a3\u8005\u59d3\u540d\uff1a" + drugMainEntity.getPatientName());
        this.drugLogisticsOrderMapper.insert(orderEntityOne);
        Long id = orderEntityOne.getId();
        log.info("============\u7269\u6d41\u7684\u8ba2\u5355id{}:", (Object)id);
        MosDrugLogisticsOrderRegEntity logisticsOrderRegEntity = new MosDrugLogisticsOrderRegEntity();
        logisticsOrderRegEntity.setMainId(drugMainEntity.getxId());
        logisticsOrderRegEntity.setLogisticsOrderId(id);
        logisticsOrderRegEntity.setCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        logisticsOrderRegEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.drugLogisticsOrderRegMapper.insert(logisticsOrderRegEntity);
    }

    private void insertDrugOrderInfo(DrugPayReqVO vo, DrugOrderDTO drugOrderDTO) {
        MerchantConfigEntity merchantConfigEntity = this.merchantConfigMapper.queryByOrganCodeAndMerchantType(drugOrderDTO.getPresOrgan(), Integer.valueOf(1));
        String orderSeq = GenSeqUtils.genOrderSeq((String)"");
        DrugOrderEntity orderEntity = new DrugOrderEntity();
        orderEntity.setxId(GenSeqUtils.getUniqueNo());
        orderEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
        orderEntity.setMainId(drugOrderDTO.getMainId());
        orderEntity.setMerchantId(merchantConfigEntity.getMerchantSeq());
        orderEntity.setOrderSeq(orderSeq);
        orderEntity.setBizSysSeq(merchantConfigEntity.getBizSysSeq());
        orderEntity.setOrganCode(drugOrderDTO.getPresOrgan());
        orderEntity.setStatus(OrderStatusEnum.TOPAY.getValue());
        orderEntity.setPayMethod(vo.getPayMethod());
        orderEntity.setPayAmount(drugOrderDTO.getPrice());
        orderEntity.setChannelCode(vo.getPayChannel());
        this.drugOrderMapper.insert(orderEntity);
    }

    private void updateDrugOrderEntity(DrugPayReqVO drugPayReqVO, DrugOrderEntity drugOrderEntity) {
        DrugMainEntity drugMainEntity = this.drugMainService.queryById(drugPayReqVO.getMainId());
        if (!drugMainEntity.getOrderType().equals(drugPayReqVO.getOrderType())) {
            drugOrderEntity.setOrderSeq(GenSeqUtils.genOrderSeq((String)""));
        }
        drugOrderEntity.setPayMethod(drugPayReqVO.getPayMethod());
        drugOrderEntity.setChannelCode(drugPayReqVO.getPayChannel());
        drugOrderEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        this.drugOrderMapper.update(drugOrderEntity);
    }

    private void updateLogisticsOrderInfo(DrugPayReqVO vo, HospitalConfigEntity configEntity) {
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainId(vo.getMainId());
        if (vo.getLogisticsPayReqVO().getDistributionType() == null) {
            vo.getLogisticsPayReqVO().setDistributionType(DistributionTypeEnum.CITY_EXPRESS.getValue());
        }
        DrugMainEntity drugMainEntity = this.mosDrugMainMapper.queryById(vo.getMainId());
        mosDrugLogisticsOrderEntity.setPayAmount(vo.getLogisticsPayReqVO().getExtra());
        mosDrugLogisticsOrderEntity.setChannelCode(vo.getPayChannel());
        mosDrugLogisticsOrderEntity.setUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
        if (StringUtils.isBlank((String)vo.getLogisticsPayReqVO().getDeliveryStoreId())) {
            mosDrugLogisticsOrderEntity.setLogisticsBasisAmount(vo.getLogisticsPayReqVO().getExtra().subtract(configEntity.getOverweightAmount()).subtract(configEntity.getPackStandardMoney()));
            mosDrugLogisticsOrderEntity.setOverweightAmount(configEntity.getOverweightAmount());
            mosDrugLogisticsOrderEntity.setPackageAmout(configEntity.getPackStandardMoney());
        }
        mosDrugLogisticsOrderEntity.setInvoiceNum(vo.getLogisticsPayReqVO().getInvoiceNum());
        mosDrugLogisticsOrderEntity.setInvoiceTitle(vo.getLogisticsPayReqVO().getInvoiceTitle());
        mosDrugLogisticsOrderEntity.setDestProvince(vo.getLogisticsPayReqVO().getDestProvince());
        mosDrugLogisticsOrderEntity.setDestCity(vo.getLogisticsPayReqVO().getDestCity());
        mosDrugLogisticsOrderEntity.setDestDistrict(vo.getLogisticsPayReqVO().getDestDistrict());
        mosDrugLogisticsOrderEntity.setDestDetailAddress(vo.getLogisticsPayReqVO().getDestAddress());
        mosDrugLogisticsOrderEntity.setDestAddress(vo.getLogisticsPayReqVO().getDestProvince() + vo.getLogisticsPayReqVO().getDestCity() + vo.getLogisticsPayReqVO().getDestDistrict() + vo.getLogisticsPayReqVO().getDestAddress());
        mosDrugLogisticsOrderEntity.setDestAddressId(vo.getLogisticsPayReqVO().getDestAddressId());
        mosDrugLogisticsOrderEntity.setDestLatitude(vo.getLogisticsPayReqVO().getLatitude());
        mosDrugLogisticsOrderEntity.setDestLongitude(vo.getLogisticsPayReqVO().getLongitude());
        mosDrugLogisticsOrderEntity.setDestName(vo.getLogisticsPayReqVO().getDestName());
        mosDrugLogisticsOrderEntity.setDestPhone(vo.getLogisticsPayReqVO().getDestPhone());
        mosDrugLogisticsOrderEntity.setAppCode(vo.getAppCode());
        mosDrugLogisticsOrderEntity.setDepositumInfo("\u836f\u54c1");
        if (StringUtils.isBlank((String)vo.getLogisticsPayReqVO().getDeliveryStoreId())) {
            mosDrugLogisticsOrderEntity.setExpressType(Integer.valueOf(vo.getLogisticsPayReqVO().getExpressType() == null ? 1 : vo.getLogisticsPayReqVO().getExpressType()));
            mosDrugLogisticsOrderEntity.setLogisticsPayMethod(Integer.valueOf(vo.getLogisticsPayReqVO().getLogisticsPayeMthod()));
            mosDrugLogisticsOrderEntity.setPackStandardMoney(configEntity.getPackStandardMoney().toString());
            mosDrugLogisticsOrderEntity.setMonthlyCard(configEntity.getMonthlyCard());
            mosDrugLogisticsOrderEntity.setSrcProvince(configEntity.getProvince());
            mosDrugLogisticsOrderEntity.setSrcCity(configEntity.getCity());
            mosDrugLogisticsOrderEntity.setSrcDistrict(configEntity.getDistrict());
            mosDrugLogisticsOrderEntity.setSrcDetailAddress(configEntity.getDetailAddress());
            mosDrugLogisticsOrderEntity.setSrcAddress(configEntity.getProvince() + configEntity.getCity() + configEntity.getDistrict() + configEntity.getDetailAddress());
            mosDrugLogisticsOrderEntity.setSrcName(configEntity.getName());
            mosDrugLogisticsOrderEntity.setSrcPhone(configEntity.getPhone());
            Double deliveryDistance = DistanceUtil.distance((double)Double.parseDouble(configEntity.getLatitude()), (double)Double.parseDouble(configEntity.getLongitude()), (double)Double.parseDouble(vo.getLogisticsPayReqVO().getLatitude()), (double)Double.parseDouble(vo.getLogisticsPayReqVO().getLongitude()));
            mosDrugLogisticsOrderEntity.setDestDeliveryDistance(deliveryDistance.toString());
        } else {
            String deliveryStoreId = vo.getLogisticsPayReqVO().getDeliveryStoreId();
            if (StringUtils.isNotBlank((String)deliveryStoreId)) {
                DrugstoreEntity drugstoreEntity = this.drugstoreService.queryById(deliveryStoreId);
                mosDrugLogisticsOrderEntity.setSrcAddress(drugstoreEntity.getStoreAddress());
                mosDrugLogisticsOrderEntity.setSrcPhone(drugstoreEntity.getStoreTelephone());
                mosDrugLogisticsOrderEntity.setSrcName(drugstoreEntity.getStoreName());
                mosDrugLogisticsOrderEntity.setDeliveryStoreId(deliveryStoreId);
            }
        }
        if (DrugTypeEnum.CM.getValue().equals(vo.getLogisticsPayReqVO().getPresType())) {
            mosDrugLogisticsOrderEntity.setProductCode("CHINESE_HERBAL");
        } else {
            mosDrugLogisticsOrderEntity.setProductCode("OTHER");
        }
        mosDrugLogisticsOrderEntity.setLogisticsName(vo.getLogisticsPayReqVO().getLogisticsType());
        mosDrugLogisticsOrderEntity.setRemark("\u60a3\u8005\u59d3\u540d\uff1a" + drugMainEntity.getPatientName());
        log.info("======>\u7269\u6d41\u652f\u4ed8\u66f4\u65b0\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)mosDrugLogisticsOrderEntity));
        this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
    }

    public BaseResponse<String> orderNotify(PayNotifyReqVO payNotifyReqVO, DrugOrderEntity drugOrderEntity, DrugMainEntity drugMainEntity) {
        if (OrderTypeEnum.DRUG_ORDER.getValue().equals(drugMainEntity.getOrderType())) {
            if (drugOrderEntity == null || drugMainEntity == null) {
                throw new BusinessException("\u652f\u4ed8\u56de\u8c03\u67e5\u8be2\u8ba2\u5355\u6216\u533b\u5631\u65f6\u53d1\u751f\u5f02\u5e38\uff01");
            }
            drugOrderEntity = this.getPayNotifyDrugOrderEntity(drugOrderEntity, payNotifyReqVO);
            this.drugOrderService.update(drugOrderEntity);
            drugMainEntity.setOrderType(OrderTypeEnum.DRUG_ORDER.getValue());
            drugMainEntity.setItemStatus(DrugMainStatusEnum.TO_TAKE.getValue());
            drugMainEntity.setFailureTime(DateTimeUtil.addDay((Date)new Date(), (int)3));
            this.drugMainService.update(drugMainEntity);
            this.threadPoolExecutor.execute(() -> {
                if (HospitalNamePinYinEnum.NCDXDEFSYY.getValue().equals(drugMainEntity.getHospitalNameFirstLetter())) {
                    DrugstoreEntity drugstoreEntity = this.mosDrugstoreMapper.queryById(drugMainEntity.getStoreId());
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                    HashMap<String, String> patientMap = new HashMap<String, String>(3);
                    patientMap.put("fetchMedicalCode", drugMainEntity.getFetchMedicalCode());
                    patientMap.put("storeName", drugstoreEntity.getStoreName());
                    patientMap.put("phone", "400-631-9377");
                    this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "ndefy-qym", drugMainEntity.getPatientPhone(), patientMap);
                    this.sendNewOrderGoEasy(drugMainEntity);
                }
            });
            if (HospitalNamePinYinEnum.NCDXDEFSYY.getValue().equals(drugMainEntity.getHospitalNameFirstLetter())) {
                RabbitMqUtils.senderDelayedPrescriptionOrder((RabbitTemplate)this.rabbitTemplate, (String)drugMainEntity.getxId(), (Integer)259200);
            }
            return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        drugOrderEntity = this.getPayNotifyDrugOrderEntity(drugOrderEntity, payNotifyReqVO);
        this.drugOrderService.update(drugOrderEntity);
        drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOYING.getValue());
        drugMainEntity.setOrderType(OrderTypeEnum.COURIER_ORDER.getValue());
        this.drugMainService.update(drugMainEntity);
        MosDrugLogisticsOrderRegEntity mosDrugLogisticsOrderRegEntity = this.mosDrugLogisticsOrderRegMapper.getByMainId1(drugMainEntity.getxId());
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.mosDrugLogisticsOrderMapper.selectByPrimaryKey(mosDrugLogisticsOrderRegEntity.getLogisticsOrderId());
        log.info("\u7269\u6d41\u8ba2\u5355\u4fe1\u606f->{}", (Object)Objects.toString(mosDrugLogisticsOrderEntity, null));
        if (mosDrugLogisticsOrderEntity == null) {
            return BaseResponse.success((Object)RETURNCODE);
        }
        if (OrderStatusEnum.PAID.getValue().equals(mosDrugLogisticsOrderEntity.getOrderStatus())) {
            return BaseResponse.success((Object)RETURNCODE);
        }
        this.threadPoolExecutor.execute(() -> {
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", drugMainEntity.getPresDoctorName());
            data.put("doctorName", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", " \u5904\u65b9\u652f\u4ed8\u6210\u529f");
            data.put("issue", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", "\u836f\u54c1\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u60a8\u9009\u62e9\u4e86\u836f\u54c1\u914d\u9001\u7684\u65b9\u5f0f");
            data.put("info", map3);
            this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/status/status?mainId=" + drugMainEntity.getxId());
            this.sendNewOrderGoEasy(drugMainEntity);
        });
        mosDrugLogisticsOrderEntity.setBankTradeNo(payNotifyReqVO.getTradeNo());
        mosDrugLogisticsOrderEntity.setOrderStatus(OrderStatusEnum.PAID.getValue());
        mosDrugLogisticsOrderEntity.setDealSeq(payNotifyReqVO.getDealTradeNo());
        mosDrugLogisticsOrderEntity.setBizSysSeq(payNotifyReqVO.getServiceCode());
        mosDrugLogisticsOrderEntity.setPayTime(payNotifyReqVO.getPayTime());
        mosDrugLogisticsOrderEntity.setPayMethod(payNotifyReqVO.getPayChannel());
        this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
        return BaseResponse.success((Object)RETURNCODE);
    }

    private void sendNewOrderGoEasy(DrugMainEntity drugMainEntity) {
        if (Objects.isNull(drugMainEntity)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", drugMainEntity.getxId());
        map.put("body", "\u67e5\u770b\u8be6\u60c5");
        map.put("type", "yyy");
        map.put("title", "\u60a8\u6709\u65b0\u7684\u5904\u65b9\u8ba2\u5355\uff01");
        map.put("subTitle", "\u60a8\u6709\u65b0\u7684\u5904\u65b9\u8ba2\u5355\uff01");
        map.put("pushCode", "1");
        List storeDoctorResDataList = this.storeDoctorRelMapper.queryByStoreId(drugMainEntity.getStoreId());
        if (CollectionUtils.isNotEmpty((Collection)storeDoctorResDataList)) {
            for (StoreDoctorResData storeDoctorResData : storeDoctorResDataList) {
                String userId;
                DoctorInfoRespVO doctorInfoRespVO = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(storeDoctorResData.getDoctorId())));
                if (doctorInfoRespVO == null || !StringUtils.isNotEmpty((String)(userId = doctorInfoRespVO.getUserId()))) continue;
                this.pushManage.iGoEasyPush(userId, JSON.toJSONString(map), "ncefy_new_order");
            }
        }
    }

    private DrugOrderEntity getPayNotifyDrugOrderEntity(DrugOrderEntity drugOrderEntity, PayNotifyReqVO payNotifyReqVO) {
        drugOrderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        drugOrderEntity.setPayTime(payNotifyReqVO.getPayTime());
        drugOrderEntity.setDealSeq(payNotifyReqVO.getDealTradeNo());
        drugOrderEntity.setBankTradeNo(payNotifyReqVO.getTradeNo());
        drugOrderEntity.setMchId("");
        return drugOrderEntity;
    }

    public BaseResponse<String> applyRefundSecond(BaseOperationDto dto, DrugMainEntity drugMainEntity) {
        DrugOrderEntity drugOrderEntity = this.drugOrderMapper.queryByMainIdAndOrderStatus(dto.getMainId(), OrderStatusEnum.PAID.getValue());
        if (drugOrderEntity != null) {
            MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity;
            if (OrderStatusEnum.REFUNDING.getValue().equals(drugOrderEntity.getStatus()) || OrderStatusEnum.REFUNDED.getValue().equals(drugOrderEntity.getStatus())) {
                return BaseResponse.success((Object)"\u6b64\u8ba2\u5355\u6b63\u5728\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
            MosDrugLogisticsOrderEntity logisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainIdAndStatus(dto.getMainId(), OrderStatusEnum.PAID.getValue());
            BigDecimal payAmount = null;
            payAmount = Objects.nonNull(logisticsOrderEntity) ? (Objects.nonNull((mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainId(drugMainEntity.getxId())).getPayAmount()) ? drugOrderEntity.getPayAmount().add(mosDrugLogisticsOrderEntity.getPayAmount()) : drugOrderEntity.getPayAmount()) : drugOrderEntity.getPayAmount();
            RefundReqVO refundReqVO = new RefundReqVO();
            refundReqVO.setOrderSeq(drugOrderEntity.getOrderSeq());
            refundReqVO.setDealSeq(drugOrderEntity.getDealSeq());
            refundReqVO.setMerchantId(drugOrderEntity.getMerchantId());
            refundReqVO.setPayMethod(drugOrderEntity.getPayMethod());
            refundReqVO.setPayAmount(payAmount);
            refundReqVO.setMerchantType(MerchantTypeEnum.DRUG.getValue());
            RefundResVo refundResVo = this.orderPayManage.applyRefundServer(refundReqVO);
            if (!refundResVo.isFlag()) {
                return BaseResponse.error((String)("\u836f\u54c1\u9000\u6b3e" + refundResVo.getMsg()));
            }
            drugOrderEntity.setStatus(OrderStatusEnum.REFUNDING.getValue());
            this.drugOrderMapper.update(drugOrderEntity);
            if (Objects.nonNull(logisticsOrderEntity)) {
                logisticsOrderEntity.setOrderStatus(OrderStatusEnum.REFUNDING.getValue());
                this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(logisticsOrderEntity);
            }
            DrugRemarkEntity drugRemarkEntity = new DrugRemarkEntity();
            drugRemarkEntity.setxId(GenSeqUtils.getUniqueNo());
            drugRemarkEntity.setxUpdateTime(DateUtils.getThisDateTime((Date)new Date()));
            drugRemarkEntity.setRemarkContent(dto.getContent());
            drugRemarkEntity.setMainId(dto.getMainId());
            drugRemarkEntity.setRemarkType(RemarkTypeEnum.REFUND.getValue());
            drugRemarkEntity.setRemarkUser(dto.getOprationUser());
            drugRemarkEntity.setxCreateTime(DateUtils.getThisDateTime((Date)new Date()));
            this.drugRemarkMapper.insert(drugRemarkEntity);
        }
        new Thread(() -> {
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", drugMainEntity.getPresDoctorName());
            data.put("doctorName", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", " \u836f\u54c1\u9000\u6b3e");
            data.put("issue", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            map3.put("value", "\u5df2\u8fdb\u884c\u9000\u6b3e\uff0c\u6b3e\u9879\u5c06\u572824\u5c0f\u65f6\u5185\u9000\u56de\u539f\u8d26\u6237");
            data.put("info", map3);
            this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/status/status?mainId=" + drugMainEntity.getxId());
            try {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("doctorName", drugMainEntity.getPresDoctorName());
                UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy-hzsqtk", drugMainEntity.getPatientPhone(), param);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new AsynException(e.getMessage());
            }
        }).start();
        return BaseResponse.success();
    }

    public void refundNotify(DrugMainEntity drugMainEntity, RefundCallBackReqVo refundNotifyReqVO) {
        log.info("=======\u8fdb\u53bb\u901a\u7528\u7248\u7269\u6d41\u56de\u8c03");
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainId(drugMainEntity.getxId());
        log.info("======>\u7269\u6d41\u9000\u6b3e\u56de\u8c03---\u8ba2\u5355\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)mosDrugLogisticsOrderEntity));
        if (mosDrugLogisticsOrderEntity != null) {
            mosDrugLogisticsOrderEntity.setOrderStatus(OrderStatusEnum.REFUNDED.getValue());
            mosDrugLogisticsOrderEntity.setRefundTime(refundNotifyReqVO.getRefundTime());
            this.drugLogisticsOrderMapper.updateByPrimaryKeySelective(mosDrugLogisticsOrderEntity);
        }
    }
}

