/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.medicalcloud.annotation.PresRoamProcessCode;
import com.ebaiyihui.medicalcloud.common.constants.BusinessConstant;
import com.ebaiyihui.medicalcloud.common.enums.BusinessCodeEnum;
import com.ebaiyihui.medicalcloud.common.enums.DrugMainStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.OrderStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.PayStatusEnum;
import com.ebaiyihui.medicalcloud.common.enums.PushCodeInfoEnum;
import com.ebaiyihui.medicalcloud.common.enums.UserEnum;
import com.ebaiyihui.medicalcloud.common.enums.UserTypeEnum;
import com.ebaiyihui.medicalcloud.manage.AsynManage;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.HisManage;
import com.ebaiyihui.medicalcloud.manage.OrderPayManage;
import com.ebaiyihui.medicalcloud.manage.PushManage;
import com.ebaiyihui.medicalcloud.mapper.MosDrugLogisticsOrderMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.mapper.MosOutpatientMainRelMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.BaseOperationDto;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HisLogEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosDrugLogisticsOrderEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.MosOutpatientMainRelEntity;
import com.ebaiyihui.medicalcloud.pojo.im.MessageData;
import com.ebaiyihui.medicalcloud.pojo.vo.his.HuaHongResultVo;
import com.ebaiyihui.medicalcloud.pojo.vo.his.LogisticsRecipeReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.his.SaveFeeReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.DrugPayReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.PayNotifyReqVO;
import com.ebaiyihui.medicalcloud.pojo.vo.pay.RefundCallBackReqVo;
import com.ebaiyihui.medicalcloud.service.HisLogService;
import com.ebaiyihui.medicalcloud.service.MosDrugMainService;
import com.ebaiyihui.medicalcloud.service.MosDrugOrderService;
import com.ebaiyihui.medicalcloud.service.PresRoamProcessService;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@PresRoamProcessCode(value="ZRYH_PROCESS")
@Service
public class PresRoamZryhProcessServiceImpl
implements PresRoamProcessService {
    private static final Logger log = LoggerFactory.getLogger(PresRoamZryhProcessServiceImpl.class);
    @Autowired
    private MosDrugOrderService drugOrderService;
    @Autowired
    private MosDrugMainService drugMainService;
    @Autowired
    private PushManage pushManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private AsynManage asynManage;
    @Autowired
    private MosOutpatientMainRelMapper outpatientMainRelMapper;
    @Autowired
    private MosDrugPrescriptionMapper mosDrugPrescriptionMapper;
    @Autowired
    private HisManage hisManage;
    @Autowired
    private MosDrugLogisticsOrderMapper drugLogisticsOrderMapper;
    @Autowired
    private MosOutpatientMainRelMapper mosOutpatientMainRelMapper;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private HisLogService hisLogService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    public static final int ONE_THOUSAND_METERS = 10000;

    public BaseResponse<Object> createTradeOrder(DrugPayReqVO vo) {
        return null;
    }

    public BaseResponse<String> orderNotify(PayNotifyReqVO payNotifyReqVO, DrugOrderEntity drugOrderEntity, DrugMainEntity drugMainEntity) {
        MosOutpatientMainRelEntity outpatientMainRelEntity = this.outpatientMainRelMapper.getByMainId(drugOrderEntity.getMainId());
        DrugPrescriptionEntity prescriptionEntity = this.mosDrugPrescriptionMapper.queryByMainId(drugOrderEntity.getMainId());
        MosDrugLogisticsOrderEntity mosDrugLogisticsOrderEntity = this.drugLogisticsOrderMapper.selectByMainId(drugOrderEntity.getMainId());
        drugOrderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        drugOrderEntity.setPayTime(payNotifyReqVO.getPayTime());
        drugOrderEntity.setDealSeq(payNotifyReqVO.getDealTradeNo());
        drugOrderEntity.setBankTradeNo(payNotifyReqVO.getTradeNo());
        drugOrderEntity.setMchId("");
        this.drugOrderService.update(drugOrderEntity);
        String fetchMedicalCode = "";
        drugMainEntity.setItemStatus(DrugMainStatusEnum.DEPLOYING.getValue());
        this.drugMainService.update(drugMainEntity);
        String doctorMsg = "\u5904\u65b9\u8ba2\u5355\u7f16\u53f7" + prescriptionEntity.getxId() + "\uff0c\u60a3\u8005" + drugMainEntity.getPatientName() + "\u5df2\u4ed8\u6b3e\u3002";
        try {
            MessageData data = new MessageData();
            data.setText(doctorMsg);
            String doctorUserId = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(drugMainEntity.getPresDoctorId()))).getUserId();
            this.asynManage.imPushMsgByMainId("", drugMainEntity.getxId(), "", "EHOS_DOCTOR", doctorUserId, outpatientMainRelEntity.getAdmissionId(), (Object)data, BusinessConstant.SERVICE_SYSTEM_POINT_TYPE);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            String userId = this.doctorRetmoteManage.getUserIdByDoctorId(Long.valueOf(Long.parseLong(drugMainEntity.getPresDoctorId()))).getUserId();
            this.pushManage.iAppMsgPush(UserEnum.DOCTOR.getDesc(), drugMainEntity.getPresOrgan(), PushCodeInfoEnum.ZRYH_PAY_PRES.getBusiCode(), doctorMsg, PushCodeInfoEnum.ZRYH_CHECK_PASS_PRES.getDesc(), PushCodeInfoEnum.ZRYH_PAY_PRES.getDesc(), PushCodeInfoEnum.ZRYH_PAY_PRES.getActionCode(), PushCodeInfoEnum.ZRYH_PAY_PRES.getValueCode().toString(), drugMainEntity.getxId(), this.doctorRetmoteManage.getDevice(userId, UserTypeEnum.DOCTOR.getValue(), drugMainEntity.getPresOrgan()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if ("SSS".equalsIgnoreCase(drugMainEntity.getPresOrgan())) {
            SaveFeeReqVO vo = new SaveFeeReqVO();
            ArrayList<String> recipeList = new ArrayList<String>();
            vo.setCardNo(drugMainEntity.getPatientNo());
            vo.setFee(prescriptionEntity.getPrice().toString());
            vo.setFeeDate(DateUtils.formatDateTime((Date)payNotifyReqVO.getPayTime()));
            vo.setHisRegNo(outpatientMainRelEntity.getHisRegNo());
            vo.setMerID(drugOrderEntity.getMerchantId());
            vo.setReqOrderNo(drugOrderEntity.getOrderSeq());
            recipeList.add(prescriptionEntity.getHisRecipeNo());
            vo.setRecipeList(recipeList);
            vo.setSign("ZWBY");
            vo.setNetCost(prescriptionEntity.getPrice().toString());
            vo.setOrgID(drugMainEntity.getOrganId());
            vo.setPayMethod("WX");
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setBody((Object)vo);
            BaseResponse baseResponse = this.hisManage.sendHis("/zryh-his/api/v1/recipe/saveFee", frontRequest, Object.class);
            HisLogEntity hisLogEntity = this.hisLogService.savaEntity(frontRequest, "/zryh-his/api/v1/recipe/saveFee", drugMainEntity.getOrganId());
            hisLogEntity.setResponse(JSONObject.toJSONString((Object)baseResponse));
            this.hisLogService.update(hisLogEntity);
            if (baseResponse.isSuccess()) {
                drugMainEntity.setFetchMedicalCode(drugMainEntity.getFetchMedicalCode());
                LogisticsRecipeReqVO logisticsRecipeReqVO = this.hisManage.getLogisticsRecipeReqVO(drugMainEntity.getxId(), mosDrugLogisticsOrderEntity.getDestAddress(), drugMainEntity.getFetchMedicalCode());
                FrontRequest logisticsFrontRequest = new FrontRequest();
                logisticsFrontRequest.setBody((Object)logisticsRecipeReqVO);
                for (int i = 0; i <= 3; ++i) {
                    BaseResponse huaHongResultResponse = this.hisManage.sendHis("/zryh-his/api/v1/logistics/synLogisticsRecipe", logisticsFrontRequest, HuaHongResultVo.class);
                    boolean flag = huaHongResultResponse.getCode().equals("1");
                    HisLogEntity logEntity = this.hisLogService.savaEntity(frontRequest, "/zryh-his/api/v1/logistics/synLogisticsRecipe", drugMainEntity.getOrganId());
                    logEntity.setResponse(JSONObject.toJSONString((Object)huaHongResultResponse));
                    this.hisLogService.update(logEntity);
                    if (flag) break;
                }
                this.threadPoolTaskExecutor.execute(() -> {
                    LinkedHashMap data = new LinkedHashMap();
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("value", drugMainEntity.getPresDoctorName());
                    data.put("doctorName", map1);
                    HashMap<String, String> map2 = new HashMap<String, String>();
                    map2.put("value", "\u836f\u54c1\u8d2d\u4e70\u6210\u529f");
                    data.put("issue", map2);
                    HashMap<String, String> map3 = new HashMap<String, String>(1);
                    map3.put("value", "\u60a8\u7684\u836f\u54c1\u5df2\u8d2d\u4e70\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u914d\u9001");
                    data.put("info", map3);
                    this.pushManage.iWeChatPush(drugMainEntity.getPresOrgan(), "inquiry_common_notify", this.pushManage.getOpenId(drugMainEntity.getPresOrgan(), drugMainEntity.getPatientUserId()), data, "/prescription/pages/detial/detial?mainId=" + drugMainEntity.getxId());
                    UcConfigurationVO configurationVO = this.pushManage.getClientCode(drugMainEntity.getPresOrgan(), "sms");
                    String signCode = JSONObject.parseObject((String)configurationVO.getClientCode()).getJSONObject("signCode").getString("patientCode");
                    if (Double.valueOf(mosDrugLogisticsOrderEntity.getDestDeliveryDistance()) > 10000.0) {
                        HashMap<String, String> param = new HashMap<String, String>();
                        param.put("phoneNumber", "010-84205927");
                        this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy_hzypzfcg", drugMainEntity.getPatientPhone(), param);
                        MosOutpatientMainRelEntity mosOutpatientMainRelEntity = this.mosOutpatientMainRelMapper.getByMainId(drugMainEntity.getxId());
                        String patientMsg = "\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u8bf7\u7b49\u5f85\u836f\u54c1\u914d\u9001\uff0c\u53ef\u5728\u4e2a\u4eba\u4e2d\u5fc3-\u836f\u54c1\u5904\u65b9\u4e2d\u67e5\u770b\u8ba2\u5355\u8fdb\u5ea6";
                        MessageData messageData = new MessageData();
                        messageData.setText(patientMsg);
                        this.asynManage.imPushMsgByMainId(BusinessCodeEnum.AUDIT.getValue(), drugMainEntity.getxId(), "", "EHOS_PATIENT", drugMainEntity.getPatientUserId(), mosOutpatientMainRelEntity.getAdmissionId(), (Object)messageData, BusinessConstant.SERVICE_SYSTEM_POINT_TYPE);
                    } else {
                        HashMap<String, String> param = new HashMap<String, String>();
                        param.put("fetchMedicalCode", drugMainEntity.getFetchMedicalCode());
                        param.put("phone", "010-84205927");
                        this.pushManage.iSMSPush("ali", drugMainEntity.getPresOrgan(), signCode, "yyy_wczz", drugMainEntity.getPatientPhone(), param);
                        MessageData messageData = new MessageData();
                        messageData.setText("\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u8bf7\u7b49\u5f85\u836f\u54c1\u914d\u9001\uff0c\u6536\u5230\u836f\u54c1\u540e\uff0c\u8bf7\u51ed\u53d6\u836f\u7801\u300c" + drugMainEntity.getFetchMedicalCode() + "\u300d\u5b8c\u6210\u53d6\u836f");
                        this.asynManage.imPushMsgByMainId(BusinessCodeEnum.AUDIT.getValue(), drugMainEntity.getxId(), "", "EHOS_PATIENT", drugMainEntity.getPatientUserId(), outpatientMainRelEntity.getAdmissionId(), (Object)messageData, BusinessConstant.SERVICE_SYSTEM_POINT_TYPE);
                    }
                });
            } else {
                this.threadPoolTaskExecutor.execute(() -> {
                    BaseOperationDto baseOperationDto = new BaseOperationDto();
                    baseOperationDto.setMainId(drugMainEntity.getxId());
                    baseOperationDto.setOprationUser("system");
                    baseOperationDto.setContent("HIS\u540c\u6b65\u7f34\u8d39\u9000\u6b3e");
                    this.orderPayManage.applyRefund(baseOperationDto);
                });
            }
        }
        return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
    }

    public BaseResponse<String> applyRefundSecond(BaseOperationDto dto, DrugMainEntity drugMainEntity) {
        return null;
    }

    public void refundNotify(DrugMainEntity drugMainEntity, RefundCallBackReqVo refundNotifyReqVO) {
        log.info("=========\u9000\u6b3e:{}", (Object)JSON.toJSONString((Object)refundNotifyReqVO));
    }
}

