/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.common.pojo.vo.card.CardDetailRespVO;
import com.ebaiyihui.medicalcloud.common.enums.DrugTypeEnum;
import com.ebaiyihui.medicalcloud.common.enums.PatientNoTypeEnum;
import com.ebaiyihui.medicalcloud.common.third.PrescPdf;
import com.ebaiyihui.medicalcloud.common.third.PrescPdfPath;
import com.ebaiyihui.medicalcloud.config.PrescPdfConfig;
import com.ebaiyihui.medicalcloud.config.SpecialNodeConfig;
import com.ebaiyihui.medicalcloud.exception.BusinessException;
import com.ebaiyihui.medicalcloud.manage.DoctorRetmoteManage;
import com.ebaiyihui.medicalcloud.manage.PatientInfoRemoteManage;
import com.ebaiyihui.medicalcloud.mapper.DrugDetailMapper;
import com.ebaiyihui.medicalcloud.mapper.DrugItemMapper;
import com.ebaiyihui.medicalcloud.mapper.HospitalConfigMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugMainMapper;
import com.ebaiyihui.medicalcloud.mapper.MosDrugPrescriptionMapper;
import com.ebaiyihui.medicalcloud.mapper.PdfAddressMapper;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.DrugDetailData;
import com.ebaiyihui.medicalcloud.pojo.dto.pres.PresInfoDTO;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugDetailEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugItemEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugMainEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.DrugPrescriptionEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.HospitalConfigEntity;
import com.ebaiyihui.medicalcloud.pojo.entity.PdfAddressEntity;
import com.ebaiyihui.medicalcloud.pojo.vo.DrugDetailPdfVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PatientInfoRespVO;
import com.ebaiyihui.medicalcloud.pojo.vo.PrescriptionPdfResVo;
import com.ebaiyihui.medicalcloud.service.DrugDetailService;
import com.ebaiyihui.medicalcloud.service.PrescriptionPdfService;
import com.ebaiyihui.medicalcloud.utils.BeanHelper;
import com.ebaiyihui.medicalcloud.utils.DateUtils;
import com.ebaiyihui.medicalcloud.utils.FileUtils;
import com.ebaiyihui.medicalcloud.utils.JsonUtil;
import com.ebaiyihui.medicalcloud.utils.PdfUtil;
import com.ebaiyihui.medicalcloud.utils.StringUtil;
import com.ebaiyihui.medicalcloud.utils.ZipUtils;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@EnableAsync
public class PrescriptionPdfServiceImpl
implements PrescriptionPdfService {
    private static final Logger log = LoggerFactory.getLogger(PrescriptionPdfServiceImpl.class);
    public static final int ZERO = 0;
    @Resource
    private PrescPdfConfig pdfConfig;
    @Resource
    private MosDrugMainMapper mosDrugMainMapper;
    @Resource
    private DrugDetailMapper drugDetailMapper;
    @Resource
    private MosDrugPrescriptionMapper drugPrescriptionMapper;
    @Autowired
    private SpecialNodeConfig specialNodeConfig;
    @Autowired
    private DrugDetailService detailService;
    @Autowired
    private PatientInfoRemoteManage patientInfoRemoteManage;
    @Autowired
    private DoctorRetmoteManage doctorRetmoteManage;
    @Autowired
    private ThreadPoolTaskExecutor executorService;
    @Autowired
    private HospitalConfigMapper configMapper;
    @Autowired
    private PdfAddressMapper pdfAddressMapper;
    @Autowired
    private DrugItemMapper drugItemMapper;
    private static List<String> unitList = new ArrayList();

    @Transactional(rollbackFor={Exception.class})
    public void producePdfSecond(List<PresInfoDTO> list, String presId, String appCode, String ossHost, String htmlPath) {
        List prescPdfPaths = this.genpPdfAndSendToOss(list, ossHost, htmlPath);
        if (CollectionUtils.isEmpty((Collection)prescPdfPaths)) {
            log.error("=======>\u751f\u6210pdf\u5931\u8d25");
            return;
        }
        PrescPdfPath prescPdfPath = (PrescPdfPath)prescPdfPaths.get(0);
        if (prescPdfPath == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty(list)) {
            if (StringUtils.isNotEmpty((String)appCode) && this.specialNodeConfig.getHyt().equals(appCode)) {
                if (StringUtils.isEmpty((String)presId)) {
                    DrugMainEntity drugMainEntity = new DrugMainEntity();
                    drugMainEntity.setxId(list.get(0).getMainId());
                    drugMainEntity.setOssUrl(prescPdfPath.getOssPath());
                    drugMainEntity.setHtmlUrl(prescPdfPath.getHtmlPath());
                    this.mosDrugMainMapper.update(drugMainEntity);
                } else {
                    for (PresInfoDTO presInfoDTO : list) {
                        if (presInfoDTO == null) continue;
                        DrugPrescriptionEntity drugPrescriptionEntity = new DrugPrescriptionEntity();
                        drugPrescriptionEntity.setxId(presInfoDTO.getPresId());
                        drugPrescriptionEntity.setOssUrl(prescPdfPath.getOssPath());
                        drugPrescriptionEntity.setHtmlUrl(prescPdfPath.getHtmlPath());
                        this.drugPrescriptionMapper.update(drugPrescriptionEntity);
                        log.info("=======>\u751f\u6210pdf - \u66f4\u65b0\u5904\u65b9oss\u548chtml\u5730\u5740\u6210\u529f - list:{}", (Object)JsonUtil.convertObject(list));
                    }
                }
                return;
            }
            for (PresInfoDTO presInfoDTO : list) {
                if (presInfoDTO == null) continue;
                DrugPrescriptionEntity drugPrescriptionEntity = new DrugPrescriptionEntity();
                drugPrescriptionEntity.setxId(presInfoDTO.getPresId());
                drugPrescriptionEntity.setOssUrl(prescPdfPath.getOssPath());
                drugPrescriptionEntity.setHtmlUrl(prescPdfPath.getHtmlPath());
                this.drugPrescriptionMapper.update(drugPrescriptionEntity);
                log.info("=======>\u751f\u6210pdf - \u66f4\u65b0\u5904\u65b9oss\u548chtml\u5730\u5740\u6210\u529f - list:{}", (Object)JsonUtil.convertObject(list));
            }
        }
    }

    public List<PrescPdfPath> genpPdfAndSendToOss(List<PresInfoDTO> presInfoDTOList, String ossHost, String htmlPath) {
        PrescPdf prescPdf = new PrescPdf(presInfoDTOList, this.pdfConfig, ossHost, htmlPath);
        boolean pdfSuccess = prescPdf.toPdf();
        if (!pdfSuccess) {
            throw new BusinessException("\u751f\u6210pdf\u5e76\u53d1\u9001\u81f3oss\u5931\u8d25");
        }
        log.info("\u751f\u6210pdf\u6210\u529f\u5730\u5740\uff1a{}", (Object)prescPdf.getPdfPath());
        return prescPdf.getPdfPath();
    }

    public void setPresPdf(String mainId, String presId) {
        PdfAddressEntity pdfAddressEntity;
        log.info("=======>\u751f\u6210pdf - \u53c2\u6570 - \u533b\u5631ID - mainId:{},presId:{}", (Object)mainId, (Object)presId);
        List list = this.mosDrugMainMapper.queryForPdf(mainId, presId);
        log.info("=======>\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)list));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (PresInfoDTO dto : list) {
            DoctorEntityInfoVO doctorEntityInfoVO;
            if (StringUtils.isNotBlank((String)dto.getPresDoctorId()) && (doctorEntityInfoVO = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(dto.getPresDoctorId().trim())))) != null) {
                dto.setPresPdfIcon(this.doctorRetmoteManage.queryOrganization(doctorEntityInfoVO.getOrganId()).getLogo());
            }
            if (StringUtils.isEmpty((String)dto.getIcdName()) && StringUtils.isNotEmpty((String)dto.getDiagnostic())) {
                dto.setIcdName(dto.getDiagnostic());
            }
            if (StringUtil.isNotEmpty((String)dto.getHisRecipeNo())) {
                dto.setPresCode(dto.getHisRecipeNo());
            }
            if (dto.getPatientNoType() == null) {
                if (StringUtils.isNotBlank((String)dto.getPatientNo())) {
                    CardDetailRespVO cardInfoVo = this.patientInfoRemoteManage.getCardInfo(dto.getPresOrgan(), dto.getPatientNo(), dto.getPatientUserId());
                    if (cardInfoVo != null) {
                        dto.setPatientNoType(Integer.valueOf(cardInfoVo.getCardTypeCode()));
                    } else {
                        dto.setPatientNoType(PatientNoTypeEnum.OWN.getValue());
                    }
                } else {
                    dto.setPatientNoType(PatientNoTypeEnum.OWN.getValue());
                }
            }
            if (this.specialNodeConfig.getHyt().equals(dto.getPresOrgan()) && dto.getOwnFlag() != null) {
                dto.setPatientNoType(dto.getOwnFlag() == 0 ? PatientNoTypeEnum.OWN.getValue() : PatientNoTypeEnum.HYT_MEDICAL_INSURANCE.getValue());
            }
            DrugDetailEntity drugDetailEntity = new DrugDetailEntity();
            drugDetailEntity.setMainId(mainId);
            drugDetailEntity.setPresId(dto.getPresId());
            if (this.specialNodeConfig.getHyt().equals(dto.getPresOrgan()) && StringUtils.isNotEmpty((String)dto.getRecipeDate())) {
                dto.setCreateTimeStr(DateUtils.getYMD((Date)DateUtils.parseDate((Object)dto.getRecipeDate())));
            } else {
                dto.setCreateTimeStr(DateUtils.getYMD((Date)dto.getCreateTime()));
            }
            List drugDetailList = this.drugDetailMapper.queryForPdf(drugDetailEntity);
            if (drugDetailList.size() != 0) {
                log.info("=======>\u751f\u6210pdf - \u836f\u54c1\u5217\u8868 - list:{}", (Object)JsonUtil.convertObject((Object)drugDetailList));
                dto.setDrugInfos(drugDetailList);
                if (this.specialNodeConfig.getHyt().equals(dto.getPresOrgan()) && DrugTypeEnum.CM.getValue().equals(((PresInfoDTO)list.get(0)).getPresType())) {
                    dto.setCmFrequencyDesc(((DrugDetailPdfVO)drugDetailList.get(0)).getFrequencyDesc());
                    dto.setCmUsageDesc(((DrugDetailPdfVO)drugDetailList.get(0)).getUsageDesc());
                    dto.setCmAmount(((DrugDetailPdfVO)drugDetailList.get(0)).getDuration());
                }
            }
            for (DrugDetailPdfVO drugDetailPdfVO : drugDetailList) {
                DrugItemEntity drugItemEntity;
                if (!StringUtils.isNotEmpty((String)drugDetailPdfVO.getAmount())) continue;
                if (this.specialNodeConfig.getHyt().equals(dto.getPresOrgan()) && DrugTypeEnum.CM.getValue().equals(((PresInfoDTO)list.get(0)).getPresType()) && unitList.contains(drugDetailPdfVO.getWholePackingUnit()) && Objects.nonNull(drugItemEntity = this.drugItemMapper.queryByCommonCode(drugDetailPdfVO.getDrugCommonCode(), dto.getPresOrgan())) && Objects.nonNull(drugItemEntity.getMeasureNum())) {
                    drugDetailPdfVO.setSingleDose(drugDetailPdfVO.getSingleDose().divide(drugItemEntity.getMeasureNum()));
                    drugDetailPdfVO.setMeasureUnit(drugDetailPdfVO.getWholePackingUnit() + "[" + drugDetailPdfVO.getDrugSpec() + "]");
                }
                drugDetailPdfVO.setAmount(StringUtil.getNoZeros((String)drugDetailPdfVO.getAmount()));
            }
        }
        log.info("=======>\u751f\u6210pdf - \u5904\u65b9\u8be6\u60c5 - list:{}", (Object)JsonUtil.convertObject((Object)list));
        HospitalConfigEntity configEntity = this.configMapper.selectByAppcode(((PresInfoDTO)list.get(0)).getPresOrgan());
        if (configEntity != null) {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_25);
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            String templateContent = "";
            templateContent = DrugTypeEnum.CM.getValue().equals(((PresInfoDTO)list.get(0)).getPresType()) ? PrescPdf.getZryhTemplateName((String)this.pdfConfig.getBasePath(), (String)configEntity.getCmTemplate()) : PrescPdf.getZryhTemplateName((String)this.pdfConfig.getBasePath(), (String)configEntity.getWmTemplate());
            stringLoader.putTemplate("prescTemplate", templateContent);
            configuration.setTemplateLoader((TemplateLoader)stringLoader);
            this.pdfConfig.setConfiguration(configuration);
        }
        if ((pdfAddressEntity = this.pdfAddressMapper.selectByAppcode(((PresInfoDTO)list.get(0)).getPresOrgan())) != null) {
            this.producePdfSecond(list, presId, ((PresInfoDTO)list.get(0)).getPresOrgan(), pdfAddressEntity.getOssHost(), pdfAddressEntity.getHtmlPath());
        }
    }

    public void exportBatchPrescriptionPdf(String mainIds, HttpServletResponse response) {
        List prescriptionPdfResVoList = this.getPrescriptionPdfResVoList(mainIds);
        this.exportPdf(response, prescriptionPdfResVoList);
    }

    private void exportPdf(HttpServletResponse response, List<PrescriptionPdfResVo> prescriptionPdfResVoList) {
        String currentTime = String.valueOf(System.currentTimeMillis());
        String path = this.getClass().getClassLoader().getResource("bootstrap.yml").getPath();
        log.info("path: " + path);
        String pdfPath = FileUtils.getPath((String)path, (String)("pdf/" + currentTime + "/"));
        CountDownLatch countDownLatch = new CountDownLatch(prescriptionPdfResVoList.size());
        prescriptionPdfResVoList.stream().forEach(prescriptionPdfResVo -> this.executorService.submit(() -> {
            HashMap<String, PrescriptionPdfResVo> dataMap = new HashMap<String, PrescriptionPdfResVo>(1);
            dataMap.put("orderDetail", (PrescriptionPdfResVo)prescriptionPdfResVo);
            String htmlStr = PdfUtil.freemarkerRender(dataMap, (String)"prescriptionPdf.ftl");
            try {
                String fileName = "byh-presc-" + prescriptionPdfResVo.getPresCode() + ".pdf";
                PdfUtil.createPdf((String)htmlStr, (String)(pdfPath + fileName));
            }
            catch (Exception e) {
                log.error("\u521b\u5efapdf\u5f02\u5e38->{}", (Throwable)e);
            }
            countDownLatch.countDown();
        }));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            log.error("countDownLatch.await()\u5f02\u5e38->{}", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        String zipPath = FileUtils.getPath((String)path, (String)("pdfzip/" + currentTime + "/"));
        ZipUtils.saveZip((String)pdfPath, (String)zipPath, (String)DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmssSSS"), (HttpServletResponse)response);
    }

    private List<PrescriptionPdfResVo> getPrescriptionPdfResVoList(String mainIds) {
        List prescriptionPdfResVoList = this.mosDrugMainMapper.queryExportPrePdfInfoByMainIds(mainIds);
        log.info("\u6e05\u5355\u6253\u5370prescriptionPdfResVoList->{}", (Object)JSON.toJSONString((Object)prescriptionPdfResVoList));
        List drugDetailEntityList = this.detailService.getByMainIds(mainIds);
        Map<String, List<DrugDetailEntity>> drugDetailEntityListMap = drugDetailEntityList.stream().collect(Collectors.groupingBy(drugDetailEntity -> drugDetailEntity.getMainId()));
        return prescriptionPdfResVoList.parallelStream().map(prescriptionPdfResVo -> {
            PatientInfoRespVO patientInfoRespVO;
            List drugDetailList = (List)drugDetailEntityListMap.get(prescriptionPdfResVo.getMainId());
            List detailDataList = drugDetailList.stream().map(drugDetailEntity -> {
                DrugDetailData drugDetailData = new DrugDetailData();
                drugDetailData.setDrugName(drugDetailEntity.getDrugName());
                drugDetailData.setDrugSpec(drugDetailEntity.getDrugSpec());
                drugDetailData.setDuration(drugDetailEntity.getDuration());
                drugDetailData.setManufacturer(drugDetailEntity.getManufacturer());
                if (drugDetailEntity.getSingleDose() != null && StringUtils.isNotEmpty((String)drugDetailEntity.getMeasureUnit()) && StringUtils.isNotEmpty((String)drugDetailEntity.getUsageDesc()) && drugDetailEntity.getDuration() != null) {
                    drugDetailData.setDosage("\u6bcf\u6b21" + StringUtil.getNoZeros((String)drugDetailEntity.getSingleDose().toString()) + drugDetailEntity.getMeasureUnit() + "," + drugDetailEntity.getUsageDesc() + "," + drugDetailEntity.getFrequencyDesc());
                }
                if (drugDetailEntity.getAmount() != null) {
                    drugDetailData.setAmount(new BigDecimal(StringUtil.getNoZeros((String)drugDetailEntity.getAmount().toString())));
                }
                drugDetailData.setUnitPrice(drugDetailEntity.getUnitPrice().toString());
                drugDetailData.setTotalPrice(drugDetailEntity.getTotalPrice().toString());
                drugDetailData.setReasonDesc(drugDetailEntity.getReasonDesc());
                drugDetailData.setDocRemark(drugDetailEntity.getDocRemark());
                drugDetailData.setVerifyRemark(drugDetailEntity.getVerifyRemark());
                drugDetailData.setAmountUnit(drugDetailEntity.getWholePackingUnit() == null ? "" : drugDetailEntity.getWholePackingUnit());
                if (DrugTypeEnum.CM.getValue().equals(prescriptionPdfResVo.getPresType())) {
                    drugDetailData.setDosage("");
                    drugDetailData.setAmountUnit("g");
                }
                return drugDetailData;
            }).collect(Collectors.toList());
            QueryOrganDetailVO queryOrganDetailVO = new QueryOrganDetailVO();
            if (StringUtils.isEmpty((String)prescriptionPdfResVo.getOrganId())) {
                DoctorEntityInfoVO doctorEntityInfoVO = this.doctorRetmoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(prescriptionPdfResVo.getPresDoctorId().trim())));
                prescriptionPdfResVo.setOrganId(doctorEntityInfoVO.getOrganId().toString());
            }
            if (StringUtils.isEmpty((String)prescriptionPdfResVo.getPatientCredNo()) && (patientInfoRespVO = this.patientInfoRemoteManage.getPatientInfoById(Long.valueOf(Long.parseLong(prescriptionPdfResVo.getPatientId().trim())), prescriptionPdfResVo.getPresOrgan(), prescriptionPdfResVo.getOrganId())) != null) {
                prescriptionPdfResVo.setPatientCredNo(patientInfoRespVO.getCredNo());
            }
            if (Objects.nonNull(queryOrganDetailVO = this.doctorRetmoteManage.queryOrganDetail(Integer.valueOf(prescriptionPdfResVo.getOrganId())))) {
                prescriptionPdfResVo.setHospitalLogo(queryOrganDetailVO.getLogo());
            }
            prescriptionPdfResVo.setHospitalLogo(queryOrganDetailVO.getLogo());
            log.info("\u533b\u9662logo->{}", (Object)prescriptionPdfResVo.getHospitalLogo());
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
            if (prescriptionPdfResVo.getPayTime() != null) {
                String payTimeStr = format.format(prescriptionPdfResVo.getPayTime());
                prescriptionPdfResVo.setPayTimeStr(payTimeStr);
            }
            if (prescriptionPdfResVo.getDrugOrderTime() != null) {
                String drugOrderTime = format.format(prescriptionPdfResVo.getDrugOrderTime());
                prescriptionPdfResVo.setDrugOrderTimeStr(drugOrderTime);
            }
            if (prescriptionPdfResVo.getPresType() != null && DrugTypeEnum.CM.getValue().equals(prescriptionPdfResVo.getPresType())) {
                prescriptionPdfResVo.setPresRemark(StringUtil.getNoZeros((String)prescriptionPdfResVo.getDrugAmount().toString()) + "\u5242\uff0c\u6bcf\u65e5" + prescriptionPdfResVo.getUseMethod() + "\u5242\uff0c" + prescriptionPdfResVo.getDecoction() + "\uff0c" + prescriptionPdfResVo.getPresRemark());
            }
            BeanHelper.nullToEmpty((Object)prescriptionPdfResVo);
            prescriptionPdfResVo.setDrugDetailData(detailDataList);
            return prescriptionPdfResVo;
        }).collect(Collectors.toList());
    }

    static {
        unitList.add("\u888b");
        unitList.add("\u6761");
    }
}

