/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjuster;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    public static final String SIMPLE_Y_M_D_FORMAT = "yyyy-MM-dd";
    public static final String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FULL_NORMAL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String SECOND_DATE_FORMAT_BIAS = "yyyy/MM/dd HH:mm:ss";
    private static String[] parsePatterns = new String[]{"yyyyMMddHHmmss", "yyyyMMdd", "yyyyMMddHHmm", "yyyyMM", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    private DateUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getDate() {
        return DateUtils.getDate((String)"yyyy-MM-dd");
    }

    public static String getDate(String pattern) {
        return DateFormatUtils.format((Date)new Date(), (String)pattern);
    }

    public static String formatDate(Date date, Object ... pattern) {
        if (date == null) {
            return null;
        }
        String formatDate = null;
        formatDate = pattern != null && pattern.length > 0 ? DateFormatUtils.format((Date)date, (String)pattern[0].toString()) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        return formatDate;
    }

    public static String formatDateTime(Date date) {
        return DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
    }

    public static String formatNewDateTime(Date date) {
        return DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"});
    }

    public static String getTime() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"HH:mm:ss"});
    }

    public static String getDateTime() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
    }

    public static String getYear() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy"});
    }

    public static String getMonth() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"MM"});
    }

    public static String getDay() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"dd"});
    }

    public static String getWeek() {
        return DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"E"});
    }

    public static Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseY_M_DDate(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseYMDDate(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String)"yyyyMMdd");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseHMSDate(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String)"HH:mm:ss");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long pastDays(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 86400000L;
    }

    public static long pastHour(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 3600000L;
    }

    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static String formatDateTime(long timeMillis) {
        long day = timeMillis / 86400000L;
        long hour = timeMillis / 3600000L - day * 24L;
        long min = timeMillis / 60000L - day * 24L * 60L - hour * 60L;
        long s = timeMillis / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long sss = timeMillis - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return (day > 0L ? day + "," : "") + hour + ":" + min + ":" + s + "." + sss;
    }

    public static float getDistanceOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (float)(afterTime - beforeTime) / 8.64E7f;
    }

    public static Long getSecondOfTwoDate(Date before, Date after) {
        long beforeTime = before.getTime();
        long afterTime = after.getTime();
        return (afterTime - beforeTime) / 1000L;
    }

    public static String getNowTimeStamp() {
        return String.valueOf(new BigDecimal(new Date().getTime()).divide(new BigDecimal("1000")).intValue());
    }

    public static Date genDayBreakDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date date = calendar.getTime();
        if (date.before(new Date())) {
            date = DateUtils.addDay((Date)date, (int)1);
        }
        return date;
    }

    public static Date addDay(Date date, int num) {
        Calendar startDT = Calendar.getInstance();
        startDT.setTime(date);
        startDT.add(5, num);
        return startDT.getTime();
    }

    public static String formatYMDDateTime(String datestr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = format.parse(datestr);
        }
        catch (ParseException e) {
            return null;
        }
        SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatTime.format(date);
    }

    public static String formatFullDateTime(String datestr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = format.parse(datestr);
        }
        catch (ParseException e) {
            return null;
        }
        SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatTime.format(date);
    }

    public static String formatABCDateTime(String datestr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = null;
        try {
            date = format.parse(datestr);
        }
        catch (ParseException e) {
            return null;
        }
        SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatTime.format(date);
    }

    public static Date parseFullFormatDate(String strDate) {
        try {
            return DateUtils.parseDate((String)strDate, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseABCFormatDate(String strDate) {
        try {
            return DateUtils.parseDate((String)strDate, (String)"yyyy/MM/dd HH:mm:ss");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDate(String str, String parsePatterns) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        parser = new SimpleDateFormat(parsePatterns);
        pos.setIndex(0);
        Date date = parser.parse(str, pos);
        if (date != null && pos.getIndex() == str.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static Date getFormatDBDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = sDateFormat.format(timestamp);
        if (StringUtils.isNotBlank((String)dateStr)) {
            try {
                return sDateFormat.parse(dateStr);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static String getCurrentDateSimpleToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(DateUtils.getDate());
        return df.format(calendar.getTime());
    }

    public static Date getThisDateTime(Date date) {
        String dateTimeStr = DateUtils.formatDate((Date)date, (Object[])new Object[]{"yyyy-MM-dd HH:mm:ss"});
        try {
            return DateUtils.parseDate((String)dateTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            log.error("ERROR", (Throwable)e);
            return null;
        }
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static int getWeekDay() {
        Date date = new Date();
        return DateUtils.getWeekDay((Date)date);
    }

    public static int getWeekDay(Date date) {
        if (date == null) {
            return -1;
        }
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int weekday = cal.get(7) - 1;
        return weekday;
    }

    public static boolean judgeBusinessTime(String weeks, String bussinessTime) {
        int week = DateUtils.getWeekDay();
        if (weeks.contains(String.valueOf(week))) {
            String[] bussinessTimes = bussinessTime.split("-");
            String beginning = bussinessTimes[0] + ":00";
            String end = bussinessTimes[1] + ":59";
            Date time = DateUtils.parseHMSDate((String)DateUtils.getTime());
            Date beginTime = DateUtils.parseHMSDate((String)beginning);
            Date endTime = DateUtils.parseHMSDate((String)end);
            if (Objects.nonNull(time) && Objects.nonNull(beginTime) && Objects.nonNull(endTime)) {
                return DateUtils.isEffectiveDate((Date)time, (Date)beginTime, (Date)endTime);
            }
        }
        return false;
    }

    public static Long getTimestamp(String time) {
        Long timestamp = null;
        try {
            timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time).getTime();
        }
        catch (ParseException e) {
            log.error("ERROR", (Throwable)e);
        }
        return timestamp;
    }

    public static String getDateString(Long time) {
        String format = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            format = simpleDateFormat.format(time * 1000L);
        }
        catch (Exception e) {
            log.error("ERROR", (Throwable)e);
        }
        return format;
    }

    public static Long getLocalExpectTime(Long time) {
        long daySecond = 86400L;
        long dayTime = time - (time + 50400L) % daySecond + 3L * daySecond;
        return dayTime;
    }

    public static Integer getWeekOfYearByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setTimeInMillis(date.getTime());
        int weekOfYear = calendar.get(3);
        return weekOfYear;
    }

    public static Date getDayByDateInBoundary(Date date, TemporalAdjuster temporalAdjuster) {
        if (date == null || temporalAdjuster == null) {
            return null;
        }
        String dateStr = DateUtils.formatDate((Date)date, (Object[])new Object[0]);
        LocalDate inputDate = LocalDate.parse(dateStr);
        LocalDate day = inputDate.with(temporalAdjuster);
        ZonedDateTime zonedDateTime = day.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static void main(String[] args) {
        String startTime = "2021-01-04";
    }

    public static String getYMD(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String format = sdf.format(date);
        return format;
    }

    public static List<String> sortAsc(List<String> dataStr) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dataStr.sort((a1, a2) -> {
            try {
                return df.parse((String)a1).compareTo(df.parse((String)a2));
            }
            catch (ParseException e) {
                log.error("ERROR", (Throwable)e);
                return 1;
            }
        });
        return dataStr;
    }

    public static String conversionTime(Long timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String time = sdf.format(new Date(timeStamp));
            return time;
        }
        catch (Exception e) {
            log.error("ERROR", (Throwable)e);
            return null;
        }
    }
}

