/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medicalcloud.utils.id;

import com.ebaiyihui.medicalcloud.exception.IdGenerationException;
import com.ebaiyihui.medicalcloud.utils.id.IdentifierGenerator;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberGenerator
implements IdentifierGenerator {
    private static final Logger log = LoggerFactory.getLogger(NumberGenerator.class);
    private static final long TWEPOCH = 1288834974657L;
    private long sequence = 0L;
    private static final long WORKER_ID_BITS = 4L;
    public static final long MAX_WORKER_ID = 15L;
    private static final long SEQUENCE_BITS = 10L;
    private static final long TIMESTAMP_LEFT_SHIFT = 14L;
    public static final long SEQUENCE_MASK = 1023L;
    private long lastTimestamp = -1L;

    public boolean isAuto() {
        return false;
    }

    public void setExtra(String extra) {
    }

    public String getFillChar() {
        return null;
    }

    public Serializable generate() throws IdGenerationException {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            try {
                throw new Exception(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            catch (Exception e) {
                log.error("ERROR", (Throwable)e);
            }
        }
        this.lastTimestamp = timestamp;
        long nextId = timestamp - 1288834974657L << 14 | this.sequence;
        return Long.valueOf(nextId);
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

