/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.client.heart;

import com.ebaiyihui.mercury.client.init.CustomerHandleInitializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HeartbeatClient {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatClient.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatClient.class);
    private EventLoopGroup group = new NioEventLoopGroup();
    @Value(value="${netty.server.port}")
    private int nettyPort;
    @Value(value="${netty.server.host}")
    private String host;
    private SocketChannel socketChannel;
    private Channel channel;
    private Bootstrap bootstrap;

    @PostConstruct
    public synchronized void start() throws InterruptedException {
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new CustomerHandleInitializer());
        this.doConnect();
    }

    protected void doConnect() {
        if (this.channel != null && this.channel.isActive()) {
            return;
        }
        ChannelFuture connect = this.bootstrap.connect(this.host, this.nettyPort);
        connect.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (channelFuture.isSuccess()) {
                    HeartbeatClient.this.channel = channelFuture.channel();
                    log.info("\u8fde\u63a5\u6210\u529f");
                } else {
                    log.info("\u6bcf\u96945s\u91cd\u8fde....");
                    channelFuture.channel().eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            HeartbeatClient.this.doConnect();
                        }
                    }, 5L, TimeUnit.SECONDS);
                }
            }
        });
    }

    @PreDestroy
    public void destroy() {
        LOGGER.info("\u5173\u95ed Netty \u6210\u529f");
    }
}

