/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.server.common;

import com.ebaiyihui.mercury.server.model.ApplicationInfoEntity;
import com.ebaiyihui.mercury.server.service.ApplicationInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ApplicationInfoMap {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInfoMap.class);
    @Autowired
    private ApplicationInfoService applicationInfoService;
    private static Map<String, List<ApplicationInfoEntity>> appServerListMap = new ConcurrentHashMap();

    public List<ApplicationInfoEntity> getList() {
        ArrayList<ApplicationInfoEntity> list = new ArrayList<ApplicationInfoEntity>();
        if (!CollectionUtils.isEmpty((Map)appServerListMap)) {
            appServerListMap.values().stream().forEach(applicationInfoEntityList -> list.addAll((Collection<ApplicationInfoEntity>)applicationInfoEntityList));
        }
        return list;
    }

    public List<ApplicationInfoEntity> get(String appCode) {
        List applicationServerInfoEntityList = (List)appServerListMap.get(appCode);
        log.info("Fetch application server info: appCode ->{}", (Object)appCode);
        return applicationServerInfoEntityList;
    }

    public void del(String appCode) {
        log.info("delete application server info: appCode ->{}", (Object)appCode);
        if (appServerListMap.containsKey(appCode)) {
            appServerListMap.remove(appCode);
        }
    }

    public Set<String> keySet() {
        return appServerListMap.keySet();
    }

    public boolean containsKey(Object key) {
        return appServerListMap.containsKey(key);
    }

    public void clear() {
        appServerListMap.clear();
    }

    public void del(String appCode, String viewId) {
        log.info("del application server param: appCode->{}, serverId->{}, viewId->{}", (Object)appCode, (Object)viewId);
        List applicationServerInfoEntityList = (List)appServerListMap.get(appCode);
        if (CollectionUtils.isEmpty((Collection)applicationServerInfoEntityList)) {
            log.info("No application info");
            return;
        }
        if ((applicationServerInfoEntityList = applicationServerInfoEntityList.stream().filter(applicationServerInfoEntity -> !applicationServerInfoEntity.getViewId().equals(viewId)).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        appServerListMap.put(appCode, applicationServerInfoEntityList);
    }

    public synchronized void put(String appCode, List<ApplicationInfoEntity> nodeApplicationServerInfoEntityList) {
        if (nodeApplicationServerInfoEntityList == null || nodeApplicationServerInfoEntityList.isEmpty()) {
            return;
        }
        appServerListMap.put(appCode, nodeApplicationServerInfoEntityList);
    }

    @PostConstruct
    private void initAppServerListMap() {
        this.applicationInfoService.initAppServerMap();
    }
}

