/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.server.controller;

import com.ebaiyihui.mercury.server.model.ApplicationInfoEntity;
import com.ebaiyihui.mercury.server.model.BaseResponse;
import com.ebaiyihui.mercury.server.model.PageResult;
import com.ebaiyihui.mercury.server.service.ApplicationInfoService;
import com.ebaiyihui.mercury.server.vo.BaseReqVo;
import com.ebaiyihui.mercury.server.vo.LoginReqVo;
import com.ebaiyihui.mercury.server.vo.LoginResVo;
import com.ebaiyihui.mercury.server.vo.SaveAppInfoRequestVo;
import com.ebaiyihui.mercury.server.vo.SearchAppInfoParamVo;
import com.ebaiyihui.mercury.server.vo.UpdateAppInfoRequestVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/mercury/api/v1/app_info"})
@Api(tags={"\u5e94\u7528\u670d\u52a1\u4fe1\u606f\u7684\u63a5\u53e3"})
public class ApplicationInfoController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInfoController.class);
    @Autowired
    private ApplicationInfoService applicationInfoService;

    @PostMapping(value={"/refresh"})
    public Mono<BaseResponse> refresh() {
        this.applicationInfoService.refresh();
        return Mono.just((Object)BaseResponse.success());
    }

    @GetMapping(value={"/get_page_app_server_info_list"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e94\u7528\u670d\u52a1\u4fe1\u606f")
    public Mono<BaseResponse<PageResult<List<ApplicationInfoEntity>>>> getPageApplicationServerInfoList(@Valid SearchAppInfoParamVo searchAppInfoParamVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return Mono.just((Object)BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage()));
        }
        PageResult pageResult = this.applicationInfoService.getPageApplicationServerInfoList(searchAppInfoParamVo);
        return Mono.just((Object)BaseResponse.success((Object)pageResult));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u589e\u52a0\u5e94\u7528\u670d\u52a1\u4fe1\u606f")
    public Mono<BaseResponse> save(@Valid SaveAppInfoRequestVo saveAppInfoRequestVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return Mono.just((Object)BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage()));
        }
        this.applicationInfoService.save(saveAppInfoRequestVo);
        return Mono.just((Object)BaseResponse.success());
    }

    @PostMapping(value={"/login"})
    @ApiOperation(value="\u767b\u5f55")
    public Mono<BaseResponse<LoginResVo>> login(@Valid LoginReqVo loginReqVo, ServerWebExchange exchange) {
        LoginResVo loginResVo = null;
        try {
            loginResVo = this.applicationInfoService.login(loginReqVo);
        }
        catch (Exception e) {
            log.error("applicationInfoService.login(loginReqVo)" + e.getMessage());
            return Mono.just((Object)BaseResponse.error((String)e.getMessage()));
        }
        return Mono.just((Object)BaseResponse.success((Object)loginResVo));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u5e94\u7528\u670d\u52a1\u4fe1\u606f")
    public Mono<BaseResponse> delete(BaseReqVo deleteAppInfoReqVo) {
        this.applicationInfoService.delete(deleteAppInfoReqVo.getId());
        return Mono.just((Object)BaseResponse.success());
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u5e94\u7528\u670d\u52a1\u4fe1\u606f")
    public Mono<BaseResponse> updateById(@Valid UpdateAppInfoRequestVo updateAppInfoRequestVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return Mono.just((Object)BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage()));
        }
        this.applicationInfoService.updateById(updateAppInfoRequestVo);
        return Mono.just((Object)BaseResponse.success());
    }

    @PostMapping(value={"/upOrDownService"})
    @ApiOperation(value="\u4fee\u6539\u5e94\u7528\u670d\u52a1\u4fe1\u606f")
    public Mono<BaseResponse> upOrDownService(@Valid BaseReqVo baseReqVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return Mono.just((Object)BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage()));
        }
        this.applicationInfoService.upOrDownService(baseReqVo);
        return Mono.just((Object)BaseResponse.success());
    }

    @GetMapping(value={"/get_by_id"})
    @ApiOperation(value="\u4fee\u6539\u5e94\u7528\u670d\u52a1\u4fe1\u606f")
    public Mono<BaseResponse<ApplicationInfoEntity>> getById(@RequestParam(value="id") Long id) {
        ApplicationInfoEntity applicationServerInfoEntity = this.applicationInfoService.getById(id);
        return Mono.just((Object)BaseResponse.success((Object)applicationServerInfoEntity));
    }

    @GetMapping(value={"/get_all_app_code"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684appCode")
    public Mono<BaseResponse<List<String>>> getAllAppCode() {
        List appCodeList = this.applicationInfoService.getAllAppCode();
        return Mono.just((Object)BaseResponse.success((Object)appCodeList));
    }
}

