/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.server.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.mercury.server.common.ApplicationInfoMap;
import com.ebaiyihui.mercury.server.common.MercuryConstant;
import com.ebaiyihui.mercury.server.enums.IpTypeEnum;
import com.ebaiyihui.mercury.server.model.ApplicationInfoEntity;
import com.ebaiyihui.mercury.server.model.PushConfigEntity;
import com.ebaiyihui.mercury.server.model.PushUrlInfoEntity;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CustomerURIFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(CustomerURIFilter.class);
    @Autowired
    private ApplicationInfoMap applicationInfoMap;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        Object uriObj = exchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
        if (uriObj != null) {
            URI originUrl = (URI)new ArrayList((LinkedHashSet)uriObj).get(0);
            String rcpUrl = this.getRpcUrl(originUrl);
            log.info("rpc url->{}", (Object)rcpUrl);
            try {
                URI uri = new URI(rcpUrl);
                this.upgradeConnection(uri, uri.getScheme());
                exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, uri);
            }
            catch (Exception e) {
                log.error("valid URL->{}", (Throwable)e);
            }
        }
        return chain.filter(exchange);
    }

    private String getRpcUrl(URI originUrl) {
        String appCode = this.getAppCode(originUrl);
        List applicationInfoEntityList = this.applicationInfoMap.get(appCode);
        ApplicationInfoEntity applicationInfoEntity = this.getRandomApplicationInfo(applicationInfoEntityList);
        String rcpUrlPrefix = this.getRcpUrlPrefix(applicationInfoEntity);
        String requestUri = originUrl.getPath().substring(1);
        requestUri = applicationInfoEntity.getNeedPrefix().intValue() == MercuryConstant.NO_NEED_PREFIX.intValue() || this.isCloudSwaggerApi(requestUri) ? (requestUri.indexOf("/") != -1 ? requestUri.substring(requestUri.indexOf("/")) : "") : "/" + requestUri;
        String rcpUrl = rcpUrlPrefix + requestUri;
        StringBuffer sb = new StringBuffer(rcpUrl);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{originUrl.getQuery()})) {
            try {
                String param = originUrl.getQuery();
                sb.append("?");
                for (int i = 0; i < param.length(); ++i) {
                    char charAt = param.charAt(i);
                    if (CustomerURIFilter.isChineseChar((char)charAt)) {
                        String encode = URLEncoder.encode(charAt + "", "UTF-8");
                        sb.append(encode);
                        continue;
                    }
                    sb.append(charAt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static boolean isChineseChar(char c) {
        return String.valueOf(c).matches("[\u4e00-\u9fa5]");
    }

    private URI upgradeConnection(URI uri, String scheme) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)uri).scheme(scheme);
        if (uri.getRawQuery() != null) {
            uriComponentsBuilder.replaceQuery(uri.getRawQuery().replace("+", "%20"));
            uriComponentsBuilder.replaceQuery(uri.getRawQuery().replace("=", "%3D"));
        }
        return uriComponentsBuilder.build(true).toUri();
    }

    public String getAppCode(URI requestUrl) {
        String requestUri;
        String appCode = requestUri = requestUrl.getPath().substring(1);
        if (requestUri.indexOf("/") != -1) {
            appCode = requestUri.substring(0, requestUri.indexOf("/"));
        }
        return appCode;
    }

    private String getRcpUrlPrefix(ApplicationInfoEntity applicationServerInfoEntity) {
        if (applicationServerInfoEntity.getIpType().intValue() == IpTypeEnum.INTRANET_IP.getValue().intValue()) {
            return "http://" + applicationServerInfoEntity.getIntranetIp() + ":" + applicationServerInfoEntity.getAppPort();
        }
        if (applicationServerInfoEntity.getIpType().intValue() == IpTypeEnum.EXTRANET_IP.getValue().intValue()) {
            return "http://" + applicationServerInfoEntity.getExtranetIp() + ":" + applicationServerInfoEntity.getAppPort();
        }
        return "https://" + applicationServerInfoEntity.getDomainName();
    }

    private ApplicationInfoEntity getRandomApplicationInfo(List<ApplicationInfoEntity> applicationServerInfoEntityList) {
        int index = (int)(Math.random() * (double)applicationServerInfoEntityList.size());
        return applicationServerInfoEntityList.get(index);
    }

    private boolean isCloudSwaggerApi(String requestUri) {
        return this.isSwaggerApi(requestUri) && requestUri.contains("CLOUD".toLowerCase());
    }

    private boolean isSwaggerApi(String requestUri) {
        return requestUri.contains("swagger") || requestUri.contains("api-docs");
    }

    private String buildSmsParam(String bodyParam, PushUrlInfoEntity pushUrlInfoEntity, PushConfigEntity pushConfigEntity) {
        Map bodyMap = (Map)JSON.parseObject((String)bodyParam, Map.class);
        String addParam = pushUrlInfoEntity.getAddParam();
        String delParam = pushUrlInfoEntity.getDelParam();
        if (addParam != null) {
            bodyMap.put(addParam, pushConfigEntity.getSignCode());
        }
        if (delParam != null) {
            bodyMap.remove(delParam);
        }
        String codeValue = pushConfigEntity.getSmsClientCode();
        if (bodyMap.containsKey("clientCode")) {
            String clientCode = bodyMap.get("clientCode").toString();
            log.info("get clientCode =" + clientCode);
            if (!clientCode.equals("EHOS_DOCTOR")) {
                bodyMap.put("clientCode", codeValue);
            }
        }
        if (bodyMap.containsKey("smsAppCode")) {
            bodyMap.put("smsAppCode", codeValue);
        }
        if (bodyMap.containsKey("tel")) {
            JSONObject json = JSON.parseObject((String)JSON.toJSONString(bodyMap.get("tel")));
            bodyMap.put("phone", json.getString("mobile"));
        }
        String bodyString = JSON.toJSONString((Object)bodyMap);
        log.info("dispatch final push param =" + bodyString);
        return bodyString;
    }

    public int getOrder() {
        return 10101;
    }
}

