/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.server.filter;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.mercury.server.common.IError;
import com.ebaiyihui.mercury.server.model.BaseResponse;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.reactive.ForwardedHeaderFilter;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@Order(value=-1)
public class LoginFilter
extends ForwardedHeaderFilter {
    private static final Logger log = LoggerFactory.getLogger(LoginFilter.class);
    @Autowired
    private RedisTemplate redisTemplate;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String requestURI = exchange.getRequest().getURI().getPath();
        if (requestURI.startsWith("/mercury/api/") && !requestURI.startsWith("/mercury/api/v1/app_info/login")) {
            String expectToken = exchange.getRequest().getHeaders().getFirst("token");
            String userName = exchange.getRequest().getHeaders().getFirst("id");
            if (StringUtils.isEmpty((CharSequence)expectToken) || StringUtils.isEmpty((CharSequence)userName)) {
                return exchange.getResponse().writeWith((Publisher)Flux.just((Object)exchange.getResponse().bufferFactory().wrap(JSON.toJSONString((Object)BaseResponse.error((IError)IError.NO_LOGIN)).getBytes())));
            }
            String token = (String)this.redisTemplate.opsForValue().get((Object)userName);
            if (StringUtils.isBlank((CharSequence)token) || !Objects.equals(expectToken, token)) {
                return exchange.getResponse().writeWith((Publisher)Flux.just((Object)exchange.getResponse().bufferFactory().wrap(JSON.toJSONString((Object)BaseResponse.error((IError)IError.NO_LOGIN)).getBytes())));
            }
        }
        return super.filter(exchange, chain);
    }
}

