/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.server.filter;

import com.ebaiyihui.mercury.server.utils.IpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class XforwardedForFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(XforwardedForFilter.class);

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        String ip = IpUtils.getIpAddress((ServerHttpRequest)exchange.getRequest());
        ServerHttpRequest request = exchange.getRequest().mutate().header("x-forwarded-for", ip).build();
        return chain.filter(exchange.mutate().request(request).build());
    }

    public int getOrder() {
        return -200;
    }
}

