/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.mercury.server.handler;

import com.ebaiyihui.mercury.server.common.ApplicationInfoMap;
import com.ebaiyihui.mercury.server.mapper.RedisRouteDefinitionRepository;
import com.ebaiyihui.mercury.server.model.ApplicationInfoEntity;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Service
public class CustomerRouteHandler
implements ApplicationEventPublisherAware,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(CustomerRouteHandler.class);
    @Autowired
    private RedisRouteDefinitionRepository routeDefinitionWriter;
    private ApplicationEventPublisher publisher;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private ApplicationInfoMap applicationInfoMap;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public void run(String ... args) {
        this.loadRouteConfig();
    }

    public void loadRouteConfig() {
        this.redisTemplate.delete((Object)"gateway:routes");
        List applicationInfoEntityList = this.applicationInfoMap.getList();
        applicationInfoEntityList = applicationInfoEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ApplicationInfoEntity>(Comparator.comparing(ApplicationInfoEntity::getAppCode))), ArrayList::new));
        log.info("\u7f51\u5173\u914d\u7f6e\u4fe1\u606f\uff1a=====>" + applicationInfoEntityList.toString());
        applicationInfoEntityList.forEach(gatewayRoute -> {
            RouteDefinition definition = this.getRouteDefinition(gatewayRoute);
            this.routeDefinitionWriter.save(Mono.just((Object)definition)).subscribe();
        });
        this.publisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
    }

    private RouteDefinition getRouteDefinition(ApplicationInfoEntity gatewayRoute) {
        RouteDefinition definition = new RouteDefinition();
        HashMap<String, String> predicateParams = new HashMap<String, String>(8);
        PredicateDefinition predicate = new PredicateDefinition();
        FilterDefinition filterDefinition = new FilterDefinition();
        filterDefinition.setName("StripPrefix");
        HashMap filterParams = new HashMap(8);
        URI uri = UriComponentsBuilder.fromPath((String)"https://testapi.ebaiyihui.com/").build().toUri();
        definition.setId(gatewayRoute.getApplicationName() + ":" + gatewayRoute.getAppCode());
        predicate.setName("Path");
        predicateParams.put("pattern", "/" + gatewayRoute.getAppCode() + "/**");
        predicate.setArgs(predicateParams);
        definition.setPredicates(Arrays.asList(predicate));
        definition.setFilters(Arrays.asList(filterDefinition));
        definition.setUri(uri);
        return definition;
    }

    public void saveRoute(ApplicationInfoEntity applicationInfoEntity) {
        RouteDefinition definition = this.getRouteDefinition(applicationInfoEntity);
        this.routeDefinitionWriter.save(Mono.just((Object)definition)).subscribe();
        this.publisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
    }

    public void deleteRoute(String routeId) {
        this.routeDefinitionWriter.delete(Mono.just((Object)routeId)).subscribe();
        this.publisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this));
    }
}

